/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UsageCounters {
    private static final Preferences prefs = Preferences.userNodeForPackage(UsageCounters.class).node("usageCounters");

    public static int get(String key) {
        return prefs.getInt(key, 0);
    }

    public static int increase(String key) {
        int newValue = prefs.getInt(key, 0) + 1;
        prefs.putInt(key, newValue);
        return newValue;
    }

    public static void reset(String key) {
        prefs.remove(key);
    }

    public static List<String> keys() {
        try {
            return Arrays.asList(prefs.keys());
        }
        catch (BackingStoreException backingStoreException) {
            return new ArrayList<String>();
        }
    }

    public static void print() {
        for (String key : UsageCounters.keys()) {
            System.out.println(key + "=" + UsageCounters.get(key));
        }
    }
}

