/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum;

import java.awt.Dimension;
import java.io.File;
import java.util.Objects;
import java.util.regex.Pattern;
import net.jalbum.OutputFormat;
import net.jalbum.Variant;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.util.IO;

public class Rendition {
    private final String name;
    private final Dimension size;
    private final OutputFormat format;
    private final Variant variant;
    private static final Pattern variantDashPattern = Pattern.compile("-\\d+w\\..+");

    public Rendition(AlbumObject ao, Dimension size, OutputFormat format, Variant variant, boolean linkInternally) {
        File f = ao.getFile();
        if (linkInternally) {
            f = ((LinkFile)f).getTarget();
        }
        String targetName = ao.getEngine().getTargetName(f);
        this.name = variant == Variant.TYPICAL ? targetName : (ao.isFolder() ? targetName : IO.baseName(targetName)) + "-" + size.width + "w." + variant.getFormat().getExtension();
        this.size = size;
        this.format = format;
        this.variant = variant;
    }

    public String getName() {
        return this.name;
    }

    public String getEncodedName() {
        return IO.urlEncode(this.name);
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public Dimension getSize() {
        return this.size;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public String toString() {
        return this.getName() + " (" + this.size.width + "x" + this.size.height + ")";
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + Objects.hashCode(this.size);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rendition other = (Rendition)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.size, other.size);
    }

    private static int variantDashIndex(String fileName) {
        int di = fileName.lastIndexOf(45);
        if (di != -1) {
            return variantDashPattern.matcher(fileName.substring(di)).matches() ? di : -1;
        }
        return di;
    }

    public static boolean isTypical(String fileName) {
        return Rendition.variantDashIndex(fileName) == -1;
    }

    public static String nameRoot(String fileName) {
        int di = Rendition.variantDashIndex(fileName);
        return di != -1 ? fileName.substring(0, di) : IO.baseName(fileName);
    }
}

