/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum;

import java.util.Set;
import javax.imageio.ImageIO;
import net.jalbum.avif.SafeAvif;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Msg;

public enum OutputFormat {
    AVIF("AVIF", "avif", "image/avif"),
    WEBP("WebP", "webp", "image/webp"),
    JPEG("JPEG", "jpg", Set.of("jpg", "jpeg"), "image/jpeg"),
    PNG("PNG", "png", "image/png");

    private final String displayName;
    private final String extension;
    private final Set<String> allExtensions;
    private final String mimeType;

    private OutputFormat(String displayName, String extension, Set<String> allExtensions, String mimeType) {
        this.displayName = displayName;
        this.extension = extension;
        this.allExtensions = allExtensions;
        this.mimeType = mimeType;
    }

    public static OutputFormat[] availableValues() {
        if (ImageIO.getImageWritersByFormatName("avif").hasNext()) {
            return new OutputFormat[]{JPEG, AVIF, WEBP};
        }
        return new OutputFormat[]{JPEG, WEBP};
    }

    private OutputFormat(String displayName, String extension, String mimeType) {
        this(displayName, extension, Set.of(extension), mimeType);
    }

    public String toString() {
        return this.displayName;
    }

    public String getToolTipText() {
        return Msg.get(this.extension + ".toolTip");
    }

    public String getExtension() {
        return this.extension;
    }

    public Set<String> getAllExtensions() {
        return this.allExtensions;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static OutputFormat ofExtension(String ext) {
        ext = ext.toLowerCase();
        for (OutputFormat of : OutputFormat.values()) {
            if (!of.getAllExtensions().contains(ext)) continue;
            return of;
        }
        throw new IllegalArgumentException("No OutputFormat for extension " + ext);
    }

    public int getQualityPercent(AlbumBean engine) {
        return switch (this.ordinal()) {
            case 2 -> engine.getQualityPercent();
            case 1 -> engine.getQualityPercentWebP();
            case 0 -> engine.getQualityPercentAVIF();
            default -> engine.getQualityPercent();
        };
    }

    public static OutputFormat getAlternative() {
        return SafeAvif.isInitiatedOk() ? AVIF : WEBP;
    }
}

