/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJTransform;

public class TJTransformer
extends TJDecompressor {
    private int[] transformedSizes = null;
    private int iccSize = 0;

    public TJTransformer() throws TJException {
        this.init();
    }

    public TJTransformer(byte[] byArray) throws TJException {
        this.init();
        this.setSourceImage(byArray, byArray.length);
    }

    public TJTransformer(byte[] byArray, int n) throws TJException {
        this.init();
        this.setSourceImage(byArray, n);
    }

    public native void setICCProfile(byte[] var1) throws TJException;

    public native int bufSize(TJTransform var1) throws TJException;

    public void transform(byte[][] byArray, TJTransform[] tJTransformArray) throws TJException {
        this.transformedSizes = this.transform(this.getJPEGBuf(), this.getJPEGSize(), byArray, tJTransformArray);
    }

    public TJDecompressor[] transform(TJTransform[] tJTransformArray) throws TJException {
        byte[][] byArrayArray = new byte[tJTransformArray.length][];
        for (int i = 0; i < tJTransformArray.length; ++i) {
            byArrayArray[i] = new byte[this.bufSize(tJTransformArray[i])];
        }
        TJDecompressor[] tJDecompressorArray = new TJDecompressor[tJTransformArray.length];
        this.transform(byArrayArray, tJTransformArray);
        for (int i = 0; i < tJTransformArray.length; ++i) {
            tJDecompressorArray[i] = new TJDecompressor(byArrayArray[i], this.transformedSizes[i]);
        }
        return tJDecompressorArray;
    }

    public int[] getTransformedSizes() {
        if (this.transformedSizes == null) {
            throw new IllegalStateException("No image has been transformed yet");
        }
        return this.transformedSizes;
    }

    private native void init() throws TJException;

    private native int[] transform(byte[] var1, int var2, byte[][] var3, TJTransform[] var4) throws TJException;
}

