/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.turbojpeg.libloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import net.jalbum.turbojpeg.libloader.Platform;
import net.jalbum.util.Profiler;

public class LibLoader {
    public static void loadLibrary(String libBaseName, Class baseClass) {
        String prefix;
        String os;
        String string = Platform.isWindows() ? "win64" : (Platform.isLinux() ? "linux64" : (os = Platform.isMac() ? "macos64" : null));
        if (os == null) {
            throw new UnsupportedOperationException("Unsupported operating system.");
        }
        String string2 = prefix = Platform.isWindows() ? "" : "lib";
        String extension = Platform.isWindows() ? ".dll" : (Platform.isLinux() ? ".so" : (Platform.isMac() ? ".dylib" : ""));
        String libName = prefix + libBaseName + extension;
        String arch = System.getProperty("os.arch");
        String resourcePath = "/native/" + os + "/" + arch + "/" + libName;
        URL resourceUrl = baseClass.getResource(resourcePath);
        if (resourceUrl == null && Platform.isMac()) {
            resourcePath = "/native/" + os + "/" + libName;
            resourceUrl = baseClass.getResource(resourcePath);
        }
        if (resourceUrl == null) {
            throw new RuntimeException("Native library not found in classpath: " + resourcePath);
        }
        try {
            LibLoader.loadWithPersistentCache(libBaseName, resourceUrl, libName, arch);
        }
        catch (Exception e) {
            System.err.println("Persistent cache failed, falling back to temp: " + e.getMessage());
            LibLoader.loadWithTempFallback(resourceUrl, libName, extension);
        }
    }

    private static void loadWithPersistentCache(String libBaseName, URL resourceUrl, String libName, String arch) throws IOException {
        Path cacheDir = LibLoader.getCacheDir();
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        Path targetPath = cacheDir.resolve(arch + "_" + libName);
        long resourceTime = resourceUrl.openConnection().getLastModified();
        if (!Files.exists(targetPath, new LinkOption[0]) || Files.getLastModifiedTime(targetPath, new LinkOption[0]).toMillis() < resourceTime) {
            try (Profiler.Sample _s2 = Profiler.profile((String)("Extracting " + libBaseName + " to persistent cache"));){
                try (InputStream in = resourceUrl.openStream();){
                    Files.copy(in, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                Files.setLastModifiedTime(targetPath, FileTime.fromMillis(resourceTime));
            }
        }
        try (Profiler.Sample _s3 = Profiler.profile((String)"TurboJPEG symbol lookup (cached)");){
            System.load(targetPath.toString());
        }
    }

    private static void loadWithTempFallback(URL resourceUrl, String prefix, String suffix) {
        try {
            File tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
            try (InputStream in = resourceUrl.openStream();){
                Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            try (Profiler.Sample _s3 = Profiler.profile((String)"TurboJPEG symbol lookup (temp)");){
                System.load(tempFile.toPath().toString());
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Total failure: Could not load library even to temp.", ex);
        }
    }

    private static Path getCacheDir() {
        String xdgCache;
        String localAppData;
        String osName = System.getProperty("os.name").toLowerCase();
        Path path = osName.contains("win") ? ((localAppData = System.getenv("LOCALAPPDATA")) != null ? Paths.get(localAppData, new String[0]) : Paths.get(System.getProperty("user.home"), "AppData", "Local")) : (osName.contains("mac") ? Paths.get(System.getProperty("user.home"), "Library", "Caches") : ((xdgCache = System.getenv("XDG_CACHE_HOME")) != null ? Paths.get(xdgCache, new String[0]) : Paths.get(System.getProperty("user.home"), ".cache")));
        return path.resolve("TurboJPEGCache");
    }
}

