/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReaderSpi;
import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageWriter;
import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegUtilities;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;

public class TurboJpegImageWriterSpi
extends ImageWriterSpi {
    static final String[] suffixes;
    static final String[] formatNames;
    static final String[] MIMETypes;
    static final String version = "1.0";
    static final String writerCN = "it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageWriter";
    static final String vendorName = "GeoSolutions";
    static final String[] readerSpiName;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;
    private static Method writerFormatNamesMethod;

    public TurboJpegImageWriterSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, writerCN, new Class[]{ImageOutputStream.class, OutputStream.class, File.class}, readerSpiName, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return new TurboJpegImageWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "GeoSolutions TurboJPEG Writer";
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return true;
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        super.onRegistration(registry, category);
        this.dePrioritizeOtherSpis(registry, category);
        if (!TurboJpegUtilities.isTurboJpegAvailable()) {
            IIORegistry iioRegistry = (IIORegistry)registry;
            Class<ImageWriterSpi> spiClass = ImageWriterSpi.class;
            Iterator<ImageWriterSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
            while (iter.hasNext()) {
                ImageWriterSpi provider = iter.next();
                if (!(provider instanceof TurboJpegImageWriterSpi)) continue;
                registry.deregisterServiceProvider(provider);
            }
        }
    }

    private void dePrioritizeOtherSpis(ServiceRegistry registry, Class category) {
        if (registry == null) {
            return;
        }
        try {
            Iterator<ImageWriterSpi> iter = registry.getServiceProviders(ImageWriterSpi.class, new TurboJpegImageReaderSpi.ContainsFilter(writerFormatNamesMethod, "JPEG"), true);
            while (iter.hasNext()) {
                ImageWriterSpi spi = iter.next();
                if (spi.getClass().equals(this.getClass())) continue;
                registry.setOrdering(category, this, spi);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        TurboJpegUtilities.loadTurboJpeg();
        suffixes = new String[]{"JPEG", "JPG", "jpeg", "jpg"};
        formatNames = new String[]{"jpeg", "jpg"};
        MIMETypes = new String[]{"image/jpeg"};
        readerSpiName = new String[]{"it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReaderSpi"};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = null;
        extraStreamMetadataFormatClassNames = null;
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = new String[]{null};
        extraImageMetadataFormatClassNames = new String[]{null};
        try {
            writerFormatNamesMethod = ImageWriterSpi.class.getMethod("getFormatNames", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.err.println(e);
        }
    }
}

