/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageWriteParam;
import it.geosolutions.imageio.utilities.ImageOutputStreamAdapter2;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.libjpegturbo.turbojpeg.TJCompressor;

public class TurboJpegImageWriter
extends ImageWriter {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.turbojpeg");
    private ImageOutputStream outputStream = null;

    public TurboJpegImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        TurboJpegImageWriteParam wparam = new TurboJpegImageWriteParam();
        wparam.setCompressionMode(2);
        wparam.setCompressionType("JPEG");
        wparam.setCompressionQuality(0.75f);
        return wparam;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public void setOutput(Object output) {
        if (output instanceof OutputStream) {
            this.outputStream = new ImageOutputStreamAdapter2((OutputStream)output);
        } else if (output instanceof ImageOutputStreamAdapter2) {
            this.outputStream = (ImageOutputStreamAdapter2)output;
        } else if (output instanceof File) {
            try {
                this.outputStream = new ImageOutputStreamAdapter2(new FileOutputStream((File)output));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.outputStream == null && output instanceof ImageOutputStream) {
            this.outputStream = (ImageOutputStream)output;
        }
        if (this.outputStream == null) {
            throw new IllegalArgumentException("Null outputstream for " + String.valueOf(output.getClass()));
        }
        super.setOutput(this.outputStream);
    }

    @Override
    public void write(IIOMetadata metadata, IIOImage image, ImageWriteParam writeParam) throws IOException {
        RenderedImage srcImage = image.getRenderedImage();
        if (!((srcImage = this.refineImage(srcImage)).getSampleModel() instanceof ComponentSampleModel)) {
            throw new RuntimeException("Illegal sample model!!!");
        }
        ComponentSampleModel sm = (ComponentSampleModel)srcImage.getSampleModel();
        int[] bandOffsets = sm.getBandOffsets();
        TurboJpegImageWriteParam param = (TurboJpegImageWriteParam)writeParam;
        if (param == null) {
            param = (TurboJpegImageWriteParam)this.getDefaultWriteParam();
        }
        int componentSampling = param.getComponentSubsampling();
        int quality = (int)(param.getCompressionQuality() * 100.0f);
        int pf = 0;
        if (bandOffsets.length == 3) {
            if (componentSampling == -1) {
                componentSampling = 2;
            }
            if (bandOffsets[0] == 2 && bandOffsets[2] == 0) {
                pf = 1;
            }
        } else if (bandOffsets.length == 1 && componentSampling == -1) {
            pf = 6;
            componentSampling = 3;
        } else {
            throw new IllegalArgumentException("TurboJPEG won't work with this type of sampleModel");
        }
        if (componentSampling < 0) {
            throw new IOException("Subsampling level not set");
        }
        int pixelsize = sm.getPixelStride();
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        int pitch = pixelsize * width;
        try (TJCompressor compressor = new TJCompressor();){
            byte[] outputImageData;
            Rectangle rect = new Rectangle(srcImage.getMinX(), srcImage.getMinY(), srcImage.getWidth(), srcImage.getHeight());
            Raster data = srcImage.getData(rect);
            byte[] inputImageData = ((DataBufferByte)data.getDataBuffer()).getData();
            try {
                compressor.setSourceImage(inputImageData, 0, 0, width, pitch, height, pf);
                compressor.set(3, quality);
                compressor.set(4, componentSampling);
                compressor.set(10, 1);
                outputImageData = compressor.compress();
            }
            catch (Exception ex) {
                throw new IOException("Error in turbojpeg comressor: " + ex.getMessage(), ex);
            }
            int imageDataSize = compressor.getCompressedSize();
            this.outputStream.write(outputImageData, 0, imageDataSize);
        }
    }

    private RenderedImage refineImage(RenderedImage srcImage) {
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        int minX = srcImage.getMinX();
        int minY = srcImage.getMinY();
        int tw = srcImage.getTileWidth();
        int th = srcImage.getTileHeight();
        if (tw > w || th > h || !(srcImage.getSampleModel() instanceof ComponentSampleModel)) {
            BufferedImage bi = srcImage instanceof BufferedImage ? (BufferedImage)srcImage : this.convertRenderedImageToBufferedImage(srcImage);
            int newType = bi.getTransparency() == 1 ? 5 : 6;
            BufferedImage croppedImage = new BufferedImage(w, h, newType);
            Graphics2D g2d = croppedImage.createGraphics();
            g2d.drawImage(bi, 0, 0, w, h, minX, minY, minX + w, minY + h, null);
            g2d.dispose();
            return croppedImage;
        }
        return srcImage;
    }

    private BufferedImage convertRenderedImageToBufferedImage(RenderedImage renderedImage) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 5);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawRenderedImage(renderedImage, null);
        g2d.dispose();
        return bufferedImage;
    }
}

