/*
 * Decompiled with CFR 0.152.
 */
package nl.tomcee.skinprops;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import net.miginfocom.swing.MigLayout;
import se.datadosen.jalbum.Frog;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.ManagesImport;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;

public class SkinPropsEditor
extends JFrame {
    static final String APP_NAME = "Skin Properties Editor";
    static final String VERSION = "2.0";
    static final String AUTHOR = "Tom and David";
    final String SIMPLE_NAME = this.getClass().getSimpleName();
    private JAlbumContext context = JAlbumContext.getInstance();
    private String skin = this.context.getSkinDir().getName();
    private String accountProfileName = this.context.getEngine().getAccountProfileName();
    private SkinProperties skinProperties = this.context.getEngine().getSkinProperties();
    private Date currentDate = new Date();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private DefaultFormatterFactory dff = new DefaultFormatterFactory(new DateFormatter(this.formatter));
    private String now = this.formatter.format(this.currentDate);
    JContentPanel contentPanel = new JContentPanel();

    private JMenuBar buildMenu() {
        JMenuBar menubar = new JMenuBar();
        JMenuItem aboutMenuItem = new JMenuItem("About");
        aboutMenuItem.addActionListener(evt -> {
            new Frog().ribbit();
            String aboutText = "<html><b>Skin Properties Editor<br>version: 2.0<br>author: Tom and David</b></html>";
            JOptionPane.showMessageDialog(this.rootPane, aboutText, "About: " + this.SIMPLE_NAME, 1, Icons.get((String)"dor-32-gradient", (int)64));
        });
        menubar.add(aboutMenuItem);
        return menubar;
    }

    private void getSkinProps() {
        PropertyBinder.syncUI((Map)this.skinProperties.getProperties(), (JComponentHolder)this.contentPanel);
    }

    private void saveSkinProps() {
        Map props = this.skinProperties.getProperties();
        PropertyBinder.getProperties((JComponentHolder)this.contentPanel, (Map)props);
        for (String key : new HashSet(props.keySet())) {
            if (!"".equals(props.get(key))) continue;
            props.remove(key);
        }
        try {
            this.skinProperties.save();
            System.out.println(String.valueOf(new Date()) + " skin.properties saved succesfully.");
        }
        catch (IOException ex) {
            System.out.println(String.valueOf(ex) + " - failed to write skin.properties");
        }
    }

    public SkinPropsEditor() {
        this.setTitle(this.skin + " - Skin Properties Editor");
        if (!Platform.isMac()) {
            this.setIconImages(JAlbumFrameIcons.getInstance().getWindowIcons());
        }
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.buildMenu());
        this.getSkinProps();
        this.getContentPane().add(this.contentPanel);
        this.pack();
        ContextHelp help = ContextHelp.getInstance();
        help.installHelpButton((JFrame)this, ContextHelp.Corner.TOP_RIGHT);
        help.add((JComponent)this.contentPanel, "http://jalbum.net/api/se/datadosen/jalbum/SkinProperties.html");
        this.setVisible(true);
        this.contentPanel.description.setCaretPosition(0);
        this.contentPanel.cancelButton.requestFocusInWindow();
    }

    public class JContentPanel
    extends JPanel
    implements JComponentHolder,
    ManagesImport {
        public JTextField title = new JTextField("", 40);
        public JTextField icon = new JTextField("", 40);
        public JTextField supportForum = new JTextField("", 40);
        public JTextField author = new JTextField("", 40);
        public JTextField skinFamily = new JTextField("", 40);
        public JTextField mainClass = new JTextField("", 40);
        public JCheckBox autoWidgetInjection = new JCheckBox();
        public JCheckBox fullSiteSupport = new JCheckBox();
        public JCheckBox fullVideoSupport = new JCheckBox();
        public JCheckBox makeWebLocationSlides = new JCheckBox();
        public JCheckBox makeDeepJSONData = new JCheckBox();
        public JCheckBox separateThemeImage = new JCheckBox();
        public JCheckBox editableThemeImageSize = new JCheckBox();
        public JCheckBox separateDescription = new JCheckBox();
        public JCheckBox singleIndexPage = new JCheckBox();
        JTextField themeImageSizeName = new JTextField(20);
        public JTextField company = new JTextField("", 40);
        public JTextArea description = new JTextArea(){
            {
                this.setRows(5);
                this.setColumns(40);
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setFont(new Font("Tahoma", 0, 11));
            }
        };
        public JScrollPane spDescription = new JScrollPane(){
            {
                this.setViewportView(JContentPanel.this.description);
            }
        };
        public JTextField homePage = new JTextField("", 40);
        public JTextField requiredJalbumVersion = new JTextField("", 40);
        public JTextField username = new JTextField("", 40);
        public JTextField version = new JTextField("", 40);
        public JFormattedTextField creationDate;
        public JFormattedTextField lastModifiedDate;
        private JButton saveButton;
        private JButton cancelButton;
        private JButton nowButton;

        public JContentPanel() {
            this.creationDate = new JFormattedTextField(SkinPropsEditor.this.dff);
            this.lastModifiedDate = new JFormattedTextField(SkinPropsEditor.this.dff);
            this.saveButton = new JButton("Save"){
                {
                    this.addActionListener(evt -> {
                        SkinPropsEditor.this.saveSkinProps();
                        SkinPropsEditor.this.dispose();
                    });
                }
            };
            this.cancelButton = new JButton("Cancel"){
                {
                    this.addActionListener(evt -> SkinPropsEditor.this.dispose());
                }
            };
            this.nowButton = new JButton("now!"){
                {
                    this.addActionListener(evt -> JContentPanel.this.lastModifiedDate.setText(SkinPropsEditor.this.now));
                    this.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent evt) {
                            this.setText(SkinPropsEditor.this.now);
                        }

                        @Override
                        public void mouseExited(MouseEvent evt) {
                            this.setText("now!");
                        }
                    });
                }
            };
            this.setLayout((LayoutManager)new MigLayout("wrap 2"));
            this.add(new JLabel("title"));
            this.add(this.title);
            this.add(new JLabel("icon"));
            this.add(this.icon);
            this.add(new JLabel("skinFamily"));
            this.add(this.skinFamily);
            this.add(new JLabel("version"));
            this.add(this.version);
            this.add(new JLabel("author"));
            this.add(this.author);
            this.add(new JLabel("creationDate"));
            this.add((Component)this.creationDate, "split 2");
            this.add(new JLabel("(YYYY-MM-DD)"));
            this.add(new JLabel("lastModifiedDate"));
            this.add((Component)this.lastModifiedDate, "split 3");
            this.add(new JLabel("(YYYY-MM-DD)"));
            this.add(this.nowButton);
            this.add(new JLabel("mainClass"));
            this.add(this.mainClass);
            this.add(new JLabel("autoWidgetInjection"));
            this.add(this.autoWidgetInjection);
            this.add(new JLabel("fullSiteSupport"));
            this.add(this.fullSiteSupport);
            this.add(new JLabel("fullVideoSupport"));
            this.add(this.fullVideoSupport);
            this.add(new JLabel("singleIndexPage"));
            this.add(this.singleIndexPage);
            this.add(new JLabel("makeWebLocationSlides"));
            this.add(this.makeWebLocationSlides);
            this.add(new JLabel("makeDeepJSONData"));
            this.add(this.makeDeepJSONData);
            this.add(new JLabel("separateDescription"));
            this.add(this.separateDescription);
            this.add(new JLabel("separateThemeImage"));
            this.add(this.separateThemeImage);
            this.add(new JLabel("editableThemeImageSize"));
            this.add(this.editableThemeImageSize);
            this.add(new JLabel("themeImageSizeName"));
            this.add(this.themeImageSizeName);
            this.add(new JLabel("requiredJalbumVersion"));
            this.add(this.requiredJalbumVersion);
            this.add(new JLabel("company"));
            this.add(this.company);
            this.add(new JLabel("username"));
            this.add(this.username);
            this.add(new JLabel("homePage"));
            this.add(this.homePage);
            this.add(new JLabel("supportForum"));
            this.add(this.supportForum);
            this.add(new JLabel("description"));
            this.add(this.spDescription);
            this.add((Component)this.saveButton, "cell 1 24, split 2, align right");
            this.add(this.cancelButton);
        }

        public void importVariables(Map<String, Object> skinVariables) {
            if (!skinVariables.containsKey("title")) {
                skinVariables.put("title", SkinPropsEditor.this.skin);
            }
            if (!skinVariables.containsKey("creationDate")) {
                skinVariables.put("creationDate", SkinPropsEditor.this.now);
            }
            if (!skinVariables.containsKey("lastModifiedDate")) {
                skinVariables.put("lastModifiedDate", SkinPropsEditor.this.now);
            }
            if (!skinVariables.containsKey("username") && !SkinPropsEditor.this.accountProfileName.isEmpty()) {
                skinVariables.put("username", SkinPropsEditor.this.accountProfileName.substring(SkinPropsEditor.this.accountProfileName.lastIndexOf("- ") + 2));
            }
        }
    }
}

