/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.jalbum.editor.EnglishLookupSupplier;
import net.jalbum.editor.JTabComponent;
import net.jalbum.editor.JTextPad;
import net.jalbum.editor.Main;
import net.jalbum.editor.OperationCanceledException;
import net.jalbum.io.PCWriter;
import org.fife.io.UnicodeReader;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.ToolTipSupplier;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JStackLabel;
import se.datadosen.component.ToggleAction;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Config;
import se.datadosen.util.Platform;
import se.datadosen.util.StringCodec;

public class JTextPadDocument
extends JPanel {
    private JTextPad owner;
    private JTabComponent tabComponent = new JTabComponent();
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu tabsMenu;
    JMenu lineTerminationMenu;
    JMenu viewMenu;
    JMenu helpMenu;
    JRadioButtonMenuItem pcTerminationStyle = new JRadioButtonMenuItem("PC style");
    JRadioButtonMenuItem unixTerminationStyle = new JRadioButtonMenuItem("UNIX style");
    ButtonGroup terminationStyle = new ButtonGroup();
    private RSyntaxTextArea textArea;
    private AutoCompletion autoCompletion;
    private AbstractCompletionProvider provider;
    private RTextScrollPane textScroller;
    private JStackLabel statusBar;
    private FileChooser fileChooser;
    private PrinterJob printerJob;
    private AbstractParser errorParser;
    int textHash;
    private static final String[] charsetNames = new String[]{"ISO-8859-1", "MacRoman", "US-ASCII", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-8", "windows-1252", "----", "Big5", "Big5-HKSCS", "EUC-CN", "EUC-JP", "euc-jp-linux", "EUC-KR", "EUC-TW", "GB18030", "GBK", "ISCII91", "ISO-2022-CN-CNS", "ISO-2022-CN-GB", "ISO-2022-KR", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "JIS0201", "JIS0208", "JIS0212", "Johab", "KOI8-R", "Shift_JIS", "TIS-620", "windows-1250", "windows-1251", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258", "windows-936", "windows-949", "windows-950"};
    Action undoAction;
    Action newWindowAction;
    Action newTabAction;
    Action openAction;
    Action closeAction;
    Action saveAction;
    Action saveAsAction;
    private boolean printableSetup;
    Action pageSetupAction;
    Action printAction;
    Action goToAction;
    Action completeCodeAction;
    Action tabSizeAction;
    ToggleAction emulatedTabs;
    Action convertTabsToSpaces;
    Action convertSpacesToTabs;
    ToggleAction lineWrapAction;
    ToggleAction lineNumbersAction;
    ToggleAction whiteSpaceAction;
    ToggleAction highlightCurrentLineAction;
    Action fontSizeAction;
    Action aboutAction;
    private boolean warnEdits;
    private String encoding;

    public AbstractCompletionProvider getCompletionProvider() {
        return this.provider;
    }

    JTextPad getOwner() {
        return this.owner;
    }

    public JTextPadDocument(JTextPad owner) {
        this.terminationStyle.add(this.pcTerminationStyle);
        this.terminationStyle.add(this.unixTerminationStyle);
        this.pcTerminationStyle.setSelected(true);
        this.textArea = new RSyntaxTextArea(60, 120){

            protected void paintComponent(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                Map hints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                g.setRenderingHints(hints);
                super.paintComponent((Graphics)g);
            }

            public void setFont(Font font) {
                super.setFont(font);
                if (JTextPadDocument.this.textScroller != null) {
                    JTextPadDocument.this.textScroller.getGutter().setLineNumberFont(this.getFont());
                }
            }
        };
        this.provider = new DefaultCompletionProvider();
        this.statusBar = new JStackLabel();
        this.printerJob = PrinterJob.getPrinterJob();
        this.textHash = 0;
        this.tabComponent.getCloseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JTextPadDocument.this.owner.closeDocument(JTextPadDocument.this);
                }
                catch (OperationCanceledException operationCanceledException) {
                    // empty catch block
                }
            }
        });
        this.undoAction = RSyntaxTextArea.getAction((int)6);
        this.newWindowAction = new AbstractAction("New window"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPad editor = new JTextPad();
                Point rel = JTextPadDocument.this.owner.getLocationOnScreen();
                editor.setLocation(rel.x + 50, rel.y + 50);
                editor.openDocument(null);
            }
        };
        this.newTabAction = new AbstractAction("New tab"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPadDocument document = JTextPadDocument.this.owner.openDocument(null);
                document.setCurrentDirectory(JTextPadDocument.this.getCurrentDirectory());
                JTextPadDocument.this.owner.setCurrentDocument(document);
            }
        };
        this.openAction = new AbstractAction("Open..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser chooser = ChooserFactory.createFilesChooser((Frame)JTextPadDocument.this.owner);
                chooser.setCurrentDirectory(JTextPadDocument.this.fileChooser.getCurrentDirectory());
                chooser.setSelectedFile(JTextPadDocument.this.fileChooser.getSelectedFile());
                chooser.setMultiSelectionEnabled(true);
                int choice = chooser.showOpenDialog((Component)JTextPadDocument.this.owner);
                File[] files = chooser.getSelectedFiles();
                if (choice == 0) {
                    boolean first = true;
                    for (File f : files) {
                        JTextPadDocument document = JTextPadDocument.this.owner.openDocument(f);
                        if (!first) continue;
                        JTextPadDocument.this.owner.setCurrentDocument(document);
                        first = false;
                    }
                }
            }
        };
        this.closeAction = new AbstractAction("Close"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JTextPadDocument.this.owner.closeDocument(JTextPadDocument.this);
                }
                catch (OperationCanceledException operationCanceledException) {
                    // empty catch block
                }
            }
        };
        this.saveAction = new AbstractAction("Save"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = JTextPadDocument.this.getFile();
                if (file == null) {
                    if (e == null) {
                        JTextPadDocument.this.owner.setCurrentDocument(JTextPadDocument.this);
                    }
                    JTextPadDocument.this.saveAsAction.actionPerformed(e);
                } else {
                    JTextPadDocument.this.saveFile(file);
                }
            }
        };
        this.saveAsAction = new AbstractAction("Save As..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, menuShortcutKeyMask | 1));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice = JTextPadDocument.this.fileChooser.showSaveDialog((Component)JTextPadDocument.this.owner);
                File selectedFile = JTextPadDocument.this.fileChooser.getSelectedFile();
                if (choice == 0 && selectedFile != null) {
                    if (selectedFile.exists()) {
                        int answer = JOptionPane.showConfirmDialog(JTextPadDocument.this.owner, selectedFile.getAbsolutePath() + " already exists.\nDo you wish to replace it?", "Save As", 1, 2);
                        if (answer == 0) {
                            JTextPadDocument.this.saveFile(selectedFile);
                            return;
                        }
                        if (answer == 1) {
                            return;
                        }
                    }
                    JTextPadDocument.this.saveFile(selectedFile);
                    return;
                }
                if (e == null) {
                    throw new OperationCanceledException();
                }
            }
        };
        this.printableSetup = false;
        this.pageSetupAction = new AbstractAction("Page Setup..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, menuShortcutKeyMask | 1));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PageFormat pf = JTextPadDocument.this.printerJob.pageDialog(JTextPadDocument.this.printerJob.defaultPage());
                JTextPadDocument.this.printerJob.setPrintable((Printable)JTextPadDocument.this.textArea, pf);
                JTextPadDocument.this.printableSetup = true;
            }
        };
        this.printAction = new AbstractAction("Print..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean doPrint;
                if (!JTextPadDocument.this.printableSetup) {
                    JTextPadDocument.this.printerJob.setPrintable((Printable)JTextPadDocument.this.textArea);
                    JTextPadDocument.this.printableSetup = true;
                }
                if (doPrint = JTextPadDocument.this.printerJob.printDialog()) {
                    try {
                        JTextPadDocument.this.printerJob.print();
                    }
                    catch (PrinterException ex) {
                        JOptionPane.showMessageDialog(JTextPadDocument.this.owner, "An error occured during printing: " + ex.getMessage(), "jAlbum Textpad", 0);
                    }
                }
            }
        };
        this.goToAction = new AbstractAction("Go To..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPadDocument.this.owner, "Line Number:", "Goto line", -1);
                int line = Integer.parseInt(s) - 1;
                try {
                    int i = JTextPadDocument.this.textArea.getLineStartOffset(line);
                    JTextPadDocument.this.textArea.setCaretPosition(i);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        this.completeCodeAction = new AbstractAction("Complete Code"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.autoCompletion.doCompletion();
            }
        };
        this.tabSizeAction = new AbstractAction("Set tab size"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPadDocument.this.owner, "Tab size:", "" + JTextPadDocument.this.textArea.getTabSize());
                int tabSize = Integer.parseInt(s);
                JTextPadDocument.this.textArea.setTabSize(tabSize);
            }
        };
        this.emulatedTabs = new ToggleAction("Emulate tabs with spaces"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setTabsEmulated(this.isSelected());
            }
        };
        this.convertTabsToSpaces = new ToggleAction("Convert tabs to spaces"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.convertTabsToSpaces();
            }
        };
        this.convertSpacesToTabs = new ToggleAction("Convert spaces to tabs"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.convertSpacesToTabs();
            }
        };
        this.lineWrapAction = new ToggleAction("Line Wrap"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setLineWrap(this.isSelected());
            }
        };
        this.lineNumbersAction = new ToggleAction("Line Numbers"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textScroller.setLineNumbersEnabled(this.isSelected());
            }
        };
        this.whiteSpaceAction = new ToggleAction("White Space"){

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setWhitespaceVisible(this.isSelected());
            }
        };
        this.highlightCurrentLineAction = new ToggleAction("Highlight current line"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPadDocument.this.textArea.setHighlightCurrentLine(this.isSelected());
            }
        };
        this.fontSizeAction = new AbstractAction("Set font size..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPadDocument.this.owner, "Font size:", "" + JTextPadDocument.this.textArea.getFont().getSize());
                try {
                    float fontSize = Float.parseFloat(s);
                    for (JTextPadDocument doc : JTextPadDocument.this.owner.getDocuments()) {
                        doc.textArea.setFont(JTextPadDocument.this.textArea.getFont().deriveFont(fontSize));
                    }
                    Preferences.userNodeForPackage(JTextPadDocument.class).putFloat("fontSize", fontSize);
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.aboutAction = new AbstractAction("About jAlbum Textpad"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(0, 1));
                panel.add(new JLabel("jAlbum Textpad 2.2"));
                panel.add(new JLabel("By David Ekholm, Jalbum"));
                panel.add(new JLabel("Thanks to Robert Futrell for providing the excellent"));
                panel.add(new JLabel("text editor engine RSyntaxTextArea!"));
                JOptionPane.showMessageDialog(JTextPadDocument.this.owner, panel, "About jAlbum Textpad", 1);
            }
        };
        this.warnEdits = true;
        this.encoding = "UTF-8";
        this.init(owner);
    }

    public JTextPadDocument(JTextPad owner, File file) {
        this.terminationStyle.add(this.pcTerminationStyle);
        this.terminationStyle.add(this.unixTerminationStyle);
        this.pcTerminationStyle.setSelected(true);
        this.textArea = new /* invalid duplicate definition of identical inner class */;
        this.provider = new DefaultCompletionProvider();
        this.statusBar = new JStackLabel();
        this.printerJob = PrinterJob.getPrinterJob();
        this.textHash = 0;
        this.tabComponent.getCloseButton().addActionListener(new /* invalid duplicate definition of identical inner class */);
        this.undoAction = RSyntaxTextArea.getAction((int)6);
        this.newWindowAction = new /* invalid duplicate definition of identical inner class */;
        this.newTabAction = new /* invalid duplicate definition of identical inner class */;
        this.openAction = new /* invalid duplicate definition of identical inner class */;
        this.closeAction = new /* invalid duplicate definition of identical inner class */;
        this.saveAction = new /* invalid duplicate definition of identical inner class */;
        this.saveAsAction = new /* invalid duplicate definition of identical inner class */;
        this.printableSetup = false;
        this.pageSetupAction = new /* invalid duplicate definition of identical inner class */;
        this.printAction = new /* invalid duplicate definition of identical inner class */;
        this.goToAction = new /* invalid duplicate definition of identical inner class */;
        this.completeCodeAction = new /* invalid duplicate definition of identical inner class */;
        this.tabSizeAction = new /* invalid duplicate definition of identical inner class */;
        this.emulatedTabs = new /* invalid duplicate definition of identical inner class */;
        this.convertTabsToSpaces = new /* invalid duplicate definition of identical inner class */;
        this.convertSpacesToTabs = new /* invalid duplicate definition of identical inner class */;
        this.lineWrapAction = new /* invalid duplicate definition of identical inner class */;
        this.lineNumbersAction = new /* invalid duplicate definition of identical inner class */;
        this.whiteSpaceAction = new /* invalid duplicate definition of identical inner class */;
        this.highlightCurrentLineAction = new /* invalid duplicate definition of identical inner class */;
        this.fontSizeAction = new /* invalid duplicate definition of identical inner class */;
        this.aboutAction = new /* invalid duplicate definition of identical inner class */;
        this.warnEdits = true;
        this.encoding = "UTF-8";
        this.init(owner);
        if (file != null) {
            if (file.isDirectory()) {
                this.setCurrentDirectory(file);
            } else {
                this.setCurrentDirectory(file.getParentFile());
                this.openFile(file);
            }
        }
    }

    public JTabComponent getTabComponent() {
        return this.tabComponent;
    }

    JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.createMenuBar();
        }
        return this.menuBar;
    }

    JStackLabel getStatusBar() {
        return this.statusBar;
    }

    RSyntaxTextArea getTextArea() {
        return this.textArea;
    }

    void openFile(File file) {
        this.openFile(file, null);
    }

    void openFile(File file, String enc) {
        try {
            String line;
            byte[] raw = Files.readAllBytes(file.toPath());
            StringCodec sc = new StringCodec();
            String tmp = sc.decode(raw);
            if (tmp.indexOf(13) >= 0) {
                this.pcTerminationStyle.setSelected(true);
            } else {
                this.unixTerminationStyle.setSelected(true);
            }
            if (enc == null) {
                this.encoding = sc.getDetectedEncoding();
                if (this.encoding == null) {
                    this.encoding = System.getProperty("jalbum.file.encoding", System.getProperty("file.encoding"));
                }
            } else {
                this.encoding = enc;
            }
            this.updateStatusBar();
            StringBuilder buf = new StringBuilder();
            BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new ByteArrayInputStream(raw), this.encoding));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String text = buf.toString();
            this.fileChooser.setSelectedFile(file);
            this.owner.getRootPane().putClientProperty("Window.documentFile", file);
            this.setSyntaxStyle();
            this.warnEdits = false;
            this.textArea.setText(text);
            this.warnEdits = true;
            this.textArea.setCaretPosition(0);
            this.textArea.discardAllEdits();
            this.owner.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            this.tabComponent.setChanged(false);
            this.textHash = text.hashCode();
            this.updateTitle();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.owner, "Can't open file " + file.getName() + ": " + ex.getMessage(), "jAlbum Textpad", 0);
        }
    }

    private void writeTextFile(String content, File file) throws IOException {
        if (!StringCodec.isEncodable((String)content, (String)this.encoding)) {
            JOptionPane.showMessageDialog(this.owner, "This document must be saved with UTF-8 encoding to avoid information loss.\nThe current encoding doesn't support the characters present.", "jAlbum Textpad", 2);
        }
        Writer writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);
        if (this.pcTerminationStyle.isSelected()) {
            writer = new PCWriter(writer);
        }
        writer.write(content);
        ((Writer)writer).close();
    }

    void saveFile(File file) {
        try {
            String text = this.textArea.getText();
            this.writeTextFile(text, file);
            this.textHash = text.hashCode();
            this.owner.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            this.tabComponent.setChanged(false);
            this.fileChooser.setSelectedFile(file);
            this.setSyntaxStyle();
            this.updateTitle();
            this.statusBar.setText("Document written to " + file.getAbsolutePath());
            this.owner.getRootPane().putClientProperty("Window.documentFile", file);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.owner, "Can't write to file " + file.getName() + ": " + ex.getMessage(), "jAlbum Textpad", 0);
        }
    }

    void ensureNoLoss() throws OperationCanceledException {
        int currentTextHash = this.textArea.getText().hashCode();
        if (currentTextHash != this.textHash) {
            this.owner.setCurrentDocument(this);
            this.owner.setVisible(true);
            int answer = JOptionPane.showConfirmDialog(this.owner, "Save changes to " + this.getTitle() + "?", "jAlbum Textpad", 1, 2);
            if (answer == 1) {
                return;
            }
            if (answer == 0) {
                this.saveAction.actionPerformed(null);
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    public void setSyntaxStyle() {
        String ext = JTextPadDocument.extensionOf(this.getFile()).toLowerCase();
        String syntaxStyle = JTextPad.fileTypes.get(ext);
        if (syntaxStyle == null) {
            syntaxStyle = "text/plain";
        }
        this.textArea.setSyntaxEditingStyle(syntaxStyle);
        this.updateStatusBar();
        if (syntaxStyle.equals("text/properties")) {
            this.textArea.setToolTipSupplier((ToolTipSupplier)new EnglishLookupSupplier(this.getFile()));
        } else {
            this.textArea.setToolTipSupplier(null);
        }
    }

    public File getFile() {
        return this.fileChooser.getSelectedFile();
    }

    public String getTitle() {
        File file = this.getFile();
        if (file == null) {
            return "Untitled";
        }
        return file.getName();
    }

    private void updateStatusBar() {
        int line = this.textArea.getCaretLineNumber() + 1;
        int col = this.textArea.getCaretOffsetFromLineStart() + 1;
        String style = this.pcTerminationStyle.isSelected() ? "PC" : "UNIX";
        this.statusBar.setText("Mode " + this.textArea.getSyntaxEditingStyle() + " | " + this.encoding + " | " + style + " | Ln " + line + ", Col " + col);
    }

    private void init(JTextPad owner) {
        this.owner = owner;
        this.fileChooser = ChooserFactory.createFileChooser((Window)owner);
        this.setLayout(new BorderLayout());
        this.updateTitle();
        ActionListener terminationStyleListner = e -> this.updateStatusBar();
        this.pcTerminationStyle.addActionListener(terminationStyleListner);
        this.unixTerminationStyle.addActionListener(terminationStyleListner);
        this.textScroller = new RTextScrollPane((RTextArea)this.textArea);
        if (Platform.isWindows()) {
            this.textArea.setFont(new Font("Lucida Sans Typewriter", 0, 13));
        }
        this.textArea.restoreDefaultSyntaxScheme();
        this.textArea.setSyntaxEditingStyle("text/plain");
        this.textArea.setLineWrap(true);
        KeyStroke shiftSpace = KeyStroke.getKeyStroke("shift SPACE");
        this.textArea.getInputMap().put(shiftSpace, "insert-space");
        this.textArea.getActionMap().put("insert-space", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JTextPadDocument.this.textArea.getDocument().insertString(JTextPadDocument.this.textArea.getCaretPosition(), " ", null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.provider.setParent(owner.getCompletionProvider());
        this.autoCompletion = new AutoCompletion((CompletionProvider)this.provider){

            protected String getReplacementText(Completion c, Document doc, int start, int len) {
                try {
                    if (start >= 2 && "${".equals(doc.getText(start - 2, 2)) && !JTextPadDocument.this.endsWithCurlyBrace(doc, start)) {
                        return c.getReplacementText() + "}";
                    }
                    return super.getReplacementText(c, doc, start, len);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        this.autoCompletion.setShowDescWindow(true);
        this.autoCompletion.setDescriptionWindowSize(400, 400);
        this.autoCompletion.setExternalURLHandler((e, c, callback) -> {
            System.out.println("URL clicked: " + e.getURL().toString());
            try {
                BrowserLauncher.openURL((String)e.getURL().toString());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(owner, "Can't open URL: " + ex.getMessage(), "jAlbum Textpad", 0);
            }
        });
        this.autoCompletion.install((JTextComponent)this.textArea);
        this.textArea.addCaretListener(e -> this.updateStatusBar());
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){
            int changeCount = 0;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warnCheck();
                JTextPadDocument.this.tabComponent.setChanged(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warnCheck();
                JTextPadDocument.this.tabComponent.setChanged(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warnCheck();
                JTextPadDocument.this.tabComponent.setChanged(true);
            }

            private void warnCheck() {
                JTextPadDocument.this.clearError();
                if (JTextPadDocument.this.warnEdits && this.changeCount++ == 2) {
                    ChainedDirectory bundledSkinsDir = Config.getConfig().chainedSkinsDir.getBackgroundDirectory();
                    File file = JTextPadDocument.this.getFile();
                    if (file != null && JTextPadDocument.isSubdirectoryOf(file, (File)bundledSkinsDir)) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(JTextPadDocument.this, "You are modifying a bundled skin.\nYour changes will be lost when updating Album.\nPlease use \"Tools->Skin developer->Create new skin\"\nto modify a copy instead.", "Modifying bundled files", 2));
                    }
                }
            }
        });
        if (owner.darkTheme != null) {
            owner.darkTheme.apply(this.textArea);
        }
        float fontSize = Preferences.userNodeForPackage(JTextPadDocument.class).getFloat("fontSize", 13.0f);
        this.textArea.setFont(this.textArea.getFont().deriveFont(fontSize));
        this.textArea.setCodeFoldingEnabled(true);
        this.add((Component)this.textScroller, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 6));
        southPanel.add((Component)this.statusBar, "Before");
        southPanel.add((Component)new JLabel(" "), "After");
        this.statusBar.setText("no text");
        this.add((Component)southPanel, "South");
        this.undoAction.addPropertyChangeListener(evt -> {
            if (owner.getCurrentDocument() != this) {
                return;
            }
            if ("enabled".equals(evt.getPropertyName())) {
                int currentTextHash = this.textArea.getText().hashCode();
                boolean changed = currentTextHash != this.textHash;
                owner.getRootPane().putClientProperty("Window.documentModified", "" + changed);
                this.tabComponent.setChanged(changed);
            }
        });
    }

    public void clearError() {
        this.setError(-1, null);
    }

    public void setError(final int line, final String errorMessage) {
        if (this.errorParser != null) {
            this.textArea.removeParser((Parser)this.errorParser);
            this.errorParser = null;
        }
        if (errorMessage != null) {
            this.errorParser = new AbstractParser(this){
                final /* synthetic */ JTextPadDocument this$0;
                {
                    this.this$0 = this$0;
                }

                public ParseResult parse(RSyntaxDocument doc, String style) {
                    return new DefaultParseResult((Parser)this){

                        public List<ParserNotice> getNotices() {
                            ArrayList<ParserNotice> notices = new ArrayList<ParserNotice>();
                            notices.add((ParserNotice)new DefaultParserNotice(this.getParser(), errorMessage, line - 1));
                            return notices;
                        }
                    };
                }
            };
            this.textArea.addParser((Parser)this.errorParser);
        }
    }

    private boolean endsWithCurlyBrace(Document doc, int offset) throws BadLocationException {
        char[] chars;
        int len = doc.getLength();
        int remaining = len - offset;
        if (remaining > 100) {
            remaining = 100;
        }
        String text = doc.getText(offset, remaining);
        for (char c : chars = text.toCharArray()) {
            if (c == '}') {
                return true;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return false;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.editMenu = new JMenu("Edit");
        this.tabsMenu = new JMenu("Tabs");
        this.lineTerminationMenu = new JMenu("Line termination");
        this.viewMenu = new JMenu("View");
        this.helpMenu = new JMenu("Help");
        this.fileMenu.add(new JMenuItem(this.newWindowAction));
        this.fileMenu.add(new JMenuItem(this.newTabAction));
        this.fileMenu.add(new JMenuItem(this.openAction));
        JMenu reopenWithEncodingMenu = new JMenu("Reopen with encoding");
        for (String enc : charsetNames) {
            if (enc.equals("----")) {
                reopenWithEncodingMenu.addSeparator();
                continue;
            }
            JMenuItem item = new JMenuItem(enc);
            item.addActionListener(ae -> {
                File file = this.getFile();
                if (file != null) {
                    this.openFile(file, enc);
                }
            });
            reopenWithEncodingMenu.add(item);
        }
        this.fileMenu.add(reopenWithEncodingMenu);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.closeAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.saveAction));
        JMenu saveWithEncodingMenu = new JMenu("Save with encoding");
        for (String enc : charsetNames) {
            if (enc.equals("----")) {
                saveWithEncodingMenu.addSeparator();
                continue;
            }
            JMenuItem item = new JMenuItem(enc);
            item.addActionListener(ae -> {
                this.encoding = enc;
                this.updateStatusBar();
                this.saveAction.actionPerformed(null);
            });
            saveWithEncodingMenu.add(item);
        }
        this.fileMenu.add(saveWithEncodingMenu);
        this.fileMenu.add(new JMenuItem(this.saveAsAction));
        this.fileMenu.add(new JMenuItem(this.owner.saveAllAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.pageSetupAction));
        this.fileMenu.add(new JMenuItem(this.printAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.owner.exitAction));
        this.editMenu.add(new JMenuItem((Action)RSyntaxTextArea.getAction((int)6)));
        this.editMenu.add(new JMenuItem((Action)RSyntaxTextArea.getAction((int)4)));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem((Action)RSyntaxTextArea.getAction((int)1)));
        this.editMenu.add(new JMenuItem((Action)RSyntaxTextArea.getAction((int)0)));
        this.editMenu.add(new JMenuItem((Action)RSyntaxTextArea.getAction((int)3)));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.owner.findAction));
        this.editMenu.add(new JMenuItem(this.owner.findNextAction));
        this.editMenu.add(new JMenuItem(this.owner.replaceAction));
        this.editMenu.add(new JMenuItem(this.goToAction));
        this.editMenu.add(new JSeparator());
        this.tabsMenu.add(this.tabSizeAction);
        this.tabsMenu.add(this.emulatedTabs.createJCheckBoxMenuItem());
        this.tabsMenu.add(this.convertTabsToSpaces);
        this.tabsMenu.add(this.convertSpacesToTabs);
        this.editMenu.add(this.tabsMenu);
        this.lineTerminationMenu.add(this.pcTerminationStyle);
        this.lineTerminationMenu.add(this.unixTerminationStyle);
        this.editMenu.add(this.lineTerminationMenu);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.completeCodeAction));
        this.editMenu.add(new JMenuItem((Action)RSyntaxTextArea.getAction((int)5)));
        this.viewMenu.add(this.lineWrapAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.lineNumbersAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.whiteSpaceAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.highlightCurrentLineAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.fontSizeAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.owner.previousDocumentAction);
        this.viewMenu.add(this.owner.nextDocumentAction);
        this.helpMenu.add(new JMenuItem(this.aboutAction));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.viewMenu);
        if (!Main.isMac() || !Main.runsStandalone) {
            this.menuBar.add(this.helpMenu);
        }
    }

    private void updateTitle() {
        this.tabComponent.setTitle(this.getTitle());
        this.owner.updateTitle();
    }

    private static String extensionOf(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1);
    }

    private static String extensionOf(File file) {
        return JTextPadDocument.extensionOf(file.getName());
    }

    private static boolean isSubdirectoryOf(File subdir, File dir) {
        File parent = subdir.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.equals(dir)) {
            return true;
        }
        return JTextPadDocument.isSubdirectoryOf(parent, dir);
    }

    private static class BackgroundThread {
        private BackgroundThread() {
        }

        public static Thread invoke(Runnable r) {
            Thread bgThread = new Thread(r, "Background thread");
            bgThread.setDaemon(true);
            bgThread.start();
            return bgThread;
        }
    }
}

