/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.RecordA;
import xyz.gianlu.zeroconf.RecordAAAA;
import xyz.gianlu.zeroconf.RecordPTR;
import xyz.gianlu.zeroconf.RecordSRV;
import xyz.gianlu.zeroconf.RecordTXT;

public final class Service {
    private final String alias;
    private final String service;
    private final int port;
    private final Map<String, String> text;
    private final List<InetAddress> addresses = new ArrayList<InetAddress>();
    private String domain;
    private String protocol;
    private String host;

    public Service(@NotNull String alias, @NotNull String service, int port) {
        this.alias = alias;
        for (int i = 0; i < alias.length(); ++i) {
            char c = alias.charAt(i);
            if (c >= ' ' && c != '\u007f') continue;
            throw new IllegalArgumentException(alias);
        }
        this.service = service;
        this.port = port;
        this.protocol = "tcp";
        this.text = new LinkedHashMap<String, String>();
    }

    private static void esc(String in, StringBuilder out) {
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '.' || c == '\\') {
                out.append('\\');
            }
            out.append(c);
        }
    }

    public String toString() {
        return "Service{alias='" + this.alias + '\'' + ", service='" + this.service + '\'' + ", port=" + this.port + ", text=" + this.text + ", addresses=" + this.addresses + ", domain='" + this.domain + '\'' + ", protocol='" + this.protocol + '\'' + ", host='" + this.host + '\'' + '}';
    }

    @NotNull
    public Service setProtocol(String protocol) {
        if (!"tcp".equals(protocol) && !"udp".equals(protocol)) {
            throw new IllegalArgumentException(protocol);
        }
        this.protocol = protocol;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    @NotNull
    public Service setDomain(String domain) {
        if (domain == null || domain.length() < 2 || domain.charAt(0) != '.') {
            throw new IllegalArgumentException(domain);
        }
        this.domain = domain;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    @NotNull
    public Service setHost(String host) {
        this.host = host;
        return this;
    }

    @NotNull
    public Service setText(String text) {
        String[] q;
        this.text.clear();
        for (String s : q = text.split(", *")) {
            String[] r = s.split("=");
            if (r.length != 2) {
                throw new IllegalArgumentException(text);
            }
            this.text.put(r[0], r[1]);
        }
        return this;
    }

    @NotNull
    public Service setText(Map<String, String> text) {
        this.text.clear();
        this.text.putAll(text);
        return this;
    }

    @NotNull
    public Service putText(String key, String value) {
        this.text.put(key, value);
        return this;
    }

    @NotNull
    public Service addAddress(@NotNull InetAddress address) {
        this.addresses.add(address);
        return this;
    }

    @NotNull
    public Service addAddresses(Collection<InetAddress> addresses) {
        this.addresses.addAll(addresses);
        return this;
    }

    public boolean hasAddresses() {
        return !this.addresses.isEmpty();
    }

    @NotNull
    public String getAlias() {
        return this.alias;
    }

    @NotNull
    public String getInstanceName() {
        StringBuilder sb = new StringBuilder();
        Service.esc(this.alias, sb);
        sb.append("._");
        Service.esc(this.service, sb);
        sb.append("._");
        sb.append(this.protocol);
        sb.append(this.domain);
        return sb.toString();
    }

    @NotNull
    public String getServiceName() {
        StringBuilder sb = new StringBuilder();
        sb.append('_');
        Service.esc(this.service, sb);
        sb.append("._");
        sb.append(this.protocol);
        sb.append(this.domain);
        return sb.toString();
    }

    @NotNull
    Packet getPacket() {
        Packet packet = new Packet();
        packet.setAuthoritative(true);
        String fqdn = this.getInstanceName();
        String ptrname = this.getServiceName();
        packet.addAnswer(new RecordPTR(ptrname, fqdn).setTTL(28800));
        packet.addAnswer(new RecordSRV(fqdn, this.host, this.port).setTTL(120));
        if (!this.text.isEmpty()) {
            packet.addAnswer(new RecordTXT(fqdn, this.text).setTTL(120));
        }
        for (InetAddress address : this.addresses) {
            if (address instanceof Inet4Address) {
                packet.addAnswer(new RecordA(this.host, (Inet4Address)address));
                continue;
            }
            if (!(address instanceof Inet6Address)) continue;
            packet.addAnswer(new RecordAAAA(this.host, (Inet6Address)address));
        }
        return packet;
    }
}

