/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.Record;

public final class RecordTXT
extends Record {
    private Map<String, String> values;

    RecordTXT() {
        super(16);
    }

    RecordTXT(String name, Map<String, String> values) {
        this();
        this.setName(name);
        this.values = values;
    }

    RecordTXT(String name, String map) {
        this();
        String[] q;
        this.setName(name);
        this.values = new LinkedHashMap<String, String>();
        for (String s : q = map.split(", *")) {
            String[] kv = s.split("=");
            if (kv.length != 2) continue;
            this.values.put(kv[0], kv[1]);
        }
    }

    @Override
    protected void readData(int len, ByteBuffer in) {
        int end = in.position() + len;
        this.values = new LinkedHashMap<String, String>();
        while (in.position() < end) {
            int slen = in.get() & 0xFF;
            StringBuilder sb = new StringBuilder(slen);
            for (int i = 0; i < slen; ++i) {
                sb.append((char)in.get());
            }
            String value = sb.toString();
            int ix = value.indexOf("=");
            if (ix <= 0) continue;
            this.values.put(value.substring(0, ix), value.substring(ix + 1));
        }
    }

    @Override
    protected int writeData(ByteBuffer out, Packet packet) {
        if (this.values != null) {
            int len = 0;
            for (Map.Entry<String, String> e : this.values.entrySet()) {
                String value = e.getKey() + "=" + e.getValue();
                out.put((byte)value.length());
                out.put(value.getBytes(StandardCharsets.UTF_8));
                len += value.length() + 1;
            }
            return len;
        }
        return -1;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{type:text, name:\"");
        sb.append(this.getName());
        sb.append("\"");
        if (this.values != null) {
            sb.append(", values:");
            sb.append(this.getValues());
        }
        sb.append('}');
        return sb.toString();
    }
}

