/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.Record;

public final class RecordSRV
extends Record {
    private int priority;
    private int weight;
    private int port;
    private String target;

    RecordSRV() {
        super(33);
    }

    RecordSRV(String name, String target, int port) {
        this();
        this.setName(name);
        this.target = target;
        this.port = port;
    }

    @Override
    protected void readData(int len, ByteBuffer in) {
        this.priority = in.getShort() & 0xFFFF;
        this.weight = in.getShort() & 0xFFFF;
        this.port = in.getShort() & 0xFFFF;
        this.target = RecordSRV.readName(in);
    }

    @Override
    protected int writeData(ByteBuffer out, Packet packet) {
        if (this.target != null) {
            out.putShort((short)this.priority);
            out.putShort((short)this.weight);
            out.putShort((short)this.port);
            return 6 + RecordSRV.writeName(this.target, out, packet);
        }
        return -1;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{type:srv, name:\"");
        sb.append(this.getName());
        sb.append('\"');
        if (this.target != null) {
            sb.append(", priority:");
            sb.append(this.getPriority());
            sb.append(", weight:");
            sb.append(this.getWeight());
            sb.append(", port:");
            sb.append(this.getPort());
            sb.append(", target:\"");
            sb.append(this.getTarget());
            sb.append('\"');
        }
        sb.append('}');
        return sb.toString();
    }
}

