/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.Record;

public final class RecordAAAA
extends Record {
    private byte[] address;

    RecordAAAA() {
        super(28);
    }

    RecordAAAA(String name, Inet6Address value) {
        this();
        this.setName(name);
        this.setTTL(120);
        this.address = value.getAddress();
    }

    @Override
    protected void readData(int len, ByteBuffer in) {
        this.address = new byte[len];
        in.get(this.address);
    }

    @Override
    protected int writeData(ByteBuffer out, Packet packet) {
        if (this.address != null) {
            out.put(this.address);
            return this.address.length;
        }
        return -1;
    }

    @Nullable
    public Inet6Address getAddress() {
        try {
            return this.address == null ? null : (Inet6Address)InetAddress.getByAddress(this.address);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "{type:aaaa, name:\"" + this.getName() + "\", address:\"" + this.getAddress() + "\"}";
    }
}

