/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.nio.ByteBuffer;
import java.util.Arrays;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.RecordA;
import xyz.gianlu.zeroconf.RecordAAAA;
import xyz.gianlu.zeroconf.RecordANY;
import xyz.gianlu.zeroconf.RecordPTR;
import xyz.gianlu.zeroconf.RecordSRV;
import xyz.gianlu.zeroconf.RecordTXT;

public class Record {
    static final int TYPE_A = 1;
    static final int TYPE_PTR = 12;
    static final int TYPE_CNAME = 5;
    static final int TYPE_TXT = 16;
    static final int TYPE_AAAA = 28;
    static final int TYPE_SRV = 33;
    static final int TYPE_NSEC = 47;
    static final int TYPE_ANY = 255;
    private final long timestamp = System.currentTimeMillis();
    private final int type;
    protected int ttl;
    private String name;
    private int clazz;
    private byte[] data;

    Record(int type) {
        this.type = type & 0xFFFF;
        this.setTTL(4500);
        this.clazz = 1;
    }

    protected static int writeName(String name, ByteBuffer out, Packet packet) {
        int len = name.length();
        int start = 0;
        for (int i = 0; i <= len; ++i) {
            int c;
            int n = c = i == len ? 46 : (int)name.charAt(i);
            if (c != 46) continue;
            out.put((byte)(i - start));
            for (int j = start; j < i; ++j) {
                out.put((byte)name.charAt(j));
            }
            start = i + 1;
        }
        out.put((byte)0);
        return name.length() + 2;
    }

    protected static String readName(ByteBuffer in) {
        int len;
        StringBuilder sb = new StringBuilder();
        while ((len = in.get() & 0xFF) > 0) {
            if (len >= 64) {
                int off = (len & 0x3F) << 8 | in.get() & 0xFF;
                int oldPos = in.position();
                in.position(off);
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(Record.readName(in));
                in.position(oldPos);
                break;
            }
            if (sb.length() > 0) {
                sb.append('.');
            }
            while (len-- > 0) {
                sb.append((char)(in.get() & 0xFF));
            }
        }
        return sb.toString();
    }

    static Record readAnswer(ByteBuffer in) {
        String name = Record.readName(in);
        int type = in.getShort() & 0xFFFF;
        Record record = Record.getInstance(type);
        record.setName(name);
        record.clazz = in.getShort() & 0xFFFF;
        record.ttl = in.getInt();
        int len = in.getShort() & 0xFFFF;
        record.readData(len, in);
        return record;
    }

    static Record readQuestion(ByteBuffer in) {
        String name = Record.readName(in);
        int type = in.getShort() & 0xFFFF;
        Record record = Record.getInstance(type);
        record.setName(name);
        record.clazz = in.getShort() & 0xFFFF;
        return record;
    }

    private static Record getInstance(int type) {
        switch (type) {
            case 1: {
                return new RecordA();
            }
            case 28: {
                return new RecordAAAA();
            }
            case 33: {
                return new RecordSRV();
            }
            case 12: {
                return new RecordPTR();
            }
            case 16: {
                return new RecordTXT();
            }
            case 255: {
                return new RecordANY();
            }
        }
        return new Record(type);
    }

    public String getName() {
        return this.name;
    }

    Record setName(String name) {
        this.name = name;
        return this;
    }

    public int getType() {
        return this.type;
    }

    Record setTTL(int ttl) {
        this.ttl = ttl;
        return this;
    }

    protected void readData(int len, ByteBuffer in) {
        this.data = new byte[len];
        in.get(this.data);
    }

    protected int writeData(ByteBuffer out, Packet packet) {
        if (this.data != null) {
            out.put(this.data);
            return this.data.length;
        }
        return -1;
    }

    public boolean isUnicastQuery() {
        return (this.clazz & 0x80) != 0;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.timestamp + (long)this.ttl * 1000L;
    }

    public String toString() {
        return "Record{type=" + this.type + ", ttl=" + this.ttl + ", name='" + this.name + '\'' + ", clazz=" + this.clazz + ", data=" + Arrays.toString(this.data) + '}';
    }

    void write(ByteBuffer out, Packet packet) {
        Record.writeName(this.name, out, packet);
        out.putShort((short)this.type);
        out.putShort((short)this.clazz);
        out.putInt(this.ttl);
        int pos = out.position();
        out.putShort((short)0);
        int len = this.writeData(out, packet);
        if (len > 0) {
            out.putShort(pos, (short)len);
        } else {
            out.position(pos);
        }
    }
}

