/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import xyz.gianlu.zeroconf.Record;

public final class Packet {
    private static final int FLAG_RESPONSE = 15;
    private static final int FLAG_AA = 10;
    private final List<Record> questions;
    private final List<Record> answers;
    private final List<Record> authorities;
    private final List<Record> additionals;
    private int id;
    private int flags;
    private InetSocketAddress address;

    Packet() {
        this(0);
    }

    Packet(int id) {
        this.id = id;
        this.questions = new ArrayList<Record>();
        this.answers = new ArrayList<Record>();
        this.authorities = new ArrayList<Record>();
        this.additionals = new ArrayList<Record>();
        this.setResponse(true);
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    int getID() {
        return this.id;
    }

    boolean isResponse() {
        return this.isFlag(15);
    }

    void setResponse(boolean on) {
        this.setFlag(15, on);
    }

    boolean isAuthoritative() {
        return this.isFlag(10);
    }

    void setAuthoritative(boolean on) {
        this.setFlag(10, on);
    }

    private boolean isFlag(int flag) {
        return (this.flags & 1 << flag) != 0;
    }

    private void setFlag(int flag, boolean on) {
        this.flags = on ? (this.flags |= 1 << flag) : (this.flags &= ~(1 << flag));
    }

    void read(ByteBuffer in, InetSocketAddress address) {
        int i;
        byte[] q = new byte[in.remaining()];
        in.get(q);
        in.position(0);
        this.address = address;
        this.id = in.getShort() & 0xFFFF;
        this.flags = in.getShort() & 0xFFFF;
        int numquestions = in.getShort() & 0xFFFF;
        int numanswers = in.getShort() & 0xFFFF;
        int numauthorities = in.getShort() & 0xFFFF;
        int numadditionals = in.getShort() & 0xFFFF;
        for (i = 0; i < numquestions; ++i) {
            this.questions.add(Record.readQuestion(in));
        }
        for (i = 0; i < numanswers; ++i) {
            if (!in.hasRemaining()) continue;
            this.answers.add(Record.readAnswer(in));
        }
        for (i = 0; i < numauthorities; ++i) {
            if (!in.hasRemaining()) continue;
            this.authorities.add(Record.readAnswer(in));
        }
        for (i = 0; i < numadditionals; ++i) {
            if (!in.hasRemaining()) continue;
            this.additionals.add(Record.readAnswer(in));
        }
    }

    void write(ByteBuffer out) {
        out.putShort((short)this.id);
        out.putShort((short)this.flags);
        out.putShort((short)this.questions.size());
        out.putShort((short)this.answers.size());
        out.putShort((short)this.authorities.size());
        out.putShort((short)this.additionals.size());
        for (Record r : this.questions) {
            r.write(out, this);
        }
        for (Record r : this.answers) {
            r.write(out, this);
        }
        for (Record r : this.authorities) {
            r.write(out, this);
        }
        for (Record r : this.additionals) {
            r.write(out, this);
        }
    }

    public String toString() {
        return "Packet{id=" + this.id + ", flags=" + this.flags + ", questions=" + this.questions + ", answers=" + this.answers + ", authorities=" + this.authorities + ", additionals=" + this.additionals + ", address=" + this.address + '}';
    }

    List<Record> getQuestions() {
        return this.questions;
    }

    List<Record> getAnswers() {
        return this.answers;
    }

    List<Record> getAdditionals() {
        return this.additionals;
    }

    void addAnswer(Record record) {
        this.answers.add(record);
    }

    void addQuestion(Record record) {
        this.questions.add(record);
    }

    void addAdditional(Record record) {
        this.additionals.add(record);
    }

    void addAuthority(Record record) {
        this.authorities.add(record);
    }
}

