/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.zeroconf.Record;
import xyz.gianlu.zeroconf.RecordSRV;

public final class DiscoveredService {
    public final String target;
    public final int port;
    public final String name;
    public final String service;
    public final String protocol;
    public final String domain;
    public final String serviceName;
    private final long expiration;
    private final List<Record> relatedRecords = new ArrayList<Record>(5);

    DiscoveredService(@NotNull RecordSRV record) {
        this.expiration = System.currentTimeMillis() + (long)record.ttl * 1000L;
        this.target = record.getTarget();
        this.port = record.getPort();
        this.serviceName = record.getName();
        String[] split = this.serviceName.split("\\.");
        if (split.length != 4) {
            throw new IllegalArgumentException("Invalid service name: " + record.getName());
        }
        this.name = split[0];
        this.service = split[1];
        this.protocol = split[2];
        this.domain = "." + split[3];
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiration;
    }

    void addRelatedRecord(@NotNull Record record) {
        this.relatedRecords.removeIf(Record::isExpired);
        this.relatedRecords.add(record);
    }

    @NotNull
    public List<Record> getRelatedRecords() {
        return new ArrayList<Record>(this.relatedRecords);
    }

    @NotNull
    public List<InetSocketAddress> getAddresses() {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(3);
        for (Record record : this.relatedRecords) {
            if (!(record instanceof RecordSRV)) continue;
            list.add(new InetSocketAddress(((RecordSRV)record).getTarget(), ((RecordSRV)record).getPort()));
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveredService that = (DiscoveredService)o;
        if (this.port != that.port) {
            return false;
        }
        if (!this.target.equals(that.target)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.service.equals(that.service)) {
            return false;
        }
        if (!this.protocol.equals(that.protocol)) {
            return false;
        }
        return this.domain.equals(that.domain);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.service.hashCode();
        result = 31 * result + this.protocol.hashCode();
        result = 31 * result + this.domain.hashCode();
        return result;
    }

    public String toString() {
        return "DiscoveredService{target='" + this.target + '\'' + ", port=" + this.port + ", name='" + this.name + '\'' + ", service='" + this.service + '\'' + ", protocol='" + this.protocol + '\'' + ", domain='" + this.domain + '\'' + '}';
    }
}

