/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.control.mediaslider.skin;

import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import net.jalbum.control.mediaslider.behavior.BehaviorBase;
import net.jalbum.control.mediaslider.skin.MultiplePropertyChangeListenerHandler;

public abstract class BehaviorSkinBase<C extends Control, BB extends BehaviorBase<C>>
extends SkinBase<C> {
    protected static final boolean IS_TOUCH_SUPPORTED = Platform.isSupported((ConditionalFeature)ConditionalFeature.INPUT_TOUCH);
    private BB behavior;
    private MultiplePropertyChangeListenerHandler changeListenerHandler;
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent e) {
            EventType type = e.getEventType();
            if (type == MouseEvent.MOUSE_ENTERED) {
                BehaviorSkinBase.this.behavior.mouseEntered(e);
            } else if (type == MouseEvent.MOUSE_EXITED) {
                BehaviorSkinBase.this.behavior.mouseExited(e);
            } else if (type == MouseEvent.MOUSE_PRESSED) {
                BehaviorSkinBase.this.behavior.mousePressed(e);
            } else if (type == MouseEvent.MOUSE_RELEASED) {
                BehaviorSkinBase.this.behavior.mouseReleased(e);
            } else if (type == MouseEvent.MOUSE_DRAGGED) {
                BehaviorSkinBase.this.behavior.mouseDragged(e);
            } else {
                throw new AssertionError((Object)"Unsupported event type received");
            }
        }
    };
    private final EventHandler<ContextMenuEvent> contextMenuHandler = new EventHandler<ContextMenuEvent>(){

        public void handle(ContextMenuEvent event) {
            BehaviorSkinBase.this.behavior.contextMenuRequested(event);
        }
    };

    protected BehaviorSkinBase(C control, BB behavior) {
        super(control);
        if (behavior == null) {
            throw new IllegalArgumentException("Cannot pass null for behavior");
        }
        this.behavior = behavior;
        control.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
        control.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        control.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        control.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        control.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        control.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this.contextMenuHandler);
    }

    public final BB getBehavior() {
        return this.behavior;
    }

    public void dispose() {
        Control control;
        if (this.changeListenerHandler != null) {
            this.changeListenerHandler.dispose();
        }
        if ((control = this.getSkinnable()) != null) {
            control.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
            control.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
            control.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
            control.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
            control.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        }
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
            this.behavior = null;
        }
        super.dispose();
    }

    protected final void registerChangeListener(ObservableValue<?> property, String reference) {
        if (this.changeListenerHandler == null) {
            this.changeListenerHandler = new MultiplePropertyChangeListenerHandler((Callback<String, Void>)((Callback)p -> {
                this.handleControlPropertyChanged((String)p);
                return null;
            }));
        }
        this.changeListenerHandler.registerChangeListener(property, reference);
    }

    protected void handleControlPropertyChanged(String propertyReference) {
    }
}

