/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.control.mediaslider;

import java.io.Serializable;
import java.text.DecimalFormat;

class TimeCode
implements Serializable,
Comparable<TimeCode> {
    private static DecimalFormat twoDigit = new DecimalFormat("00");
    private static DecimalFormat threeDigit = new DecimalFormat("000");
    private int secs;
    private int millis;

    public TimeCode() {
    }

    public TimeCode(int secs) {
        this.secs = secs;
    }

    public TimeCode(int secs, int millis) {
        this.secs = secs;
        this.millis = millis;
    }

    public TimeCode(String s) throws IllegalArgumentException {
        char c;
        int end;
        if (s == null) {
            throw new IllegalArgumentException("Passing null timecode string");
        }
        char[] chars = s.toCharArray();
        for (end = 0; end < chars.length && (Character.isDigit(c = chars[end]) || c == ':' || c == '.' || c == ' '); ++end) {
        }
        s = new String(chars, 0, end).trim();
        String[] parts = s.split(":");
        try {
            this.secs = 3600 * Integer.parseInt(parts[0]);
            this.secs += 60 * Integer.parseInt(parts[1]);
            float secsFloat = Float.parseFloat(parts[2]);
            this.secs += (int)secsFloat;
            this.millis = (int)(secsFloat * 1000.0f) % 1000;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Cannot parse timecode string: " + s);
        }
    }

    public String toString() {
        return TimeCode.formatAshhmmssMillis(this.secs, this.millis);
    }

    public String toShortString() {
        int hours = this.secs / 3600;
        int mins = (this.secs - 3600 * hours) / 60;
        int secs = this.secs - 3600 * hours - 60 * mins;
        return (hours > 0 ? hours + ":" : "") + mins + ":" + twoDigit.format(secs);
    }

    public int getSecs() {
        return this.secs;
    }

    public void setSecs(int secs) {
        this.secs = secs;
    }

    public int getMillis() {
        return this.millis;
    }

    public void setMillis(int millis) {
        this.millis = millis;
    }

    public void setFrames(int frames) {
        this.millis = frames;
    }

    private static String formatAshhmmssMillis(int secsFromStart, int millis) {
        int hours = secsFromStart / 3600;
        int mins = (secsFromStart - 3600 * hours) / 60;
        int secs = secsFromStart - 3600 * hours - 60 * mins;
        return twoDigit.format(hours) + ":" + twoDigit.format(mins) + ":" + twoDigit.format(secs) + (millis != 0 ? "." + threeDigit.format(millis) : "");
    }

    public long asMillis() {
        return 1000 * this.secs + this.millis;
    }

    public static TimeCode fromMillis(long millis) {
        int secs = (int)(millis / 1000L);
        int fraction = (int)(millis % 1000L);
        return new TimeCode(secs, fraction);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeCode other = (TimeCode)obj;
        if (this.secs != other.secs) {
            return false;
        }
        return this.millis == other.millis;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    @Override
    public int compareTo(TimeCode o) {
        return this.secs * 1000 + this.millis - (o.secs * 1000 + o.millis);
    }
}

