/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.control.mediaslider;

import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import net.jalbum.control.mediaslider.MediaSlider;
import net.jalbum.control.mediaslider.MediaSliderBehavior;
import net.jalbum.control.mediaslider.skin.BehaviorSkinBase;

public class MediaSliderSkin
extends BehaviorSkinBase<MediaSlider, MediaSliderBehavior> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private Pane track;
    private double trackStart;
    private double trackLength;
    private double rangeEnd;
    private double rangeStart;
    private ThumbPane thumb;
    private ThumbPane lowThumb;
    private ThumbPane highThumb;
    Tooltip durationTooltip = new Tooltip();
    private StackPane rangeBar;
    private double preDragPos;
    private Point2D preDragThumbPoint;
    private MediaSliderBehavior.FocusedChild currentFocus = MediaSliderBehavior.FocusedChild.LOW_THUMB;

    public MediaSliderSkin(MediaSlider mediaSlider) {
        super(mediaSlider, new MediaSliderBehavior(mediaSlider));
        this.initLowThumb();
        this.initHighThumb();
        this.initRangeBar();
        this.initThumb();
        this.registerChangeListener((ObservableValue<?>)mediaSlider.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue<?>)mediaSlider.lowValueProperty(), "LOW_VALUE");
        this.registerChangeListener((ObservableValue<?>)mediaSlider.highValueProperty(), "HIGH_VALUE");
        this.registerChangeListener((ObservableValue<?>)mediaSlider.minProperty(), "MIN");
        this.registerChangeListener((ObservableValue<?>)mediaSlider.maxProperty(), "MAX");
        this.registerChangeListener(mediaSlider.showTickMarksProperty(), "SHOW_TICK_MARKS");
        this.registerChangeListener(mediaSlider.showTickLabelsProperty(), "SHOW_TICK_LABELS");
        this.registerChangeListener(mediaSlider.majorTickUnitProperty(), "MAJOR_TICK_UNIT");
        this.registerChangeListener(mediaSlider.minorTickCountProperty(), "MINOR_TICK_COUNT");
        this.lowThumb.focusedProperty().addListener((ov, t, hasFocus) -> {
            if (hasFocus.booleanValue()) {
                this.currentFocus = MediaSliderBehavior.FocusedChild.LOW_THUMB;
            }
        });
        this.highThumb.focusedProperty().addListener((ov, t, hasFocus) -> {
            if (hasFocus.booleanValue()) {
                this.currentFocus = MediaSliderBehavior.FocusedChild.HIGH_THUMB;
            }
        });
        mediaSlider.focusedProperty().addListener((ov, t, hasFocus) -> {
            if (hasFocus.booleanValue()) {
                this.lowThumb.setFocus(true);
            } else {
                this.lowThumb.setFocus(false);
                this.highThumb.setFocus(false);
                this.currentFocus = MediaSliderBehavior.FocusedChild.NONE;
            }
        });
        EventHandler keyEventHandler = event -> {
            if (KeyCode.TAB.equals((Object)event.getCode())) {
                if (this.lowThumb.isFocused()) {
                    if (event.isShiftDown()) {
                        this.lowThumb.setFocus(false);
                        new ParentTraversalEngine((Parent)mediaSlider).select((Node)mediaSlider, Direction.PREVIOUS);
                    } else {
                        this.lowThumb.setFocus(false);
                        this.highThumb.setFocus(true);
                    }
                    event.consume();
                } else if (this.highThumb.isFocused()) {
                    if (event.isShiftDown()) {
                        this.highThumb.setFocus(false);
                        this.lowThumb.setFocus(true);
                    } else {
                        this.highThumb.setFocus(false);
                        new ParentTraversalEngine((Parent)mediaSlider).select((Node)mediaSlider, Direction.NEXT);
                    }
                    event.consume();
                }
            }
        };
        ((MediaSlider)this.getSkinnable()).addEventHandler(KeyEvent.KEY_PRESSED, keyEventHandler);
        ((MediaSliderBehavior)this.getBehavior()).setSelectedValue((Callback<Void, MediaSliderBehavior.FocusedChild>)((Callback)v -> this.currentFocus));
    }

    private void initThumb() {
        this.thumb = new ThumbPane();
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        this.thumb.setFocusTraversable(true);
        this.getChildren().add((Object)this.thumb);
        this.thumb.setOnMousePressed(me -> {
            this.lowThumb.setFocus(false);
            this.highThumb.setFocus(false);
            this.thumb.setFocus(true);
            ((MediaSliderBehavior)this.getBehavior()).thumbPressed((MouseEvent)me, 0.0f);
            this.preDragThumbPoint = this.thumb.localToParent(me.getX(), me.getY());
            this.preDragPos = (((MediaSlider)this.getSkinnable()).getValue() - ((MediaSlider)this.getSkinnable()).getMin()) / this.getMaxMinusMinNoZero();
        });
        this.thumb.setOnMouseReleased(me -> ((MediaSliderBehavior)this.getBehavior()).thumbReleased((MouseEvent)me));
        this.thumb.setOnMouseDragged(me -> {
            Point2D cur = this.thumb.localToParent(me.getX(), me.getY());
            double dragPos = cur.getX() - this.preDragThumbPoint.getX();
            ((MediaSliderBehavior)this.getBehavior()).thumbDragged((MouseEvent)me, this.preDragPos + dragPos / this.trackLength);
        });
    }

    private void initLowThumb() {
        this.lowThumb = new ThumbPane();
        this.lowThumb.getStyleClass().setAll((Object[])new String[]{"low-thumb"});
        this.lowThumb.setFocusTraversable(true);
        this.track = new Pane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.lowThumb});
        this.setShowTickMarks(((MediaSlider)this.getSkinnable()).isShowTickMarks(), ((MediaSlider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed(me -> {
            if (!this.lowThumb.isPressed() && !this.highThumb.isPressed()) {
                ((MediaSliderBehavior)this.getBehavior()).trackPress((MouseEvent)me, me.getX() / this.trackLength);
            }
        });
        this.track.setOnMouseReleased(me -> ((MediaSliderBehavior)this.getBehavior()).trackRelease((MouseEvent)me, 0.0));
        this.lowThumb.setOnMousePressed(me -> {
            this.highThumb.setFocus(false);
            this.lowThumb.setFocus(true);
            this.updateDurationTooltip((MouseEvent)me);
            ((MediaSliderBehavior)this.getBehavior()).lowThumbPressed((MouseEvent)me, 0.0);
            this.preDragThumbPoint = this.lowThumb.localToParent(me.getX(), me.getY());
            this.preDragPos = (((MediaSlider)this.getSkinnable()).getLowValue() - ((MediaSlider)this.getSkinnable()).getMin()) / this.getMaxMinusMinNoZero();
        });
        this.lowThumb.setOnMouseReleased(me -> {
            this.durationTooltip.hide();
            ((MediaSliderBehavior)this.getBehavior()).lowThumbReleased((MouseEvent)me);
        });
        Tooltip.install((Node)this.lowThumb, (Tooltip)this.durationTooltip);
        this.lowThumb.setOnMouseDragged(me -> {
            Point2D cur = this.lowThumb.localToParent(me.getX(), me.getY());
            double dragPos = cur.getX() - this.preDragThumbPoint.getX();
            this.updateDurationTooltip((MouseEvent)me);
            ((MediaSliderBehavior)this.getBehavior()).lowThumbDragged((MouseEvent)me, this.preDragPos + dragPos / this.trackLength);
        });
    }

    private void updateDurationTooltip(MouseEvent me) {
        if (((MediaSlider)this.getSkinnable()).durationTooltipSupplier != null) {
            Point2D p = this.lowThumb.localToScreen(0.0, 0.0);
            this.durationTooltip.setText(((MediaSlider)this.getSkinnable()).durationTooltipSupplier.get());
            this.durationTooltip.show((Node)this.lowThumb, me.getScreenX() - this.durationTooltip.getWidth() / 2.0, p.getY() + 30.0);
        }
    }

    private void initHighThumb() {
        this.highThumb = new ThumbPane();
        this.highThumb.getStyleClass().setAll((Object[])new String[]{"high-thumb"});
        this.highThumb.setFocusTraversable(true);
        if (!this.getChildren().contains((Object)this.highThumb)) {
            this.getChildren().add((Object)this.highThumb);
        }
        this.highThumb.setOnMousePressed(e -> {
            this.lowThumb.setFocus(false);
            this.highThumb.setFocus(true);
            this.updateDurationTooltip((MouseEvent)e);
            ((MediaSliderBehavior)this.getBehavior()).highThumbPressed((MouseEvent)e, 0.0);
            this.preDragThumbPoint = this.highThumb.localToParent(e.getX(), e.getY());
            this.preDragPos = (((MediaSlider)this.getSkinnable()).getHighValue() - ((MediaSlider)this.getSkinnable()).getMin()) / this.getMaxMinusMinNoZero();
        });
        this.highThumb.setOnMouseReleased(e -> {
            this.durationTooltip.hide();
            ((MediaSliderBehavior)this.getBehavior()).highThumbReleased((MouseEvent)e);
        });
        Tooltip.install((Node)this.lowThumb, (Tooltip)this.durationTooltip);
        this.highThumb.setOnMouseDragged(me -> {
            this.updateDurationTooltip((MouseEvent)me);
            double trackLength1 = this.track.getWidth();
            Point2D cur = this.highThumb.localToParent(me.getX(), me.getY());
            double dragPos = cur.getX() - this.preDragThumbPoint.getX();
            ((MediaSliderBehavior)this.getBehavior()).highThumbDragged((MouseEvent)me, this.preDragPos + dragPos / trackLength1);
        });
    }

    private void initRangeBar() {
        this.rangeBar = new StackPane();
        this.rangeBar.getStyleClass().setAll((Object[])new String[]{"range-bar"});
        this.rangeBar.setOnMousePressed(me -> {
            if (!(this.lowThumb.isPressed() || this.highThumb.isPressed() || this.thumb.isPressed())) {
                ((MediaSliderBehavior)this.getBehavior()).rangePress((MouseEvent)me, (me.getX() + this.rangeBar.getLayoutX() - this.track.getLayoutX() - this.thumb.getWidth() / 2.0) / this.trackLength);
            }
        });
        this.rangeBar.setOnMouseReleased(me -> ((MediaSliderBehavior)this.getBehavior()).rangeRelease((MouseEvent)me, 0.0));
        this.getChildren().add((Object)this.rangeBar);
    }

    private void setShowTickMarks(boolean ticksVisible, boolean labelsVisible) {
        this.showTickMarks = ticksVisible || labelsVisible;
        MediaSlider mediaSlider = (MediaSlider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.tickLabelFormatterProperty().bind(((MediaSlider)this.getSkinnable()).labelFormatterProperty());
                this.tickLine.setAnimated(false);
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(Side.BOTTOM);
                this.tickLine.setUpperBound(mediaSlider.getMax());
                this.tickLine.setLowerBound(mediaSlider.getMin());
                this.tickLine.setTickUnit(mediaSlider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
                this.tickLine.setMinorTickCount(Math.max(mediaSlider.getMinorTickCount(), 0) + 1);
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.tickLine, this.track, this.lowThumb});
            } else {
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.track, this.lowThumb});
        }
        ((MediaSlider)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if (null != p) {
            switch (p) {
                case "MIN": {
                    if (this.showTickMarks && this.tickLine != null) {
                        this.tickLine.setLowerBound(((MediaSlider)this.getSkinnable()).getMin());
                    }
                    ((MediaSlider)this.getSkinnable()).requestLayout();
                    break;
                }
                case "MAX": {
                    if (this.showTickMarks && this.tickLine != null) {
                        this.tickLine.setUpperBound(((MediaSlider)this.getSkinnable()).getMax());
                    }
                    ((MediaSlider)this.getSkinnable()).requestLayout();
                    break;
                }
                case "SHOW_TICK_MARKS": 
                case "SHOW_TICK_LABELS": {
                    this.setShowTickMarks(((MediaSlider)this.getSkinnable()).isShowTickMarks(), ((MediaSlider)this.getSkinnable()).isShowTickLabels());
                    if (!this.getChildren().contains((Object)this.highThumb)) {
                        this.getChildren().add((Object)this.highThumb);
                    }
                    if (this.getChildren().contains((Object)this.rangeBar)) break;
                    this.getChildren().add((Object)this.rangeBar);
                    break;
                }
                case "MAJOR_TICK_UNIT": {
                    if (this.tickLine == null) break;
                    this.tickLine.setTickUnit(((MediaSlider)this.getSkinnable()).getMajorTickUnit());
                    ((MediaSlider)this.getSkinnable()).requestLayout();
                    break;
                }
                case "MINOR_TICK_COUNT": {
                    if (this.tickLine == null) break;
                    this.tickLine.setMinorTickCount(Math.max(((MediaSlider)this.getSkinnable()).getMinorTickCount(), 0) + 1);
                    ((MediaSlider)this.getSkinnable()).requestLayout();
                    break;
                }
                case "VALUE": {
                    this.positionThumb();
                    break;
                }
                case "LOW_VALUE": {
                    this.positionLowThumb();
                    this.rangeBar.resizeRelocate(this.rangeStart, this.rangeBar.getLayoutY(), this.rangeEnd - this.rangeStart, this.rangeBar.getHeight());
                    break;
                }
                case "HIGH_VALUE": {
                    this.positionHighThumb();
                    this.rangeBar.resize(this.rangeEnd - this.rangeStart, this.rangeBar.getHeight());
                }
            }
        }
        super.handleControlPropertyChanged(p);
    }

    private double getMaxMinusMinNoZero() {
        MediaSlider slider = (MediaSlider)this.getSkinnable();
        return slider.getMax() - slider.getMin() == 0.0 ? 1.0 : slider.getMax() - slider.getMin();
    }

    private void positionThumb() {
        MediaSlider slider = (MediaSlider)this.getSkinnable();
        double x = this.trackStart + (this.trackLength * ((slider.getValue() - slider.getMin()) / this.getMaxMinusMinNoZero()) - this.thumb.getWidth() / 2.0);
        this.thumb.setLayoutX(x);
    }

    private void positionLowThumb() {
        MediaSlider slider = (MediaSlider)this.getSkinnable();
        double lx = this.trackStart + (this.trackLength * ((slider.getLowValue() - slider.getMin()) / this.getMaxMinusMinNoZero()) - this.lowThumb.getWidth() / 2.0);
        this.lowThumb.setLayoutX(lx);
        this.rangeStart = lx + this.lowThumb.getWidth();
    }

    private void positionHighThumb() {
        MediaSlider slider = (MediaSlider)this.getSkinnable();
        double tw = this.lowThumb.getWidth();
        double th = this.lowThumb.getHeight();
        double pad = 0.0;
        double trackStart = this.track.getLayoutX();
        double trackLength = this.track.getWidth();
        double x = (trackStart += pad) + ((trackLength -= 2.0 * pad) * ((slider.getHighValue() - slider.getMin()) / this.getMaxMinusMinNoZero()) - tw / 2.0);
        this.highThumb.setLayoutX(x);
        this.rangeEnd = x;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double lowThumbWidth = this.lowThumb.prefWidth(-1.0);
        double lowThumbHeight = this.lowThumb.prefHeight(-1.0);
        this.lowThumb.resize(lowThumbWidth, lowThumbHeight);
        this.highThumb.resize(lowThumbWidth, lowThumbHeight);
        this.thumb.resize(this.thumb.prefWidth(-1.0), this.thumb.prefHeight(-1.0));
        double trackRadius = this.track.getBackground() == null ? 0.0 : (this.track.getBackground().getFills().size() > 0 ? ((BackgroundFill)this.track.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius() : 0.0);
        double tickLineHeight = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
        double trackHeight = this.track.prefHeight(-1.0);
        double trackAreaHeight = Math.max(trackHeight, lowThumbHeight);
        double totalHeightNeeded = trackAreaHeight + (this.showTickMarks ? this.trackToTickGap + tickLineHeight : 0.0);
        double startY = y + (h - totalHeightNeeded) / 2.0;
        this.trackLength = w - lowThumbWidth;
        this.trackStart = x + lowThumbWidth / 2.0;
        double trackTop = (int)(startY + (trackAreaHeight - trackHeight) / 2.0);
        double ypos = (int)(startY + (trackAreaHeight - lowThumbHeight) / 2.0);
        this.lowThumb.setLayoutY(ypos);
        this.highThumb.setLayoutY(ypos);
        this.thumb.setLayoutY((int)(startY + (trackAreaHeight - this.thumb.getHeight()) / 2.0));
        this.positionLowThumb();
        this.track.resizeRelocate(this.trackStart - trackRadius, trackTop, this.trackLength + trackRadius + trackRadius, trackHeight);
        this.positionHighThumb();
        this.positionThumb();
        this.rangeBar.resizeRelocate(this.rangeStart, trackTop, this.rangeEnd - this.rangeStart, trackHeight);
        if (this.showTickMarks) {
            this.tickLine.setLayoutX(this.trackStart);
            this.tickLine.setLayoutY(trackTop + trackHeight + this.trackToTickGap);
            this.tickLine.resize(this.trackLength, tickLineHeight);
            this.tickLine.requestAxisLayout();
        } else {
            if (this.tickLine != null) {
                this.tickLine.resize(0.0, 0.0);
                this.tickLine.requestAxisLayout();
            }
            this.tickLine = null;
        }
    }

    private double minTrackLength() {
        return 2.0 * this.lowThumb.prefWidth(-1.0);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.minTrackLength() + this.lowThumb.minWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.lowThumb.prefHeight(-1.0) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefWidth(-1.0));
        }
        return 140.0;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MediaSlider)this.getSkinnable()).getInsets().getTop() + Math.max(this.lowThumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MediaSlider)this.getSkinnable()).prefHeight(width);
    }

    private static class ThumbPane
    extends StackPane {
        private ThumbPane() {
        }

        public void setFocus(boolean value) {
            this.setFocused(value);
        }
    }
}

