/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.control.mediaslider;

import java.util.ArrayList;
import java.util.List;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import net.jalbum.control.mediaslider.MediaSlider;
import net.jalbum.control.mediaslider.Utils;
import net.jalbum.control.mediaslider.behavior.BehaviorBase;
import net.jalbum.control.mediaslider.behavior.KeyBinding;

public class MediaSliderBehavior
extends BehaviorBase<MediaSlider> {
    private static final List<KeyBinding> MEDIASLIDER_BINDINGS = new ArrayList<KeyBinding>();
    private Callback<Void, FocusedChild> selectedValue;

    public MediaSliderBehavior(MediaSlider slider) {
        super(slider, MEDIASLIDER_BINDINGS);
    }

    @Override
    protected void callAction(String s) {
        if (null == s) {
            super.callAction(s);
        } else {
            switch (s) {
                case "Home": 
                case "Home2": {
                    this.home();
                    break;
                }
                case "End": 
                case "End2": {
                    this.end();
                    break;
                }
                case "IncrementValue": 
                case "IncrementValue2": {
                    this.incrementValue();
                    break;
                }
                case "DecrementValue": 
                case "DecrementValue2": {
                    this.decrementValue();
                    break;
                }
                default: {
                    super.callAction(s);
                }
            }
        }
    }

    public void setSelectedValue(Callback<Void, FocusedChild> c) {
        this.selectedValue = c;
    }

    public void trackPress(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        if (this.selectedValue != null) {
            double newPosition = position * (slider.getMax() - slider.getMin()) + slider.getMin();
            if (newPosition < slider.getLowValue()) {
                slider.adjustLowValue(newPosition);
            } else if (newPosition > slider.getHighValue()) {
                slider.adjustHighValue(newPosition);
            }
        }
    }

    public void trackRelease(MouseEvent e, double position) {
    }

    public void rangePress(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.adjustValue(position * (slider.getMax() - slider.getMin()) + slider.getMin());
    }

    public void rangeRelease(MouseEvent e, double position) {
    }

    void thumbPressed(MouseEvent me, float f) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setValueChanging(true);
    }

    public void thumbDragged(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.setValue(Utils.clamp(slider.getMin(), position * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMax()));
    }

    void thumbReleased(MouseEvent me) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.setValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setValue(this.snapValueToTicks(slider.getValue()));
        }
    }

    public void lowThumbPressed(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setLowValueChanging(true);
    }

    public void lowThumbDragged(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        double newValue = Utils.clamp(slider.getMin(), position * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMax());
        slider.setLowValue(newValue);
    }

    public void lowThumbReleased(MouseEvent e) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.setLowValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setLowValue(this.snapValueToTicks(slider.getLowValue()));
        }
    }

    void home() {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.adjustHighValue(slider.getMin());
    }

    void decrementValue() {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (slider.isSnapToTicks()) {
                    slider.adjustHighValue(slider.getHighValue() - this.computeIncrement());
                } else {
                    slider.decrementHighValue();
                }
            } else if (slider.isSnapToTicks()) {
                slider.adjustLowValue(slider.getLowValue() - this.computeIncrement());
            } else {
                slider.decrementLowValue();
            }
        }
    }

    void end() {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.adjustHighValue(slider.getMax());
    }

    void incrementValue() {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (slider.isSnapToTicks()) {
                    slider.adjustHighValue(slider.getHighValue() + this.computeIncrement());
                } else {
                    slider.incrementHighValue();
                }
            } else if (slider.isSnapToTicks()) {
                slider.adjustLowValue(slider.getLowValue() + this.computeIncrement());
            } else {
                slider.incrementLowValue();
            }
        }
    }

    double computeIncrement() {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        double d = 0.0;
        d = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        if (slider.getBlockIncrement() > 0.0 && slider.getBlockIncrement() < d) {
            return d;
        }
        return slider.getBlockIncrement();
    }

    private double snapValueToTicks(double d) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        double d1 = d;
        double d2 = 0.0;
        d2 = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        int i = (int)((d1 - slider.getMin()) / d2);
        double d3 = (double)i * d2 + slider.getMin();
        double d4 = (double)(i + 1) * d2 + slider.getMin();
        d1 = Utils.nearest(d3, d1, d4);
        return Utils.clamp(slider.getMin(), d1, slider.getMax());
    }

    public void highThumbReleased(MouseEvent e) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.setHighValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setHighValue(this.snapValueToTicks(slider.getHighValue()));
        }
    }

    public void highThumbPressed(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setHighValueChanging(true);
    }

    public void highThumbDragged(MouseEvent e, double position) {
        MediaSlider slider = (MediaSlider)((Object)this.getControl());
        slider.setHighValue(Utils.clamp(slider.getMin(), position * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMax()));
    }

    static {
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.F4, "TraverseDebug").alt().ctrl().shift());
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "DecrementValue"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "DecrementValue"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "IncrementValue"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "IncrementValue"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "TraverseUp"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.HOME, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, "Home"));
        MEDIASLIDER_BINDINGS.add(new KeyBinding(KeyCode.END, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, "End"));
    }

    public static enum FocusedChild {
        LOW_THUMB,
        HIGH_THUMB,
        NONE;

    }
}

