/*
 * Decompiled with CFR 0.152.
 */
package digfx.util;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class NodeGroup {
    private final List<Node> members = new ArrayList<Node>();
    private final BooleanProperty disableProperty = new SimpleBooleanProperty(false){

        public void bind(ObservableValue<? extends Boolean> rawObservable) {
            super.bind(rawObservable);
        }
    };

    public NodeGroup() {
        this.disableProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                for (Node n : NodeGroup.this.members) {
                    n.setDisable(newValue.booleanValue());
                }
            }
        });
    }

    public NodeGroup(Node ... nodes) {
        this();
        for (Node n : nodes) {
            this.add((T)n);
        }
    }

    public BooleanProperty disableProperty() {
        return this.disableProperty;
    }

    public void add(Node ... nodes) {
        for (Node n : nodes) {
            this.add((T)n);
        }
    }

    public void addAll(List<Node> otherList) {
        this.members.addAll(otherList);
    }

    public List<Node> getLMembers() {
        return this.members;
    }

    public <T extends Node> T add(T node) {
        this.members.add(node);
        node.getProperties().put((Object)"Belongs to", (Object)this);
        return node;
    }

    public Label add(String text) {
        return this.add(new Label(text));
    }
}

