/*
 * Decompiled with CFR 0.152.
 */
package digfx.scene.layout;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.sg.prism.NGNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class RiverPane
extends BorderPane {
    private static final String VALIGNMENT_CONSTRAINT = "riverpane-valignment";
    private static final String HALIGNMENT_CONSTRAINT = "riverpane-halignment";
    private static final String HFILL_CONSTRAINT = "riverpane-hfill";
    private static final String VFILL_CONSTRAINT = "riverpane-vfill";
    private List<Node> nodes = new ArrayList<Node>();
    private Set<String> nodeIds = new HashSet<String>();
    private boolean debugMode = false;
    protected GridPane grid = new GridPane();
    private int currentRow = 0;
    private int currentColumn = 0;
    private int _colIndex = 0;
    private int _rowIndex = 0;
    private int columnCount;
    private ObjectProperty<VPos> rowValignment;

    static void setConstraint(Node node, Object key, Object value) {
        if (value == null) {
            node.getProperties().remove(key);
        } else {
            node.getProperties().put(key, value);
        }
        if (node.getParent() != null) {
            node.getParent().requestLayout();
        }
    }

    static Object getConstraint(Node node, Object key) {
        Object value;
        if (node.hasProperties() && (value = node.getProperties().get(key)) != null) {
            return value;
        }
        return null;
    }

    static boolean hasConstraint(Node node, Object key) {
        if (node.hasProperties()) {
            return node.getProperties().containsKey(key);
        }
        return false;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public RiverPane() {
        this(8.0);
    }

    public RiverPane(double gap) {
        this(gap, gap);
    }

    public RiverPane(double hgap, double vgap) {
        this.grid.setHgap(vgap);
        this.grid.setVgap(vgap);
    }

    public void setPadding(double padding) {
        super.setPadding(new Insets(padding));
    }

    public ColumnConstraints getColumnConstraints(int col) {
        ObservableList list = this.grid.getColumnConstraints();
        return col < list.size() ? (ColumnConstraints)list.get(col) : null;
    }

    public RowConstraints getRowConstraints(int row) {
        ObservableList list = this.grid.getRowConstraints();
        return row < list.size() ? (RowConstraints)list.get(row) : null;
    }

    public void setColumnConstrains(int col, ColumnConstraints cc) {
        ObservableList list = this.grid.getColumnConstraints();
        int size = list.size();
        if (col >= size) {
            for (int i = 0; i < col - size; ++i) {
                list.add(new ColumnConstraints());
            }
            list.add(cc);
        } else {
            list.add(col, cc);
        }
    }

    public void setRowConstrains(int row, RowConstraints rc) {
        ObservableList list = this.grid.getRowConstraints();
        int size = list.size();
        if (row >= size) {
            for (int i = 0; i < row - size; ++i) {
                list.add(new RowConstraints());
            }
            list.add(rc);
        } else {
            list.add(row, rc);
        }
    }

    public ColumnConstraints col(int col) {
        ColumnConstraints cc = this.getColumnConstraints(col);
        if (cc == null) {
            cc = new ColumnConstraints();
            this.setColumnConstrains(col, cc);
        }
        return cc;
    }

    public RowConstraints row(int row) {
        RowConstraints rc = this.getRowConstraints(row);
        if (rc == null) {
            rc = new RowConstraints();
            this.setRowConstrains(row, rc);
        }
        return rc;
    }

    public GridPane getGridPane() {
        this.build();
        return this.grid;
    }

    public RiverPane id(String id) {
        if (!this.nodes.isEmpty()) {
            if (this.nodeIds.contains(id)) {
                throw new IllegalArgumentException("Node id '" + id + "' already in use");
            }
            this.nodes.get(this.nodes.size() - 1).setId(id);
            this.nodeIds.add(id);
        }
        return this;
    }

    public RiverPane add(String text) {
        return this.add((Node)new Label(text), null, null, null);
    }

    public RiverPane add(String text, VPos vAlign) {
        return this.add((Node)new Label(text), vAlign);
    }

    public RiverPane add(String text, HPos hAlign) {
        return this.add((Node)new Label(text), hAlign);
    }

    public RiverPane add(String text, Pos align) {
        return this.add((Node)new Label(text), align);
    }

    public RiverPane add(Node n) {
        return this.add(n, null, null, null);
    }

    public RiverPane add(Node n, HPos hAlign) {
        return this.add(n, null, hAlign, null);
    }

    public RiverPane add(Node n, VPos vAlign) {
        return this.add(n, vAlign, null, null);
    }

    public RiverPane add(Node n, Pos align) {
        return this.add(n, align.getVpos(), align.getHpos(), null);
    }

    public RiverPane add(Node n, Fill fill) {
        return this.add(n, null, null, fill);
    }

    public RiverPane add(Node n, HPos hAlign, Fill fill) {
        return this.add(n, null, hAlign, fill);
    }

    public RiverPane add(Node n, VPos vAlign, Fill fill) {
        return this.add(n, vAlign, null, fill);
    }

    public RiverPane add(Node n, Pos align, Fill fill) {
        return this.add(n, align.getVpos(), align.getHpos(), fill);
    }

    protected RiverPane add(Node n, VPos vAlign, HPos hAlign, Fill fill) {
        if (vAlign != null) {
            RiverPane.setConstraint(n, VALIGNMENT_CONSTRAINT, vAlign);
        }
        if (hAlign != null) {
            RiverPane.setConstraint(n, HALIGNMENT_CONSTRAINT, hAlign);
        }
        if (fill != null) {
            switch (fill) {
                case H: {
                    RiverPane.setConstraint(n, HFILL_CONSTRAINT, Boolean.TRUE);
                    break;
                }
                case V: {
                    RiverPane.setConstraint(n, VFILL_CONSTRAINT, Boolean.TRUE);
                    break;
                }
                case BOTH: {
                    RiverPane.setConstraint(n, HFILL_CONSTRAINT, Boolean.TRUE);
                    RiverPane.setConstraint(n, VFILL_CONSTRAINT, Boolean.TRUE);
                }
            }
        }
        this.nodes.add(n);
        return this;
    }

    public RiverPane br() {
        this.nodes.add(new Break());
        ++this.currentRow;
        this.currentColumn = 0;
        return this;
    }

    public RiverPane tab() {
        this.nodes.add(new Tab());
        ++this.currentColumn;
        return this;
    }

    public RiverPane p() {
        this.nodes.add(new Break());
        this.nodes.add(new Break());
        this.currentRow += 2;
        this.currentColumn = 0;
        return this;
    }

    private int getColumnCount() {
        int maxCols = 1;
        int cols = 1;
        for (Node n : this.nodes) {
            if (n instanceof Tab) {
                ++cols;
                continue;
            }
            if (!(n instanceof Break)) continue;
            if (cols > maxCols) {
                maxCols = cols;
            }
            cols = 1;
        }
        if (cols > maxCols) {
            maxCols = cols;
        }
        return maxCols;
    }

    private void build() {
        if (!this.nodes.isEmpty()) {
            this.columnCount = this.getColumnCount();
            GroupIterator<Break> rowIterator = new GroupIterator<Break>(this.nodes, Break.class);
            rowIterator.forEach(row -> {
                this._colIndex = 0;
                GroupIterator<Tab> colIterator = new GroupIterator<Tab>((List<Tab>)row, Tab.class);
                colIterator.forEach(col -> {
                    if (col.size() > 0) {
                        int colspan;
                        boolean hfill = false;
                        boolean vfill = false;
                        HPos hAlign = null;
                        VPos vAlign = this.getRowValignment(this._rowIndex);
                        Node cell = (Node)col.get(0);
                        HBox box = null;
                        if (col.size() > 1) {
                            box = new HBox(this.getHgap());
                            box.setAlignment(RiverPane.posOf(vAlign, HPos.LEFT));
                            cell = box;
                        }
                        for (Node n : col) {
                            if (box != null) {
                                box.getChildren().add((Object)n);
                            }
                            if (RiverPane.hasConstraint(n, HFILL_CONSTRAINT)) {
                                HBox.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                                hfill = true;
                            }
                            if (RiverPane.hasConstraint(n, VFILL_CONSTRAINT)) {
                                vfill = true;
                            }
                            if (RiverPane.hasConstraint(n, HALIGNMENT_CONSTRAINT)) {
                                hAlign = (HPos)RiverPane.getConstraint(n, HALIGNMENT_CONSTRAINT);
                            }
                            if (!RiverPane.hasConstraint(n, VALIGNMENT_CONSTRAINT)) continue;
                            vAlign = (VPos)RiverPane.getConstraint(n, VALIGNMENT_CONSTRAINT);
                        }
                        if (hfill) {
                            GridPane.setHgrow((Node)cell, (Priority)Priority.ALWAYS);
                            GridPane.setFillWidth((Node)cell, (Boolean)true);
                        } else {
                            GridPane.setHgrow((Node)cell, (Priority)Priority.NEVER);
                            GridPane.setFillWidth((Node)cell, (Boolean)false);
                        }
                        if (vfill) {
                            GridPane.setVgrow((Node)cell, (Priority)Priority.ALWAYS);
                            GridPane.setFillHeight((Node)cell, (Boolean)true);
                        } else if (box != null) {
                            box.setMaxHeight(Double.NEGATIVE_INFINITY);
                        }
                        if (hAlign != null) {
                            if (box != null) {
                                box.setAlignment(RiverPane.posOf(vAlign, hAlign));
                            }
                            GridPane.setHalignment((Node)cell, hAlign);
                        }
                        GridPane.setValignment((Node)cell, (VPos)vAlign);
                        int n = colspan = colIterator.isLast() ? this.columnCount - this._colIndex : 1;
                        if (this.debugMode) {
                            cell.setStyle("-fx-background-color: #BBD;");
                        }
                        this.grid.add(cell, this._colIndex, this._rowIndex, colspan, 1);
                    }
                    ++this._colIndex;
                });
                ++this._rowIndex;
            });
            super.setCenter((Node)this.grid);
        }
        this.nodes.clear();
        this.nodeIds.clear();
    }

    protected double computePrefHeight(double width) {
        this.build();
        return super.computePrefHeight(width);
    }

    protected double computePrefWidth(double height) {
        this.build();
        return super.computePrefWidth(height);
    }

    protected void layoutChildren() {
        this.build();
        super.layoutChildren();
    }

    public final DoubleProperty hgapProperty() {
        return this.grid.hgapProperty();
    }

    public final void setHgap(double value) {
        this.grid.setHgap(value);
    }

    public final double getHgap() {
        return this.grid.getHgap();
    }

    public final DoubleProperty vgapProperty() {
        return this.grid.vgapProperty();
    }

    public final void setVgap(double value) {
        this.grid.setVgap(value);
    }

    public final double getVgap() {
        return this.grid.getVgap();
    }

    public final ObjectProperty<VPos> rowValignmentProperty() {
        if (this.rowValignment == null) {
            this.rowValignment = new StyleableObjectProperty<VPos>(VPos.BASELINE){

                public void invalidated() {
                    RiverPane.this.requestLayout();
                }

                public CssMetaData<RiverPane, VPos> getCssMetaData() {
                    return StyleableProperties.ROW_VALIGNMENT;
                }

                public Object getBean() {
                    return RiverPane.this;
                }

                public String getName() {
                    return "rowValignment";
                }
            };
        }
        return this.rowValignment;
    }

    public final void setRowValignment(VPos value) {
        this.rowValignmentProperty().set((Object)value);
    }

    public final VPos getRowValignment() {
        return this.rowValignment == null ? VPos.BASELINE : (VPos)this.rowValignment.get();
    }

    private final VPos getRowValignment(int row) {
        RowConstraints rc = this.getRowConstraints(row);
        if (rc != null && rc.getValignment() != null) {
            return rc.getValignment();
        }
        return this.getRowValignment();
    }

    private static Pos posOf(VPos v, HPos h) {
        if (v == VPos.CENTER && h == HPos.CENTER) {
            return Pos.CENTER;
        }
        return Pos.valueOf((String)(v.name() + "_" + h.name()));
    }

    private static class GroupIterator<T> {
        private final List<T> list;
        private final Class<? extends T> separator;
        private boolean isLast = false;

        public GroupIterator(List<T> list, Class<? extends T> separator) {
            this.list = list;
            this.separator = separator;
        }

        public void forEach(Consumer<List<T>> consumer) {
            ArrayList<T> group = new ArrayList<T>();
            for (T e : this.list) {
                if (this.separator.isAssignableFrom(e.getClass())) {
                    consumer.accept(group);
                    group = new ArrayList();
                    continue;
                }
                group.add(e);
            }
            if (!group.isEmpty()) {
                this.isLast = true;
                consumer.accept(group);
            }
        }

        public boolean isLast() {
            return this.isLast;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<RiverPane, VPos> ROW_VALIGNMENT = new CssMetaData<RiverPane, VPos>("-fx-row-valignment", (StyleConverter)new EnumConverter(VPos.class), VPos.BASELINE){

            public boolean isSettable(RiverPane node) {
                return node.rowValignment == null || !node.rowValignment.isBound();
            }

            public StyleableProperty<VPos> getStyleableProperty(RiverPane node) {
                return (StyleableProperty)node.rowValignmentProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<RiverPane, VPos>> styleables = new ArrayList<CssMetaData<RiverPane, VPos>>(Region.getClassCssMetaData());
            styleables.add(ROW_VALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private static class Break
    extends FlowControl {
        private Break() {
        }
    }

    private static class Tab
    extends FlowControl {
        private Tab() {
        }
    }

    private static class FlowControl
    extends Node {
        private FlowControl() {
        }

        protected NGNode impl_createPeer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean impl_computeContains(double localX, double localY) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object impl_processMXNode(MXNodeAlgorithm alg, MXNodeAlgorithmContext ctx) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static enum Fill {
        H,
        V,
        BOTH,
        NONE;

    }
}

