/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import net.jalbum.avif.nativeapi.LibAvif;
import se.datadosen.util.VersionNumber;

class Support {
    Support() {
    }

    public static String getResultString(int result) {
        try {
            MemorySegment resultStr = LibAvif.avifResultToString((int)result);
            return Support.getStringFromNative(resultStr);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to get result string", t);
        }
    }

    public static String getStringFromNative(MemorySegment str) {
        if (str == null || str.equals(MemorySegment.NULL)) {
            return null;
        }
        return str.reinterpret(Long.MAX_VALUE).getString(0L, StandardCharsets.UTF_8);
    }

    public static MemorySegment stringToNative(String s, Arena arena) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        MemorySegment seg = arena.allocate(bytes.length + 1, 1L);
        for (int i = 0; i < bytes.length; ++i) {
            seg.set(ValueLayout.JAVA_BYTE, (long)i, bytes[i]);
        }
        seg.set(ValueLayout.JAVA_BYTE, (long)bytes.length, (byte)0);
        return seg;
    }

    public static boolean isValid(MemorySegment seg) {
        return seg != null && !seg.equals(MemorySegment.NULL);
    }

    public static boolean isOkJavaVersion() {
        return new VersionNumber(System.getProperty("java.version")).compareTo(new VersionNumber("26")) >= 0;
    }
}

