/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.imageio.stream.ImageInputStream;

final class ImageIOUtils {
    private ImageIOUtils() {
    }

    public static ImageInputStream createImageInputStream(Object input) {
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (input instanceof ImageInputStream) {
            return (ImageInputStream)input;
        }
        throw new UnsupportedOperationException("Unsupported input type: " + input.getClass().getName());
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        if (input == null) {
            return new byte[0];
        }
        try (InputStream is = input;){
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    public static byte[] toByteArray(Path path) throws IOException {
        if (path == null) {
            return new byte[0];
        }
        return Files.readAllBytes(path);
    }
}

