/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.ValueLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.metadata.IIOMetadata;
import net.jalbum.avif.AVIFImageReadParam;
import net.jalbum.avif.AVIFImageWriteParam;
import net.jalbum.avif.AVIFMetadata;
import net.jalbum.avif.CodecChoice;
import net.jalbum.avif.DecodeException;
import net.jalbum.avif.ImageInfo;
import net.jalbum.avif.StdoutHandler;
import net.jalbum.avif.Support;
import net.jalbum.avif.nativeapi.LibAvif;
import net.jalbum.avif.nativeapi.avifDecoder;
import net.jalbum.avif.nativeapi.avifImage;
import net.jalbum.avif.nativeapi.avifImageMirror;
import net.jalbum.avif.nativeapi.avifImageRotation;
import net.jalbum.avif.nativeapi.avifRGBImage;
import net.jalbum.avif.nativeapi.avifRWData;
import net.jalbum.util.Profiler;

public class Avif {
    public static final String NATIVE_LIB_NAME = "avif";
    public static final Logger LOGGER = Logger.getLogger("imageio-avif");
    private static volatile boolean initiated;
    private static volatile Throwable initError;

    private static AVIFMetadata getMetadata(IIOImage iioImage) {
        IIOMetadata meta = iioImage.getMetadata();
        if (meta instanceof AVIFMetadata) {
            return (AVIFMetadata)meta;
        }
        if (meta == null) {
            return null;
        }
        AVIFMetadata avifMeta = new AVIFMetadata();
        avifMeta.setEXIF(AVIFMetadata.getEXIFBytes(meta));
        return avifMeta;
    }

    private Avif() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void ensureInitiated() {
        if (!initiated && initError == null) {
            Class<Avif> clazz = Avif.class;
            // MONITORENTER : net.jalbum.avif.Avif.class
            if (!initiated && initError == null) {
                try {
                    LibAvif.avifVersion();
                    initiated = true;
                }
                catch (Throwable ex) {
                    initError = ex;
                    System.err.println("Error loading native AVIF library: " + ex.toString());
                }
            }
            // MONITOREXIT : clazz
        }
        if (initiated) return;
        throw new RuntimeException("AVIF library not initiated");
    }

    public static Throwable getInitError() {
        return initError;
    }

    static boolean isInitiatedOk() {
        try {
            Avif.ensureInitiated();
            return initiated;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getVersion() {
        Avif.ensureInitiated();
        return Support.getStringFromNative(LibAvif.avifVersion());
    }

    public static IIOImage read(File file, ImageInfo ii, AVIFImageReadParam param) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            Avif.ensureInitiated();
            if (!file.exists()) {
                throw new IOException("File not found: " + file.getAbsolutePath());
            }
            Arena arena = Arena.ofConfined();
            try {
                MemorySegment io = LibAvif.avifIOCreateFileReader((MemorySegment)Support.stringToNative(file.getAbsolutePath(), arena));
                if (io.equals(MemorySegment.NULL)) {
                    throw new DecodeException("Failed to create file reader");
                }
                IIOImage iIOImage = Avif.readFromDecoderIO(io, arena, ii, param);
                if (arena != null) {
                    arena.close();
                }
                return iIOImage;
            }
            catch (Throwable throwable) {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static IIOImage read(byte[] bytes, ImageInfo ii, AVIFImageReadParam param) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            Avif.ensureInitiated();
            Arena arena = Arena.ofConfined();
            try {
                MemorySegment mem = arena.allocate(bytes.length);
                mem.copyFrom(MemorySegment.ofArray(bytes));
                MemorySegment io = LibAvif.avifIOCreateMemoryReader((MemorySegment)mem, (long)bytes.length);
                if (io.equals(MemorySegment.NULL)) {
                    throw new DecodeException("Failed to create memory reader");
                }
                IIOImage iIOImage = Avif.readFromDecoderIO(io, arena, ii, param);
                if (arena != null) {
                    arena.close();
                }
                return iIOImage;
            }
            catch (Throwable throwable) {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIOImage readFromDecoderIO(MemorySegment io, Arena arena, ImageInfo ii, AVIFImageReadParam param) throws IOException {
        if (param == null) {
            param = new AVIFImageReadParam();
        }
        MemorySegment decoder = null;
        try {
            MemorySegment xmpSeg;
            MemorySegment realXmp;
            decoder = LibAvif.avifDecoderCreate();
            if (decoder.equals(MemorySegment.NULL)) {
                throw new DecodeException("avifDecoderCreate failed");
            }
            avifDecoder.codecChoice((MemorySegment)decoder, (int)param.getPreferredCodec().ordinal());
            int codecChoice = avifDecoder.codecChoice((MemorySegment)decoder);
            param.setChosenCodec(CodecChoice.values()[codecChoice]);
            LibAvif.avifDecoderSetIO((MemorySegment)decoder, (MemorySegment)io);
            avifDecoder.ignoreExif((MemorySegment)decoder, (int)0);
            avifDecoder.ignoreXMP((MemorySegment)decoder, (int)0);
            int res = LibAvif.avifDecoderParse((MemorySegment)decoder);
            if (res != LibAvif.AVIF_RESULT_OK()) {
                throw new DecodeException("Failed to parse AVIF image: result=" + Support.getResultString(res));
            }
            MemorySegment image = avifDecoder.image((MemorySegment)decoder);
            int width = avifImage.width((MemorySegment)image);
            int height = avifImage.height((MemorySegment)image);
            boolean hasAlpha = avifImage.alphaPlane((MemorySegment)image) != MemorySegment.NULL;
            MemorySegment imageRotation = avifImage.irot((MemorySegment)image);
            byte angle = avifImageRotation.angle((MemorySegment)imageRotation);
            MemorySegment imageMirror = avifImage.imir((MemorySegment)image);
            byte mirrorAxis = avifImageMirror.axis((MemorySegment)imageMirror);
            AVIFMetadata meta = new AVIFMetadata();
            MemorySegment exifSeg = avifImage.exif((MemorySegment)image);
            MemorySegment realEXIF = avifRWData.data((MemorySegment)exifSeg).reinterpret(avifRWData.size((MemorySegment)exifSeg));
            if (realEXIF != MemorySegment.NULL && realEXIF.byteSize() > 0L) {
                meta.setEXIF(realEXIF.toArray(ValueLayout.JAVA_BYTE));
            }
            if ((realXmp = avifRWData.data((MemorySegment)(xmpSeg = avifImage.xmp((MemorySegment)image))).reinterpret(avifRWData.size((MemorySegment)xmpSeg))) != MemorySegment.NULL) {
                meta.setXmp(realXmp.toArray(ValueLayout.JAVA_BYTE));
            }
            if (ii != null) {
                ii.width = width;
                ii.height = height;
                ii.depth = avifImage.depth((MemorySegment)image);
                ii.angle = angle;
                ii.mirrorAxis = mirrorAxis;
                ii.meta = meta;
                IIOImage iIOImage = null;
                return iIOImage;
            }
            MemorySegment codecName = LibAvif.avifCodecName((int)codecChoice, (int)LibAvif.AVIF_CODEC_FLAG_CAN_DECODE());
            LOGGER.log(Level.CONFIG, () -> "AVIF decoder used: " + Support.getStringFromNative(codecName));
            res = LibAvif.avifDecoderNextImage((MemorySegment)decoder);
            if (res != LibAvif.AVIF_RESULT_OK()) {
                throw new DecodeException("No image found in AVIF stream");
            }
            MemorySegment rgb = avifRGBImage.allocate((SegmentAllocator)arena);
            LibAvif.avifRGBImageSetDefaults((MemorySegment)rgb, (MemorySegment)image);
            avifRGBImage.depth((MemorySegment)rgb, (int)8);
            avifRGBImage.isFloat((MemorySegment)rgb, (int)0);
            avifRGBImage.format((MemorySegment)rgb, (int)(hasAlpha ? LibAvif.AVIF_RGB_FORMAT_ABGR() : LibAvif.AVIF_RGB_FORMAT_BGR()));
            LibAvif.avifRGBImageAllocatePixels((MemorySegment)rgb);
            res = LibAvif.avifImageYUVToRGB((MemorySegment)image, (MemorySegment)rgb);
            if (res != LibAvif.AVIF_RESULT_OK()) {
                LibAvif.avifRGBImageFreePixels((MemorySegment)rgb);
                throw new DecodeException("YUV -> RGB conversion failed: " + Support.getResultString(res));
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, hasAlpha ? 6 : 5);
            byte[] destPixels = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            MemorySegment srcPixels = avifRGBImage.pixels((MemorySegment)rgb);
            MemorySegment.copy(srcPixels, 0L, MemorySegment.ofArray(destPixels), 0L, Math.min(srcPixels.byteSize(), (long)destPixels.length));
            LibAvif.avifRGBImageFreePixels((MemorySegment)rgb);
            BufferedImage finalImg = param.getSourceRegion() != null ? Avif.cropImage(bufferedImage, param.getSourceRegion()) : bufferedImage;
            IIOImage iIOImage = new IIOImage(finalImg, null, (IIOMetadata)meta);
            return iIOImage;
        }
        finally {
            if (decoder != null && !decoder.equals(MemorySegment.NULL)) {
                LibAvif.avifDecoderDestroy((MemorySegment)decoder);
            }
        }
    }

    public static MemorySegment createTestImage(Arena arena) throws IOException {
        int width = 640;
        int height = 480;
        MemorySegment avifImg = LibAvif.avifImageCreate((int)width, (int)height, (int)8, (int)LibAvif.AVIF_PIXEL_FORMAT_YUV420());
        if (avifImg.equals(MemorySegment.NULL)) {
            throw new IOException("avifImageCreate failed");
        }
        int res = LibAvif.avifImageAllocatePlanes((MemorySegment)avifImg, (int)LibAvif.AVIF_PLANES_YUV());
        if (res != LibAvif.AVIF_RESULT_OK()) {
            throw new IOException("Plane allocation failed");
        }
        MemorySegment rgb = avifRGBImage.allocate((SegmentAllocator)arena);
        LibAvif.avifRGBImageSetDefaults((MemorySegment)rgb, (MemorySegment)avifImg);
        avifRGBImage.format((MemorySegment)rgb, (int)LibAvif.AVIF_RGB_FORMAT_RGB());
        avifRGBImage.depth((MemorySegment)rgb, (int)8);
        LibAvif.avifRGBImageAllocatePixels((MemorySegment)rgb);
        byte gray = -128;
        MemorySegment pixels = avifRGBImage.pixels((MemorySegment)rgb);
        for (int i = 0; i < width * height * 3; ++i) {
            pixels.setAtIndex(ValueLayout.JAVA_BYTE, (long)i, gray);
        }
        for (int x = 0; x < width; ++x) {
            int y = x * height / width;
            pixels.setAtIndex(ValueLayout.JAVA_BYTE, (long)((y * width + x) * 3), (byte)-1);
        }
        res = LibAvif.avifImageRGBToYUV((MemorySegment)avifImg, (MemorySegment)rgb);
        if (res != LibAvif.AVIF_RESULT_OK()) {
            throw new IOException("RGB->YUV conversion failed");
        }
        return avifImg;
    }

    /*
     * Exception decompiling
     */
    public static byte[] write(IIOImage iioImage, AVIFImageWriteParam param) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void write(IIOImage image, AVIFImageWriteParam param, File outFile) throws IOException {
        byte[] outData = Avif.write(image, param);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(outData);
        }
    }

    private static BufferedImage cropImage(BufferedImage src, Rectangle rect) {
        int x = Math.max(0, rect.x);
        int y = Math.max(0, rect.y);
        int width = Math.min(rect.width, src.getWidth() - x);
        int height = Math.min(rect.height, src.getHeight() - y);
        return src.getSubimage(x, y, width, height);
    }

    private static BufferedImage ensureCompatibleType(BufferedImage img) {
        int targetType;
        int type = img.getType();
        boolean hasAlpha = img.getColorModel().hasAlpha();
        int n = targetType = hasAlpha ? 6 : 5;
        if (type == targetType) {
            return img;
        }
        BufferedImage fast = new BufferedImage(img.getWidth(), img.getHeight(), targetType);
        Graphics2D g = fast.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return fast;
    }

    public static void setLoggingLevel(Level l) {
        LOGGER.setLevel(l);
    }

    public static Level getLoggingLevel() {
        return LOGGER.getLevel();
    }

    static {
        LOGGER.addHandler(new StdoutHandler());
    }
}

