/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.util.Arrays;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.jalbum.image.ImageMetadata;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AVIFMetadata
extends IIOMetadata
implements ImageMetadata {
    private byte[] xmp;
    private byte[] exif;

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Node getAsTree(String formatName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reset() {
    }

    @Override
    public byte[] getXmp() {
        return this.xmp;
    }

    @Override
    public void setXmp(byte[] xmp) {
        this.xmp = xmp;
    }

    @Override
    public byte[] getEXIF() {
        return this.exif;
    }

    @Override
    public void setEXIF(byte[] exif) {
        this.exif = exif;
    }

    public static byte[] getEXIFBytes(IIOMetadata meta) {
        if (meta instanceof AVIFMetadata) {
            return ((AVIFMetadata)meta).getEXIF();
        }
        try {
            Node root = meta.getAsTree("javax_imageio_jpeg_image_1.0");
            return AVIFMetadata.getExifBytes(root);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getExifBytes(Node root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!"markerSequence".equals(node.getNodeName())) continue;
            NodeList markers = node.getChildNodes();
            for (int j = 0; j < markers.getLength(); ++j) {
                Node marker = markers.item(j);
                if (!"unknown".equals(marker.getNodeName()) || !"225".equals(marker.getAttributes().getNamedItem("MarkerTag").getNodeValue())) continue;
                byte[] fullEXIF = (byte[])((IIOMetadataNode)marker).getUserObject();
                return Arrays.copyOfRange(fullEXIF, 4, fullEXIF.length);
            }
        }
        return null;
    }
}

