/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.io.File;
import java.io.OutputStream;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import net.jalbum.avif.AVIFConstants;
import net.jalbum.avif.AVIFImageReaderSpi;
import net.jalbum.avif.AVIFImageWriter;
import net.jalbum.avif.SafeAvif;
import net.jalbum.avif.Support;

public class AVIFImageWriterSpi
extends ImageWriterSpi
implements AVIFConstants {
    private volatile boolean initialized = false;

    public AVIFImageWriterSpi() {
        super("jAlbum", "1.0", NAMES, SUFFIXES, MIME_TYPES, AVIFImageWriter.class.getName(), new Class[]{ImageOutputStream.class, OutputStream.class, File.class}, new String[]{AVIFImageReaderSpi.class.getName()}, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return Support.isOkJavaVersion();
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) {
        this.ensureLoaded();
        return new AVIFImageWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "AVIF Image Writer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() {
        if (this.initialized) {
            return;
        }
        AVIFImageWriterSpi aVIFImageWriterSpi = this;
        synchronized (aVIFImageWriterSpi) {
            if (this.initialized) {
                return;
            }
            if (!SafeAvif.isInitiatedOk()) {
                IIORegistry.getDefaultInstance().deregisterServiceProvider(this);
                throw new RuntimeException("LibAvif native library could not be loaded");
            }
            this.initialized = true;
        }
    }
}

