/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import net.jalbum.avif.AVIFImageWriteParam;
import net.jalbum.avif.Avif;

public class AVIFImageWriter
extends ImageWriter {
    private AVIFImageWriteParam lastParam = new AVIFImageWriteParam();

    protected AVIFImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new AVIFImageWriteParam();
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        Object output = this.getOutput();
        if (output == null) {
            throw new IllegalStateException("No output source set");
        }
        if (!(output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("Output must be an ImageOutputStream");
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        ImageOutputStream ios = (ImageOutputStream)output;
        try {
            byte[] avifData = Avif.write(image, (AVIFImageWriteParam)param);
            this.lastParam = (AVIFImageWriteParam)param;
            ios.write(avifData);
        }
        catch (IOException e) {
            throw new IIOException("Failed to write AVIF image: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "AvifImageWriter {codec=" + String.valueOf((Object)this.lastParam.getChosenCodec()) + "}";
    }

    @Override
    public void dispose() {
    }
}

