/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.jalbum.avif.AVIFConstants;
import net.jalbum.avif.AVIFImageReader;
import net.jalbum.avif.ImageIOUtils;
import net.jalbum.avif.SafeAvif;
import net.jalbum.avif.Support;

public class AVIFImageReaderSpi
extends ImageReaderSpi
implements AVIFConstants {
    private static final Class<?>[] INPUT_TYPES = new Class[]{ImageInputStream.class};
    private volatile boolean initialized = false;

    public AVIFImageReaderSpi() {
        super("jAlbum", "1.0", NAMES, SUFFIXES, MIME_TYPES, AVIFImageReader.class.getName(), INPUT_TYPES, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!Support.isOkJavaVersion()) {
            return false;
        }
        if (!(source instanceof ImageInputStream) && (source = ImageIOUtils.createImageInputStream(source)) == null) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        byte[] b = new byte[12];
        stream.mark();
        stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        stream.readFully(b);
        stream.reset();
        return b[4] == 102 && b[5] == 116 && b[6] == 121 && b[7] == 112 && (b[8] == 97 && b[9] == 118 && b[10] == 105 && b[11] == 102 || b[8] == 109 && b[9] == 105 && b[10] == 102 && b[11] == 49 || b[8] == 109 && b[9] == 115 && b[10] == 102 && b[11] == 49 || b[8] == 97 && b[9] == 118 && b[10] == 105 && b[11] == 115);
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        this.ensureLoaded();
        return new AVIFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "AVIF Image Reader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() {
        if (this.initialized) {
            return;
        }
        AVIFImageReaderSpi aVIFImageReaderSpi = this;
        synchronized (aVIFImageReaderSpi) {
            if (this.initialized) {
                return;
            }
            if (!SafeAvif.isInitiatedOk()) {
                IIORegistry.getDefaultInstance().deregisterServiceProvider(this);
                throw new RuntimeException("LibAvif native library could not be loaded");
            }
            this.initialized = true;
        }
    }
}

