/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.avif;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.jalbum.avif.AVIFImageReadParam;
import net.jalbum.avif.Avif;
import net.jalbum.avif.ImageIOUtils;
import net.jalbum.avif.ImageInfo;

public class AVIFImageReader
extends ImageReader {
    private static final String LIB_AVIF = "avif";
    private ImageInputStream iis = null;
    private BufferedImage image = null;
    private ImageInfo imageInfo;
    private AVIFImageReadParam lastParam = new AVIFImageReadParam();

    public AVIFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.iis = null;
            return;
        }
        this.iis = ImageIOUtils.createImageInputStream(input);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("No input source set");
        }
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkBounds(imageIndex);
        this.ensureMetaLoaded();
        return this.imageInfo.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkBounds(imageIndex);
        this.ensureMetaLoaded();
        return this.imageInfo.height;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new AVIFImageReadParam();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkBounds(imageIndex);
        this.ensureMetaLoaded();
        ImageTypeSpecifier specifier = ImageTypeSpecifier.createFromRenderedImage(this.image);
        return Collections.singleton(specifier).iterator();
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkBounds(imageIndex);
        this.ensureMetaLoaded();
        return this.imageInfo.meta;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkBounds(imageIndex);
        if (this.iis == null) {
            throw new IllegalStateException("No input source set");
        }
        long len = this.iis.length();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new IOException("Unknown or too large stream length: " + len);
        }
        byte[] bytes = new byte[(int)len];
        this.iis.readFully(bytes);
        IIOImage iioImage = Avif.read(bytes, null, (AVIFImageReadParam)param);
        this.image = (BufferedImage)iioImage.getRenderedImage();
        this.imageInfo = new ImageInfo(this.image.getWidth(), this.image.getHeight());
        return this.image;
    }

    private void checkBounds(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds");
        }
        if (this.iis == null) {
            throw new IllegalStateException("No input source set");
        }
    }

    private void ensureMetaLoaded() throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("No input source set");
        }
        if (this.imageInfo == null) {
            this.iis.mark();
            long len = this.iis.length();
            if (len < 0L || len > Integer.MAX_VALUE) {
                throw new IOException("Unknown or too large stream length: " + len);
            }
            byte[] bytes = new byte[(int)len];
            this.iis.readFully(bytes);
            ImageInfo ii = new ImageInfo();
            Avif.read(bytes, ii, null);
            this.iis.reset();
            this.imageInfo = ii;
        }
    }

    private void ensureImageLoaded() throws IOException {
        if (this.image != null) {
            return;
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return "AvifImageReader {codec=" + String.valueOf((Object)this.lastParam.getChosenCodec()) + "}";
    }
}

