/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime.linker;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import jdk.dynalink.beans.StaticClass;
import org.openjdk.nashorn.internal.codegen.Compiler;
import org.openjdk.nashorn.internal.codegen.DumpBytecode;
import org.openjdk.nashorn.internal.runtime.Context;
import org.openjdk.nashorn.internal.runtime.JSType;
import org.openjdk.nashorn.internal.runtime.ScriptFunction;
import org.openjdk.nashorn.internal.runtime.ScriptObject;
import org.openjdk.nashorn.internal.runtime.linker.JavaAdapterServices;

final class JavaAdapterClassLoader {
    private static final Module NASHORN_MODULE = Context.class.getModule();
    private static final Collection<String> VISIBLE_INTERNAL_CLASS_NAMES = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList(JavaAdapterServices.class.getName(), ScriptObject.class.getName(), ScriptFunction.class.getName(), JSType.class.getName())));
    private final String className;
    private final byte[] classBytes;

    JavaAdapterClassLoader(String className, byte[] classBytes) {
        this.className = className.replace('/', '.');
        this.classBytes = classBytes;
    }

    StaticClass generateClass(ClassLoader parentLoader) {
        try {
            return StaticClass.forClass(Class.forName(this.className, true, this.createClassLoader(parentLoader)));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ClassLoader createClassLoader(ClassLoader parentLoader) {
        return new ClassLoader(parentLoader){
            private final ClassLoader myLoader;
            private final Module adapterModule;
            {
                this.myLoader = this.getClass().getClassLoader();
                this.adapterModule = this.getUnnamedModule();
                NASHORN_MODULE.addExports("org.openjdk.nashorn.internal.runtime", this.adapterModule);
                NASHORN_MODULE.addExports("org.openjdk.nashorn.internal.runtime.linker", this.adapterModule);
                NASHORN_MODULE.addReads(this.adapterModule);
            }

            @Override
            public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (SecurityException se) {
                    if (VISIBLE_INTERNAL_CLASS_NAMES.contains(name)) {
                        return this.myLoader != null ? this.myLoader.loadClass(name) : Class.forName(name, false, null);
                    }
                    throw se;
                }
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(JavaAdapterClassLoader.this.className)) {
                    assert (JavaAdapterClassLoader.this.classBytes != null) : "what? already cleared .class bytes!!";
                    Context ctx = Context.getContext();
                    DumpBytecode.dumpBytecode(ctx.getEnv(), ctx.getLogger(Compiler.class), JavaAdapterClassLoader.this.classBytes, name);
                    return this.defineClass(name, JavaAdapterClassLoader.this.classBytes, 0, JavaAdapterClassLoader.this.classBytes.length);
                }
                throw new ClassNotFoundException(name);
            }
        };
    }
}

