/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mpg;

import de.sciss.jump3r.mp3.Enc;
import de.sciss.jump3r.mp3.MP3Data;
import de.sciss.jump3r.mp3.PlottingData;
import de.sciss.jump3r.mpg.Common;
import de.sciss.jump3r.mpg.Decode;
import de.sciss.jump3r.mpg.Frame;
import de.sciss.jump3r.mpg.Interface;

public class MPGLib {
    Interface interf;
    Common common;
    public static final int MP3_ERR = -1;
    public static final int MP3_OK = 0;
    static final int MP3_NEED_MORE = 1;
    private static final int[][] smpls = new int[][]{{0, 384, 1152, 1152}, {0, 384, 1152, 576}};
    private static final int OUTSIZE_CLIPPED = 4096;
    private static final int OUTSIZE_UNCLIPPED = 2304;

    public void setModules(Interface i, Common c) {
        this.interf = i;
        this.common = c;
    }

    protected <DST_TYPE, SRC_TYPE> void COPY_MONO(DST_TYPE[] pcm_l, int pcm_lPos, int processed_samples, SRC_TYPE[] p) {
        int p_samples = 0;
        for (int i = 0; i < processed_samples; ++i) {
            pcm_l[pcm_lPos++] = p[p_samples++];
        }
    }

    protected <DST_TYPE, SRC_TYPE> void COPY_STEREO(DST_TYPE[] pcm_l, int pcm_lPos, DST_TYPE[] pcm_r, int pcm_rPos, int processed_samples, SRC_TYPE[] p) {
        int p_samples = 0;
        for (int i = 0; i < processed_samples; ++i) {
            pcm_l[pcm_lPos++] = p[p_samples++];
            pcm_r[pcm_rPos++] = p[p_samples++];
        }
    }

    private <S, T> int decode1_headersB_clipchoice(mpstr_tag pmp, byte[] buffer, int bufferPos, int len, S[] pcm_l, int pcm_lPos, S[] pcm_r, int pcm_rPos, MP3Data mp3data, Enc enc, T[] p, int psize, IDecoder decodeMP3_ptr, Decode.Factory<T> tFactory) {
        mp3data.header_parsed = false;
        ProcessedBytes pb = new ProcessedBytes();
        int ret = decodeMP3_ptr.decode(pmp, buffer, bufferPos, len, p, psize, pb, tFactory);
        int processed_samples = pb.pb;
        if (pmp.header_parsed || pmp.fsizeold > 0 || pmp.framesize > 0) {
            mp3data.header_parsed = true;
            mp3data.stereo = pmp.fr.stereo;
            mp3data.samplerate = Common.freqs[pmp.fr.sampling_frequency];
            mp3data.mode = pmp.fr.mode;
            mp3data.mode_ext = pmp.fr.mode_ext;
            mp3data.framesize = smpls[pmp.fr.lsf][pmp.fr.lay];
            mp3data.bitrate = pmp.fsizeold > 0 ? (int)((double)(8 * (4 + pmp.fsizeold) * mp3data.samplerate) / (1000.0 * (double)mp3data.framesize) + 0.5) : (pmp.framesize > 0 ? (int)((double)(8 * (4 + pmp.framesize) * mp3data.samplerate) / (1000.0 * (double)mp3data.framesize) + 0.5) : Common.tabsel_123[pmp.fr.lsf][pmp.fr.lay - 1][pmp.fr.bitrate_index]);
            if (pmp.num_frames > 0) {
                mp3data.totalframes = pmp.num_frames;
                mp3data.nsamp = mp3data.framesize * pmp.num_frames;
                enc.enc_delay = pmp.enc_delay;
                enc.enc_padding = pmp.enc_padding;
            }
        }
        block0 : switch (ret) {
            case 0: {
                switch (pmp.fr.stereo) {
                    case 1: {
                        this.COPY_MONO(pcm_l, pcm_lPos, processed_samples, p);
                        break block0;
                    }
                    case 2: {
                        this.COPY_STEREO(pcm_l, pcm_lPos, pcm_r, pcm_rPos, processed_samples >>= 1, p);
                        break block0;
                    }
                }
                processed_samples = -1;
                assert (false);
                break;
            }
            case 1: {
                processed_samples = 0;
                break;
            }
            case -1: {
                processed_samples = -1;
                break;
            }
            default: {
                processed_samples = -1;
                assert (false);
                break;
            }
        }
        return processed_samples;
    }

    public mpstr_tag hip_decode_init() {
        return this.interf.InitMP3();
    }

    public int hip_decode_exit(mpstr_tag hip) {
        if (hip != null) {
            this.interf.ExitMP3(hip);
            hip = null;
        }
        return 0;
    }

    public int hip_decode1_unclipped(mpstr_tag hip, byte[] buffer, int bufferPos, int len, float[] pcm_l, float[] pcm_r) {
        MP3Data mp3data = new MP3Data();
        Enc enc = new Enc();
        if (hip != null) {
            int i;
            IDecoder dec = new IDecoder(){

                public <X> int decode(mpstr_tag mp, byte[] in, int bufferPos, int isize, X[] out, int osize, ProcessedBytes done, Decode.Factory<X> tFactory) {
                    return MPGLib.this.interf.decodeMP3_unclipped(mp, in, bufferPos, isize, out, osize, done, tFactory);
                }
            };
            Float[] out = new Float[2304];
            Decode.Factory<Float> tFactory = new Decode.Factory<Float>(){

                @Override
                public Float create(float x) {
                    return Float.valueOf(x);
                }
            };
            Float[] pcmL = new Float[pcm_l.length];
            for (int i2 = 0; i2 < pcmL.length; ++i2) {
                pcmL[i2] = Float.valueOf(pcm_l[i2]);
            }
            Float[] pcmR = new Float[pcm_r.length];
            for (int i3 = 0; i3 < pcmR.length; ++i3) {
                pcmR[i3] = Float.valueOf(pcm_r[i3]);
            }
            int decode1_headersB_clipchoice = this.decode1_headersB_clipchoice(hip, buffer, bufferPos, len, pcmL, 0, pcmR, 0, mp3data, enc, out, 2304, dec, tFactory);
            for (i = 0; i < pcmL.length; ++i) {
                pcm_l[i] = pcmL[i].floatValue();
            }
            for (i = 0; i < pcmR.length; ++i) {
                pcm_r[i] = pcmR[i].floatValue();
            }
            return decode1_headersB_clipchoice;
        }
        return 0;
    }

    public int hip_decode1_headers(mpstr_tag hip, byte[] buffer, int len, short[] pcm_l, short[] pcm_r, MP3Data mp3data) {
        Enc enc = new Enc();
        return this.hip_decode1_headersB(hip, buffer, len, pcm_l, pcm_r, mp3data, enc);
    }

    public int hip_decode1_headersB(mpstr_tag hip, byte[] buffer, int len, short[] pcm_l, short[] pcm_r, MP3Data mp3data, Enc enc) {
        if (hip != null) {
            int i;
            IDecoder dec = new IDecoder(){

                public <X> int decode(mpstr_tag mp, byte[] in, int bufferPos, int isize, X[] out, int osize, ProcessedBytes done, Decode.Factory<X> tFactory) {
                    return MPGLib.this.interf.decodeMP3(mp, in, bufferPos, isize, out, osize, done, tFactory);
                }
            };
            Short[] out = new Short[4096];
            Decode.Factory<Short> tFactory = new Decode.Factory<Short>(){

                @Override
                public Short create(float x) {
                    return (short)x;
                }
            };
            Short[] pcmL = new Short[pcm_l.length];
            for (int i2 = 0; i2 < pcmL.length; ++i2) {
                pcmL[i2] = pcm_l[i2];
            }
            Short[] pcmR = new Short[pcm_r.length];
            for (int i3 = 0; i3 < pcmR.length; ++i3) {
                pcmR[i3] = pcm_r[i3];
            }
            int decode1_headersB_clipchoice = this.decode1_headersB_clipchoice(hip, buffer, 0, len, pcmL, 0, pcmR, 0, mp3data, enc, out, 4096, dec, tFactory);
            for (i = 0; i < pcmL.length; ++i) {
                pcm_l[i] = pcmL[i];
            }
            for (i = 0; i < pcmR.length; ++i) {
                pcm_r[i] = pcmR[i];
            }
            return decode1_headersB_clipchoice;
        }
        return -1;
    }

    void hip_set_pinfo(mpstr_tag hip, PlottingData pinfo) {
        if (hip != null) {
            hip.pinfo = pinfo;
        }
    }

    static class ProcessedBytes {
        int pb;

        ProcessedBytes() {
        }
    }

    static interface IDecoder {
        public <T> int decode(mpstr_tag var1, byte[] var2, int var3, int var4, T[] var5, int var6, ProcessedBytes var7, Decode.Factory<T> var8);
    }

    public static class mpstr_tag {
        buf head;
        buf tail;
        boolean vbr_header;
        int num_frames;
        int enc_delay;
        int enc_padding;
        boolean header_parsed;
        boolean side_parsed;
        boolean data_parsed;
        boolean free_format;
        boolean old_free_format;
        int bsize;
        int framesize;
        int ssize;
        int dsize;
        int fsizeold;
        int fsizeold_nopadding;
        Frame fr = new Frame();
        byte[][] bsspace = new byte[2][3904];
        float[][][] hybrid_block = new float[2][2][576];
        int[] hybrid_blc = new int[2];
        long header;
        int bsnum;
        float[][][] synth_buffs = new float[2][2][272];
        int synth_bo;
        int sync_bitstream;
        int bitindex;
        byte[] wordpointer;
        int wordpointerPos;
        PlottingData pinfo;
    }

    public static class framebuf {
        buf buf;
        long pos;
        Frame next;
        Frame prev;
    }

    public static class buf {
        byte[] pnt;
        int size;
        int pos;
        buf next;
        buf prev;
    }
}

