/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.ATH;
import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.CalcNoiseData;
import de.sciss.jump3r.mp3.CalcNoiseResult;
import de.sciss.jump3r.mp3.GrInfo;
import de.sciss.jump3r.mp3.IIISideInfo;
import de.sciss.jump3r.mp3.III_psy_ratio;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.LameInternalFlags;
import de.sciss.jump3r.mp3.MeanBits;
import de.sciss.jump3r.mp3.PsyModel;
import de.sciss.jump3r.mp3.Reservoir;
import de.sciss.jump3r.mp3.ScaleFac;
import de.sciss.jump3r.mp3.Takehiro;
import de.sciss.jump3r.mp3.Util;
import de.sciss.jump3r.mp3.VbrMode;

public class QuantizePVT {
    Takehiro tak;
    Reservoir rv;
    PsyModel psy;
    private static final float DBL_EPSILON = 2.220446E-16f;
    public static final int IXMAX_VAL = 8206;
    private static final int PRECALC_SIZE = 8208;
    private static final int Q_MAX = 257;
    public static final int Q_MAX2 = 116;
    public static final int LARGE_BITS = 100000;
    private static final int NSATHSCALE = 100;
    public final int[][][] nr_of_sfb_block = new int[][][]{new int[][]{{6, 5, 5, 5}, {9, 9, 9, 9}, {6, 9, 9, 9}}, new int[][]{{6, 5, 7, 3}, {9, 9, 12, 6}, {6, 9, 12, 6}}, new int[][]{{11, 10, 0, 0}, {18, 18, 0, 0}, {15, 18, 0, 0}}, new int[][]{{7, 7, 7, 0}, {12, 12, 12, 0}, {6, 15, 12, 0}}, new int[][]{{6, 6, 6, 3}, {12, 9, 9, 6}, {6, 12, 9, 6}}, new int[][]{{8, 8, 5, 0}, {15, 12, 9, 0}, {6, 18, 9, 0}}};
    public final int[] pretab = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0};
    public final ScaleFac[] sfBandIndex = new ScaleFac[]{new ScaleFac(new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new int[]{0, 4, 8, 12, 18, 24, 32, 42, 56, 74, 100, 132, 174, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194, 232, 278, 332, 394, 464, 540, 576}, new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 136, 180, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576}, new int[]{0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576}, new int[]{0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576}, new int[]{0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0}), new ScaleFac(new int[]{0, 12, 24, 36, 48, 60, 72, 88, 108, 132, 160, 192, 232, 280, 336, 400, 476, 566, 568, 570, 572, 574, 576}, new int[]{0, 8, 16, 24, 36, 52, 72, 96, 124, 160, 162, 164, 166, 192}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0})};
    public float[] pow20 = new float[374];
    public float[] ipow20 = new float[257];
    public float[] pow43 = new float[8208];
    public float[] adj43 = new float[8208];

    public final void setModules(Takehiro tk, Reservoir rv, PsyModel psy) {
        this.tak = tk;
        this.rv = rv;
        this.psy = psy;
    }

    public final float POW20(int x) {
        assert (0 <= x + 116 && x < 257);
        return this.pow20[x + 116];
    }

    public final float IPOW20(int x) {
        assert (0 <= x && x < 257);
        return this.ipow20[x];
    }

    private float ATHmdct(LameGlobalFlags gfp, float f) {
        float ath = this.psy.ATHformula(f, gfp);
        ath -= 100.0f;
        ath = (float)Math.pow(10.0, (double)ath / 10.0 + (double)gfp.ATHlower);
        return ath;
    }

    private void compute_ath(LameGlobalFlags gfp) {
        float ATH_f;
        float freq;
        int i;
        int end;
        int start;
        int sfb;
        float[] ATH_l = gfp.internal_flags.ATH.l;
        float[] ATH_psfb21 = gfp.internal_flags.ATH.psfb21;
        float[] ATH_s = gfp.internal_flags.ATH.s;
        float[] ATH_psfb12 = gfp.internal_flags.ATH.psfb12;
        LameInternalFlags gfc = gfp.internal_flags;
        float samp_freq = gfp.out_samplerate;
        for (sfb = 0; sfb < 22; ++sfb) {
            start = gfc.scalefac_band.l[sfb];
            end = gfc.scalefac_band.l[sfb + 1];
            ATH_l[sfb] = Float.MAX_VALUE;
            for (i = start; i < end; ++i) {
                freq = (float)i * samp_freq / 1152.0f;
                ATH_f = this.ATHmdct(gfp, freq);
                ATH_l[sfb] = Math.min(ATH_l[sfb], ATH_f);
            }
        }
        for (sfb = 0; sfb < 6; ++sfb) {
            start = gfc.scalefac_band.psfb21[sfb];
            end = gfc.scalefac_band.psfb21[sfb + 1];
            ATH_psfb21[sfb] = Float.MAX_VALUE;
            for (i = start; i < end; ++i) {
                freq = (float)i * samp_freq / 1152.0f;
                ATH_f = this.ATHmdct(gfp, freq);
                ATH_psfb21[sfb] = Math.min(ATH_psfb21[sfb], ATH_f);
            }
        }
        for (sfb = 0; sfb < 13; ++sfb) {
            start = gfc.scalefac_band.s[sfb];
            end = gfc.scalefac_band.s[sfb + 1];
            ATH_s[sfb] = Float.MAX_VALUE;
            for (i = start; i < end; ++i) {
                freq = (float)i * samp_freq / 384.0f;
                ATH_f = this.ATHmdct(gfp, freq);
                ATH_s[sfb] = Math.min(ATH_s[sfb], ATH_f);
            }
            int n = sfb;
            ATH_s[n] = ATH_s[n] * (float)(gfc.scalefac_band.s[sfb + 1] - gfc.scalefac_band.s[sfb]);
        }
        sfb = 0;
        while (sfb < 6) {
            start = gfc.scalefac_band.psfb12[sfb];
            end = gfc.scalefac_band.psfb12[sfb + 1];
            ATH_psfb12[sfb] = Float.MAX_VALUE;
            for (i = start; i < end; ++i) {
                freq = (float)i * samp_freq / 384.0f;
                ATH_f = this.ATHmdct(gfp, freq);
                ATH_psfb12[sfb] = Math.min(ATH_psfb12[sfb], ATH_f);
            }
            int n = sfb++;
            ATH_psfb12[n] = ATH_psfb12[n] * (float)(gfc.scalefac_band.s[13] - gfc.scalefac_band.s[12]);
        }
        if (gfp.noATH) {
            for (sfb = 0; sfb < 22; ++sfb) {
                ATH_l[sfb] = 1.0E-20f;
            }
            for (sfb = 0; sfb < 6; ++sfb) {
                ATH_psfb21[sfb] = 1.0E-20f;
            }
            for (sfb = 0; sfb < 13; ++sfb) {
                ATH_s[sfb] = 1.0E-20f;
            }
            for (sfb = 0; sfb < 6; ++sfb) {
                ATH_psfb12[sfb] = 1.0E-20f;
            }
        }
        gfc.ATH.floor = 10.0f * (float)Math.log10(this.ATHmdct(gfp, -1.0f));
    }

    public final void iteration_init(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        IIISideInfo l3_side = gfc.l3_side;
        if (gfc.iteration_init_init == 0) {
            float f;
            int i;
            gfc.iteration_init_init = 1;
            l3_side.main_data_begin = 0;
            this.compute_ath(gfp);
            this.pow43[0] = 0.0f;
            for (i = 1; i < 8208; ++i) {
                this.pow43[i] = (float)Math.pow(i, 1.3333333333333333);
            }
            for (i = 0; i < 8207; ++i) {
                this.adj43[i] = (float)((double)(i + 1) - Math.pow(0.5 * (double)(this.pow43[i] + this.pow43[i + 1]), 0.75));
            }
            this.adj43[i] = 0.5f;
            for (i = 0; i < 257; ++i) {
                this.ipow20[i] = (float)Math.pow(2.0, (double)(i - 210) * -0.1875);
            }
            for (i = 0; i <= 373; ++i) {
                this.pow20[i] = (float)Math.pow(2.0, (double)(i - 210 - 116) * 0.25);
            }
            this.tak.huffman_init(gfc);
            i = gfp.exp_nspsytune >> 2 & 0x3F;
            if (i >= 32) {
                i -= 64;
            }
            float bass = (float)Math.pow(10.0, (double)i / 4.0 / 10.0);
            i = gfp.exp_nspsytune >> 8 & 0x3F;
            if (i >= 32) {
                i -= 64;
            }
            float alto = (float)Math.pow(10.0, (double)i / 4.0 / 10.0);
            i = gfp.exp_nspsytune >> 14 & 0x3F;
            if (i >= 32) {
                i -= 64;
            }
            float treble = (float)Math.pow(10.0, (double)i / 4.0 / 10.0);
            i = gfp.exp_nspsytune >> 20 & 0x3F;
            if (i >= 32) {
                i -= 64;
            }
            float sfb21 = treble * (float)Math.pow(10.0, (double)i / 4.0 / 10.0);
            for (i = 0; i < 22; ++i) {
                f = i <= 6 ? bass : (i <= 13 ? alto : (i <= 20 ? treble : sfb21));
                gfc.nsPsy.longfact[i] = f;
            }
            for (i = 0; i < 13; ++i) {
                f = i <= 5 ? bass : (i <= 10 ? alto : (i <= 11 ? treble : sfb21));
                gfc.nsPsy.shortfact[i] = f;
            }
        }
    }

    public final int on_pe(LameGlobalFlags gfp, float[][] pe, int[] targ_bits, int mean_bits, int gr, int cbr) {
        int ch;
        MeanBits mb;
        LameInternalFlags gfc = gfp.internal_flags;
        int tbits = 0;
        int[] add_bits = new int[2];
        tbits = mb.bits;
        mb = new MeanBits(tbits);
        int extra_bits = this.rv.ResvMaxBits(gfp, mean_bits, mb, cbr);
        int max_bits = tbits + extra_bits;
        if (max_bits > 7680) {
            max_bits = 7680;
        }
        int bits = 0;
        for (ch = 0; ch < gfc.channels_out; ++ch) {
            targ_bits[ch] = Math.min(4095, tbits / gfc.channels_out);
            add_bits[ch] = (int)((double)((float)targ_bits[ch] * pe[gr][ch]) / 700.0 - (double)targ_bits[ch]);
            if (add_bits[ch] > mean_bits * 3 / 4) {
                add_bits[ch] = mean_bits * 3 / 4;
            }
            if (add_bits[ch] < 0) {
                add_bits[ch] = 0;
            }
            if (add_bits[ch] + targ_bits[ch] > 4095) {
                add_bits[ch] = Math.max(0, 4095 - targ_bits[ch]);
            }
            bits += add_bits[ch];
        }
        if (bits > extra_bits) {
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                add_bits[ch] = extra_bits * add_bits[ch] / bits;
            }
        }
        for (ch = 0; ch < gfc.channels_out; ++ch) {
            int n = ch;
            targ_bits[n] = targ_bits[n] + add_bits[ch];
            extra_bits -= add_bits[ch];
        }
        bits = 0;
        for (ch = 0; ch < gfc.channels_out; ++ch) {
            bits += targ_bits[ch];
        }
        if (bits > 7680) {
            int sum = 0;
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                int n = ch;
                targ_bits[n] = targ_bits[n] * 7680;
                int n2 = ch;
                targ_bits[n2] = targ_bits[n2] / bits;
                sum += targ_bits[ch];
            }
            assert (sum <= 7680);
        }
        return max_bits;
    }

    public final void reduce_side(int[] targ_bits, float ms_ener_ratio, int mean_bits, int max_bits) {
        int move_bits;
        assert (max_bits <= 7680);
        assert (targ_bits[0] + targ_bits[1] <= 7680);
        float fac = 0.33f * (0.5f - ms_ener_ratio) / 0.5f;
        if (fac < 0.0f) {
            fac = 0.0f;
        }
        if ((double)fac > 0.5) {
            fac = 0.5f;
        }
        if ((move_bits = (int)((double)fac * 0.5 * (double)(targ_bits[0] + targ_bits[1]))) > 4095 - targ_bits[0]) {
            move_bits = 4095 - targ_bits[0];
        }
        if (move_bits < 0) {
            move_bits = 0;
        }
        if (targ_bits[1] >= 125) {
            if (targ_bits[1] - move_bits > 125) {
                if (targ_bits[0] < mean_bits) {
                    targ_bits[0] = targ_bits[0] + move_bits;
                }
                targ_bits[1] = targ_bits[1] - move_bits;
            } else {
                targ_bits[0] = targ_bits[0] + (targ_bits[1] - 125);
                targ_bits[1] = 125;
            }
        }
        if ((move_bits = targ_bits[0] + targ_bits[1]) > max_bits) {
            targ_bits[0] = max_bits * targ_bits[0] / move_bits;
            targ_bits[1] = max_bits * targ_bits[1] / move_bits;
        }
        assert (targ_bits[0] <= 4095);
        assert (targ_bits[1] <= 4095);
        assert (targ_bits[0] + targ_bits[1] <= 7680);
    }

    public final float athAdjust(float a, float x, float athFloor) {
        float o = 90.30873f;
        float p = 94.82445f;
        float u = Util.FAST_LOG10_X(x, 10.0f);
        float v = a * a;
        float w = 0.0f;
        u -= athFloor;
        if ((double)v > 1.0E-20) {
            w = 1.0f + Util.FAST_LOG10_X(v, 0.11073127f);
        }
        if (w < 0.0f) {
            w = 0.0f;
        }
        u *= w;
        return (float)Math.pow(10.0, 0.1 * (double)(u += athFloor + 90.30873f - 94.82445f));
    }

    public final int calc_xmin(LameGlobalFlags gfp, III_psy_ratio ratio, GrInfo cod_info, float[] pxmin) {
        int gsfb;
        int pxminPos = 0;
        LameInternalFlags gfc = gfp.internal_flags;
        int j = 0;
        int ath_over = 0;
        ATH ATH2 = gfc.ATH;
        float[] xr = cod_info.xr;
        boolean enable_athaa_fix = gfp.VBR == VbrMode.vbr_mtrh;
        float masking_lower = gfc.masking_lower;
        if (gfp.VBR == VbrMode.vbr_mtrh || gfp.VBR == VbrMode.vbr_mt) {
            masking_lower = 1.0f;
        }
        for (gsfb = 0; gsfb < cod_info.psy_lmax; ++gsfb) {
            float e;
            float x;
            float xmin = gfp.VBR == VbrMode.vbr_rh || gfp.VBR == VbrMode.vbr_mtrh ? this.athAdjust(ATH2.adjust, ATH2.l[gsfb], ATH2.floor) : ATH2.adjust * ATH2.l[gsfb];
            int width = cod_info.width[gsfb];
            float rh1 = xmin / (float)width;
            float rh2 = 2.220446E-16f;
            int l = width >> 1;
            float en0 = 0.0f;
            do {
                float xa = xr[j] * xr[j];
                en0 += xa;
                rh2 += xa < rh1 ? xa : rh1;
                float xb = xr[++j] * xr[j];
                en0 += xb;
                rh2 += xb < rh1 ? xb : rh1;
                ++j;
            } while (--l > 0);
            if (en0 > xmin) {
                ++ath_over;
            }
            if (gsfb == 21 && rh2 < (x = xmin * gfc.nsPsy.longfact[gsfb])) {
                rh2 = x;
            }
            if (enable_athaa_fix) {
                xmin = rh2;
            }
            if (!gfp.ATHonly && (e = ratio.en.l[gsfb]) > 0.0f) {
                float x2 = en0 * ratio.thm.l[gsfb] * masking_lower / e;
                if (enable_athaa_fix) {
                    x2 *= gfc.nsPsy.longfact[gsfb];
                }
                if (xmin < x2) {
                    xmin = x2;
                }
            }
            pxmin[pxminPos++] = enable_athaa_fix ? xmin : xmin * gfc.nsPsy.longfact[gsfb];
        }
        int max_nonzero = 575;
        if (cod_info.block_type != 2) {
            int k = 576;
            while (k-- != 0 && BitStream.EQ(xr[k], 0.0f)) {
                max_nonzero = k;
            }
        }
        cod_info.max_nonzero_coeff = max_nonzero;
        int sfb = cod_info.sfb_smin;
        while (gsfb < cod_info.psymax) {
            float tmpATH = gfp.VBR == VbrMode.vbr_rh || gfp.VBR == VbrMode.vbr_mtrh ? this.athAdjust(ATH2.adjust, ATH2.s[sfb], ATH2.floor) : ATH2.adjust * ATH2.s[sfb];
            int width = cod_info.width[gsfb];
            for (int b = 0; b < 3; ++b) {
                float e;
                float x;
                float en0 = 0.0f;
                int l = width >> 1;
                float rh1 = tmpATH / (float)width;
                float rh2 = 2.220446E-16f;
                do {
                    float xa = xr[j] * xr[j];
                    en0 += xa;
                    rh2 += xa < rh1 ? xa : rh1;
                    float xb = xr[++j] * xr[j];
                    en0 += xb;
                    rh2 += xb < rh1 ? xb : rh1;
                    ++j;
                } while (--l > 0);
                if (en0 > tmpATH) {
                    ++ath_over;
                }
                if (sfb == 12 && rh2 < (x = tmpATH * gfc.nsPsy.shortfact[sfb])) {
                    rh2 = x;
                }
                float xmin = enable_athaa_fix ? rh2 : tmpATH;
                if (!gfp.ATHonly && !gfp.ATHshort && (e = ratio.en.s[sfb][b]) > 0.0f) {
                    float x3 = en0 * ratio.thm.s[sfb][b] * masking_lower / e;
                    if (enable_athaa_fix) {
                        x3 *= gfc.nsPsy.shortfact[sfb];
                    }
                    if (xmin < x3) {
                        xmin = x3;
                    }
                }
                pxmin[pxminPos++] = enable_athaa_fix ? xmin : xmin * gfc.nsPsy.shortfact[sfb];
            }
            if (gfp.useTemporal.booleanValue()) {
                if (pxmin[pxminPos - 3] > pxmin[pxminPos - 3 + 1]) {
                    int n = pxminPos - 3 + 1;
                    pxmin[n] = pxmin[n] + (pxmin[pxminPos - 3] - pxmin[pxminPos - 3 + 1]) * gfc.decay;
                }
                if (pxmin[pxminPos - 3 + 1] > pxmin[pxminPos - 3 + 2]) {
                    int n = pxminPos - 3 + 2;
                    pxmin[n] = pxmin[n] + (pxmin[pxminPos - 3 + 1] - pxmin[pxminPos - 3 + 2]) * gfc.decay;
                }
            }
            ++sfb;
            gsfb += 3;
        }
        return ath_over;
    }

    private float calc_noise_core(GrInfo cod_info, StartLine startline, int l, float step) {
        float noise = 0.0f;
        int j = startline.s;
        int[] ix = cod_info.l3_enc;
        if (j > cod_info.count1) {
            while (l-- != 0) {
                float temp = cod_info.xr[j];
                noise += temp * temp;
                temp = cod_info.xr[++j];
                ++j;
                noise += temp * temp;
            }
        } else if (j > cod_info.big_values) {
            float[] ix01 = new float[]{0.0f, step};
            while (l-- != 0) {
                float temp = Math.abs(cod_info.xr[j]) - ix01[ix[j]];
                noise += temp * temp;
                temp = Math.abs(cod_info.xr[++j]) - ix01[ix[j]];
                ++j;
                noise += temp * temp;
            }
        } else {
            while (l-- != 0) {
                float temp = Math.abs(cod_info.xr[j]) - this.pow43[ix[j]] * step;
                noise += temp * temp;
                temp = Math.abs(cod_info.xr[++j]) - this.pow43[ix[j]] * step;
                ++j;
                noise += temp * temp;
            }
        }
        startline.s = j;
        return noise;
    }

    public final int calc_noise(GrInfo cod_info, float[] l3_xmin, float[] distort, CalcNoiseResult res, CalcNoiseData prev_noise) {
        int distortPos = 0;
        int l3_xminPos = 0;
        int over = 0;
        float over_noise_db = 0.0f;
        float tot_noise_db = 0.0f;
        float max_noise = -20.0f;
        int j = 0;
        int[] scalefac = cod_info.scalefac;
        int scalefacPos = 0;
        res.over_SSD = 0;
        for (int sfb = 0; sfb < cod_info.psymax; ++sfb) {
            int s = cod_info.global_gain - (scalefac[scalefacPos++] + (cod_info.preflag != 0 ? this.pretab[sfb] : 0) << cod_info.scalefac_scale + 1) - cod_info.subblock_gain[cod_info.window[sfb]] * 8;
            float noise = 0.0f;
            if (prev_noise != null && prev_noise.step[sfb] == s) {
                noise = prev_noise.noise[sfb];
                j += cod_info.width[sfb];
                distort[distortPos++] = noise / l3_xmin[l3_xminPos++];
                noise = prev_noise.noise_log[sfb];
            } else {
                float step = this.POW20(s);
                int l = cod_info.width[sfb] >> 1;
                if (j + cod_info.width[sfb] > cod_info.max_nonzero_coeff) {
                    int usefullsize = cod_info.max_nonzero_coeff - j + 1;
                    l = usefullsize > 0 ? usefullsize >> 1 : 0;
                }
                StartLine sl = new StartLine(j);
                noise = this.calc_noise_core(cod_info, sl, l, step);
                j = sl.s;
                if (prev_noise != null) {
                    prev_noise.step[sfb] = s;
                    prev_noise.noise[sfb] = noise;
                }
                int n = distortPos++;
                float f = noise / l3_xmin[l3_xminPos++];
                distort[n] = f;
                noise = f;
                noise = Util.FAST_LOG10((float)Math.max((double)noise, 1.0E-20));
                if (prev_noise != null) {
                    prev_noise.noise_log[sfb] = noise;
                }
            }
            if (prev_noise != null) {
                prev_noise.global_gain = cod_info.global_gain;
            }
            tot_noise_db += noise;
            if ((double)noise > 0.0) {
                int tmp = Math.max((int)((double)(noise * 10.0f) + 0.5), 1);
                res.over_SSD += tmp * tmp;
                ++over;
                over_noise_db += noise;
            }
            max_noise = Math.max(max_noise, noise);
        }
        res.over_count = over;
        res.tot_noise = tot_noise_db;
        res.over_noise = over_noise_db;
        res.max_noise = max_noise;
        return over;
    }

    private void set_pinfo(LameGlobalFlags gfp, GrInfo cod_info, III_psy_ratio ratio, int gr, int ch) {
        float en1;
        float en0;
        int bw;
        int end;
        int start;
        int sfb;
        LameInternalFlags gfc = gfp.internal_flags;
        float ifqstep = cod_info.scalefac_scale == 0 ? 0.5f : 1.0f;
        int[] scalefac = cod_info.scalefac;
        float[] l3_xmin = new float[39];
        float[] xfsf = new float[39];
        CalcNoiseResult noise = new CalcNoiseResult();
        this.calc_xmin(gfp, ratio, cod_info, l3_xmin);
        this.calc_noise(cod_info, l3_xmin, xfsf, noise, null);
        int j = 0;
        int sfb2 = cod_info.sfb_lmax;
        if (cod_info.block_type != 2 && 0 == cod_info.mixed_block_flag) {
            sfb2 = 22;
        }
        for (sfb = 0; sfb < sfb2; ++sfb) {
            start = gfc.scalefac_band.l[sfb];
            end = gfc.scalefac_band.l[sfb + 1];
            bw = end - start;
            en0 = 0.0f;
            while (j < end) {
                en0 += cod_info.xr[j] * cod_info.xr[j];
                ++j;
            }
            en1 = 1.0E15f;
            gfc.pinfo.en[gr][ch][sfb] = en1 * (en0 /= (float)bw);
            gfc.pinfo.xfsf[gr][ch][sfb] = en1 * l3_xmin[sfb] * xfsf[sfb] / (float)bw;
            en0 = ratio.en.l[sfb] > 0.0f && !gfp.ATHonly ? (en0 /= ratio.en.l[sfb]) : 0.0f;
            gfc.pinfo.thr[gr][ch][sfb] = en1 * Math.max(en0 * ratio.thm.l[sfb], gfc.ATH.l[sfb]);
            gfc.pinfo.LAMEsfb[gr][ch][sfb] = 0.0;
            if (cod_info.preflag != 0 && sfb >= 11) {
                gfc.pinfo.LAMEsfb[gr][ch][sfb] = -ifqstep * (float)this.pretab[sfb];
            }
            if (sfb >= 21) continue;
            assert (scalefac[sfb] >= 0);
            double[] dArray = gfc.pinfo.LAMEsfb[gr][ch];
            int n = sfb;
            dArray[n] = dArray[n] - (double)(ifqstep * (float)scalefac[sfb]);
        }
        if (cod_info.block_type == 2) {
            sfb2 = sfb;
            for (sfb = cod_info.sfb_smin; sfb < 13; ++sfb) {
                start = gfc.scalefac_band.s[sfb];
                end = gfc.scalefac_band.s[sfb + 1];
                bw = end - start;
                for (int i = 0; i < 3; ++i) {
                    en0 = 0.0f;
                    for (int l = start; l < end; ++l) {
                        en0 += cod_info.xr[j] * cod_info.xr[j];
                        ++j;
                    }
                    en0 = (float)Math.max((double)(en0 / (float)bw), 1.0E-20);
                    en1 = 1.0E15f;
                    gfc.pinfo.en_s[gr][ch][3 * sfb + i] = en1 * en0;
                    gfc.pinfo.xfsf_s[gr][ch][3 * sfb + i] = en1 * l3_xmin[sfb2] * xfsf[sfb2] / (float)bw;
                    en0 = ratio.en.s[sfb][i] > 0.0f ? (en0 /= ratio.en.s[sfb][i]) : 0.0f;
                    if (gfp.ATHonly || gfp.ATHshort) {
                        en0 = 0.0f;
                    }
                    gfc.pinfo.thr_s[gr][ch][3 * sfb + i] = en1 * Math.max(en0 * ratio.thm.s[sfb][i], gfc.ATH.s[sfb]);
                    gfc.pinfo.LAMEsfb_s[gr][ch][3 * sfb + i] = -2.0 * (double)cod_info.subblock_gain[i];
                    if (sfb < 12) {
                        double[] dArray = gfc.pinfo.LAMEsfb_s[gr][ch];
                        int n = 3 * sfb + i;
                        dArray[n] = dArray[n] - (double)(ifqstep * (float)scalefac[sfb2]);
                    }
                    ++sfb2;
                }
            }
        }
        gfc.pinfo.LAMEqss[gr][ch] = cod_info.global_gain;
        gfc.pinfo.LAMEmainbits[gr][ch] = cod_info.part2_3_length + cod_info.part2_length;
        gfc.pinfo.LAMEsfbits[gr][ch] = cod_info.part2_length;
        gfc.pinfo.over[gr][ch] = noise.over_count;
        gfc.pinfo.max_noise[gr][ch] = (double)noise.max_noise * 10.0;
        gfc.pinfo.over_noise[gr][ch] = (double)noise.over_noise * 10.0;
        gfc.pinfo.tot_noise[gr][ch] = (double)noise.tot_noise * 10.0;
        gfc.pinfo.over_SSD[gr][ch] = noise.over_SSD;
    }

    public final void set_frame_pinfo(LameGlobalFlags gfp, III_psy_ratio[][] ratio) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.masking_lower = 1.0f;
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                GrInfo cod_info = gfc.l3_side.tt[gr][ch];
                int[] scalefac_sav = new int[39];
                System.arraycopy(cod_info.scalefac, 0, scalefac_sav, 0, scalefac_sav.length);
                if (gr == 1) {
                    for (int sfb = 0; sfb < cod_info.sfb_lmax; ++sfb) {
                        if (cod_info.scalefac[sfb] >= 0) continue;
                        cod_info.scalefac[sfb] = gfc.l3_side.tt[0][ch].scalefac[sfb];
                    }
                }
                this.set_pinfo(gfp, cod_info, ratio[gr][ch], gr, ch);
                System.arraycopy(scalefac_sav, 0, cod_info.scalefac, 0, scalefac_sav.length);
            }
        }
    }

    private static class StartLine {
        int s;

        public StartLine(int j) {
            this.s = j;
        }
    }
}

