/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.ATH;
import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.CalcNoiseData;
import de.sciss.jump3r.mp3.CalcNoiseResult;
import de.sciss.jump3r.mp3.GrInfo;
import de.sciss.jump3r.mp3.IIISideInfo;
import de.sciss.jump3r.mp3.III_psy_ratio;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.LameInternalFlags;
import de.sciss.jump3r.mp3.MeanBits;
import de.sciss.jump3r.mp3.QuantizePVT;
import de.sciss.jump3r.mp3.Reservoir;
import de.sciss.jump3r.mp3.Takehiro;
import de.sciss.jump3r.mp3.Util;
import de.sciss.jump3r.mp3.VBRQuantize;
import de.sciss.jump3r.mp3.VbrMode;
import java.util.Arrays;

public class Quantize {
    BitStream bs;
    Reservoir rv;
    QuantizePVT qupvt;
    VBRQuantize vbr = new VBRQuantize();
    Takehiro tk;

    public final void setModules(BitStream bs, Reservoir rv, QuantizePVT qupvt, Takehiro tk) {
        this.bs = bs;
        this.rv = rv;
        this.qupvt = qupvt;
        this.tk = tk;
        this.vbr.setModules(qupvt, tk);
    }

    public final void ms_convert(IIISideInfo l3_side, int gr) {
        for (int i = 0; i < 576; ++i) {
            float l = l3_side.tt[gr][0].xr[i];
            float r = l3_side.tt[gr][1].xr[i];
            l3_side.tt[gr][0].xr[i] = (l + r) * 0.70710677f;
            l3_side.tt[gr][1].xr[i] = (l - r) * 0.70710677f;
        }
    }

    private float init_xrpow_core(GrInfo cod_info, float[] xrpow, int upper, float sum) {
        sum = 0.0f;
        for (int i = 0; i <= upper; ++i) {
            float tmp = Math.abs(cod_info.xr[i]);
            sum += tmp;
            xrpow[i] = (float)Math.sqrt((double)tmp * Math.sqrt(tmp));
            if (!(xrpow[i] > cod_info.xrpow_max)) continue;
            cod_info.xrpow_max = xrpow[i];
        }
        return sum;
    }

    public final boolean init_xrpow(LameInternalFlags gfc, GrInfo cod_info, float[] xrpow) {
        float sum = 0.0f;
        int upper = cod_info.max_nonzero_coeff;
        assert (xrpow != null);
        cod_info.xrpow_max = 0.0f;
        assert (0 <= upper && upper <= 575);
        Arrays.fill(xrpow, upper, 576, 0.0f);
        sum = this.init_xrpow_core(cod_info, xrpow, upper, sum);
        if (sum > 1.0E-20f) {
            int j = 0;
            if ((gfc.substep_shaping & 2) != 0) {
                j = 1;
            }
            for (int i = 0; i < cod_info.psymax; ++i) {
                gfc.pseudohalf[i] = j;
            }
            return true;
        }
        Arrays.fill(cod_info.l3_enc, 0, 576, 0);
        return false;
    }

    private void psfb21_analogsilence(LameInternalFlags gfc, GrInfo cod_info) {
        ATH ath = gfc.ATH;
        float[] xr = cod_info.xr;
        if (cod_info.block_type != 2) {
            boolean stop = false;
            block0: for (int gsfb = 5; gsfb >= 0 && !stop; --gsfb) {
                int start = gfc.scalefac_band.psfb21[gsfb];
                int end = gfc.scalefac_band.psfb21[gsfb + 1];
                float ath21 = this.qupvt.athAdjust(ath.adjust, ath.psfb21[gsfb], ath.floor);
                if (gfc.nsPsy.longfact[21] > 1.0E-12f) {
                    ath21 *= gfc.nsPsy.longfact[21];
                }
                for (int j = end - 1; j >= start; --j) {
                    if (!(Math.abs(xr[j]) < ath21)) {
                        stop = true;
                        continue block0;
                    }
                    xr[j] = 0.0f;
                }
            }
        } else {
            for (int block = 0; block < 3; ++block) {
                boolean stop = false;
                block3: for (int gsfb = 5; gsfb >= 0 && !stop; --gsfb) {
                    int start = gfc.scalefac_band.s[12] * 3 + (gfc.scalefac_band.s[13] - gfc.scalefac_band.s[12]) * block + (gfc.scalefac_band.psfb12[gsfb] - gfc.scalefac_band.psfb12[0]);
                    int end = start + (gfc.scalefac_band.psfb12[gsfb + 1] - gfc.scalefac_band.psfb12[gsfb]);
                    float ath12 = this.qupvt.athAdjust(ath.adjust, ath.psfb12[gsfb], ath.floor);
                    if (gfc.nsPsy.shortfact[12] > 1.0E-12f) {
                        ath12 *= gfc.nsPsy.shortfact[12];
                    }
                    for (int j = end - 1; j >= start; --j) {
                        if (!(Math.abs(xr[j]) < ath12)) {
                            stop = true;
                            continue block3;
                        }
                        xr[j] = 0.0f;
                    }
                }
            }
        }
    }

    public final void init_outer_loop(LameInternalFlags gfc, GrInfo cod_info) {
        cod_info.part2_3_length = 0;
        cod_info.big_values = 0;
        cod_info.count1 = 0;
        cod_info.global_gain = 210;
        cod_info.scalefac_compress = 0;
        cod_info.table_select[0] = 0;
        cod_info.table_select[1] = 0;
        cod_info.table_select[2] = 0;
        cod_info.subblock_gain[0] = 0;
        cod_info.subblock_gain[1] = 0;
        cod_info.subblock_gain[2] = 0;
        cod_info.subblock_gain[3] = 0;
        cod_info.region0_count = 0;
        cod_info.region1_count = 0;
        cod_info.preflag = 0;
        cod_info.scalefac_scale = 0;
        cod_info.count1table_select = 0;
        cod_info.part2_length = 0;
        cod_info.sfb_lmax = 21;
        cod_info.sfb_smin = 12;
        cod_info.psymax = cod_info.psy_lmax = gfc.sfb21_extra ? 22 : 21;
        cod_info.sfbmax = cod_info.sfb_lmax;
        cod_info.sfbdivide = 11;
        for (int sfb = 0; sfb < 22; ++sfb) {
            cod_info.width[sfb] = gfc.scalefac_band.l[sfb + 1] - gfc.scalefac_band.l[sfb];
            cod_info.window[sfb] = 3;
        }
        if (cod_info.block_type == 2) {
            float[] ixwork = new float[576];
            cod_info.sfb_smin = 0;
            cod_info.sfb_lmax = 0;
            if (cod_info.mixed_block_flag != 0) {
                cod_info.sfb_smin = 3;
                cod_info.sfb_lmax = gfc.mode_gr * 2 + 4;
            }
            cod_info.psymax = cod_info.sfb_lmax + 3 * ((gfc.sfb21_extra ? 13 : 12) - cod_info.sfb_smin);
            cod_info.sfbmax = cod_info.sfb_lmax + 3 * (12 - cod_info.sfb_smin);
            cod_info.sfbdivide = cod_info.sfbmax - 18;
            cod_info.psy_lmax = cod_info.sfb_lmax;
            int ix = gfc.scalefac_band.l[cod_info.sfb_lmax];
            System.arraycopy(cod_info.xr, 0, ixwork, 0, 576);
            for (int sfb = cod_info.sfb_smin; sfb < 13; ++sfb) {
                int start = gfc.scalefac_band.s[sfb];
                int end = gfc.scalefac_band.s[sfb + 1];
                for (int window = 0; window < 3; ++window) {
                    for (int l = start; l < end; ++l) {
                        cod_info.xr[ix++] = ixwork[3 * l + window];
                    }
                }
            }
            int j = cod_info.sfb_lmax;
            for (int sfb = cod_info.sfb_smin; sfb < 13; ++sfb) {
                int n = gfc.scalefac_band.s[sfb + 1] - gfc.scalefac_band.s[sfb];
                cod_info.width[j + 2] = n;
                cod_info.width[j + 1] = n;
                cod_info.width[j] = n;
                cod_info.window[j] = 0;
                cod_info.window[j + 1] = 1;
                cod_info.window[j + 2] = 2;
                j += 3;
            }
        }
        cod_info.count1bits = 0;
        cod_info.sfb_partition_table = this.qupvt.nr_of_sfb_block[0][0];
        cod_info.slen[0] = 0;
        cod_info.slen[1] = 0;
        cod_info.slen[2] = 0;
        cod_info.slen[3] = 0;
        cod_info.max_nonzero_coeff = 575;
        Arrays.fill(cod_info.scalefac, 0);
        this.psfb21_analogsilence(gfc, cod_info);
    }

    private int bin_search_StepSize(LameInternalFlags gfc, GrInfo cod_info, int desired_rate, int ch, float[] xrpow) {
        int nBits;
        int CurrentStep = gfc.CurrentStep[ch];
        boolean flagGoneOver = false;
        int start = gfc.OldValue[ch];
        BinSearchDirection Direction = BinSearchDirection.BINSEARCH_NONE;
        cod_info.global_gain = start;
        desired_rate -= cod_info.part2_length;
        assert (CurrentStep != 0);
        while (true) {
            int step;
            nBits = this.tk.count_bits(gfc, xrpow, cod_info, null);
            if (CurrentStep == 1 || nBits == desired_rate) break;
            if (nBits > desired_rate) {
                if (Direction == BinSearchDirection.BINSEARCH_DOWN) {
                    flagGoneOver = true;
                }
                if (flagGoneOver) {
                    CurrentStep /= 2;
                }
                Direction = BinSearchDirection.BINSEARCH_UP;
                step = CurrentStep;
            } else {
                if (Direction == BinSearchDirection.BINSEARCH_UP) {
                    flagGoneOver = true;
                }
                if (flagGoneOver) {
                    CurrentStep /= 2;
                }
                Direction = BinSearchDirection.BINSEARCH_DOWN;
                step = -CurrentStep;
            }
            cod_info.global_gain += step;
            if (cod_info.global_gain < 0) {
                cod_info.global_gain = 0;
                flagGoneOver = true;
            }
            if (cod_info.global_gain <= 255) continue;
            cod_info.global_gain = 255;
            flagGoneOver = true;
        }
        assert (cod_info.global_gain >= 0);
        assert (cod_info.global_gain < 256);
        while (nBits > desired_rate && cod_info.global_gain < 255) {
            ++cod_info.global_gain;
            nBits = this.tk.count_bits(gfc, xrpow, cod_info, null);
        }
        gfc.CurrentStep[ch] = start - cod_info.global_gain >= 4 ? 4 : 2;
        gfc.OldValue[ch] = cod_info.global_gain;
        cod_info.part2_3_length = nBits;
        return nBits;
    }

    public final void trancate_smallspectrums(LameInternalFlags gfc, GrInfo gi, float[] l3_xmin, float[] work) {
        int j;
        float[] distort = new float[39];
        if (0 == (gfc.substep_shaping & 4) && gi.block_type == 2 || (gfc.substep_shaping & 0x80) != 0) {
            return;
        }
        this.qupvt.calc_noise(gi, l3_xmin, distort, new CalcNoiseResult(), null);
        for (j = 0; j < 576; ++j) {
            float xr = 0.0f;
            if (gi.l3_enc[j] != 0) {
                xr = Math.abs(gi.xr[j]);
            }
            work[j] = xr;
        }
        j = 0;
        int sfb = 8;
        if (gi.block_type == 2) {
            sfb = 6;
        }
        do {
            int nsame;
            int width = gi.width[sfb];
            j += width;
            if ((double)distort[sfb] >= 1.0) continue;
            Arrays.sort(work, j - width, width);
            if (BitStream.EQ(work[j - 1], 0.0f)) continue;
            float allowedNoise = (1.0f - distort[sfb]) * l3_xmin[sfb];
            float trancateThreshold = 0.0f;
            int start = 0;
            do {
                nsame = 1;
                while (start + nsame < width && !BitStream.NEQ(work[start + j - width], work[start + j + nsame - width])) {
                    ++nsame;
                }
                float noise = work[start + j - width] * work[start + j - width] * (float)nsame;
                if (allowedNoise < noise) {
                    if (start == 0) break;
                    trancateThreshold = work[start + j - width - 1];
                    break;
                }
                allowedNoise -= noise;
            } while ((start += nsame) < width);
            if (BitStream.EQ(trancateThreshold, 0.0f)) continue;
            do {
                if (!(Math.abs(gi.xr[j - width]) <= trancateThreshold)) continue;
                gi.l3_enc[j - width] = 0;
            } while (--width > 0);
        } while (++sfb < gi.psymax);
        gi.part2_3_length = this.tk.noquant_count_bits(gfc, gi, null);
    }

    private boolean loop_break(GrInfo cod_info) {
        for (int sfb = 0; sfb < cod_info.sfbmax; ++sfb) {
            if (cod_info.scalefac[sfb] + cod_info.subblock_gain[cod_info.window[sfb]] != 0) continue;
            return false;
        }
        return true;
    }

    private double penalties(double noise) {
        return Util.FAST_LOG10((float)(0.368 + 0.632 * noise * noise * noise));
    }

    private double get_klemm_noise(float[] distort, GrInfo gi) {
        double klemm_noise = 1.0E-37;
        for (int sfb = 0; sfb < gi.psymax; ++sfb) {
            klemm_noise += this.penalties(distort[sfb]);
        }
        return Math.max(1.0E-20, klemm_noise);
    }

    private boolean quant_compare(int quant_comp, CalcNoiseResult best, CalcNoiseResult calc, GrInfo gi, float[] distort) {
        boolean better;
        switch (quant_comp) {
            default: {
                if (best.over_count > 0) {
                    boolean bl = better = calc.over_SSD <= best.over_SSD;
                    if (calc.over_SSD != best.over_SSD) break;
                    better = calc.bits < best.bits;
                    break;
                }
                better = calc.max_noise < 0.0f && calc.max_noise * 10.0f + (float)calc.bits <= best.max_noise * 10.0f + (float)best.bits;
                break;
            }
            case 0: {
                better = calc.over_count < best.over_count || calc.over_count == best.over_count && calc.over_noise < best.over_noise || calc.over_count == best.over_count && BitStream.EQ(calc.over_noise, best.over_noise) && calc.tot_noise < best.tot_noise;
                break;
            }
            case 8: {
                calc.max_noise = (float)this.get_klemm_noise(distort, gi);
            }
            case 1: {
                better = calc.max_noise < best.max_noise;
                break;
            }
            case 2: {
                better = calc.tot_noise < best.tot_noise;
                break;
            }
            case 3: {
                better = calc.tot_noise < best.tot_noise && calc.max_noise < best.max_noise;
                break;
            }
            case 4: {
                better = (double)calc.max_noise <= 0.0 && (double)best.max_noise > 0.2 || (double)calc.max_noise <= 0.0 && (double)best.max_noise < 0.0 && (double)best.max_noise > (double)calc.max_noise - 0.2 && calc.tot_noise < best.tot_noise || (double)calc.max_noise <= 0.0 && (double)best.max_noise > 0.0 && (double)best.max_noise > (double)calc.max_noise - 0.2 && calc.tot_noise < best.tot_noise + best.over_noise || (double)calc.max_noise > 0.0 && (double)best.max_noise > -0.05 && (double)best.max_noise > (double)calc.max_noise - 0.1 && calc.tot_noise + calc.over_noise < best.tot_noise + best.over_noise || (double)calc.max_noise > 0.0 && (double)best.max_noise > -0.1 && (double)best.max_noise > (double)calc.max_noise - 0.15 && calc.tot_noise + calc.over_noise + calc.over_noise < best.tot_noise + best.over_noise + best.over_noise;
                break;
            }
            case 5: {
                better = calc.over_noise < best.over_noise || BitStream.EQ(calc.over_noise, best.over_noise) && calc.tot_noise < best.tot_noise;
                break;
            }
            case 6: {
                better = calc.over_noise < best.over_noise || BitStream.EQ(calc.over_noise, best.over_noise) && (calc.max_noise < best.max_noise || BitStream.EQ(calc.max_noise, best.max_noise) && calc.tot_noise <= best.tot_noise);
                break;
            }
            case 7: {
                boolean bl = better = calc.over_count < best.over_count || calc.over_noise < best.over_noise;
            }
        }
        if (best.over_count == 0) {
            better = better && calc.bits < best.bits;
        }
        return better;
    }

    private void amp_scalefac_bands(LameGlobalFlags gfp, GrInfo cod_info, float[] distort, float[] xrpow, boolean bRefine) {
        LameInternalFlags gfc = gfp.internal_flags;
        float ifqstep34 = cod_info.scalefac_scale == 0 ? 1.2968396f : 1.6817929f;
        float trigger = 0.0f;
        for (int sfb = 0; sfb < cod_info.sfbmax; ++sfb) {
            if (!(trigger < distort[sfb])) continue;
            trigger = distort[sfb];
        }
        int noise_shaping_amp = gfc.noise_shaping_amp;
        if (noise_shaping_amp == 3) {
            noise_shaping_amp = bRefine ? 2 : 1;
        }
        switch (noise_shaping_amp) {
            case 2: {
                break;
            }
            case 1: {
                if ((double)trigger > 1.0) {
                    trigger = (float)Math.pow(trigger, 0.5);
                    break;
                }
                trigger = (float)((double)trigger * 0.95);
                break;
            }
            default: {
                trigger = (double)trigger > 1.0 ? 1.0f : (float)((double)trigger * 0.95);
            }
        }
        int j = 0;
        for (int sfb = 0; sfb < cod_info.sfbmax; ++sfb) {
            int width = cod_info.width[sfb];
            j += width;
            if (distort[sfb] < trigger) continue;
            if ((gfc.substep_shaping & 2) != 0) {
                int n = gfc.pseudohalf[sfb] = 0 == gfc.pseudohalf[sfb] ? 1 : 0;
                if (0 == gfc.pseudohalf[sfb] && gfc.noise_shaping_amp == 2) {
                    return;
                }
            }
            int n = sfb;
            cod_info.scalefac[n] = cod_info.scalefac[n] + 1;
            for (int l = -width; l < 0; ++l) {
                int n2 = j + l;
                xrpow[n2] = xrpow[n2] * ifqstep34;
                if (!(xrpow[j + l] > cod_info.xrpow_max)) continue;
                cod_info.xrpow_max = xrpow[j + l];
            }
            if (gfc.noise_shaping_amp != 2) continue;
            return;
        }
    }

    private void inc_scalefac_scale(GrInfo cod_info, float[] xrpow) {
        float ifqstep34 = 1.2968396f;
        int j = 0;
        for (int sfb = 0; sfb < cod_info.sfbmax; ++sfb) {
            int width = cod_info.width[sfb];
            int s = cod_info.scalefac[sfb];
            if (cod_info.preflag != 0) {
                s += this.qupvt.pretab[sfb];
            }
            j += width;
            if ((s & 1) != 0) {
                ++s;
                for (int l = -width; l < 0; ++l) {
                    int n = j + l;
                    xrpow[n] = xrpow[n] * 1.2968396f;
                    if (!(xrpow[j + l] > cod_info.xrpow_max)) continue;
                    cod_info.xrpow_max = xrpow[j + l];
                }
            }
            cod_info.scalefac[sfb] = s >> 1;
        }
        cod_info.preflag = 0;
        cod_info.scalefac_scale = 1;
    }

    private boolean inc_subblock_gain(LameInternalFlags gfc, GrInfo cod_info, float[] xrpow) {
        int sfb;
        int[] scalefac = cod_info.scalefac;
        for (sfb = 0; sfb < cod_info.sfb_lmax; ++sfb) {
            if (scalefac[sfb] < 16) continue;
            return true;
        }
        for (int window = 0; window < 3; ++window) {
            float amp;
            int s1 = 0;
            int s2 = 0;
            for (sfb = cod_info.sfb_lmax + window; sfb < cod_info.sfbdivide; sfb += 3) {
                if (s1 >= scalefac[sfb]) continue;
                s1 = scalefac[sfb];
            }
            while (sfb < cod_info.sfbmax) {
                if (s2 < scalefac[sfb]) {
                    s2 = scalefac[sfb];
                }
                sfb += 3;
            }
            if (s1 < 16 && s2 < 8) continue;
            if (cod_info.subblock_gain[window] >= 7) {
                return true;
            }
            int n = window;
            cod_info.subblock_gain[n] = cod_info.subblock_gain[n] + 1;
            int j = gfc.scalefac_band.l[cod_info.sfb_lmax];
            for (sfb = cod_info.sfb_lmax + window; sfb < cod_info.sfbmax; sfb += 3) {
                int width = cod_info.width[sfb];
                int s = scalefac[sfb];
                assert (s >= 0);
                if ((s -= 4 >> cod_info.scalefac_scale) >= 0) {
                    scalefac[sfb] = s;
                    j += width * 3;
                    continue;
                }
                scalefac[sfb] = 0;
                int gain = 210 + (s << cod_info.scalefac_scale + 1);
                amp = this.qupvt.IPOW20(gain);
                j += width * (window + 1);
                for (int l = -width; l < 0; ++l) {
                    int n2 = j + l;
                    xrpow[n2] = xrpow[n2] * amp;
                    if (!(xrpow[j + l] > cod_info.xrpow_max)) continue;
                    cod_info.xrpow_max = xrpow[j + l];
                }
                j += width * (3 - window - 1);
            }
            amp = this.qupvt.IPOW20(202);
            j += cod_info.width[sfb] * (window + 1);
            for (int l = -cod_info.width[sfb]; l < 0; ++l) {
                int n3 = j + l;
                xrpow[n3] = xrpow[n3] * amp;
                if (!(xrpow[j + l] > cod_info.xrpow_max)) continue;
                cod_info.xrpow_max = xrpow[j + l];
            }
        }
        return false;
    }

    private boolean balance_noise(LameGlobalFlags gfp, GrInfo cod_info, float[] distort, float[] xrpow, boolean bRefine) {
        LameInternalFlags gfc = gfp.internal_flags;
        this.amp_scalefac_bands(gfp, cod_info, distort, xrpow, bRefine);
        boolean status = this.loop_break(cod_info);
        if (status) {
            return false;
        }
        status = gfc.mode_gr == 2 ? this.tk.scale_bitcount(cod_info) : this.tk.scale_bitcount_lsf(gfc, cod_info);
        if (!status) {
            return true;
        }
        if (gfc.noise_shaping > 1) {
            Arrays.fill(gfc.pseudohalf, 0);
            if (0 == cod_info.scalefac_scale) {
                this.inc_scalefac_scale(cod_info, xrpow);
                status = false;
            } else if (cod_info.block_type == 2 && gfc.subblock_gain > 0) {
                boolean bl = status = this.inc_subblock_gain(gfc, cod_info, xrpow) || this.loop_break(cod_info);
            }
        }
        if (!status) {
            status = gfc.mode_gr == 2 ? this.tk.scale_bitcount(cod_info) : this.tk.scale_bitcount_lsf(gfc, cod_info);
        }
        return !status;
    }

    public final int outer_loop(LameGlobalFlags gfp, GrInfo cod_info, float[] l3_xmin, float[] xrpow, int ch, int targ_bits) {
        LameInternalFlags gfc = gfp.internal_flags;
        GrInfo cod_info_w = new GrInfo();
        float[] save_xrpow = new float[576];
        float[] distort = new float[39];
        CalcNoiseResult best_noise_info = new CalcNoiseResult();
        CalcNoiseData prev_noise = new CalcNoiseData();
        int best_part2_3_length = 9999999;
        boolean bEndOfSearch = false;
        boolean bRefine = false;
        int best_ggain_pass1 = 0;
        this.bin_search_StepSize(gfc, cod_info, targ_bits, ch, xrpow);
        if (0 == gfc.noise_shaping) {
            return 100;
        }
        this.qupvt.calc_noise(cod_info, l3_xmin, distort, best_noise_info, prev_noise);
        best_noise_info.bits = cod_info.part2_3_length;
        cod_info_w.assign(cod_info);
        int age = 0;
        System.arraycopy(xrpow, 0, save_xrpow, 0, 576);
        while (!bEndOfSearch) {
            do {
                int huff_bits;
                CalcNoiseResult noise_info = new CalcNoiseResult();
                int maxggain = 255;
                int search_limit = (gfc.substep_shaping & 2) != 0 ? 20 : 3;
                if (gfc.sfb21_extra && ((double)distort[cod_info_w.sfbmax] > 1.0 || cod_info_w.block_type == 2 && ((double)distort[cod_info_w.sfbmax + 1] > 1.0 || (double)distort[cod_info_w.sfbmax + 2] > 1.0)) || !this.balance_noise(gfp, cod_info_w, distort, xrpow, bRefine)) break;
                if (cod_info_w.scalefac_scale != 0) {
                    maxggain = 254;
                }
                if ((huff_bits = targ_bits - cod_info_w.part2_length) <= 0) break;
                while ((cod_info_w.part2_3_length = this.tk.count_bits(gfc, xrpow, cod_info_w, prev_noise)) > huff_bits && cod_info_w.global_gain <= maxggain) {
                    ++cod_info_w.global_gain;
                }
                if (cod_info_w.global_gain > maxggain) break;
                if (best_noise_info.over_count == 0) {
                    while ((cod_info_w.part2_3_length = this.tk.count_bits(gfc, xrpow, cod_info_w, prev_noise)) > best_part2_3_length && cod_info_w.global_gain <= maxggain) {
                        ++cod_info_w.global_gain;
                    }
                    if (cod_info_w.global_gain > maxggain) break;
                }
                this.qupvt.calc_noise(cod_info_w, l3_xmin, distort, noise_info, prev_noise);
                noise_info.bits = cod_info_w.part2_3_length;
                int better = cod_info.block_type != 2 ? gfp.quant_comp : gfp.quant_comp_short;
                int n = better = this.quant_compare(better, best_noise_info, noise_info, cod_info_w, distort) ? 1 : 0;
                if (better != 0) {
                    best_part2_3_length = cod_info.part2_3_length;
                    best_noise_info = noise_info;
                    cod_info.assign(cod_info_w);
                    age = 0;
                    System.arraycopy(xrpow, 0, save_xrpow, 0, 576);
                    continue;
                }
                if (gfc.full_outer_loop == 0 && (++age > search_limit && best_noise_info.over_count == 0 || gfc.noise_shaping_amp == 3 && bRefine && age > 30 || gfc.noise_shaping_amp == 3 && bRefine && cod_info_w.global_gain - best_ggain_pass1 > 15)) break;
            } while (cod_info_w.global_gain + cod_info_w.scalefac_scale < 255);
            if (gfc.noise_shaping_amp == 3) {
                if (!bRefine) {
                    cod_info_w.assign(cod_info);
                    System.arraycopy(save_xrpow, 0, xrpow, 0, 576);
                    age = 0;
                    best_ggain_pass1 = cod_info_w.global_gain;
                    bRefine = true;
                    continue;
                }
                bEndOfSearch = true;
                continue;
            }
            bEndOfSearch = true;
        }
        assert (cod_info.global_gain + cod_info.scalefac_scale <= 255);
        if (gfp.VBR == VbrMode.vbr_rh || gfp.VBR == VbrMode.vbr_mtrh) {
            System.arraycopy(save_xrpow, 0, xrpow, 0, 576);
        } else if ((gfc.substep_shaping & 1) != 0) {
            this.trancate_smallspectrums(gfc, cod_info, l3_xmin, xrpow);
        }
        return best_noise_info.over_count;
    }

    public final void iteration_finish_one(LameInternalFlags gfc, int gr, int ch) {
        IIISideInfo l3_side = gfc.l3_side;
        GrInfo cod_info = l3_side.tt[gr][ch];
        this.tk.best_scalefac_store(gfc, gr, ch, l3_side);
        if (gfc.use_best_huffman == 1) {
            this.tk.best_huffman_divide(gfc, cod_info);
        }
        this.rv.ResvAdjust(gfc, cod_info);
    }

    public final void VBR_encode_granule(LameGlobalFlags gfp, GrInfo cod_info, float[] l3_xmin, float[] xrpow, int ch, int min_bits, int max_bits) {
        int dbits;
        LameInternalFlags gfc = gfp.internal_flags;
        GrInfo bst_cod_info = new GrInfo();
        float[] bst_xrpow = new float[576];
        int Max_bits = max_bits;
        int real_bits = max_bits + 1;
        int this_bits = (max_bits + min_bits) / 2;
        int found = 0;
        boolean sfb21_extra = gfc.sfb21_extra;
        assert (Max_bits <= 4095);
        Arrays.fill(bst_cod_info.l3_enc, 0);
        do {
            assert (this_bits >= min_bits);
            assert (this_bits <= max_bits);
            assert (min_bits <= max_bits);
            gfc.sfb21_extra = this_bits > Max_bits - 42 ? false : sfb21_extra;
            int over = this.outer_loop(gfp, cod_info, l3_xmin, xrpow, ch, this_bits);
            if (over <= 0) {
                found = 1;
                real_bits = cod_info.part2_3_length;
                bst_cod_info.assign(cod_info);
                System.arraycopy(xrpow, 0, bst_xrpow, 0, 576);
                max_bits = real_bits - 32;
                dbits = max_bits - min_bits;
                this_bits = (max_bits + min_bits) / 2;
                continue;
            }
            min_bits = this_bits + 32;
            dbits = max_bits - min_bits;
            this_bits = (max_bits + min_bits) / 2;
            if (found == 0) continue;
            found = 2;
            cod_info.assign(bst_cod_info);
            System.arraycopy(bst_xrpow, 0, xrpow, 0, 576);
        } while (dbits > 12);
        gfc.sfb21_extra = sfb21_extra;
        if (found == 2) {
            System.arraycopy(bst_cod_info.l3_enc, 0, cod_info.l3_enc, 0, 576);
        }
        assert (cod_info.part2_3_length <= Max_bits);
    }

    public final void get_framebits(LameGlobalFlags gfp, int[] frameBits) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.bitrate_index = gfc.VBR_min_bitrate;
        int bitsPerFrame = this.bs.getframebits(gfp);
        gfc.bitrate_index = 1;
        bitsPerFrame = this.bs.getframebits(gfp);
        for (int i = 1; i <= gfc.VBR_max_bitrate; ++i) {
            gfc.bitrate_index = i;
            MeanBits mb = new MeanBits(bitsPerFrame);
            frameBits[i] = this.rv.ResvFrameBegin(gfp, mb);
            bitsPerFrame = mb.bits;
        }
    }

    public final int VBR_old_prepare(LameGlobalFlags gfp, float[][] pe, float[] ms_ener_ratio, III_psy_ratio[][] ratio, float[][][] l3_xmin, int[] frameBits, int[][] min_bits, int[][] max_bits, int[][] bands) {
        int gr;
        LameInternalFlags gfc = gfp.internal_flags;
        float adjust = 0.0f;
        int analog_silence = 1;
        int bits = 0;
        gfc.bitrate_index = gfc.VBR_max_bitrate;
        int avg = this.rv.ResvFrameBegin(gfp, new MeanBits(0)) / gfc.mode_gr;
        this.get_framebits(gfp, frameBits);
        for (gr = 0; gr < gfc.mode_gr; ++gr) {
            int mxb = this.qupvt.on_pe(gfp, pe, max_bits[gr], avg, gr, 0);
            if (gfc.mode_ext == 2) {
                this.ms_convert(gfc.l3_side, gr);
                this.qupvt.reduce_side(max_bits[gr], ms_ener_ratio[gr], avg, mxb);
            }
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                float masking_lower_db;
                GrInfo cod_info = gfc.l3_side.tt[gr][ch];
                if (cod_info.block_type != 2) {
                    adjust = 1.28f / (1.0f + (float)Math.exp(3.5 - (double)pe[gr][ch] / 300.0)) - 0.05f;
                    masking_lower_db = gfc.PSY.mask_adjust - adjust;
                } else {
                    adjust = 2.56f / (1.0f + (float)Math.exp(3.5 - (double)pe[gr][ch] / 300.0)) - 0.14f;
                    masking_lower_db = gfc.PSY.mask_adjust_short - adjust;
                }
                gfc.masking_lower = (float)Math.pow(10.0, (double)masking_lower_db * 0.1);
                this.init_outer_loop(gfc, cod_info);
                bands[gr][ch] = this.qupvt.calc_xmin(gfp, ratio[gr][ch], cod_info, l3_xmin[gr][ch]);
                if (bands[gr][ch] != 0) {
                    analog_silence = 0;
                }
                min_bits[gr][ch] = 126;
                bits += max_bits[gr][ch];
            }
        }
        for (gr = 0; gr < gfc.mode_gr; ++gr) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                if (bits > frameBits[gfc.VBR_max_bitrate]) {
                    int[] nArray = max_bits[gr];
                    int n = ch;
                    nArray[n] = nArray[n] * frameBits[gfc.VBR_max_bitrate];
                    int[] nArray2 = max_bits[gr];
                    int n2 = ch;
                    nArray2[n2] = nArray2[n2] / bits;
                }
                if (min_bits[gr][ch] <= max_bits[gr][ch]) continue;
                min_bits[gr][ch] = max_bits[gr][ch];
            }
        }
        return analog_silence;
    }

    public final void bitpressure_strategy(LameInternalFlags gfc, float[][][] l3_xmin, int[][] min_bits, int[][] max_bits) {
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                int sfb;
                GrInfo gi = gfc.l3_side.tt[gr][ch];
                float[] pxmin = l3_xmin[gr][ch];
                int pxminPos = 0;
                for (sfb = 0; sfb < gi.psy_lmax; ++sfb) {
                    int n = pxminPos++;
                    pxmin[n] = (float)((double)pxmin[n] * (1.0 + 0.029 * (double)sfb * (double)sfb / 22.0 / 22.0));
                }
                if (gi.block_type == 2) {
                    for (sfb = gi.sfb_smin; sfb < 13; ++sfb) {
                        int n = pxminPos++;
                        pxmin[n] = (float)((double)pxmin[n] * (1.0 + 0.029 * (double)sfb * (double)sfb / 13.0 / 13.0));
                        int n2 = pxminPos++;
                        pxmin[n2] = (float)((double)pxmin[n2] * (1.0 + 0.029 * (double)sfb * (double)sfb / 13.0 / 13.0));
                        int n3 = pxminPos++;
                        pxmin[n3] = (float)((double)pxmin[n3] * (1.0 + 0.029 * (double)sfb * (double)sfb / 13.0 / 13.0));
                    }
                }
                max_bits[gr][ch] = (int)Math.max((double)min_bits[gr][ch], 0.9 * (double)max_bits[gr][ch]);
            }
        }
    }

    public final int VBR_new_prepare(LameGlobalFlags gfp, float[][] pe, III_psy_ratio[][] ratio, float[][][] l3_xmin, int[] frameBits, int[][] max_bits) {
        int ch;
        int gr;
        int maximum_framebits;
        MeanBits mb;
        LameInternalFlags gfc = gfp.internal_flags;
        int analog_silence = 1;
        int avg = 0;
        int bits = 0;
        if (!gfp.free_format) {
            gfc.bitrate_index = gfc.VBR_max_bitrate;
            mb = new MeanBits(avg);
            this.rv.ResvFrameBegin(gfp, mb);
            avg = mb.bits;
            this.get_framebits(gfp, frameBits);
            maximum_framebits = frameBits[gfc.VBR_max_bitrate];
        } else {
            gfc.bitrate_index = 0;
            mb = new MeanBits(avg);
            maximum_framebits = this.rv.ResvFrameBegin(gfp, mb);
            avg = mb.bits;
            frameBits[0] = maximum_framebits;
        }
        for (gr = 0; gr < gfc.mode_gr; ++gr) {
            this.qupvt.on_pe(gfp, pe, max_bits[gr], avg, gr, 0);
            if (gfc.mode_ext == 2) {
                this.ms_convert(gfc.l3_side, gr);
            }
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                GrInfo cod_info = gfc.l3_side.tt[gr][ch];
                gfc.masking_lower = (float)Math.pow(10.0, (double)gfc.PSY.mask_adjust * 0.1);
                this.init_outer_loop(gfc, cod_info);
                if (0 != this.qupvt.calc_xmin(gfp, ratio[gr][ch], cod_info, l3_xmin[gr][ch])) {
                    analog_silence = 0;
                }
                bits += max_bits[gr][ch];
            }
        }
        for (gr = 0; gr < gfc.mode_gr; ++gr) {
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                if (bits <= maximum_framebits) continue;
                int[] nArray = max_bits[gr];
                int n = ch;
                nArray[n] = nArray[n] * maximum_framebits;
                int[] nArray2 = max_bits[gr];
                int n2 = ch;
                nArray2[n2] = nArray2[n2] / bits;
            }
        }
        return analog_silence;
    }

    public final void calc_target_bits(LameGlobalFlags gfp, float[][] pe, float[] ms_ener_ratio, int[][] targ_bits, int[] analog_silence_bits, int[] max_frame_bits) {
        int ch;
        int gr;
        LameInternalFlags gfc = gfp.internal_flags;
        IIISideInfo l3_side = gfc.l3_side;
        int mean_bits = 0;
        gfc.bitrate_index = gfc.VBR_max_bitrate;
        MeanBits mb = new MeanBits(mean_bits);
        max_frame_bits[0] = this.rv.ResvFrameBegin(gfp, mb);
        mean_bits = mb.bits;
        gfc.bitrate_index = 1;
        mean_bits = this.bs.getframebits(gfp) - gfc.sideinfo_len * 8;
        analog_silence_bits[0] = mean_bits / (gfc.mode_gr * gfc.channels_out);
        mean_bits = gfp.VBR_mean_bitrate_kbps * gfp.framesize * 1000;
        if ((gfc.substep_shaping & 1) != 0) {
            mean_bits = (int)((double)mean_bits * 1.09);
        }
        mean_bits /= gfp.out_samplerate;
        mean_bits -= gfc.sideinfo_len * 8;
        mean_bits /= gfc.mode_gr * gfc.channels_out;
        float res_factor = 0.93f + 0.07f * (11.0f - gfp.compression_ratio) / 5.5f;
        if ((double)res_factor < 0.9) {
            res_factor = 0.9f;
        }
        if ((double)res_factor > 1.0) {
            res_factor = 1.0f;
        }
        for (gr = 0; gr < gfc.mode_gr; ++gr) {
            int sum = 0;
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                targ_bits[gr][ch] = (int)(res_factor * (float)mean_bits);
                if (pe[gr][ch] > 700.0f) {
                    int add_bits = (int)((double)(pe[gr][ch] - 700.0f) / 1.4);
                    GrInfo cod_info = l3_side.tt[gr][ch];
                    targ_bits[gr][ch] = (int)(res_factor * (float)mean_bits);
                    if (cod_info.block_type == 2 && add_bits < mean_bits / 2) {
                        add_bits = mean_bits / 2;
                    }
                    if (add_bits > mean_bits * 3 / 2) {
                        add_bits = mean_bits * 3 / 2;
                    } else if (add_bits < 0) {
                        add_bits = 0;
                    }
                    int[] nArray = targ_bits[gr];
                    int n = ch;
                    nArray[n] = nArray[n] + add_bits;
                }
                if (targ_bits[gr][ch] > 4095) {
                    targ_bits[gr][ch] = 4095;
                }
                sum += targ_bits[gr][ch];
            }
            if (sum <= 7680) continue;
            ch = 0;
            while (ch < gfc.channels_out) {
                int[] nArray = targ_bits[gr];
                int n = ch;
                nArray[n] = nArray[n] * 7680;
                int[] nArray2 = targ_bits[gr];
                int n2 = ch++;
                nArray2[n2] = nArray2[n2] / sum;
            }
        }
        if (gfc.mode_ext == 2) {
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                this.qupvt.reduce_side(targ_bits[gr], ms_ener_ratio[gr], mean_bits * gfc.channels_out, 7680);
            }
        }
        int totbits = 0;
        for (gr = 0; gr < gfc.mode_gr; ++gr) {
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                if (targ_bits[gr][ch] > 4095) {
                    targ_bits[gr][ch] = 4095;
                }
                totbits += targ_bits[gr][ch];
            }
        }
        if (totbits > max_frame_bits[0]) {
            for (gr = 0; gr < gfc.mode_gr; ++gr) {
                ch = 0;
                while (ch < gfc.channels_out) {
                    int[] nArray = targ_bits[gr];
                    int n = ch;
                    nArray[n] = nArray[n] * max_frame_bits[0];
                    int[] nArray3 = targ_bits[gr];
                    int n3 = ch++;
                    nArray3[n3] = nArray3[n3] / totbits;
                }
            }
        }
    }

    private static enum BinSearchDirection {
        BINSEARCH_NONE,
        BINSEARCH_UP,
        BINSEARCH_DOWN;

    }
}

