/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r.mp3;

import de.sciss.jump3r.mp3.ABRIterationLoop;
import de.sciss.jump3r.mp3.ATH;
import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.CBRNewIterationLoop;
import de.sciss.jump3r.mp3.Encoder;
import de.sciss.jump3r.mp3.GainAnalysis;
import de.sciss.jump3r.mp3.ID3Tag;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.LameInternalFlags;
import de.sciss.jump3r.mp3.MPEGMode;
import de.sciss.jump3r.mp3.PSY;
import de.sciss.jump3r.mp3.Presets;
import de.sciss.jump3r.mp3.PsyModel;
import de.sciss.jump3r.mp3.Quantize;
import de.sciss.jump3r.mp3.QuantizePVT;
import de.sciss.jump3r.mp3.ReplayGain;
import de.sciss.jump3r.mp3.ShortBlock;
import de.sciss.jump3r.mp3.Tables;
import de.sciss.jump3r.mp3.VBRNewIterationLoop;
import de.sciss.jump3r.mp3.VBROldIterationLoop;
import de.sciss.jump3r.mp3.VBRTag;
import de.sciss.jump3r.mp3.VbrMode;
import de.sciss.jump3r.mp3.Version;
import de.sciss.jump3r.mpg.MPGLib;

public class Lame {
    GainAnalysis ga;
    BitStream bs;
    Presets p;
    QuantizePVT qupvt;
    Quantize qu;
    PsyModel psy = new PsyModel();
    VBRTag vbr;
    Version ver;
    ID3Tag id3;
    MPGLib mpglib;
    public Encoder enc = new Encoder();
    public static final long LAME_ID = -487877L;
    public static final int V9 = 410;
    public static final int V8 = 420;
    public static final int V7 = 430;
    public static final int V6 = 440;
    public static final int V5 = 450;
    public static final int V4 = 460;
    public static final int V3 = 470;
    public static final int V2 = 480;
    public static final int V1 = 490;
    public static final int V0 = 500;
    public static final int R3MIX = 1000;
    public static final int STANDARD = 1001;
    public static final int EXTREME = 1002;
    public static final int INSANE = 1003;
    public static final int STANDARD_FAST = 1004;
    public static final int EXTREME_FAST = 1005;
    public static final int MEDIUM = 1006;
    public static final int MEDIUM_FAST = 1007;
    static final int LAME_MAXALBUMART = 131072;
    public static final int LAME_MAXMP3BUFFER = 147456;
    private static final int LAME_DEFAULT_QUALITY = 3;

    public final void setModules(GainAnalysis ga, BitStream bs, Presets p, QuantizePVT qupvt, Quantize qu, VBRTag vbr, Version ver, ID3Tag id3, MPGLib mpglib) {
        this.ga = ga;
        this.bs = bs;
        this.p = p;
        this.qupvt = qupvt;
        this.qu = qu;
        this.vbr = vbr;
        this.ver = ver;
        this.id3 = id3;
        this.mpglib = mpglib;
        this.enc.setModules(bs, this.psy, qupvt, vbr);
    }

    private float filter_coef(float x) {
        if ((double)x > 1.0) {
            return 0.0f;
        }
        if ((double)x <= 0.0) {
            return 1.0f;
        }
        return (float)Math.cos(1.5707963267948966 * (double)x);
    }

    private void lame_init_params_ppflt(LameGlobalFlags gfp) {
        float freq;
        int band;
        LameInternalFlags gfc = gfp.internal_flags;
        int lowpass_band = 32;
        int highpass_band = -1;
        if (gfc.lowpass1 > 0.0f) {
            int minband = 999;
            for (band = 0; band <= 31; ++band) {
                freq = (float)((double)band / 31.0);
                if (freq >= gfc.lowpass2) {
                    lowpass_band = Math.min(lowpass_band, band);
                }
                if (!(gfc.lowpass1 < freq) || !(freq < gfc.lowpass2)) continue;
                minband = Math.min(minband, band);
            }
            gfc.lowpass1 = minband == 999 ? ((float)lowpass_band - 0.75f) / 31.0f : ((float)minband - 0.75f) / 31.0f;
            gfc.lowpass2 = (float)lowpass_band / 31.0f;
        }
        if (gfc.highpass2 > 0.0f && (double)gfc.highpass2 < 0.021774193548387097) {
            gfc.highpass1 = 0.0f;
            gfc.highpass2 = 0.0f;
            System.err.println("Warning: highpass filter disabled.  highpass frequency too small\n");
        }
        if (gfc.highpass2 > 0.0f) {
            int maxband = -1;
            for (band = 0; band <= 31; ++band) {
                freq = (float)band / 31.0f;
                if (freq <= gfc.highpass1) {
                    highpass_band = Math.max(highpass_band, band);
                }
                if (!(gfc.highpass1 < freq) || !(freq < gfc.highpass2)) continue;
                maxband = Math.max(maxband, band);
            }
            gfc.highpass1 = (float)highpass_band / 31.0f;
            gfc.highpass2 = maxband == -1 ? ((float)highpass_band + 0.75f) / 31.0f : ((float)maxband + 0.75f) / 31.0f;
        }
        for (int band2 = 0; band2 < 32; ++band2) {
            float freq2 = (float)band2 / 31.0f;
            double fc1 = gfc.highpass2 > gfc.highpass1 ? (double)this.filter_coef((gfc.highpass2 - freq2) / (gfc.highpass2 - gfc.highpass1 + 1.0E-20f)) : 1.0;
            double fc2 = gfc.lowpass2 > gfc.lowpass1 ? (double)this.filter_coef((freq2 - gfc.lowpass1) / (gfc.lowpass2 - gfc.lowpass1 + 1.0E-20f)) : 1.0;
            gfc.amp_filter[band2] = (float)(fc1 * fc2);
        }
    }

    private void optimum_bandwidth(LowPassHighPass lh, int bitrate) {
        BandPass[] freq_map = new BandPass[]{new BandPass(8, 2000), new BandPass(16, 3700), new BandPass(24, 3900), new BandPass(32, 5500), new BandPass(40, 7000), new BandPass(48, 7500), new BandPass(56, 10000), new BandPass(64, 11000), new BandPass(80, 13500), new BandPass(96, 15100), new BandPass(112, 15600), new BandPass(128, 17000), new BandPass(160, 17500), new BandPass(192, 18600), new BandPass(224, 19400), new BandPass(256, 19700), new BandPass(320, 20500)};
        int table_index = this.nearestBitrateFullIndex(bitrate);
        lh.lowerlimit = freq_map[table_index].lowpass;
    }

    private int optimum_samplefreq(int lowpassfreq, int input_samplefreq) {
        int suggested_samplefreq = 44100;
        if (input_samplefreq >= 48000) {
            suggested_samplefreq = 48000;
        } else if (input_samplefreq >= 44100) {
            suggested_samplefreq = 44100;
        } else if (input_samplefreq >= 32000) {
            suggested_samplefreq = 32000;
        } else if (input_samplefreq >= 24000) {
            suggested_samplefreq = 24000;
        } else if (input_samplefreq >= 22050) {
            suggested_samplefreq = 22050;
        } else if (input_samplefreq >= 16000) {
            suggested_samplefreq = 16000;
        } else if (input_samplefreq >= 12000) {
            suggested_samplefreq = 12000;
        } else if (input_samplefreq >= 11025) {
            suggested_samplefreq = 11025;
        } else if (input_samplefreq >= 8000) {
            suggested_samplefreq = 8000;
        }
        if (lowpassfreq == -1) {
            return suggested_samplefreq;
        }
        if (lowpassfreq <= 15960) {
            suggested_samplefreq = 44100;
        }
        if (lowpassfreq <= 15250) {
            suggested_samplefreq = 32000;
        }
        if (lowpassfreq <= 11220) {
            suggested_samplefreq = 24000;
        }
        if (lowpassfreq <= 9970) {
            suggested_samplefreq = 22050;
        }
        if (lowpassfreq <= 7230) {
            suggested_samplefreq = 16000;
        }
        if (lowpassfreq <= 5420) {
            suggested_samplefreq = 12000;
        }
        if (lowpassfreq <= 4510) {
            suggested_samplefreq = 11025;
        }
        if (lowpassfreq <= 3970) {
            suggested_samplefreq = 8000;
        }
        if (input_samplefreq < suggested_samplefreq) {
            if (input_samplefreq > 44100) {
                return 48000;
            }
            if (input_samplefreq > 32000) {
                return 44100;
            }
            if (input_samplefreq > 24000) {
                return 32000;
            }
            if (input_samplefreq > 22050) {
                return 24000;
            }
            if (input_samplefreq > 16000) {
                return 22050;
            }
            if (input_samplefreq > 12000) {
                return 16000;
            }
            if (input_samplefreq > 11025) {
                return 12000;
            }
            if (input_samplefreq > 8000) {
                return 11025;
            }
            return 8000;
        }
        return suggested_samplefreq;
    }

    private void lame_init_qval(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        switch (gfp.quality) {
            default: {
                gfc.psymodel = 0;
                gfc.noise_shaping = 0;
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 8: {
                gfp.quality = 7;
            }
            case 7: {
                gfc.psymodel = 1;
                gfc.noise_shaping = 0;
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 6: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 5: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 4: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 3: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 1;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 2: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                if (gfc.substep_shaping == 0) {
                    gfc.substep_shaping = 2;
                }
                gfc.noise_shaping_amp = 1;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 1: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                if (gfc.substep_shaping == 0) {
                    gfc.substep_shaping = 2;
                }
                gfc.noise_shaping_amp = 2;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 0: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                if (gfc.substep_shaping == 0) {
                    gfc.substep_shaping = 2;
                }
                gfc.noise_shaping_amp = 2;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
            }
        }
    }

    private double linear_int(double a, double b, double m) {
        return a + m * (b - a);
    }

    private int FindNearestBitrate(int bRate, int version, int samplerate) {
        if (samplerate < 16000) {
            version = 2;
        }
        int bitrate = Tables.bitrate_table[version][1];
        for (int i = 2; i <= 14; ++i) {
            if (Tables.bitrate_table[version][i] <= 0 || Math.abs(Tables.bitrate_table[version][i] - bRate) >= Math.abs(bitrate - bRate)) continue;
            bitrate = Tables.bitrate_table[version][i];
        }
        return bitrate;
    }

    public final int nearestBitrateFullIndex(int bitrate) {
        int[] full_bitrate_table = new int[]{8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
        int lower_range = 0;
        int lower_range_kbps = 0;
        int upper_range = 0;
        int upper_range_kbps = 0;
        upper_range_kbps = full_bitrate_table[16];
        upper_range = 16;
        lower_range_kbps = full_bitrate_table[16];
        lower_range = 16;
        for (int b = 0; b < 16; ++b) {
            if (Math.max(bitrate, full_bitrate_table[b + 1]) == bitrate) continue;
            upper_range_kbps = full_bitrate_table[b + 1];
            upper_range = b + 1;
            lower_range_kbps = full_bitrate_table[b];
            lower_range = b;
            break;
        }
        if (upper_range_kbps - bitrate > bitrate - lower_range_kbps) {
            return lower_range;
        }
        return upper_range;
    }

    private int map2MP3Frequency(int freq) {
        if (freq <= 8000) {
            return 8000;
        }
        if (freq <= 11025) {
            return 11025;
        }
        if (freq <= 12000) {
            return 12000;
        }
        if (freq <= 16000) {
            return 16000;
        }
        if (freq <= 22050) {
            return 22050;
        }
        if (freq <= 24000) {
            return 24000;
        }
        if (freq <= 32000) {
            return 32000;
        }
        if (freq <= 44100) {
            return 44100;
        }
        return 48000;
    }

    private int SmpFrqIndex(int sample_freq, LameGlobalFlags gpf) {
        switch (sample_freq) {
            case 44100: {
                gpf.version = 1;
                return 0;
            }
            case 48000: {
                gpf.version = 1;
                return 1;
            }
            case 32000: {
                gpf.version = 1;
                return 2;
            }
            case 22050: {
                gpf.version = 0;
                return 0;
            }
            case 24000: {
                gpf.version = 0;
                return 1;
            }
            case 16000: {
                gpf.version = 0;
                return 2;
            }
            case 11025: {
                gpf.version = 0;
                return 0;
            }
            case 12000: {
                gpf.version = 0;
                return 1;
            }
            case 8000: {
                gpf.version = 0;
                return 2;
            }
        }
        gpf.version = 0;
        return -1;
    }

    public final int BitrateIndex(int bRate, int version, int samplerate) {
        if (samplerate < 16000) {
            version = 2;
        }
        for (int i = 0; i <= 14; ++i) {
            if (Tables.bitrate_table[version][i] <= 0 || Tables.bitrate_table[version][i] != bRate) continue;
            return i;
        }
        return -1;
    }

    private float blackman(float x, float fcn, int l) {
        float wcn = (float)(Math.PI * (double)fcn);
        if ((x /= (float)l) < 0.0f) {
            x = 0.0f;
        }
        if (x > 1.0f) {
            x = 1.0f;
        }
        float x2 = x - 0.5f;
        float bkwn = 0.42f - 0.5f * (float)Math.cos((double)(2.0f * x) * Math.PI) + 0.08f * (float)Math.cos((double)(4.0f * x) * Math.PI);
        if ((double)Math.abs(x2) < 1.0E-9) {
            return (float)((double)wcn / Math.PI);
        }
        return (float)((double)bkwn * Math.sin((float)l * wcn * x2) / (Math.PI * (double)l * (double)x2));
    }

    private int gcd(int i, int j) {
        return j != 0 ? this.gcd(j, i % j) : i;
    }

    private int fill_buffer_resample(LameGlobalFlags gfp, float[] outbuf, int outbufPos, int desired_len, float[] inbuf, int in_bufferPos, int len, NumUsed num_used, int ch) {
        double time0;
        int k;
        int i;
        int filter_l;
        LameInternalFlags gfc = gfp.internal_flags;
        int j = 0;
        int bpc = gfp.out_samplerate / this.gcd(gfp.out_samplerate, gfp.in_samplerate);
        if (bpc > 320) {
            bpc = 320;
        }
        float intratio = Math.abs(gfc.resample_ratio - Math.floor(0.5 + gfc.resample_ratio)) < 1.0E-4 ? 1.0f : 0.0f;
        float fcn = 1.0f / (float)gfc.resample_ratio;
        if ((double)fcn > 1.0) {
            fcn = 1.0f;
        }
        if (0 == (filter_l = 31) % 2) {
            --filter_l;
        }
        filter_l = (int)((float)filter_l + intratio);
        int BLACKSIZE = filter_l + 1;
        if (gfc.fill_buffer_resample_init == 0) {
            gfc.inbuf_old[0] = new float[BLACKSIZE];
            gfc.inbuf_old[1] = new float[BLACKSIZE];
            for (i = 0; i <= 2 * bpc; ++i) {
                gfc.blackfilt[i] = new float[BLACKSIZE];
            }
            gfc.itime[0] = 0.0;
            gfc.itime[1] = 0.0;
            for (j = 0; j <= 2 * bpc; ++j) {
                float sum = 0.0f;
                float offset = (float)(j - bpc) / (2.0f * (float)bpc);
                for (i = 0; i <= filter_l; ++i) {
                    float f = this.blackman((float)i - offset, fcn, filter_l);
                    gfc.blackfilt[j][i] = f;
                    sum += f;
                }
                i = 0;
                while (i <= filter_l) {
                    float[] fArray = gfc.blackfilt[j];
                    int n = i++;
                    fArray[n] = fArray[n] / sum;
                }
            }
            gfc.fill_buffer_resample_init = 1;
        }
        float[] inbuf_old = gfc.inbuf_old[ch];
        for (k = 0; k < desired_len && filter_l + (j = (int)Math.floor((time0 = (double)k * gfc.resample_ratio) - gfc.itime[ch])) - filter_l / 2 < len; ++k) {
            float offset = (float)(time0 - gfc.itime[ch] - ((double)j + 0.5 * (double)(filter_l % 2)));
            assert ((double)Math.abs(offset) <= 0.501);
            int joff = (int)Math.floor((double)(offset * 2.0f * (float)bpc + (float)bpc) + 0.5);
            float xvalue = 0.0f;
            for (i = 0; i <= filter_l; ++i) {
                int j2 = i + j - filter_l / 2;
                assert (j2 < len);
                assert (j2 + BLACKSIZE >= 0);
                float y = j2 < 0 ? inbuf_old[BLACKSIZE + j2] : inbuf[in_bufferPos + j2];
                xvalue += y * gfc.blackfilt[joff][i];
            }
            outbuf[outbufPos + k] = xvalue;
        }
        num_used.num_used = Math.min(len, filter_l + j - filter_l / 2);
        int n = ch;
        gfc.itime[n] = gfc.itime[n] + ((double)num_used.num_used - (double)k * gfc.resample_ratio);
        if (num_used.num_used >= BLACKSIZE) {
            for (i = 0; i < BLACKSIZE; ++i) {
                inbuf_old[i] = inbuf[in_bufferPos + num_used.num_used + i - BLACKSIZE];
            }
        } else {
            int n_shift = BLACKSIZE - num_used.num_used;
            for (i = 0; i < n_shift; ++i) {
                inbuf_old[i] = inbuf_old[i + num_used.num_used];
            }
            j = 0;
            while (i < BLACKSIZE) {
                inbuf_old[i] = inbuf[in_bufferPos + j];
                ++i;
                ++j;
            }
            assert (j == num_used.num_used);
        }
        return k;
    }

    private void fill_buffer(LameGlobalFlags gfp, float[][] mfbuf, float[][] in_buffer, int in_bufferPos, int nsamples, InOut io) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc.resample_ratio < 0.9999 || gfc.resample_ratio > 1.0001) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                NumUsed numUsed = new NumUsed();
                io.n_out = this.fill_buffer_resample(gfp, mfbuf[ch], gfc.mf_size, gfp.framesize, in_buffer[ch], in_bufferPos, nsamples, numUsed, ch);
                io.n_in = numUsed.num_used;
            }
        } else {
            io.n_in = io.n_out = Math.min(gfp.framesize, nsamples);
            for (int i = 0; i < io.n_out; ++i) {
                mfbuf[0][gfc.mf_size + i] = in_buffer[0][in_bufferPos + i];
                if (gfc.channels_out != 2) continue;
                mfbuf[1][gfc.mf_size + i] = in_buffer[1][in_bufferPos + i];
            }
        }
    }

    public final int lame_init_params(LameGlobalFlags gfp) {
        int i;
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.Class_ID = 0L;
        if (gfc.ATH == null) {
            gfc.ATH = new ATH();
        }
        if (gfc.PSY == null) {
            gfc.PSY = new PSY();
        }
        if (gfc.rgdata == null) {
            gfc.rgdata = new ReplayGain();
        }
        gfc.channels_in = gfp.num_channels;
        if (gfc.channels_in == 1) {
            gfp.mode = MPEGMode.MONO;
        }
        gfc.channels_out = gfp.mode == MPEGMode.MONO ? 1 : 2;
        gfc.mode_ext = 2;
        if (gfp.mode == MPEGMode.MONO) {
            gfp.force_ms = false;
        }
        if (gfp.VBR == VbrMode.vbr_off && gfp.VBR_mean_bitrate_kbps != 128 && gfp.brate == 0) {
            gfp.brate = gfp.VBR_mean_bitrate_kbps;
        }
        if (gfp.VBR != VbrMode.vbr_off && gfp.VBR != VbrMode.vbr_mtrh && gfp.VBR != VbrMode.vbr_mt) {
            gfp.free_format = false;
        }
        if (gfp.VBR == VbrMode.vbr_off && gfp.brate == 0 && BitStream.EQ(gfp.compression_ratio, 0.0f)) {
            gfp.compression_ratio = 11.025f;
        }
        if (gfp.VBR == VbrMode.vbr_off && gfp.compression_ratio > 0.0f) {
            if (gfp.out_samplerate == 0) {
                gfp.out_samplerate = this.map2MP3Frequency((int)(0.97 * (double)gfp.in_samplerate));
            }
            gfp.brate = (int)((float)(gfp.out_samplerate * 16 * gfc.channels_out) / (1000.0f * gfp.compression_ratio));
            gfc.samplerate_index = this.SmpFrqIndex(gfp.out_samplerate, gfp);
            if (!gfp.free_format) {
                gfp.brate = this.FindNearestBitrate(gfp.brate, gfp.version, gfp.out_samplerate);
            }
        }
        if (gfp.out_samplerate != 0) {
            if (gfp.out_samplerate < 16000) {
                gfp.VBR_mean_bitrate_kbps = Math.max(gfp.VBR_mean_bitrate_kbps, 8);
                gfp.VBR_mean_bitrate_kbps = Math.min(gfp.VBR_mean_bitrate_kbps, 64);
            } else if (gfp.out_samplerate < 32000) {
                gfp.VBR_mean_bitrate_kbps = Math.max(gfp.VBR_mean_bitrate_kbps, 8);
                gfp.VBR_mean_bitrate_kbps = Math.min(gfp.VBR_mean_bitrate_kbps, 160);
            } else {
                gfp.VBR_mean_bitrate_kbps = Math.max(gfp.VBR_mean_bitrate_kbps, 32);
                gfp.VBR_mean_bitrate_kbps = Math.min(gfp.VBR_mean_bitrate_kbps, 320);
            }
        }
        if (gfp.lowpassfreq == 0) {
            double lowpass = 16000.0;
            switch (gfp.VBR) {
                case vbr_off: {
                    LowPassHighPass lh = new LowPassHighPass();
                    this.optimum_bandwidth(lh, gfp.brate);
                    lowpass = lh.lowerlimit;
                    break;
                }
                case vbr_abr: {
                    LowPassHighPass lh = new LowPassHighPass();
                    this.optimum_bandwidth(lh, gfp.VBR_mean_bitrate_kbps);
                    lowpass = lh.lowerlimit;
                    break;
                }
                case vbr_rh: {
                    double m;
                    double b;
                    double a;
                    int[] x = new int[]{19500, 19000, 18600, 18000, 17500, 16000, 15600, 14900, 12500, 10000, 3950};
                    if (0 <= gfp.VBR_q && gfp.VBR_q <= 9) {
                        a = x[gfp.VBR_q];
                        b = x[gfp.VBR_q + 1];
                        m = gfp.VBR_q_frac;
                        lowpass = this.linear_int(a, b, m);
                        break;
                    }
                    lowpass = 19500.0;
                    break;
                }
                default: {
                    double m;
                    double b;
                    double a;
                    int[] x = new int[]{19500, 19000, 18500, 18000, 17500, 16500, 15500, 14500, 12500, 9500, 3950};
                    if (0 <= gfp.VBR_q && gfp.VBR_q <= 9) {
                        a = x[gfp.VBR_q];
                        b = x[gfp.VBR_q + 1];
                        m = gfp.VBR_q_frac;
                        lowpass = this.linear_int(a, b, m);
                        break;
                    }
                    lowpass = 19500.0;
                }
            }
            if (gfp.mode == MPEGMode.MONO && (gfp.VBR == VbrMode.vbr_off || gfp.VBR == VbrMode.vbr_abr)) {
                lowpass *= 1.5;
            }
            gfp.lowpassfreq = (int)lowpass;
        }
        if (gfp.out_samplerate == 0) {
            if (2 * gfp.lowpassfreq > gfp.in_samplerate) {
                gfp.lowpassfreq = gfp.in_samplerate / 2;
            }
            gfp.out_samplerate = this.optimum_samplefreq(gfp.lowpassfreq, gfp.in_samplerate);
        }
        gfp.lowpassfreq = Math.min(20500, gfp.lowpassfreq);
        gfp.lowpassfreq = Math.min(gfp.out_samplerate / 2, gfp.lowpassfreq);
        if (gfp.VBR == VbrMode.vbr_off) {
            gfp.compression_ratio = (float)(gfp.out_samplerate * 16 * gfc.channels_out) / (1000.0f * (float)gfp.brate);
        }
        if (gfp.VBR == VbrMode.vbr_abr) {
            gfp.compression_ratio = (float)(gfp.out_samplerate * 16 * gfc.channels_out) / (1000.0f * (float)gfp.VBR_mean_bitrate_kbps);
        }
        if (!gfp.bWriteVbrTag) {
            gfp.findReplayGain = false;
            gfp.decode_on_the_fly = false;
            gfc.findPeakSample = false;
        }
        gfc.findReplayGain = gfp.findReplayGain;
        gfc.decode_on_the_fly = gfp.decode_on_the_fly;
        if (gfc.decode_on_the_fly) {
            gfc.findPeakSample = true;
        }
        if (gfc.findReplayGain && this.ga.InitGainAnalysis(gfc.rgdata, gfp.out_samplerate) == 0) {
            gfp.internal_flags = null;
            return -6;
        }
        if (gfc.decode_on_the_fly && !gfp.decode_only) {
            if (gfc.hip != null) {
                this.mpglib.hip_decode_exit(gfc.hip);
            }
            gfc.hip = this.mpglib.hip_decode_init();
        }
        gfc.mode_gr = gfp.out_samplerate <= 24000 ? 1 : 2;
        gfp.framesize = 576 * gfc.mode_gr;
        gfp.encoder_delay = 576;
        gfc.resample_ratio = (double)gfp.in_samplerate / (double)gfp.out_samplerate;
        switch (gfp.VBR) {
            case vbr_rh: 
            case vbr_mt: 
            case vbr_mtrh: {
                float[] cmp = new float[]{5.7f, 6.5f, 7.3f, 8.2f, 10.0f, 11.9f, 13.0f, 14.0f, 15.0f, 16.5f};
                gfp.compression_ratio = cmp[gfp.VBR_q];
                break;
            }
            case vbr_abr: {
                gfp.compression_ratio = (float)(gfp.out_samplerate * 16 * gfc.channels_out) / (1000.0f * (float)gfp.VBR_mean_bitrate_kbps);
                break;
            }
            default: {
                gfp.compression_ratio = (float)(gfp.out_samplerate * 16 * gfc.channels_out) / (1000.0f * (float)gfp.brate);
            }
        }
        if (gfp.mode == MPEGMode.NOT_SET) {
            gfp.mode = MPEGMode.JOINT_STEREO;
        }
        if (gfp.highpassfreq > 0) {
            gfc.highpass1 = 2.0f * (float)gfp.highpassfreq;
            gfc.highpass2 = gfp.highpasswidth >= 0 ? 2.0f * (float)(gfp.highpassfreq + gfp.highpasswidth) : 2.0f * (float)gfp.highpassfreq;
            gfc.highpass1 /= (float)gfp.out_samplerate;
            gfc.highpass2 /= (float)gfp.out_samplerate;
        } else {
            gfc.highpass1 = 0.0f;
            gfc.highpass2 = 0.0f;
        }
        if (gfp.lowpassfreq > 0) {
            gfc.lowpass2 = 2.0f * (float)gfp.lowpassfreq;
            if (gfp.lowpasswidth >= 0) {
                gfc.lowpass1 = 2.0f * (float)(gfp.lowpassfreq - gfp.lowpasswidth);
                if (gfc.lowpass1 < 0.0f) {
                    gfc.lowpass1 = 0.0f;
                }
            } else {
                gfc.lowpass1 = 2.0f * (float)gfp.lowpassfreq;
            }
            gfc.lowpass1 /= (float)gfp.out_samplerate;
            gfc.lowpass2 /= (float)gfp.out_samplerate;
        } else {
            gfc.lowpass1 = 0.0f;
            gfc.lowpass2 = 0.0f;
        }
        this.lame_init_params_ppflt(gfp);
        gfc.samplerate_index = this.SmpFrqIndex(gfp.out_samplerate, gfp);
        if (gfc.samplerate_index < 0) {
            gfp.internal_flags = null;
            return -1;
        }
        if (gfp.VBR == VbrMode.vbr_off) {
            if (gfp.free_format) {
                gfc.bitrate_index = 0;
            } else {
                gfp.brate = this.FindNearestBitrate(gfp.brate, gfp.version, gfp.out_samplerate);
                gfc.bitrate_index = this.BitrateIndex(gfp.brate, gfp.version, gfp.out_samplerate);
                if (gfc.bitrate_index <= 0) {
                    gfp.internal_flags = null;
                    return -1;
                }
            }
        } else {
            gfc.bitrate_index = 1;
        }
        if (gfp.analysis) {
            gfp.bWriteVbrTag = false;
        }
        if (gfc.pinfo != null) {
            gfp.bWriteVbrTag = false;
        }
        this.bs.init_bit_stream_w(gfc);
        int j = gfc.samplerate_index + 3 * gfp.version + 6 * (gfp.out_samplerate < 16000 ? 1 : 0);
        for (i = 0; i < 23; ++i) {
            gfc.scalefac_band.l[i] = this.qupvt.sfBandIndex[j].l[i];
        }
        for (i = 0; i < 7; ++i) {
            int start;
            int size = (gfc.scalefac_band.l[22] - gfc.scalefac_band.l[21]) / 6;
            gfc.scalefac_band.psfb21[i] = start = gfc.scalefac_band.l[21] + i * size;
        }
        gfc.scalefac_band.psfb21[6] = 576;
        for (i = 0; i < 14; ++i) {
            gfc.scalefac_band.s[i] = this.qupvt.sfBandIndex[j].s[i];
        }
        for (i = 0; i < 7; ++i) {
            int start;
            int size = (gfc.scalefac_band.s[13] - gfc.scalefac_band.s[12]) / 6;
            gfc.scalefac_band.psfb12[i] = start = gfc.scalefac_band.s[12] + i * size;
        }
        gfc.scalefac_band.psfb12[6] = 192;
        if (gfp.version == 1) {
            gfc.sideinfo_len = gfc.channels_out == 1 ? 21 : 36;
        } else {
            int n = gfc.sideinfo_len = gfc.channels_out == 1 ? 13 : 21;
        }
        if (gfp.error_protection) {
            gfc.sideinfo_len += 2;
        }
        this.lame_init_bitstream(gfp);
        gfc.Class_ID = -487877L;
        for (int k = 0; k < 19; ++k) {
            gfc.nsPsy.pefirbuf[k] = 700 * gfc.mode_gr * gfc.channels_out;
        }
        if (gfp.ATHtype == -1) {
            gfp.ATHtype = 4;
        }
        assert (gfp.VBR_q <= 9);
        assert (gfp.VBR_q >= 0);
        switch (gfp.VBR) {
            case vbr_mt: {
                gfp.VBR = VbrMode.vbr_mtrh;
            }
            case vbr_mtrh: {
                if (gfp.useTemporal == null) {
                    gfp.useTemporal = false;
                }
                this.p.apply_preset(gfp, 500 - gfp.VBR_q * 10, 0);
                if (gfp.quality < 0) {
                    gfp.quality = 3;
                }
                if (gfp.quality < 5) {
                    gfp.quality = 0;
                }
                if (gfp.quality > 5) {
                    gfp.quality = 5;
                }
                gfc.PSY.mask_adjust = gfp.maskingadjust;
                gfc.PSY.mask_adjust_short = gfp.maskingadjust_short;
                gfc.sfb21_extra = gfp.experimentalY ? false : gfp.out_samplerate > 44000;
                gfc.iteration_loop = new VBRNewIterationLoop(this.qu);
                break;
            }
            case vbr_rh: {
                this.p.apply_preset(gfp, 500 - gfp.VBR_q * 10, 0);
                gfc.PSY.mask_adjust = gfp.maskingadjust;
                gfc.PSY.mask_adjust_short = gfp.maskingadjust_short;
                if (gfp.experimentalY) {
                    gfc.sfb21_extra = false;
                } else {
                    boolean bl = gfc.sfb21_extra = gfp.out_samplerate > 44000;
                }
                if (gfp.quality > 6) {
                    gfp.quality = 6;
                }
                if (gfp.quality < 0) {
                    gfp.quality = 3;
                }
                gfc.iteration_loop = new VBROldIterationLoop(this.qu);
                break;
            }
            default: {
                VbrMode vbrmode;
                gfc.sfb21_extra = false;
                if (gfp.quality < 0) {
                    gfp.quality = 3;
                }
                if ((vbrmode = gfp.VBR) == VbrMode.vbr_off) {
                    gfp.VBR_mean_bitrate_kbps = gfp.brate;
                }
                this.p.apply_preset(gfp, gfp.VBR_mean_bitrate_kbps, 0);
                gfp.VBR = vbrmode;
                gfc.PSY.mask_adjust = gfp.maskingadjust;
                gfc.PSY.mask_adjust_short = gfp.maskingadjust_short;
                if (vbrmode == VbrMode.vbr_off) {
                    gfc.iteration_loop = new CBRNewIterationLoop(this.qu);
                    break;
                }
                gfc.iteration_loop = new ABRIterationLoop(this.qu);
                break;
            }
        }
        if (gfp.VBR != VbrMode.vbr_off) {
            gfc.VBR_min_bitrate = 1;
            gfc.VBR_max_bitrate = 14;
            if (gfp.out_samplerate < 16000) {
                gfc.VBR_max_bitrate = 8;
            }
            if (gfp.VBR_min_bitrate_kbps != 0) {
                gfp.VBR_min_bitrate_kbps = this.FindNearestBitrate(gfp.VBR_min_bitrate_kbps, gfp.version, gfp.out_samplerate);
                gfc.VBR_min_bitrate = this.BitrateIndex(gfp.VBR_min_bitrate_kbps, gfp.version, gfp.out_samplerate);
                if (gfc.VBR_min_bitrate < 0) {
                    return -1;
                }
            }
            if (gfp.VBR_max_bitrate_kbps != 0) {
                gfp.VBR_max_bitrate_kbps = this.FindNearestBitrate(gfp.VBR_max_bitrate_kbps, gfp.version, gfp.out_samplerate);
                gfc.VBR_max_bitrate = this.BitrateIndex(gfp.VBR_max_bitrate_kbps, gfp.version, gfp.out_samplerate);
                if (gfc.VBR_max_bitrate < 0) {
                    return -1;
                }
            }
            gfp.VBR_min_bitrate_kbps = Tables.bitrate_table[gfp.version][gfc.VBR_min_bitrate];
            gfp.VBR_max_bitrate_kbps = Tables.bitrate_table[gfp.version][gfc.VBR_max_bitrate];
            gfp.VBR_mean_bitrate_kbps = Math.min(Tables.bitrate_table[gfp.version][gfc.VBR_max_bitrate], gfp.VBR_mean_bitrate_kbps);
            gfp.VBR_mean_bitrate_kbps = Math.max(Tables.bitrate_table[gfp.version][gfc.VBR_min_bitrate], gfp.VBR_mean_bitrate_kbps);
        }
        if (gfp.tune) {
            gfc.PSY.mask_adjust += gfp.tune_value_a;
            gfc.PSY.mask_adjust_short += gfp.tune_value_a;
        }
        this.lame_init_qval(gfp);
        gfc.ATH.useAdjust = gfp.athaa_type < 0 ? 3 : gfp.athaa_type;
        gfc.ATH.aaSensitivityP = (float)Math.pow(10.0, (double)gfp.athaa_sensitivity / -10.0);
        if (gfp.short_blocks == null) {
            gfp.short_blocks = ShortBlock.short_block_allowed;
        }
        if (gfp.short_blocks == ShortBlock.short_block_allowed && (gfp.mode == MPEGMode.JOINT_STEREO || gfp.mode == MPEGMode.STEREO)) {
            gfp.short_blocks = ShortBlock.short_block_coupled;
        }
        if (gfp.quant_comp < 0) {
            gfp.quant_comp = 1;
        }
        if (gfp.quant_comp_short < 0) {
            gfp.quant_comp_short = 0;
        }
        if (gfp.msfix < 0.0f) {
            gfp.msfix = 0.0f;
        }
        gfp.exp_nspsytune |= 1;
        if (gfp.internal_flags.nsPsy.attackthre < 0.0f) {
            gfp.internal_flags.nsPsy.attackthre = 4.4f;
        }
        if (gfp.internal_flags.nsPsy.attackthre_s < 0.0f) {
            gfp.internal_flags.nsPsy.attackthre_s = 25.0f;
        }
        if (gfp.scale < 0.0f) {
            gfp.scale = 1.0f;
        }
        if (gfp.ATHtype < 0) {
            gfp.ATHtype = 4;
        }
        if (gfp.ATHcurve < 0.0f) {
            gfp.ATHcurve = 4.0f;
        }
        if (gfp.athaa_loudapprox < 0) {
            gfp.athaa_loudapprox = 2;
        }
        if (gfp.interChRatio < 0.0f) {
            gfp.interChRatio = 0.0f;
        }
        if (gfp.useTemporal == null) {
            gfp.useTemporal = true;
        }
        gfc.frac_SpF = 0;
        gfc.slot_lag = 0;
        if (gfp.VBR == VbrMode.vbr_off) {
            gfc.slot_lag = gfc.frac_SpF = (int)((long)(gfp.version + 1) * 72000L * (long)gfp.brate % (long)gfp.out_samplerate);
        }
        this.qupvt.iteration_init(gfp);
        this.psy.psymodel_init(gfp);
        return 0;
    }

    public final void lame_print_config(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        double out_samplerate = gfp.out_samplerate;
        double in_samplerate = (double)gfp.out_samplerate * gfc.resample_ratio;
        System.out.printf("LAME %s %s (%s)\n", this.ver.getLameVersion(), this.ver.getLameOsBitness(), this.ver.getLameUrl());
        if (gfp.num_channels == 2 && gfc.channels_out == 1) {
            System.out.printf("Autoconverting from stereo to mono. Setting encoding to mono mode.\n", new Object[0]);
        }
        if (BitStream.NEQ((float)gfc.resample_ratio, 1.0f)) {
            System.out.printf("Resampling:  input %g kHz  output %g kHz\n", 0.001 * in_samplerate, 0.001 * out_samplerate);
        }
        if ((double)gfc.highpass2 > 0.0) {
            System.out.printf("Using polyphase highpass filter, transition band: %5.0f Hz - %5.0f Hz\n", 0.5 * (double)gfc.highpass1 * out_samplerate, 0.5 * (double)gfc.highpass2 * out_samplerate);
        }
        if (0.0 < (double)gfc.lowpass1 || 0.0 < (double)gfc.lowpass2) {
            System.out.printf("Using polyphase lowpass filter, transition band: %5.0f Hz - %5.0f Hz\n", 0.5 * (double)gfc.lowpass1 * out_samplerate, 0.5 * (double)gfc.lowpass2 * out_samplerate);
        } else {
            System.out.printf("polyphase lowpass filter disabled\n", new Object[0]);
        }
        if (gfp.free_format) {
            System.err.printf("Warning: many decoders cannot handle free format bitstreams\n", new Object[0]);
            if (gfp.brate > 320) {
                System.err.printf("Warning: many decoders cannot handle free format bitrates >320 kbps (see documentation)\n", new Object[0]);
            }
        }
    }

    public final void lame_print_internals(LameGlobalFlags gfp) {
        String pc;
        LameInternalFlags gfc = gfp.internal_flags;
        System.err.printf("\nmisc:\n\n", new Object[0]);
        System.err.printf("\tscaling: %g\n", Float.valueOf(gfp.scale));
        System.err.printf("\tch0 (left) scaling: %g\n", Float.valueOf(gfp.scale_left));
        System.err.printf("\tch1 (right) scaling: %g\n", Float.valueOf(gfp.scale_right));
        switch (gfc.use_best_huffman) {
            default: {
                pc = "normal";
                break;
            }
            case 1: {
                pc = "best (outside loop)";
                break;
            }
            case 2: {
                pc = "best (inside loop, slow)";
            }
        }
        System.err.printf("\thuffman search: %s\n", pc);
        System.err.printf("\texperimental Y=%d\n", gfp.experimentalY);
        System.err.printf("\t...\n", new Object[0]);
        System.err.printf("\nstream format:\n\n", new Object[0]);
        switch (gfp.version) {
            case 0: {
                pc = "2.5";
                break;
            }
            case 1: {
                pc = "1";
                break;
            }
            case 2: {
                pc = "2";
                break;
            }
            default: {
                pc = "?";
            }
        }
        System.err.printf("\tMPEG-%s Layer 3\n", pc);
        switch (gfp.mode) {
            case JOINT_STEREO: {
                pc = "joint stereo";
                break;
            }
            case STEREO: {
                pc = "stereo";
                break;
            }
            case DUAL_CHANNEL: {
                pc = "dual channel";
                break;
            }
            case MONO: {
                pc = "mono";
                break;
            }
            case NOT_SET: {
                pc = "not set (error)";
                break;
            }
            default: {
                pc = "unknown (error)";
            }
        }
        System.err.printf("\t%d channel - %s\n", gfc.channels_out, pc);
        switch (gfp.VBR) {
            case vbr_off: {
                pc = "off";
                break;
            }
            default: {
                pc = "all";
            }
        }
        System.err.printf("\tpadding: %s\n", pc);
        pc = VbrMode.vbr_default == gfp.VBR ? "(default)" : (gfp.free_format ? "(free format)" : "");
        switch (gfp.VBR) {
            case vbr_off: {
                System.err.printf("\tconstant bitrate - CBR %s\n", pc);
                break;
            }
            case vbr_abr: {
                System.err.printf("\tvariable bitrate - ABR %s\n", pc);
                break;
            }
            case vbr_rh: {
                System.err.printf("\tvariable bitrate - VBR rh %s\n", pc);
                break;
            }
            case vbr_mt: {
                System.err.printf("\tvariable bitrate - VBR mt %s\n", pc);
                break;
            }
            case vbr_mtrh: {
                System.err.printf("\tvariable bitrate - VBR mtrh %s\n", pc);
                break;
            }
            default: {
                System.err.printf("\t ?? oops, some new one ?? \n", new Object[0]);
            }
        }
        if (gfp.bWriteVbrTag) {
            System.err.printf("\tusing LAME Tag\n", new Object[0]);
        }
        System.err.printf("\t...\n", new Object[0]);
        System.err.printf("\npsychoacoustic:\n\n", new Object[0]);
        switch (gfp.short_blocks) {
            default: {
                pc = "?";
                break;
            }
            case short_block_allowed: {
                pc = "allowed";
                break;
            }
            case short_block_coupled: {
                pc = "channel coupled";
                break;
            }
            case short_block_dispensed: {
                pc = "dispensed";
                break;
            }
            case short_block_forced: {
                pc = "forced";
            }
        }
        System.err.printf("\tusing short blocks: %s\n", pc);
        System.err.printf("\tsubblock gain: %d\n", gfc.subblock_gain);
        System.err.printf("\tadjust masking: %g dB\n", Float.valueOf(gfc.PSY.mask_adjust));
        System.err.printf("\tadjust masking short: %g dB\n", Float.valueOf(gfc.PSY.mask_adjust_short));
        System.err.printf("\tquantization comparison: %d\n", gfp.quant_comp);
        System.err.printf("\t ^ comparison short blocks: %d\n", gfp.quant_comp_short);
        System.err.printf("\tnoise shaping: %d\n", gfc.noise_shaping);
        System.err.printf("\t ^ amplification: %d\n", gfc.noise_shaping_amp);
        System.err.printf("\t ^ stopping: %d\n", gfc.noise_shaping_stop);
        pc = "using";
        if (gfp.ATHshort) {
            pc = "the only masking for short blocks";
        }
        if (gfp.ATHonly) {
            pc = "the only masking";
        }
        if (gfp.noATH) {
            pc = "not used";
        }
        System.err.printf("\tATH: %s\n", pc);
        System.err.printf("\t ^ type: %d\n", gfp.ATHtype);
        System.err.printf("\t ^ shape: %g%s\n", Float.valueOf(gfp.ATHcurve), " (only for type 4)");
        System.err.printf("\t ^ level adjustement: %g\n", Float.valueOf(gfp.ATHlower));
        System.err.printf("\t ^ adjust type: %d\n", gfc.ATH.useAdjust);
        System.err.printf("\t ^ adjust sensitivity power: %f\n", Float.valueOf(gfc.ATH.aaSensitivityP));
        System.err.printf("\t ^ adapt threshold type: %d\n", gfp.athaa_loudapprox);
        System.err.printf("\texperimental psy tunings by Naoki Shibata\n", new Object[0]);
        System.err.printf("\t   adjust masking bass=%g dB, alto=%g dB, treble=%g dB, sfb21=%g dB\n", 10.0 * Math.log10(gfc.nsPsy.longfact[0]), 10.0 * Math.log10(gfc.nsPsy.longfact[7]), 10.0 * Math.log10(gfc.nsPsy.longfact[14]), 10.0 * Math.log10(gfc.nsPsy.longfact[21]));
        pc = gfp.useTemporal != false ? "yes" : "no";
        System.err.printf("\tusing temporal masking effect: %s\n", pc);
        System.err.printf("\tinterchannel masking ratio: %g\n", Float.valueOf(gfp.interChRatio));
        System.err.printf("\t...\n", new Object[0]);
        System.err.printf("\n", new Object[0]);
    }

    private int lame_encode_frame(LameGlobalFlags gfp, float[] inbuf_l, float[] inbuf_r, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        int ret = this.enc.lame_encode_mp3_frame(gfp, inbuf_l, inbuf_r, mp3buf, mp3bufPos, mp3buf_size);
        ++gfp.frameNum;
        return ret;
    }

    private void update_inbuffer_size(LameInternalFlags gfc, int nsamples) {
        if (gfc.in_buffer_0 == null || gfc.in_buffer_nsamples < nsamples) {
            gfc.in_buffer_0 = new float[nsamples];
            gfc.in_buffer_1 = new float[nsamples];
            gfc.in_buffer_nsamples = nsamples;
        }
    }

    private int calcNeeded(LameGlobalFlags gfp) {
        int mf_needed = 1024 + gfp.framesize - 272;
        mf_needed = Math.max(mf_needed, 512 + gfp.framesize - 32);
        assert (3984 >= mf_needed);
        return mf_needed;
    }

    private int lame_encode_buffer_sample(LameGlobalFlags gfp, float[] buffer_l, float[] buffer_r, int nsamples, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        int i;
        LameInternalFlags gfc = gfp.internal_flags;
        int mp3size = 0;
        float[][] mfbuf = new float[2][];
        float[][] in_buffer = new float[2][];
        if (gfc.Class_ID != -487877L) {
            return -3;
        }
        if (nsamples == 0) {
            return 0;
        }
        int mp3out = this.bs.copy_buffer(gfc, mp3buf, mp3bufPos, mp3buf_size, 0);
        if (mp3out < 0) {
            return mp3out;
        }
        mp3bufPos += mp3out;
        mp3size += mp3out;
        in_buffer[0] = buffer_l;
        in_buffer[1] = buffer_r;
        if (BitStream.NEQ(gfp.scale, 0.0f) && BitStream.NEQ(gfp.scale, 1.0f)) {
            for (i = 0; i < nsamples; ++i) {
                float[] fArray = in_buffer[0];
                int n = i;
                fArray[n] = fArray[n] * gfp.scale;
                if (gfc.channels_out != 2) continue;
                float[] fArray2 = in_buffer[1];
                int n2 = i;
                fArray2[n2] = fArray2[n2] * gfp.scale;
            }
        }
        if (BitStream.NEQ(gfp.scale_left, 0.0f) && BitStream.NEQ(gfp.scale_left, 1.0f)) {
            i = 0;
            while (i < nsamples) {
                float[] fArray = in_buffer[0];
                int n = i++;
                fArray[n] = fArray[n] * gfp.scale_left;
            }
        }
        if (BitStream.NEQ(gfp.scale_right, 0.0f) && BitStream.NEQ(gfp.scale_right, 1.0f)) {
            i = 0;
            while (i < nsamples) {
                float[] fArray = in_buffer[1];
                int n = i++;
                fArray[n] = fArray[n] * gfp.scale_right;
            }
        }
        if (gfp.num_channels == 2 && gfc.channels_out == 1) {
            for (i = 0; i < nsamples; ++i) {
                in_buffer[0][i] = 0.5f * (in_buffer[0][i] + in_buffer[1][i]);
                in_buffer[1][i] = 0.0f;
            }
        }
        int mf_needed = this.calcNeeded(gfp);
        mfbuf[0] = gfc.mfbuf[0];
        mfbuf[1] = gfc.mfbuf[1];
        int in_bufferPos = 0;
        while (nsamples > 0) {
            int ret;
            float[][] in_buffer_ptr = new float[2][];
            int n_in = 0;
            int n_out = 0;
            in_buffer_ptr[0] = in_buffer[0];
            in_buffer_ptr[1] = in_buffer[1];
            InOut inOut = new InOut();
            this.fill_buffer(gfp, mfbuf, in_buffer_ptr, in_bufferPos, nsamples, inOut);
            n_in = inOut.n_in;
            n_out = inOut.n_out;
            if (gfc.findReplayGain && !gfc.decode_on_the_fly && this.ga.AnalyzeSamples(gfc.rgdata, mfbuf[0], gfc.mf_size, mfbuf[1], gfc.mf_size, n_out, gfc.channels_out) == 0) {
                return -6;
            }
            nsamples -= n_in;
            in_bufferPos += n_in;
            if (gfc.channels_out == 2) {
                // empty if block
            }
            gfc.mf_size += n_out;
            assert (gfc.mf_size <= 3984);
            if (gfc.mf_samples_to_encode < 1) {
                gfc.mf_samples_to_encode = 1728;
            }
            gfc.mf_samples_to_encode += n_out;
            if (gfc.mf_size < mf_needed) continue;
            int buf_size = mp3buf_size - mp3size;
            if (mp3buf_size == 0) {
                buf_size = 0;
            }
            if ((ret = this.lame_encode_frame(gfp, mfbuf[0], mfbuf[1], mp3buf, mp3bufPos, buf_size)) < 0) {
                return ret;
            }
            mp3bufPos += ret;
            mp3size += ret;
            gfc.mf_size -= gfp.framesize;
            gfc.mf_samples_to_encode -= gfp.framesize;
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                for (i = 0; i < gfc.mf_size; ++i) {
                    mfbuf[ch][i] = mfbuf[ch][i + gfp.framesize];
                }
            }
        }
        assert (nsamples == 0);
        return mp3size;
    }

    private int lame_encode_buffer(LameGlobalFlags gfp, short[] buffer_l, short[] buffer_r, int nsamples, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        LameInternalFlags gfc = gfp.internal_flags;
        float[][] in_buffer = new float[2][];
        if (gfc.Class_ID != -487877L) {
            return -3;
        }
        if (nsamples == 0) {
            return 0;
        }
        this.update_inbuffer_size(gfc, nsamples);
        in_buffer[0] = gfc.in_buffer_0;
        in_buffer[1] = gfc.in_buffer_1;
        for (int i = 0; i < nsamples; ++i) {
            in_buffer[0][i] = buffer_l[i];
            if (gfc.channels_in <= 1) continue;
            in_buffer[1][i] = buffer_r[i];
        }
        return this.lame_encode_buffer_sample(gfp, in_buffer[0], in_buffer[1], nsamples, mp3buf, mp3bufPos, mp3buf_size);
    }

    public int lame_encode_buffer_int(LameGlobalFlags gfp, int[] buffer_l, int[] buffer_r, int nsamples, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        LameInternalFlags gfc = gfp.internal_flags;
        float[][] in_buffer = new float[2][];
        if (gfc.Class_ID != -487877L) {
            return -3;
        }
        if (nsamples == 0) {
            return 0;
        }
        this.update_inbuffer_size(gfc, nsamples);
        in_buffer[0] = gfc.in_buffer_0;
        in_buffer[1] = gfc.in_buffer_1;
        for (int i = 0; i < nsamples; ++i) {
            in_buffer[0][i] = (float)buffer_l[i] * 1.5258789E-5f;
            if (gfc.channels_in <= 1) continue;
            in_buffer[1][i] = (float)buffer_r[i] * 1.5258789E-5f;
        }
        return this.lame_encode_buffer_sample(gfp, in_buffer[0], in_buffer[1], nsamples, mp3buf, mp3bufPos, mp3buf_size);
    }

    public final int lame_encode_flush_nogap(LameGlobalFlags gfp, byte[] mp3buffer, int mp3buffer_size) {
        LameInternalFlags gfc = gfp.internal_flags;
        this.bs.flush_bitstream(gfp);
        return this.bs.copy_buffer(gfc, mp3buffer, 0, mp3buffer_size, 1);
    }

    public final void lame_init_bitstream(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfp.frameNum = 0;
        if (gfp.write_id3tag_automatic) {
            this.id3.id3tag_write_v2(gfp);
        }
        gfc.bitrate_stereoMode_Hist = new int[16][5];
        gfc.bitrate_blockType_Hist = new int[16][6];
        gfc.PeakSample = 0.0f;
        if (gfp.bWriteVbrTag) {
            this.vbr.InitVbrTag(gfp);
        }
    }

    public final int lame_encode_flush(LameGlobalFlags gfp, byte[] mp3buffer, int mp3bufferPos, int mp3buffer_size) {
        int mp3buffer_size_remaining;
        int frame_num;
        int end_padding;
        LameInternalFlags gfc = gfp.internal_flags;
        short[][] buffer = new short[2][1152];
        int imp3 = 0;
        int samples_to_encode = gfc.mf_samples_to_encode - 1152;
        int mf_needed = this.calcNeeded(gfp);
        if (gfc.mf_samples_to_encode < 1) {
            return 0;
        }
        int mp3count = 0;
        if (gfp.in_samplerate != gfp.out_samplerate) {
            samples_to_encode = (int)((double)samples_to_encode + 16.0 * (double)gfp.out_samplerate / (double)gfp.in_samplerate);
        }
        if ((end_padding = gfp.framesize - samples_to_encode % gfp.framesize) < 576) {
            end_padding += gfp.framesize;
        }
        gfp.encoder_padding = end_padding;
        for (int frames_left = (samples_to_encode + end_padding) / gfp.framesize; frames_left > 0 && imp3 >= 0; frames_left -= frame_num != gfp.frameNum ? 1 : 0) {
            int bunch = mf_needed - gfc.mf_size;
            frame_num = gfp.frameNum;
            bunch *= gfp.in_samplerate;
            if ((bunch /= gfp.out_samplerate) > 1152) {
                bunch = 1152;
            }
            if (bunch < 1) {
                bunch = 1;
            }
            mp3buffer_size_remaining = mp3buffer_size - mp3count;
            if (mp3buffer_size == 0) {
                mp3buffer_size_remaining = 0;
            }
            imp3 = this.lame_encode_buffer(gfp, buffer[0], buffer[1], bunch, mp3buffer, mp3bufferPos, mp3buffer_size_remaining);
            mp3bufferPos += imp3;
            mp3count += imp3;
        }
        gfc.mf_samples_to_encode = 0;
        if (imp3 < 0) {
            return imp3;
        }
        mp3buffer_size_remaining = mp3buffer_size - mp3count;
        if (mp3buffer_size == 0) {
            mp3buffer_size_remaining = 0;
        }
        this.bs.flush_bitstream(gfp);
        imp3 = this.bs.copy_buffer(gfc, mp3buffer, mp3bufferPos, mp3buffer_size_remaining, 1);
        if (imp3 < 0) {
            return imp3;
        }
        mp3bufferPos += imp3;
        mp3buffer_size_remaining = mp3buffer_size - (mp3count += imp3);
        if (mp3buffer_size == 0) {
            mp3buffer_size_remaining = 0;
        }
        if (gfp.write_id3tag_automatic) {
            this.id3.id3tag_write_v1(gfp);
            imp3 = this.bs.copy_buffer(gfc, mp3buffer, mp3bufferPos, mp3buffer_size_remaining, 0);
            if (imp3 < 0) {
                return imp3;
            }
            mp3count += imp3;
        }
        return mp3count;
    }

    public final int lame_close(LameGlobalFlags gfp) {
        int ret = 0;
        if (gfp != null && gfp.class_id == -487877L) {
            LameInternalFlags gfc = gfp.internal_flags;
            gfp.class_id = 0L;
            if (null == gfc || gfc.Class_ID != -487877L) {
                ret = -3;
            }
            gfc.Class_ID = 0L;
            gfp.internal_flags = null;
            gfp.lame_allocated_gfp = 0;
        }
        return ret;
    }

    private int lame_init_old(LameGlobalFlags gfp) {
        gfp.class_id = -487877L;
        LameInternalFlags gfc = gfp.internal_flags = new LameInternalFlags();
        gfp.mode = MPEGMode.NOT_SET;
        gfp.original = 1;
        gfp.in_samplerate = 44100;
        gfp.num_channels = 2;
        gfp.num_samples = -1;
        gfp.bWriteVbrTag = true;
        gfp.quality = -1;
        gfp.short_blocks = null;
        gfc.subblock_gain = -1;
        gfp.lowpassfreq = 0;
        gfp.highpassfreq = 0;
        gfp.lowpasswidth = -1;
        gfp.highpasswidth = -1;
        gfp.VBR = VbrMode.vbr_off;
        gfp.VBR_q = 4;
        gfp.ATHcurve = -1.0f;
        gfp.VBR_mean_bitrate_kbps = 128;
        gfp.VBR_min_bitrate_kbps = 0;
        gfp.VBR_max_bitrate_kbps = 0;
        gfp.VBR_hard_min = 0;
        gfc.VBR_min_bitrate = 1;
        gfc.VBR_max_bitrate = 13;
        gfp.quant_comp = -1;
        gfp.quant_comp_short = -1;
        gfp.msfix = -1.0f;
        gfc.resample_ratio = 1.0;
        gfc.OldValue[0] = 180;
        gfc.OldValue[1] = 180;
        gfc.CurrentStep[0] = 4;
        gfc.CurrentStep[1] = 4;
        gfc.masking_lower = 1.0f;
        gfc.nsPsy.attackthre = -1.0f;
        gfc.nsPsy.attackthre_s = -1.0f;
        gfp.scale = -1.0f;
        gfp.athaa_type = -1;
        gfp.ATHtype = -1;
        gfp.athaa_loudapprox = -1;
        gfp.athaa_sensitivity = 0.0f;
        gfp.useTemporal = null;
        gfp.interChRatio = -1.0f;
        gfc.mf_samples_to_encode = 1728;
        gfp.encoder_padding = 0;
        gfc.mf_size = 528;
        gfp.findReplayGain = false;
        gfp.decode_on_the_fly = false;
        gfc.decode_on_the_fly = false;
        gfc.findReplayGain = false;
        gfc.findPeakSample = false;
        gfc.RadioGain = 0;
        gfc.AudiophileGain = 0;
        gfc.noclipGainChange = 0;
        gfc.noclipScale = -1.0f;
        gfp.preset = 0;
        gfp.write_id3tag_automatic = true;
        return 0;
    }

    public final LameGlobalFlags lame_init() {
        LameGlobalFlags gfp = new LameGlobalFlags();
        int ret = this.lame_init_old(gfp);
        if (ret != 0) {
            return null;
        }
        gfp.lame_allocated_gfp = 1;
        return gfp;
    }

    public final void lame_bitrate_kbps(LameGlobalFlags gfp, int[] bitrate_kbps) {
        if (null == bitrate_kbps) {
            return;
        }
        if (null == gfp) {
            return;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (gfp.free_format) {
            for (int i = 0; i < 14; ++i) {
                bitrate_kbps[i] = -1;
            }
            bitrate_kbps[0] = gfp.brate;
        } else {
            for (int i = 0; i < 14; ++i) {
                bitrate_kbps[i] = Tables.bitrate_table[gfp.version][i + 1];
            }
        }
    }

    public final void lame_bitrate_hist(LameGlobalFlags gfp, int[] bitrate_count) {
        if (null == bitrate_count) {
            return;
        }
        if (null == gfp) {
            return;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (gfp.free_format) {
            for (int i = 0; i < 14; ++i) {
                bitrate_count[i] = 0;
            }
            bitrate_count[0] = gfc.bitrate_stereoMode_Hist[0][4];
        } else {
            for (int i = 0; i < 14; ++i) {
                bitrate_count[i] = gfc.bitrate_stereoMode_Hist[i + 1][4];
            }
        }
    }

    public final void lame_stereo_mode_hist(LameGlobalFlags gfp, int[] stmode_count) {
        if (null == stmode_count) {
            return;
        }
        if (null == gfp) {
            return;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            stmode_count[i] = gfc.bitrate_stereoMode_Hist[15][i];
        }
    }

    public final void lame_bitrate_stereo_mode_hist(LameGlobalFlags gfp, int[][] bitrate_stmode_count) {
        if (null == bitrate_stmode_count) {
            return;
        }
        if (null == gfp) {
            return;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (gfp.free_format) {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 4; ++i) {
                    bitrate_stmode_count[j][i] = 0;
                }
            }
            for (int i = 0; i < 4; ++i) {
                bitrate_stmode_count[0][i] = gfc.bitrate_stereoMode_Hist[0][i];
            }
        } else {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 4; ++i) {
                    bitrate_stmode_count[j][i] = gfc.bitrate_stereoMode_Hist[j + 1][i];
                }
            }
        }
    }

    public final void lame_block_type_hist(LameGlobalFlags gfp, int[] btype_count) {
        if (null == btype_count) {
            return;
        }
        if (null == gfp) {
            return;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            btype_count[i] = gfc.bitrate_blockType_Hist[15][i];
        }
    }

    public final void lame_bitrate_block_type_hist(LameGlobalFlags gfp, int[][] bitrate_btype_count) {
        if (null == bitrate_btype_count) {
            return;
        }
        if (null == gfp) {
            return;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (gfp.free_format) {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 6; ++i) {
                    bitrate_btype_count[j][i] = 0;
                }
            }
            for (int i = 0; i < 6; ++i) {
                bitrate_btype_count[0][i] = gfc.bitrate_blockType_Hist[0][i];
            }
        } else {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 6; ++i) {
                    bitrate_btype_count[j][i] = gfc.bitrate_blockType_Hist[j + 1][i];
                }
            }
        }
    }

    private static class BandPass {
        public int lowpass;

        public BandPass(int bitrate, int lPass) {
            this.lowpass = lPass;
        }
    }

    protected static class LowPassHighPass {
        double lowerlimit;

        protected LowPassHighPass() {
        }
    }

    protected static class NumUsed {
        int num_used;

        protected NumUsed() {
        }
    }

    protected static class InOut {
        int n_in;
        int n_out;

        protected InOut() {
        }
    }
}

