/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.jump3r;

import de.sciss.jump3r.mp3.BRHist;
import de.sciss.jump3r.mp3.BitStream;
import de.sciss.jump3r.mp3.Enc;
import de.sciss.jump3r.mp3.GainAnalysis;
import de.sciss.jump3r.mp3.GetAudio;
import de.sciss.jump3r.mp3.ID3Tag;
import de.sciss.jump3r.mp3.Lame;
import de.sciss.jump3r.mp3.LameGlobalFlags;
import de.sciss.jump3r.mp3.Parse;
import de.sciss.jump3r.mp3.Presets;
import de.sciss.jump3r.mp3.Quantize;
import de.sciss.jump3r.mp3.QuantizePVT;
import de.sciss.jump3r.mp3.Reservoir;
import de.sciss.jump3r.mp3.Takehiro;
import de.sciss.jump3r.mp3.VBRTag;
import de.sciss.jump3r.mp3.Version;
import de.sciss.jump3r.mpg.Common;
import de.sciss.jump3r.mpg.Interface;
import de.sciss.jump3r.mpg.MPGLib;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public class Main {
    private GetAudio gaud;
    private ID3Tag id3;
    private Lame lame;
    private GainAnalysis ga;
    private BitStream bs;
    private Presets p;
    private QuantizePVT qupvt;
    private Quantize qu;
    private VBRTag vbr;
    private Version ver;
    private Reservoir rv;
    private Takehiro tak;
    private Parse parse;
    private BRHist hist;
    private MPGLib mpg;
    private Interface intf;
    private Common common;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final int MAX_NOGAP = 200;
    private double last_time = 0.0;
    private int oldPercent;
    private int curPercent;
    private int oldConsoleX;
    private static final int MAX_WIDTH = 79;

    public PropertyChangeSupport getSupport() {
        return this.support;
    }

    private int parse_args_from_string(LameGlobalFlags gfp, String argv, StringBuilder inPath, StringBuilder outPath) {
        if (argv == null || argv.length() == 0) {
            return 0;
        }
        StringTokenizer tok = new StringTokenizer(argv, " ");
        ArrayList<String> args = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            args.add(tok.nextToken());
        }
        return this.parse.parse_args(gfp, args, inPath, outPath, null, null);
    }

    public DataOutput init_files(LameGlobalFlags gf, String inPath, String outPath, Enc enc) {
        if (inPath.equals(outPath)) {
            System.err.println("Input file and Output file are the same. Abort.");
            return null;
        }
        this.gaud.init_infile(gf, inPath, enc);
        DataOutput outf = this.gaud.init_outfile(outPath);
        if (outf == null) {
            System.err.printf("Can't init outfile '%s'\n", outPath);
            return null;
        }
        return outf;
    }

    private void lame_decoder(LameGlobalFlags gfp, DataOutput outf, int skip_start, String inPath, String outPath, Enc enc) throws IOException {
        int i;
        int iread;
        short[][] Buffer = new short[2][1152];
        int skip_end = 0;
        int tmp_num_channels = gfp.num_channels;
        if (this.parse.silent < 10) {
            System.out.printf("\rinput:  %s%s(%g kHz, %d channel%s, ", inPath, inPath.length() > 26 ? "\n\t" : "  ", (double)gfp.in_samplerate / 1000.0, tmp_num_channels, tmp_num_channels != 1 ? "s" : "");
        }
        switch (this.parse.input_format) {
            case sf_mp123: {
                throw new RuntimeException("Internal error.  Aborting.");
            }
            case sf_mp3: {
                if (skip_start == 0) {
                    if (enc.enc_delay > -1 || enc.enc_padding > -1) {
                        if (enc.enc_delay > -1) {
                            skip_start = enc.enc_delay + 528 + 1;
                        }
                        if (enc.enc_padding > -1) {
                            skip_end = enc.enc_padding - 529;
                        }
                    } else {
                        skip_start = gfp.encoder_delay + 528 + 1;
                    }
                } else {
                    skip_start += 529;
                }
                if (this.parse.silent >= 10) break;
                System.out.printf("MPEG-%d%s Layer %s", 2 - gfp.version, gfp.out_samplerate < 16000 ? ".5" : "", "III");
                break;
            }
            case sf_mp2: {
                skip_start += 241;
                if (this.parse.silent >= 10) break;
                System.out.printf("MPEG-%d%s Layer %s", 2 - gfp.version, gfp.out_samplerate < 16000 ? ".5" : "", "II");
                break;
            }
            case sf_mp1: {
                skip_start += 241;
                if (this.parse.silent >= 10) break;
                System.out.printf("MPEG-%d%s Layer %s", 2 - gfp.version, gfp.out_samplerate < 16000 ? ".5" : "", "I");
                break;
            }
            case sf_raw: {
                if (this.parse.silent < 10) {
                    System.out.printf("raw PCM data", new Object[0]);
                }
                this.parse.mp3input_data.nsamp = gfp.num_samples;
                this.parse.mp3input_data.framesize = 1152;
                skip_start = 0;
                break;
            }
            case sf_wave: {
                if (this.parse.silent < 10) {
                    System.out.printf("Microsoft WAVE", new Object[0]);
                }
                this.parse.mp3input_data.nsamp = gfp.num_samples;
                this.parse.mp3input_data.framesize = 1152;
                skip_start = 0;
                break;
            }
            case sf_aiff: {
                if (this.parse.silent < 10) {
                    System.out.printf("SGI/Apple AIFF", new Object[0]);
                }
                this.parse.mp3input_data.nsamp = gfp.num_samples;
                this.parse.mp3input_data.framesize = 1152;
                skip_start = 0;
                break;
            }
            default: {
                if (this.parse.silent < 10) {
                    System.out.printf("unknown", new Object[0]);
                }
                this.parse.mp3input_data.nsamp = gfp.num_samples;
                this.parse.mp3input_data.framesize = 1152;
                skip_start = 0;
                assert (false);
                break;
            }
        }
        if (this.parse.silent < 10) {
            System.out.printf(")\noutput: %s%s(16 bit, Microsoft WAVE)\n", outPath, outPath.length() > 45 ? "\n\t" : "  ");
            if (skip_start > 0) {
                System.out.printf("skipping initial %d samples (encoder+decoder delay)\n", skip_start);
            }
            if (skip_end > 0) {
                System.out.printf("skipping final %d samples (encoder padding-decoder delay)\n", skip_end);
            }
        }
        if (this.parse.silent <= 0) {
            System.out.print("|");
            for (int j = 0; j < 77; ++j) {
                System.out.print("=");
            }
            System.out.println("|");
        }
        this.oldConsoleX = 0;
        this.curPercent = 0;
        this.oldPercent = 0;
        if (!this.parse.disable_wav_header) {
            this.gaud.WriteWaveHeader(outf, Integer.MAX_VALUE, gfp.in_samplerate, tmp_num_channels, 16);
        }
        double wavsize = -(skip_start + skip_end);
        this.parse.mp3input_data.totalframes = this.parse.mp3input_data.nsamp / this.parse.mp3input_data.framesize;
        assert (tmp_num_channels >= 1 && tmp_num_channels <= 2);
        do {
            if ((iread = this.gaud.get_audio16(gfp, Buffer)) < 0) continue;
            this.parse.mp3input_data.framenum += iread / this.parse.mp3input_data.framesize;
            wavsize += (double)iread;
            if (this.parse.silent <= 0) {
                this.timestatus(this.parse.mp3input_data.framenum, this.parse.mp3input_data.totalframes);
            }
            i = skip_start < iread ? skip_start : iread;
            skip_start -= i;
            if (skip_end > 1152 && this.parse.mp3input_data.framenum + 2 > this.parse.mp3input_data.totalframes) {
                iread -= skip_end - 1152;
                skip_end = 1152;
            } else if (this.parse.mp3input_data.framenum == this.parse.mp3input_data.totalframes && iread != 0) {
                iread -= skip_end;
            }
            while (i < iread) {
                if (this.parse.disable_wav_header) {
                    if (this.parse.swapbytes) {
                        this.WriteBytesSwapped(outf, Buffer[0], i);
                    } else {
                        this.WriteBytes(outf, Buffer[0], i);
                    }
                    if (tmp_num_channels == 2) {
                        if (this.parse.swapbytes) {
                            this.WriteBytesSwapped(outf, Buffer[1], i);
                        } else {
                            this.WriteBytes(outf, Buffer[1], i);
                        }
                    }
                } else {
                    this.gaud.write16BitsLowHigh(outf, Buffer[0][i] & 0xFFFF);
                    if (tmp_num_channels == 2) {
                        this.gaud.write16BitsLowHigh(outf, Buffer[1][i] & 0xFFFF);
                    }
                }
                ++i;
            }
        } while (iread > 0);
        i = 2 * tmp_num_channels;
        assert (i > 0);
        if (wavsize <= 0.0) {
            if (this.parse.silent < 10) {
                System.err.println("WAVE file contains 0 PCM samples");
            }
            wavsize = 0.0;
        } else if (wavsize > (double)(0xFFFFFFD0L / (long)i)) {
            if (this.parse.silent < 10) {
                System.err.println("Very huge WAVE file, can't set filesize accordingly");
            }
            wavsize = -48.0;
        } else {
            wavsize *= (double)i;
        }
        ((Closeable)((Object)outf)).close();
        if (!this.parse.disable_wav_header) {
            RandomAccessFile rf = new RandomAccessFile(outPath, "rw");
            this.gaud.WriteWaveHeader(rf, (int)wavsize, gfp.in_samplerate, tmp_num_channels, 16);
            rf.close();
        }
        if (this.parse.silent <= 0) {
            System.out.print("|");
            for (int j = 0; j < 77; ++j) {
                System.out.print("=");
            }
            System.out.println("|");
        }
    }

    private void print_lame_tag_leading_info(LameGlobalFlags gf) {
        if (gf.bWriteVbrTag) {
            System.out.println("Writing LAME Tag...");
        }
    }

    private void print_trailing_info(LameGlobalFlags gf) {
        if (gf.bWriteVbrTag) {
            System.out.println("done\n");
        }
        if (gf.findReplayGain) {
            int RadioGain = gf.internal_flags.RadioGain;
            System.out.printf("ReplayGain: %s%.1fdB\n", RadioGain > 0 ? "+" : "", Float.valueOf((float)RadioGain / 10.0f));
            if (RadioGain > 510 || RadioGain < -510) {
                System.out.println("WARNING: ReplayGain exceeds the -51dB to +51dB range. Such a result is too\n         high to be stored in the header.");
            }
        }
        if (this.parse.print_clipping_info && gf.decode_on_the_fly) {
            float noclipGainChange = (float)gf.internal_flags.noclipGainChange / 10.0f;
            float noclipScale = gf.internal_flags.noclipScale;
            if ((double)noclipGainChange > 0.0) {
                System.out.printf("WARNING: clipping occurs at the current gain. Set your decoder to decrease\n         the  gain  by  at least %.1fdB or encode again ", Float.valueOf(noclipGainChange));
                if (noclipScale > 0.0f) {
                    System.out.printf(Locale.US, "using  --scale %.2f\n", Float.valueOf(noclipScale));
                    System.out.print("         or less (the value under --scale is approximate).\n");
                } else {
                    System.out.print("using --scale <arg>\n         (For   a   suggestion  on  the  optimal  value  of  <arg>  encode\n         with  --scale 1  first)\n");
                }
            } else if ((double)noclipGainChange > -0.1) {
                System.out.print("\nThe waveform does not clip and is less than 0.1dB away from full scale.\n");
            } else {
                System.out.printf("\nThe waveform does not clip and is at least %.1fdB away from full scale.\n", Float.valueOf(-noclipGainChange));
            }
        }
    }

    private int write_xing_frame(LameGlobalFlags gf, RandomAccessFile outf) {
        byte[] mp3buffer = new byte[147456];
        int imp3 = this.vbr.getLameTagFrame(gf, mp3buffer);
        if (imp3 > mp3buffer.length) {
            System.err.printf("Error writing LAME-tag frame: buffer too small: buffer size=%d  frame size=%d\n", mp3buffer.length, imp3);
            return -1;
        }
        if (imp3 <= 0) {
            return 0;
        }
        try {
            outf.write(mp3buffer, 0, imp3);
        }
        catch (IOException e) {
            System.err.println("Error writing LAME-tag");
            return -1;
        }
        return imp3;
    }

    private int lame_encoder(LameGlobalFlags gf, DataOutput outf, boolean nogap, String inPath, String outPath) {
        int iread;
        byte[] mp3buffer = new byte[147456];
        int[][] Buffer = new int[2][1152];
        this.encoder_progress_begin(gf, inPath, outPath);
        int imp3 = this.id3.lame_get_id3v2_tag(gf, mp3buffer, mp3buffer.length);
        if (imp3 > mp3buffer.length) {
            this.encoder_progress_end(gf);
            System.err.printf("Error writing ID3v2 tag: buffer too small: buffer size=%d  ID3v2 size=%d\n", mp3buffer.length, imp3);
            return 1;
        }
        try {
            outf.write(mp3buffer, 0, imp3);
        }
        catch (IOException e) {
            this.encoder_progress_end(gf);
            System.err.printf("Error writing ID3v2 tag \n", new Object[0]);
            return 1;
        }
        int id3v2_size = imp3;
        do {
            if ((iread = this.gaud.get_audio(gf, Buffer)) < 0) continue;
            this.encoder_progress(gf);
            imp3 = this.lame.lame_encode_buffer_int(gf, Buffer[0], Buffer[1], iread, mp3buffer, 0, mp3buffer.length);
            if (imp3 < 0) {
                if (imp3 == -1) {
                    System.err.printf("mp3 buffer is not big enough... \n", new Object[0]);
                } else {
                    System.err.printf("mp3 internal error:  error code=%d\n", imp3);
                }
                return 1;
            }
            try {
                outf.write(mp3buffer, 0, imp3);
            }
            catch (IOException e) {
                this.encoder_progress_end(gf);
                System.err.printf("Error writing mp3 output \n", new Object[0]);
                return 1;
            }
        } while (iread > 0);
        imp3 = nogap ? this.lame.lame_encode_flush_nogap(gf, mp3buffer, mp3buffer.length) : this.lame.lame_encode_flush(gf, mp3buffer, 0, mp3buffer.length);
        if (imp3 < 0) {
            if (imp3 == -1) {
                System.err.printf("mp3 buffer is not big enough... \n", new Object[0]);
            } else {
                System.err.printf("mp3 internal error:  error code=%d\n", imp3);
            }
            return 1;
        }
        this.encoder_progress_end(gf);
        try {
            outf.write(mp3buffer, 0, imp3);
        }
        catch (IOException e) {
            this.encoder_progress_end(gf);
            System.err.printf("Error writing mp3 output \n", new Object[0]);
            return 1;
        }
        imp3 = this.id3.lame_get_id3v1_tag(gf, mp3buffer, mp3buffer.length);
        if (imp3 > mp3buffer.length) {
            System.err.printf("Error writing ID3v1 tag: buffer too small: buffer size=%d  ID3v1 size=%d\n", mp3buffer.length, imp3);
        } else if (imp3 > 0) {
            try {
                outf.write(mp3buffer, 0, imp3);
            }
            catch (IOException e) {
                this.encoder_progress_end(gf);
                System.err.printf("Error writing ID3v1 tag \n", new Object[0]);
                return 1;
            }
        }
        if (this.parse.silent <= 0) {
            this.print_lame_tag_leading_info(gf);
        }
        try {
            ((Closeable)((Object)outf)).close();
            RandomAccessFile rf = new RandomAccessFile(outPath, "rw");
            rf.seek(id3v2_size);
            this.write_xing_frame(gf, rf);
            rf.close();
        }
        catch (IOException e) {
            System.err.printf("fatal error: can't update LAME-tag frame!\n", new Object[0]);
        }
        this.print_trailing_info(gf);
        return 0;
    }

    private void brhist_init_package(LameGlobalFlags gf) {
        if (this.parse.brhist) {
            if (this.hist.brhist_init(gf, gf.VBR_min_bitrate_kbps, gf.VBR_max_bitrate_kbps) != 0) {
                this.parse.brhist = false;
            }
        } else {
            this.hist.brhist_init(gf, 128, 128);
        }
    }

    private void parse_nogap_filenames(int nogapout, String inPath, StringBuilder outPath, StringBuilder outdir) {
        outPath.setLength(0);
        outPath.append((CharSequence)outdir);
        if (0 == nogapout) {
            outPath.setLength(0);
            outPath.append(inPath);
            if (outPath.toString().endsWith(".wav")) {
                outPath.setLength(0);
                outPath.append(outPath.substring(0, outPath.length() - 4) + ".mp3");
            } else {
                outPath.setLength(0);
                outPath.append(outPath + ".mp3");
            }
        } else {
            int slasher = inPath.lastIndexOf(System.getProperty("file.separator"));
            if (slasher != 0 && (outPath.toString().endsWith(System.getProperty("file.separator")) || outPath.toString().endsWith(":"))) {
                ++slasher;
            } else if (slasher == 0 && (!outPath.toString().endsWith(System.getProperty("file.separator")) || outPath.toString().endsWith(":"))) {
                outPath.append(System.getProperty("file.separator"));
            }
            outPath.append(inPath.substring(slasher));
            if (outPath.toString().endsWith(".wav")) {
                String string = outPath.substring(0, outPath.length() - 4) + ".mp3";
                outPath.setLength(0);
                outPath.append(string);
            } else {
                String string = outPath + ".mp3";
                outPath.setLength(0);
                outPath.append(string);
            }
        }
    }

    public static final void main(String[] args) {
        try {
            new Main().run(args);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int run(String[] args) throws IOException {
        DataOutput outf;
        this.lame = new Lame();
        this.gaud = new GetAudio();
        this.ga = new GainAnalysis();
        this.bs = new BitStream();
        this.p = new Presets();
        this.qupvt = new QuantizePVT();
        this.qu = new Quantize();
        this.vbr = new VBRTag();
        this.ver = new Version();
        this.id3 = new ID3Tag();
        this.rv = new Reservoir();
        this.tak = new Takehiro();
        this.parse = new Parse();
        this.hist = new BRHist();
        this.mpg = new MPGLib();
        this.intf = new Interface();
        this.common = new Common();
        this.lame.setModules(this.ga, this.bs, this.p, this.qupvt, this.qu, this.vbr, this.ver, this.id3, this.mpg);
        this.bs.setModules(this.ga, this.mpg, this.ver, this.vbr);
        this.id3.setModules(this.bs, this.ver);
        this.p.setModules(this.lame);
        this.qu.setModules(this.bs, this.rv, this.qupvt, this.tak);
        this.qupvt.setModules(this.tak, this.rv, this.lame.enc.psy);
        this.rv.setModules(this.bs);
        this.tak.setModules(this.qupvt);
        this.vbr.setModules(this.lame, this.bs, this.ver);
        this.gaud.setModules(this.parse, this.mpg);
        this.parse.setModules(this.ver, this.id3, this.p);
        this.mpg.setModules(this.intf, this.common);
        this.intf.setModules(this.vbr, this.common);
        StringBuilder outPath = new StringBuilder();
        StringBuilder nogapdir = new StringBuilder();
        StringBuilder inPath = new StringBuilder();
        Enc enc = new Enc();
        int nogapout = 0;
        int max_nogap = 200;
        String[] nogap_inPath = new String[max_nogap];
        this.parse.input_format = GetAudio.sound_file_format.sf_unknown;
        LameGlobalFlags gf = this.lame.lame_init();
        if (args.length < 1) {
            this.parse.usage(System.err, "lame");
            this.lame.lame_close(gf);
            return 1;
        }
        this.parse_args_from_string(gf, System.getenv("LAMEOPT"), inPath, outPath);
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsList.add(args[i]);
        }
        Parse.NoGap ng = new Parse.NoGap();
        int ret = this.parse.parse_args(gf, argsList, inPath, outPath, nogap_inPath, ng);
        max_nogap = ng.num_nogap;
        if (ret < 0) {
            this.lame.lame_close(gf);
            return ret == -2 ? 0 : 1;
        }
        if ((double)this.parse.update_interval < 0.0) {
            this.parse.update_interval = 2.0f;
        }
        if (outPath.length() != 0 && max_nogap > 0) {
            nogapdir = outPath;
            nogapout = 1;
        }
        if (max_nogap > 0) {
            this.parse_nogap_filenames(nogapout, nogap_inPath[0], outPath, nogapdir);
            outf = this.init_files(gf, nogap_inPath[0], outPath.toString(), enc);
        } else {
            outf = this.init_files(gf, inPath.toString(), outPath.toString(), enc);
        }
        if (outf == null) {
            this.lame.lame_close(gf);
            return -1;
        }
        gf.write_id3tag_automatic = false;
        int i = this.lame.lame_init_params(gf);
        if (i < 0) {
            if (i == -1) {
                this.parse.display_bitrates(System.err);
            }
            System.err.println("fatal error during initialization");
            this.lame.lame_close(gf);
            return i;
        }
        if (this.parse.silent > 0) {
            this.parse.brhist = false;
        }
        if (gf.decode_only) {
            if (this.parse.mp3_delay_set) {
                this.lame_decoder(gf, outf, this.parse.mp3_delay, inPath.toString(), outPath.toString(), enc);
            } else {
                this.lame_decoder(gf, outf, 0, inPath.toString(), outPath.toString(), enc);
            }
        } else if (max_nogap > 0) {
            for (i = 0; i < max_nogap; ++i) {
                boolean use_flush_nogap;
                boolean bl = use_flush_nogap = i != max_nogap - 1;
                if (i > 0) {
                    this.parse_nogap_filenames(nogapout, nogap_inPath[i], outPath, nogapdir);
                    outf = this.init_files(gf, nogap_inPath[i], outPath.toString(), enc);
                    this.lame.lame_init_bitstream(gf);
                }
                this.brhist_init_package(gf);
                gf.internal_flags.nogap_total = max_nogap;
                gf.internal_flags.nogap_current = i;
                ret = this.lame_encoder(gf, outf, use_flush_nogap, nogap_inPath[i], outPath.toString());
                ((Closeable)((Object)outf)).close();
                this.gaud.close_infile();
            }
        } else {
            this.brhist_init_package(gf);
            ret = this.lame_encoder(gf, outf, false, inPath.toString(), outPath.toString());
            ((Closeable)((Object)outf)).close();
            this.gaud.close_infile();
        }
        this.lame.lame_close(gf);
        return ret;
    }

    private void encoder_progress_begin(LameGlobalFlags gf, String inPath, String outPath) {
        if (this.parse.silent < 10) {
            this.lame.lame_print_config(gf);
            System.out.printf("Encoding %s%s to %s\n", inPath, inPath.length() + outPath.length() < 66 ? "" : "\n     ", outPath);
            System.out.printf("Encoding as %g kHz ", 0.001 * (double)gf.out_samplerate);
            String[][] mode_names = new String[][]{{"stereo", "j-stereo", "dual-ch", "single-ch"}, {"stereo", "force-ms", "dual-ch", "single-ch"}};
            switch (gf.VBR) {
                case vbr_rh: {
                    System.out.printf("%s MPEG-%d%s Layer III VBR(q=%g) qval=%d\n", mode_names[gf.force_ms ? 1 : 0][gf.mode.ordinal()], 2 - gf.version, gf.out_samplerate < 16000 ? ".5" : "", Float.valueOf((float)gf.VBR_q + gf.VBR_q_frac), gf.quality);
                    break;
                }
                case vbr_mt: 
                case vbr_mtrh: {
                    System.out.printf("%s MPEG-%d%s Layer III VBR(q=%d)\n", mode_names[gf.force_ms ? 1 : 0][gf.mode.ordinal()], 2 - gf.version, gf.out_samplerate < 16000 ? ".5" : "", gf.quality);
                    break;
                }
                case vbr_abr: {
                    System.out.printf("%s MPEG-%d%s Layer III (%gx) average %d kbps qval=%d\n", mode_names[gf.force_ms ? 1 : 0][gf.mode.ordinal()], 2 - gf.version, gf.out_samplerate < 16000 ? ".5" : "", 0.1 * (double)((int)(10.0 * (double)gf.compression_ratio + 0.5)), gf.VBR_mean_bitrate_kbps, gf.quality);
                    break;
                }
                default: {
                    System.out.printf("%s MPEG-%d%s Layer III (%gx) %3d kbps qval=%d\n", mode_names[gf.force_ms ? 1 : 0][gf.mode.ordinal()], 2 - gf.version, gf.out_samplerate < 16000 ? ".5" : "", 0.1 * (double)((int)(10.0 * (double)gf.compression_ratio + 0.5)), gf.brate, gf.quality);
                }
            }
            if (this.parse.silent <= -10) {
                this.lame.lame_print_internals(gf);
            }
            System.out.print("|");
            for (int i = 0; i < 77; ++i) {
                System.out.print("=");
            }
            System.out.println("|");
            this.oldConsoleX = 0;
            this.curPercent = 0;
            this.oldPercent = 0;
        }
    }

    private void encoder_progress(LameGlobalFlags gf) {
        if (this.parse.silent <= 0) {
            int frames = gf.frameNum;
            if (this.parse.update_interval <= 0.0f) {
                if (frames % 100 != 0) {
                    return;
                }
            } else {
                double act;
                double dif;
                if (frames != 0 && frames != 9 && (dif = (act = (double)System.currentTimeMillis()) - this.last_time) >= 0.0 && dif < (double)this.parse.update_interval) {
                    return;
                }
                this.last_time = System.currentTimeMillis();
            }
            if (this.parse.brhist) {
                this.hist.brhist_jump_back();
            }
            this.timestatus(gf.frameNum, this.lame_get_totalframes(gf));
            if (this.parse.brhist) {
                this.hist.brhist_disp(gf);
            }
        }
    }

    private void encoder_progress_end(LameGlobalFlags gf) {
        if (this.parse.silent <= 0) {
            if (this.parse.brhist) {
                this.hist.brhist_jump_back();
            }
            this.timestatus(gf.frameNum, this.lame_get_totalframes(gf));
            if (this.parse.brhist) {
                this.hist.brhist_disp(gf);
            }
            System.out.print("|");
            for (int i = 0; i < 77; ++i) {
                System.out.print("=");
            }
            System.out.println("|");
        }
    }

    private void timestatus(int frameNum, int totalframes) {
        int percent = frameNum < totalframes ? (int)(100.0 * (double)frameNum / (double)totalframes + 0.5) : 100;
        boolean stepped = false;
        if (this.oldPercent != percent) {
            this.progressStep();
            stepped = true;
        }
        this.oldPercent = percent;
        if (percent == 100) {
            for (int i = this.curPercent; i < 100; ++i) {
                this.progressStep();
                stepped = true;
            }
        }
        if (percent == 100 && stepped) {
            System.out.println();
        }
    }

    private void progressStep() {
        ++this.curPercent;
        float consoleX = (float)this.curPercent * 79.0f / 100.0f;
        if ((int)consoleX != this.oldConsoleX) {
            System.out.print(".");
        }
        this.oldConsoleX = (int)consoleX;
        this.support.firePropertyChange("progress", this.oldPercent, this.curPercent);
    }

    private int lame_get_totalframes(LameGlobalFlags gfp) {
        int totalframes = (int)(2.0 + (double)gfp.num_samples * (double)gfp.out_samplerate / ((double)gfp.in_samplerate * (double)gfp.framesize));
        return totalframes;
    }

    private void WriteBytesSwapped(DataOutput fp, short[] p, int pPos) throws IOException {
        fp.writeShort(p[pPos]);
    }

    private void WriteBytes(DataOutput fp, short[] p, int pPos) throws IOException {
        fp.write(p[pPos] & 0xFF);
        fp.write((p[pPos] & 0xFFFF) >> 8 & 0xFF);
    }
}

