/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.internal.SuggestionsHidden;
import com.teamdev.jxbrowser.browser.event.internal.SuggestionsUpdated;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.view.swing.internal.menu.SuggestionsPopup;

public final class SuggestionsListener {
    private final Browser browser;
    private Subscription subscriptionToUpdate;
    private Subscription subscriptionToHide;

    public SuggestionsListener(Browser browser) {
        Preconditions.checkNotNull((Object)browser);
        this.browser = browser;
    }

    public void startEventsProcessing() {
        this.subscriptionToUpdate = this.browser.on(SuggestionsUpdated.class, this::onSuggestionsUpdated);
        this.subscriptionToHide = this.browser.on(SuggestionsHidden.class, this::onSuggestionsHidden);
    }

    public void stopEventsProcessing() {
        this.subscriptionToUpdate.unsubscribe();
        this.subscriptionToHide.unsubscribe();
    }

    private void onSuggestionsUpdated(SuggestionsUpdated event) {
        SuggestionsPopup.fromBrowser(event.browser().id()).ifPresent(suggestionsPopup -> suggestionsPopup.updateSuggestions(event.suggestions()));
    }

    private void onSuggestionsHidden(SuggestionsHidden event) {
        SuggestionsPopup.fromBrowser(event.browser().id()).ifPresent(SuggestionsPopup::hide);
    }
}

