/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DistortedUtfBom;
import com.teamdev.jxbrowser.view.swing.internal.dnd.RichDataFlavor;
import com.teamdev.jxbrowser.view.swing.internal.dnd.StringDataFlavor;
import com.teamdev.jxbrowser.view.swing.internal.dnd.WindowsHtmlClipboardFormat;
import java.awt.datatransfer.Transferable;
import java.util.List;

final class HtmlDataType
extends DataType {
    private final StringDataFlavor htmlFlavor = StringDataFlavor.newInstance("text/html");

    HtmlDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        if (!this.isPresentedIn(transferable)) {
            return;
        }
        String html = this.htmlFlavor.read(transferable);
        if (Environment.isWindows()) {
            html = WindowsHtmlClipboardFormat.removeMetaData(html);
        }
        if (Environment.isLinux()) {
            if (DistortedUtfBom.isFound(html)) {
                html = DistortedUtfBom.truncate(html);
            }
            html = html.replaceAll("\u0000", "");
        }
        dropData.setHtml(html);
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
        metadata.setContainsHtml(true);
    }

    @Override
    protected List<? extends RichDataFlavor<?>> supportedFlavors() {
        return ImmutableList.of((Object)this.htmlFlavor);
    }
}

