<%--------------------------------

		sections.inc - index page sections 

--------------------------------%><%
	
	var	getFolderThumb = function(ao) {
				var vars = ao.getVars(),
					s;

				// Iconpath => SVG, folder thumb path
				if (s = vars.get('iconPath')) {
					s = s.replace('folder.png', defaultFolderIconName);
					return s.replace(/^\.\.\//, '');
				} else {
					return createFolderThumb(ao, folderThumbSize, true);
				}
			},
			
		getNewImagesContent = function(ao) {
				var vars = ao.getVars(),
					t = vars.get('fileTitle'),
					d;
				
				d = {
						fn:				'collectByDate',
						start:			today - (vars.get('newImagesDays') || 30),
						depth:			vars.get('newImagesDepth') || 'tree',
						sortBy:			vars.get('newImagesSort') || 'date',
						reference:		vars.get('newImagesSource') || 'dateTaken',
						reverse:		vars.get('newImagesReverse') || false,
						linkMore:		vars.get('closeupPath')
					};
				
				return (t? ('<h4>' + t + '</h4>') : '') + 
					'<div class="new-images single-row" data-jalbum-query=\'' + JSON.stringify(d) + '\'></div>';
			},
			
		getMosaic = function(folder, cp) {
				// Mosaic
				var rao = folder.getRepresentingAlbumObject(),
					imgs = getRandomChildren(folder, 3, 'image,video,folder,webLocation', true, rao? rao.getName() : null),
					sb = '',
					co = getCountObj(folder, false),
					ti = (typeof co !== UNDEF)? (co.image + co.audio + co.video) : 0;
					
				if (imgs.length >= 1) {
					
					for (var i = 0, ic, tp, cat, vars, l = imgs.length; i < l; i++) {
						vars = imgs[i].getVars();
						
						if (vars) {
							cat = imgs[i].getCategory();
							
							if (cat === Category.folder && vars.get('iconPath')) {
								// No folder thumbnail
								tp = resPath + '/' + defaultFolderIconName;
								ic = 'icon ';
							} else {
								//print(imgs[i] + ' thumbPath="' + getThumbPath(imgs[i]) + '"');
								tp = getThumbPath(imgs[i]);
								ic = '';
							}
							
							sb += '<a href="' + cp +
									((cat === Category.folder || cat === Category.webLocation || i === l - 1)? '' : ('#img=' + imgs[i].getWebName())) + 
									'"' + 
									ask + 
									' class="' + ic + ((i >= preloadThumbs)? 'lazyload" data-src="' : 'preload">' +
										'<img src="') + tp + '"' + 
											(addAltTags? (' alt="' + [ stripHTML(vars.get('title'), shorten(vars.get('comment'), 120, true)).trim() ].filter(Boolean).join(' ') + '"') : '') + 
										'>' + 
								((i === l - 1)? ('<span>+' + ((ti > imgs.length)? ('<small>' + (ti - imgs.length) + '</small>') : '') + '</span>') : '') +
							'</a>';
						}
					}
				}
				
				return sb? ('<div class="mosaic">' + sb + '</div>') : '';
			},
							
		getPageThumbnail = function(ao) {
				var vars = ao.getVars(),
					s,
					c;
					
				s = '<h4><a class="icon-' + getPageIcon(ao) + '" href="' + vars.get('closeupPath') + '"> ' + vars.get('title') + '</a></h4>';
				
				if (showPages === 'excerpt') {
					c = vars.get('aboutText') || vars.get('comment');
					
					if (c) {
						var i = c.indexOf('<!--more-->'); 
						s += '<div class="caption">' +
								((i > 0)? c.substring(0, i) : shorten(c)) +
							'</div>';
					}
				}
				
				return '<div class="card">' + s + '</div>';
			};
			
	/******************************************************************
	 *
	 *						Main Content
	 *
	 ******************************************************************/
	
	for each (section in sectionsOrder.split('\t')) {
		
		switch (section) {
			
			case 'folders':
				
				var folders = getChildrenOfType(currentFolder, 'folder' + (hideWeblocations? '' : ',webLocation'));
				
				if (folders.length) {
					
					var vars,
						c,
						cp,
						ip,
						tp,
						ftw = folderThumbDims.split('x')[0],
						fth = folderThumbDims.split('x')[1],
						rao,
						icon,
						alt,
						ask,
						wl;

					// Creating folders section
					out.println('\t\t\t\t<section class="folders hide-on-overlay">');
						out.println('\t\t\t\t\t<div class="' +
								[	'cont',
									'caption-' + folderCaptionPlacement, 
									'thumbs-' + (fixedShapeFolderThumbs? 'fill':'fit')
								].filter(Boolean).join(' ') +
							'">');
					
					for (var i = 0; i < folders.length; i++) {
						
						vars = folders[i].getVars();
						c = vars.get('thumbCaption');
						cp = getExternalLink(vars) || vars.get('closeupPath');
						ip = vars.get('iconPath');
						view = vars.get('folderViewName') || '';
						tp = vars.get('folderThumbPath') || vars.get('thumbPath');
						alt = addAltTags? (stripQuot(stripHTML(vars.get('title') + ' ' + shorten(vars.get('comment'), 120, true))).trim()) : '';
						ask = vars.get('askPermission');
						wl = folders[i].getCategory() === Category.webLocation;
						co = getCountObj(folders[i], false);
						rao = folders[i].getRepresentingAlbumObject(),
						mosaic = '';
						
						if (typeof folderMosaic !== UNDEF && folderMosaic) {
							mosaic = getMosaic(folders[i], cp);
						}
						
						if (ip || !tp) {
							tp = resPath + '/' + defaultFolderIconName;
						}
						
						if (!fixedShapeFolderThumbs) {
							// Variable folder thumb dimensions
							ftw = vars.get('folderThumbWidth');
							fth = vars.get('folderThumbHeight');
						}
						
						if (linkFolderTitle) {
							c = c.replace(/<(h3|h4)([^>]*)>/, '<$1$2><a href="' + cp + '">').replace(/<\/(h3|h4)>/, '</a></$1>');
						}
						
						cnt = showFolderImageCount? (vars.get('counts') || '') : '';
						ask = (ask !== null)? (' data-ask-permission=\'' + ask.replace(/'/g, '&apos;') + '\'') : '';		//'
						ti = (typeof co !== UNDEF)? (co.image + co.audio + co.video) : 0;
						
						// Card
						out.print('\t\t\t\t\t\t<div class="' + 
									[	'card',
										'folder',
										(i < preloadThumbs)? 'preload' : 'lazyload',
										(mosaic && mosaic.length)? 'hasmosaic' : 'nomosaic',
										(folders[i] instanceof VirtualFolder)? ('view ' + getFolderView(folders[i])) : '',
										wl? 'webloc' : '',
										cnt? 'has-count' : ''
									].filter(Boolean).join(' ') +  
								'">');
							// Thumbnail image
							out.print('<a href="' + cp + '" class="thumb' + (ip? ' icon' : '') + '"' + 
										ask + 			
										// Open in new tab?
										((wl && webLocationOpenNew)? ' target="_blank"' : '') + 
										// Passing along thumbPath and alt for lazy loaded folders
										((i >= preloadThumbs)? 
											(' data-src="' + tp + '"' + (alt? (' data-alt="' + alt + '"') : '') + 
												' data-width="' + ftw + '" data-height="' + fth + '">'
											)
											:
											('><img src="' + tp + '"' + (alt? (' alt="' + alt + '"') : '') + 
												' width="' + ftw + '" height="' + fth + '">'
											)
										) +
								'</a>');
							
							if (mosaic && mosaic.length) {
								// Mosaic
								out.print(mosaic);
							}
							
							// Caption
							if (c) {
								out.print('<div class="caption">' + c + cnt + '</div>');
							}
							
						out.println('</div>');
					}
					
					out.println('\t\t\t\t\t</div>\n\t\t\t\t</section>');
				}
				
				break;
				
			case 'pages':
				
				if (showPages !== 'none') {
					var pages = getChildrenOfType(currentFolder, 'webPage'),
						s;
					
					if (pages.length) {
						// Creating pages section
						out.println('\t\t\t\t<section class="pages hide-on-overlay">\n' +
								'\t\t\t\t\t<div class="cont pages-cont ' + 
									(showPages === 'embedCustom'? 'embed' : showPages) +
								'">');
						
						if (showPages === 'embed' || showPages === 'embedCustom') {
							
							if (showPages === 'embedCustom') {
								// Show predefined pages as links first
								for each (var ao in pages) {
									if (isPredefinedPage(ao)) {
										out.print(getPageThumbnail(ao));
									}
								}
							}
							
							for each (var ao in pages) {
								// Embed custom pages
								//print('pages[' + i + '] = ' + JSON.stringify(pages[i]));
								if (!ao.isHidden()) {
									var nm = getOriginalPageName(ao, 'user');
									
									if (showPages === 'embed' || nm === 'user') {
										s = (nm === 'newimages')? 
											getNewImagesContent(ao)
											:
											getCustomPageContent(ao);
										
										//print(pages[i].getName() + ' (' + nm + ')');
										if (s) {
											out.println('\t\t\t\t\t\t\t<div class="custom ' + nm + '-page' + (useBoxForPages? ' boxed' : '') + '">');
											out.println('\t\t\t\t\t\t\t\t<div class="page-wrap">\n' + s + '\n\t\t\t\t\t\t\t\t</div>');
											out.println('\t\t\t\t\t\t\t</div>');
										}
									}
								}
							}
							
						} else {
							s = '';
							
							for each (var ao in pages) {
								if (!ao.isHidden()) {
									out.println('\t\t\t\t\t\t' + getPageThumbnail(ao));
								}
							}
						}
						
						out.println('\t\t\t\t\t</div>\n\t\t\t\t</section>');
					}
					
				}
				
				break;
					
			case 'images':
				
				var images = getChildrenOfType(currentFolder, 'image,audio,video,other');
					
				if (images.length) {
					
					var vars,
						cat,
						alt,
						c,
						tw,
						th,
						ar,
						ip,
						tp,
						icon,
						justified = thumbLayout === 'justified';
				
					// Creating thumbnails section
					out.println('\t\t\t\t<section class="thumbnails hide-on-overlay" data-overlay="base">');
						out.println('\t\t\t\t\t<div class="' +
								[	'cont',
									'base',
									thumbLayout, 
									'caption-' + captionPlacement,
									(captionPlacement !== 'below' && captionShowOnHover)? ' caption-on-hover' : ''
								].filter(Boolean).join(' ') +
							'">')
					
					// Iterate through normal thumbnails (images)
					for (var i = 0; i < images.length; i++) {
						
						if (i >= preloadThumbs) {
							break;
						}
						
						vars = images[i].getVars();
						cat = images[i].category;
						alt = addAltTags? (' alt="' + stripHTML(vars.get('title') + ' ' + vars.get('commentShort')).trim() + '"') : '';
						c = vars.get('thumbCaption');
						tw = vars.get('thumbWidth');
						th = vars.get('thumbHeight');
						ar = tw / th;
						tp = vars.get('thumbPath');
						icon = vars.get('iconPath');
						
						if (vars.get('imageAttachmentPath') !== null) {
							// Has representing image: don't use the icon
							icon = null;
						}
						
						switch (cat) {
							case 'image':
								ip = vars.get('imagePath');
								break;
							case 'video':
								ip = vars.get('videoPath');
								break;
							default:
								ip = vars.get('originalPath') || vars.get('imagePath');
						}

						out.println('\t\t\t\t\t\t<div class="' + 
									[
										'card',
										'preload',
										cat,
										c? 'hascaption' : '',
										((tw < maxThumbWidth && th < maxThumbHeight)? 'tiny' : ''),
										icon? 'icon' : '',
										(ar >= 1.25)? 'landscape' : ((ar <= 0.8)? 'portrait' : 'square')
									].filter(Boolean).join(' ') +
								'">' +
								'<a class="thumb' + 
									(icon? ' iconthumb' : '') +
									(((tw < maxThumbWidth) && (th < maxThumbHeight))? ' tiny' : '') +
									'" href="' + ip  + '">' +
									'<img src="' + tp + '"' +
										(!icon? (' width="' + tw + '" height="' + th + '"') : '') +
										alt +
									'>' +
								'</a>' +
								// Max width needed to avoid a long caption stretches out the thumb
								(c? ('<div class="caption"' + 
										(justified? (' style="max-width:' + tw + 'px"') : '') + 
									'>' + c + '</div>') : '') +
							'</div>');
					}
					
					out.println('\t\t\t\t\t</div>\n\t\t\t\t</section>');
					
				}
				
				break;
				
			case 'map':
			
				if (showMapSection && (typeof locationCount !== UNDEF) && locationCount) {
					out.println('\t\t\t\t<section class="map hide-on-overlay" data-rel="base">');
						out.println('\t\t\t\t\t<div class="cont box">' +
								'<div class="map-root" data-map-root></div>' +
							'</div>');
					out.println('\t\t\t\t</section>');
				}
				
				break;
				
			case 'filtering':
				
				if ((typeof lightboxableCount !== UNDEF) && lightboxableCount > 1 && (_useFilters || _useSort)) {
					
					out.print('\t\t\t\t<section class="filter-cont" id="filters"' + 
								(filteringBoxSticky? ' data-sticky' : '') +
							'><div class="cont box small-column">');
					
					if (_useFilters && filterLabel || _useSort && sortLabel) {
						var l = '';
						
						if (_useFilters && filterLabel) {
							l = filterLabel;
						}
						
						if (_useSort && sortLabel) {
							l += (l.length? ' / ' : '') + sortLabel;
						}
						
						out.println('\t\t\t\t\t<h4 class="title icon-' + (_useFilters? 'filter' : 'ordering') + '"> ' +  l + '</h4>');
					}
					
					if (_useFilters) {
						out.println('\t\t\t\t\t<form class="filter"></form>');
					}
						
					if (_useSort) {
						out.println('\t\t\t\t\t<form class="sort"></form>');
					}
					
					out.println('\t\t\t\t</div></section>');
				}
				
				break;
				
			case 'shoppingCart':
				
				if (_useShop) {
					
					out.println('\t\t\t\t<section id="shop" class="shop-cont' + 
							((showShopOnImagePagesOnly && !shopCount)? ' hide-on-empty' : '') + '"' +
							(shopBoxSticky? ' data-sticky' : '') +
						'><div class="cont box">');
					
					if (shopLabel) {
						out.println('\t\t\t\t\t<h4 class="title icon-shopping-cart"> ' +  shopLabel + '</h4>');
					}
					
					out.println('\t\t\t\t\t<div class="select-box">' +
							'<label>' + getText('select') + '</label> ' +
							'<div class="buttons">' + 
								'<a class="select-all small button">' + getText('all') + 	'</a>' + 
								'<a class="select-none small button">' + getText('none') + '</a>' + 
								'<a class="keep-selected icon-filter small button"> ' + getText('keepOnlySelected') + '</a>' +
							'</div></div>');
					
					out.println('\t\t\t\t\t<div id="shop-root" class="shop-root" data-shop-root></div>');
					
					if (shopInstructionsBox) {
						out.println('\t\t\t\t\t<div class="instructions">' + getProcessed(shopInstructionsBox) + '</div>');
					}
					
					out.println('\t\t\t\t</div></section>');
				}
				
				break;
				
			case 'feedback':
				
				if (_useFeedback) {
					
					out.println('\t\t\t\t<section id="feedback" class="feedback-cont' + 
							((showFeedbackOnImagePagesOnly && !lightboxableCount)? ' hide-on-empty' : '') + '"' +
							(feedbackBoxSticky? ' data-sticky' : '') +
						'><div class="cont box">');
					
					out.println('\t\t\t\t\t<h4 class="title icon-email-send"> ' +  (feedbackLabel || getText('feedback')) + '</h4>');
					
					out.println('\t\t\t\t\t<div class="select-box">' +
							'<label>' + getText('select') + '</label>' +
							'<div class="buttons">' + 
								'<a class="select-all small button">' + getText('all') + 	'</a>' + 
								'<a class="select-none small button">' + getText('none') + '</a>' + 
								'<a class="keep-selected icon-filter small button"> ' + getText('keepOnlySelected') + '</a>' +
							'</div></div>');
										
					out.println('\t\t\t\t\t<div id="feedback-root" class="feedback-root" data-feedback-root></div>');
					
					if (feedbackInstructionsBox) {
						out.println('\t\t\t\t\t<div class="instructions">' + getProcessed(feedbackInstructionsBox) + '</div>');
					}
					
					out.println('\t\t\t\t</div></section>');
				}
				
				break;
				
			case 'neighboringFolders':
				
				if (level && linkNeighboringFolders) {

					if ((typeof previousFolderPath !== UNDEF) && previousFolderPath || 
						(typeof nextFolderPath !== UNDEF) && nextFolderPath) {
						
						out.print('\t\t\t\t<section class="prev-next-links hide-on-overlay"><div class="cont">');

						if (previousFolderPath) {
							out.print('<div class="previous-link ' +
										((neighboringFolderBgImage && previousFolderThumbPath)? 'has-bg' : 'no-bg') +
									'">' + 
									'<a rel="prev" href="' + previousFolderPath + indexName + '"' +
										((neighboringFolderBgImage && previousFolderThumbPath)? (' style="background-image:url(' + previousFolderThumbPath + ')"') : ' class="button"') +
										((typeof previousFolderAsk !== UNDEF)? (' data-ask-permission="' + previousFolderAsk + '"') : '') +
									'>' +
										'<span class="caption"><span class="icon-caret-left"></span> ' + previousFolderTitle + '</span>' +
									'</a>' +
								'</div>');
						}

						if (nextFolderPath) {
							out.print('<div class="next-link ' +
										((neighboringFolderBgImage && nextFolderThumbPath)? 'has-bg' : 'no-bg') +
									'">' + 
									'<a rel="next" href="' + nextFolderPath + indexName + '"' +
										((neighboringFolderBgImage && nextFolderThumbPath)? (' style="background-image:url(' + nextFolderThumbPath + ')"') : ' class="button"') +
										((typeof nextFolderAsk !== UNDEF)? (' data-ask-permission="' + nextFolderAsk + '"') : '') +
									'>' +
										'<span class="caption">' + nextFolderTitle + ' <span class="icon-caret-right"></span></span>' +
									'</a>' +
								'</div>');
						}

						out.println('</div></section>');
					}
				}
				
				break;
				
			case 'tags':
				
				if (tagCloudSource !== 'none' && (tagCloudSource !== 'subfolders' || tagCloudSkipLevels <= level)) {
					
					out.println('\t\t\t\t<section id="tag-cloud" class="hide-on-overlay"><div class="cont box small-column">' +
							(tagCloudLabel? ('<h4 class="icon-tag"> ' + tagCloudLabel + '</h4>') : '') +
							'<div class="tag-cloud-cont' + (tagCloudFontVaries? ' font-varies' : '') +'"></div>' +
						'</div></section>');
				}
				
				break;
				
			case 'newImages':
				
				if (searchNewSource !== 'none') {
					
					out.println('\t\t\t\t<section id="search-new" class="cont-box hide-on-overlay"><div class="cont box small-column">' +
							(searchNewLabel? ('<h4 class="icon-new"> ' + searchNewLabel + '</h4>') : '') +
							'<div class="search-new"></div>' +
						'</div></section>');
				}
					
				break;
				
			case 'comments':

				if (_useFacebookCommenting || _useDisqusCommenting) {

					out.println('\t\t\t\t<section class="commenting hide-on-overlay"><div class="cont box small-column">' +
							(_useFacebookCommenting? ('<div class="fb-comments cont" id="fb-comments" data-num-posts="' + facebookCommentingPosts + '" data-width="100%" data-colorscheme="' + commentingTheme + '"' + (pageUrl? ' data-href="' + pageUrl + '"' : '') + '></div>') : '') +
							(_useDisqusCommenting? '<div class="disqus-comments cont" id="disqus-comments"><div id="disqus_thread"></div></div>' : '') +
						'</div></section>');
				}

				break;

			case 'customContent':

				if (customSectionHook && (!level || !customSectionTopLevelOnly)) {
					var cs = getProcessed(customSectionHook).trim();
					if (cs[0] !== '<') {
						cs = '<p>' + cs + '</p>';
					}
					out.println('\t\t\t\t<section class="custom-content hide-on-overlay">' + 
							'<div class="cont box">' + cs + '</div>' +
						'</section>');
				}

				break;
				
		}
	}

%>