;(function($, $window) {
	'use strict';
				
	/* 
		sticky.js - renders 'sticky' class to off-screen layers
	*/

	$.fn.sticky = function(options) {
		
			options = $.extend({
							stickyClass:			'sticky',					// Sticky class
							stickToEdge:			'st-stick',					// The first/last element that need to be stick to edge class
							topmostClass:			'st-topmost',				// First element but not stick to window top
							bottommostClass:		'st-bottommost',			// First element but not stick to window top
							topClass:				'st-top',					// Top class
							bottomClass:			'st-bottom',				// Bottom class
							placeholderClass:		'st-placeholder',			// Placeholder class
							controlsClass:			'st-controls',				// Minimize/Maximize controls
							minimizedClass:			'minimized',
							maximizedClass:			'maximized',
							watch:					'.thumbnails',				// Only if this section is on screen
							watchThreshold:			100,						// The height to be on screen to be considered as visible
							minimizableThreshold:	80,							// Minimized controls added only above this height
							placeBelow:				'.top-bar.sticky'			// Extra top position to add above
						}, options);
			
			var ns = 'lst_' + Math.floor(Math.random() * 10000),
				st = new Array(),
				last = -999,
				pto,
				
				// Make panel static
				
				makeStatic = function(i) {
						var el = $('[data-sticky-rel=' + st[i].id + ']'),
							p = $('#' + st[i].id);
							
						if (el.length && el.hasClass(options.stickyClass)) {
							// Hiding placeholder
							p.height(0);
							// On screen
							el.removeClass(options.stickyClass + ' ' + options.topClass + ' ' + options.bottomClass);
						}
					},
					
				// Make all panels static
				
				makeAllStatic = function() {
					
						for (var i = 0; i < st.length; i++) {
							makeStatic(i);
						}
					},
					
				// Recalculate panel positions after minimize / maximize
				
				recalcPos = function(bottom) {
						var el = bottom? 
							$('.' + options.bottomClass + '.' + options.stickyClass + ':visible').backwards()
							: 
							$('.' + options.topClass + '.' + options.stickyClass + ':visible'),
						offs = bottom? 0 : $(options.placeBelow + ':visible').outerHeight() || 0;
						
						el.each(function() {
								$(this).css(bottom? 'bottom':'top', offs);
								offs += $(this).outerHeight();
							});
					},
					
				// Checking all elements
				
				checkPos = function() {
						var wt = $window.scrollTop(),
							wh = $window.outerHeight(),
							watch = $(options.watch + ':visible'),
							offsTop,
							offsBtm,
							topmost,
							bottommost,
							wpt;
						
						if (Math.abs(wt - last) <= 2) {
							// Already checked
							return;
						}
						
						if (watch.length) {
							wpt = watch.position().top;
						}
						
						if (!watch.length || (wpt > wt + wh - options.watchThreshold) || (wpt + watch.outerHeight() <= wt + options.watchThreshold)) {
							// No watch element or not on screen
							
							makeAllStatic();
							
						} else {
							// Watch element is on screen
							
							offsTop = $(options.placeBelow + ':visible').outerHeight() || 0;
							topmost = true;
							
							// Calculating top position
							$('.' + options.topClass + '.' + options.stickyClass + ':visible').each(function() {
									offsTop += $(this).outerHeight();
									topmost = false;
								});
							
							offsBtm = 0;
							bottommost = true;
							
							// Calculating bottom position
							$('.' + options.bottomClass + '.' + options.stickyClass + ':visible').each(function() {
									offsBtm += $(this).outerHeight();
									bottommost = false;
								});
							
							for (var i = 0, el, p, pt, ph; i < st.length; i++) { 
								el = $('[data-sticky-rel=' + st[i].id + ']');
								p = $('#' + st[i].id);
								
								if (el.length && p.length) {
									// Panel's top position
									pt = p.position().top;
								
									if (pt < (wt + offsTop) || (pt + st[i].height) > (wt + wh - offsBtm)) {
										// Place as sticky
										if (!el.hasClass(options.stickyClass)) {
											// Make the placeholder same height
											p.height(st[i].height);
											el.addClass(options.stickyClass);
											
											if (pt < (wt + offsTop)) {
												// Above
												//pt = getPos(options.topClass);
												
												if (offsTop) {
													// Offsetting already existing stickies
													el.removeClass(options.stickToEdge).css('top', offsTop);
												} else {
													el.addClass(options.stickToEdge);
												}
												
												offsTop += $(this).outerHeight();
												
												if (topmost) {
													el.addClass(options.topmostClass);
													topmost = false;
												}
												
												el.addClass(options.topClass).removeClass(options.bottomClass);
												
											} else {
												// Below
												el.addClass(options.bottomClass).removeClass(options.topClass);
											}
										}
										
									} else {
										// Place as static
										makeStatic(i);
									}
								}
							}
							
							offsBtm = 0;
							
							$('.' + options.bottomClass + '.' + options.stickyClass).backwards().each(function() {
									$(this).css('bottom', offsBtm);
									
									if (offsBtm) {
										$(this).removeClass(options.stickToEdge);
									} else {
										$(this).addClass(options.stickToEdge);
									}
									
									offsBtm += $(this).outerHeight();
									
									if (bottommost) {
										$(this).addClass(options.bottommostClass);
										bottommost = false;
									}
								});
						}
						
						return true;
					};
					
			// Preprocessing elements
			this.each(function(i) {
					var el = $(this),
						cont = el.children().first(),
						id = ns + '_' + i,
						h = el.outerHeight();
					
					el.before($('<div>', {
							id:				id,
							'class': 		options.placeholderClass
						}));
					
					if (h > options.minimizableThreshold) {
						cont.prepend($('<div>', {
								'class':		options.controlsClass
							}).append($('<a>', {
									'class':		'minimize'
									}).on('click', function() {
										el.removeClass(options.maximizedClass).addClass(options.minimizedClass);
										recalcPos(el.hasClass(options.bottomClass));
								})).append($('<a>', {
									'class':		'maximize'
									}).on('click', function() {
										el.removeClass(options.minimizedClass).addClass(options.maximizedClass);
										recalcPos(el.hasClass(options.bottomClass));
								}))
							);
					}
					
					el.attr('data-sticky-rel', id).addClass(options.maximizedClass);
					
					st[i] = {
							id:				id,
							height:			h
						}
				});
			
			$(this).on('stickyRefresh', function() {
					last = -999;
					checkPos();
				});
			
			// Scroll event listener
			$window.on('scroll.' + ns + ' resize.' + ns, function() {
					checkPos();
				});
			
			// Initial check
			checkPos();
			
			return this;
		};
	
}(jQuery, jQuery(window)));