/*
 * 	lightbox.js - lightbox for Tiger skin
 *	jslint browser: true
 */
 
;(function($, $window, $document, $body, undefined) {	
	'use strict';
	// Requires laza.util, laza.swipe and laza.transform
	
	$.fn.lightbox = function(album, settings) {
		
			if (typeof album === UNDEF) {
				return this;
			}
			
			settings = $.extend({}, $.fn.lightbox.defaults, settings);
	
			var self = $(this),
				text = getTranslations($.fn.lightbox.text),
				thumbs = $([]),
				thumb = $(),
				main = $(),
				oldMain = $(),
				image = $(),
				media = $(),
				caption = $(),
				oldCaption = $(),
				controls = $(),
				audioClip = $(),
				el,
				isImage = true,
				isVideo = false,
				isAudio = false,
				isOther = false,
				isExternal = false,
				isVr = false,
				isPdf = false,
				isPanorama = false,
				dontRemove = false,
				slideshow = null,
				slideshowSuspended = false,
				slideshowDelay = settings.slideshowDelay,
				transitionSpeed = settings.transitionSpeed,
				audioClipTimeout = null,
				fitTimeout = null,
				controlsTimeout = null,
				resizeTimeout = null,
				progressTo = null,
				listening = false,
				
				maxZoom = settings.maxZoom,
				fitImages = settings.fitImages,
				zoomLevel,
				
				thumbsVisibleDefault = settings.thumbsVisible,
				captionVisibleDefault = settings.captionVisible,
				
				curr = -1,
				loadCounter = 0,
				loadTimer,
				connectionSpeed = 0,
				direction = 0,
				imgPadding,
				lbPadding = settings['fitPadding'], 
				
				// Elements
				lightbox,
				lb_overlay,
				lb_activity,
				
				// Thumbstrip
				lb_thumbstrip,
				lb_thumb_cont,
				lb_thumbs,
				
				// Controls
				lb_btn_left,
				lb_up,
				lb_zoom,
				lb_zoomin,
				lb_zoomout,
				lb_zoom_slider,
				lb_fullscr,
				lb_exitfullscr,
				lb_showthumbs,
				lb_hidethumbs,
				lb_showcaption,
				lb_hidecaption,
				lb_play_pause,
				lb_progress,
				lb_timing_value,
				lb_btn_right,
				
				// Caption
				lb_caption,
				
				ns = self.data('llb_ns'),
				extraSizes = settings.hasOwnProperty('extraSizes')? settings.extraSizes.split(/,\s*/) : false,
				
				backgroundAudioRoot = $('[data-audioplayer]'),
				backgroundAudioOn = backgroundAudioRoot.length && !backgroundAudioRoot.data('paused'),
	
				cleanup = function(ns) {	
						// cleaning up the old event handlers
						$window.add(document).off('.' + ns);
						// Removing the lightbox :: you can only have one lightbox per thumb set
						$('#' + ns).remove();
					},
				
				closeModal = function(id) {
					
						lightbox.find('.modal').trigger('destroy');
					},
							
				getThumbsHeight = function() {
						return (settings.fitBetween !== 'screen' && 
								settings.thumbsVisible && 
								thumbs.length > 1 && 
								lb_thumb_cont && 
								lb_thumb_cont.length)? 
							lb_thumb_cont[0].clientHeight : 0;
					},
				
				getInfoHeight = function() {
					
						return (settings.fitBetween !== 'screen' && 
								lightbox.hasClass(settings.captionVisibleClass)	&& 
								caption && 
								caption.length)? 
							caption[0].offsetHeight : 0;
					},
				
				getControlsHeight = function() {
					
						return controls[0].clientHeight;
					},
				
				getPanelsHeight = function() {
						
						return getThumbsHeight() + getInfoHeight();
					},
					
				// Fixing the zoom button after pinch
				fixZoom = function(zoom, coords) {
					
						if (settings.useZoom && settings.zoomSlider) {
							if (zoom === 1) {
								return;
							}
							
							var mnr = main.data('minRatio') || 1,
								mxr = main.data('maxRatio') || 1.4,
								z = mnr + zoomLevel * (mxr - mnr) / 100; 
							
							z = Math.minMax(mnr, z * zoom, mxr);
							zoomLevel = (z - mnr) / (mxr - mnr) * 100;
						
							setZoomSlider(zoom);
							setZoomBtn(zoomLevel < 50, zoomLevel >= 50);
						}
					},
				
				// Toggling zoom in simple zomm toggling
				toggleZoom = function(coords) {
					
						if (settings.useZoom && settings.zoomSlider) {
							fitImages = true;
							zoomLevel = (zoomLevel > 50)? 0 : 100;
							setZoomSlider(zoomLevel);
						} else {
							// Change fit strategy
							fitImages = !fitImages;
						}
						//savePrefs();
						if (typeof coords === UNDEF) {
							fitImage(true);
						} else {
							fitImage(true, coords);
						}
					},
					
				// Sets zoom (0 .. 100), where 100 means 1:1 size
				setZoom = function(zoom, coords) {
						//console.log('Set zoom:' + zoom);
						zoomLevel = zoom;
						setZoomSlider(zoom);
						
						if (typeof coords === UNDEF) {
							fitImage(true);
						} else {
							fitImage(true, coords);
						}
					},
					
				increaseZoom = function(incr, coords) {
						var v = settings.zoomSlider? getZoomSlider() : zoomLevel;
						
						if (v < 100) {
							v = Math.min(100, v + ((typeof incr !== UNDEF)? incr : 25));
						}
						
						if (typeof coords === UNDEF) {
							setZoom(v);
						} else {
							setZoom(v, coords);
						}
					},
						
				decreaseZoom = function(incr, coords) {
						var v = settings.zoomSlider? getZoomSlider() : zoomLevel;
						
						if (v > 0) {
							v = Math.max(0, v - ((typeof incr !== UNDEF)? incr : 25));
						}
						
						if (typeof coords === UNDEF) {
							setZoom(v);
						} else {
							setZoom(v, coords);
						}
					},
					
				getZoomSlider = function() {
						return parseInt(lb_zoom_slider.val());
					},
						
				setZoomSlider = function(zoom) {
						lb_zoom_slider.val(zoom);
					},
					
				setZoomBtn = function(canZoomIn, canZoomOut) {
					
						if (settings.zoomSlider) {
							if (canZoomIn || canZoomOut) {
								lightbox.addClass('show-zoom-level');
								if (zoomLevel === 0) {
									lb_zoom.removeClass('icon-zoom-out icon-zoom-level').addClass('icon-zoom-in');
								} else if (zoomLevel === 100) {
									lb_zoom.removeClass('icon-zoom-in icon-zoom-level').addClass('icon-zoom-out');
								} else {
									lb_zoom.removeClass('icon-zoom-in icon-zoom-out').addClass('icon-zoom-level');
								}
							} else {
								lightbox.removeClass('show-zoom-level');
							}
						} else {
							lightbox.toggleClass('show-zoom-out', canZoomOut);
							// Zoom out takes precedence if both possible
							lightbox.toggleClass('show-zoom-in', canZoomIn && !canZoomOut);
						}
						
					},
				
				// Slideshow timing controls
				
				setTiming = function(t) {
						lb_timing_value.html((t >= 1000)? (Math.round(t / 1000) + 's') : (t + 'ms')); 
					},
					
				increaseTiming = function() {
					
						if (settings.slideshowDelay > 1000) {
							settings.slideshowDelay += 1000;
						} else {
							settings.slideshowDelay += 100;
						}
						
						setTiming(settings.slideshowDelay);
					},
						
				decreaseTiming = function() {
					
						if (settings.slideshowDelay > 500) {
							if (settings.slideshowDelay > 1000) {
								settings.slideshowDelay -= 1000;
							} else {
								settings.slideshowDelay -= 100;
							}
						}
						
						setTiming(settings.slideshowDelay);
					},
					
				// Animating progress bar
				
				animateProgress = function(duration) {
						var d = 20 / duration,
						
							setProgress = function(to) {
								
									//progress.css('transform', 'rotate(' + to * 360 + 'deg)');
									lb_progress.css('width', to * 100 + '%');

									if (to < 1) {
										to = Math.min(1, to + d);
										progressTo = setTimeout(setProgress, 20, to); 
									}
								};
							
						clearTimeout(progressTo);
						progressTo = setTimeout(setProgress, 20, 0);
					},
						
				showProgress = function() {
						if (lb_progress) {
							lb_progress.show();
							animateProgress(slideshowDelay);
						}
					},
				
				hideProgress = function() {
						if (lb_progress) {
							clearTimeout(progressTo);
							lb_progress.hide();
						}
					},
					
				getLightboxDims = function() {
						var lbDims = [ lightbox.width(), lightbox.height() ];
						
						return [ lbDims[0] - 2 * lbPadding, lbDims[1] - Math.max(getThumbsHeight(), lbPadding) - Math.max(getInfoHeight(), lbPadding) ];
					},
					
				// Reacalculating image position and size upon window resize
				
				fitImage = function(animate, center, doneFn) {
						var o = thumbs.eq(curr).data(J.OBJ),
							lbDims 			= [ lightbox.width(), lightbox.height() ],
							imgDims 		= album.getDimensions(o),
							maxDims 		= album.getMaxDimensions(o),
							controlsHeight 	= (isVr || isOther || isExternal || (settings.fitBetween === 'all' && !settings.autohideControls))? getControlsHeight() : 0,
							thumbsHeight 	= getThumbsHeight(),
							infoHeight 		= getInfoHeight(),
							
							checkPano = function(dims) {
									return settings.autoPano && (dims[0] / dims[1] > settings.horzPanoThreshold || dims[0] / dims[1] < settings.vertPanoThreshold);
								},
								
							checkPanoDims = function(dims) {
									return 	dims[0] / lbDims[0] >= settings.panoramaAutoDetect	 			// hangs over the edges least 1.3333 times the width or height
											||
											dims[1] / lbDims[1] >= settings.panoramaAutoDetect;
								},
								
							getTargetDims = function(dims, f) {
									return [ dims[0] * f, dims[1] * f ];
								},
								
							fitPano = function(dims) {
									return Math.max(
											(lbDims[0] - 2 * lbPadding - 2 * imgPadding) / dims[0],
											(lbDims[1] - Math.max(thumbsHeight + controlsHeight, lbPadding) - Math.max(infoHeight, lbPadding) - 2 * imgPadding) / dims[1]
										);
								},
								
							fitToLightbox = function(dims) {
									return Math.min(	
											(lbDims[0] - 2 * lbPadding - 2 * imgPadding) / dims[0], 
											(lbDims[1] - Math.max(thumbsHeight + controlsHeight, lbPadding) - Math.max(infoHeight, lbPadding) - 2 * imgPadding) / dims[1]
										);
								};
							
						// Image padding = border
						if (typeof imgPadding === UNDEF) {
							imgPadding = parseInt(main.css('paddingTop'));
						}
											
						// Lightbox padding
						if (typeof lbPadding === UNDEF) {
							if (settings.hasOwnProperty('fitRatio')) {
								// Image margin defined by "fitRatio" - Photoblogger
								lbPadding = Math.round((1 - settings.fitRatio) * Math.min(lbDims[0], lbDims[1]) / 2);
							} else {
								lbPadding = 0;
							}
						}
						
						// Set zoom level if undef
						if (typeof zoomLevel === UNDEF || zoomLevel === null) {
							zoomLevel = fitImages? 0 : 100;
							if (settings.useZoom && settings.zoomSlider) {
								setZoomSlider(zoomLevel);
							}
						}
						
						
						if (isVr || isOther || isExternal || isAudio && image.hasClass('default')) {
							// Non-zoomable types
							var th 	= Math.max(thumbsHeight + ((isVr || isOther || isExternal)? controlsHeight : 0), lbPadding),
								bh 	= Math.max(infoHeight, lbPadding),
								w	= lbDims[0] - 2 * lbPadding,
								h 	= lbDims[1] - (th + bh);
								
							if (isExternal || isAudio) {
								// Might be smaller than viewport
								if (imgDims[0] < w && imgDims[1] < h) {
									// Smaller than available space?
									w = Math.min(imgDims[0], w) + 2 * imgPadding;
									h = Math.min(imgDims[1], h) + 2 * imgPadding;
								}
							}
							
							main.data('fitted', true)
								.css({
									display:		'block',
									width:			w,
									height:			h,
									transition:		'none',
									transform:		'matrix(1,0,0,1,' + Math.round((0 - w) / 2) + ',' + Math.round((th - bh - h) / 2) + ')',
									opacity:		1
								});
								
							if (settings.useZoom) {
								setZoomBtn(false, false);
							}
							
							// Done Function
							if (typeof doneFn === FUNCTION) {
								doneFn.call(null);
							}
							
						} else {
							// Zoomable types
							var minRatio,
								maxRatio,
								targetRatio,
								targetDims,
								matrix = main.getMatrix(),
								optSrc,
								isPano,
								fitted = false;
								
							// Stop pano move
							if (lightbox.data('panomove')) {
								main.trigger('autopanoStop');
							}
							
							// Minimal size	
							minRatio = Math.min(1, fitToLightbox(imgDims));
							
							// Maximum size
							if (isVideo || isAudio) {
								// Audio or Video: constrain to lightbox
								maxRatio =	Math.min(maxZoom, fitToLightbox(imgDims));
							} else if (maxDims) {
								// Has larger variants
								maxRatio = Math.max(maxZoom, 
											Math.min(maxDims[0] / imgDims[0], maxDims[1] / imgDims[1]));
							} else {
								// Normal image
								maxRatio = Math.min(maxZoom, fitToLightbox(imgDims));
							}
							
							if (minRatio > maxRatio) {
								// Swap if reversed
								var r = minRatio;
								minRatio = maxRatio;
								maxRatio = r;
							}
							
							// Target size (fit image taken into account)
							if (settings.useZoom && settings.zoomSlider) {
								// Determining initial size for zoom slider
								if (main.data('inited')) {
									// Already painted
									targetRatio = minRatio + zoomLevel * (maxRatio - minRatio) / 100;
									targetDims = getTargetDims(imgDims, targetRatio);
									fitted = targetRatio == minRatio;
									isPano = !!lightbox.data('hasAutoPano');
								} else {
									// First paint
									if (isPanorama || checkPano(imgDims)) {
										// Panorama: fit to height
										targetRatio = Math.min(maxRatio, fitPano(imgDims));
										targetDims = getTargetDims(imgDims, targetRatio);
										isPano = checkPanoDims(targetDims);
										fitted = true;
									} else if (settings.fitImages) {
										// Fit to screen
										targetRatio = Math.min(maxRatio, fitToLightbox(imgDims));
										targetDims = getTargetDims(imgDims, targetRatio);
										isPano = false;
										fitted = true;
									} else {
										// Show in 1:1 size
										targetRatio = 1;
										targetDims = imgDims;
										isPano = false;
										fitted = targetRatio == minRatio;
									}
									zoomLevel = 100 * Math.minMax(0, (targetRatio - minRatio) / (maxRatio - minRatio), 1);
									setZoomSlider(zoomLevel);
								}
							} else {
								// Fit toggle
								if (isPanorama || checkPano(imgDims)) {
									targetRatio = Math.min(maxZoom, fitImages? fitPano(imgDims) : fitToLightbox(imgDims));
									targetDims = getTargetDims(imgDims, targetRatio);
									isPano = checkPanoDims(targetDims);
									fitted = fitImages;
								} else {
									if (!main.data('inited')) {
										fitImages = settings.fitImages;
										// Initial: fit if larger, 1:1 if smaller
										targetRatio = fitImages? Math.min(maxZoom, fitToLightbox(imgDims)) : 1;
									} else {
										if (fitImages) {
											// Zoom out
											targetRatio = Math.min(1, fitToLightbox(imgDims));
										} else {
											// Zoom in
											targetRatio = Math.max(maxZoom, maxRatio);
										}
									}
									fitted = targetRatio == minRatio;
									targetDims = getTargetDims(imgDims, targetRatio);
								}
							}
							
							// Checking if high res image needed
							if (	isImage && !fitted	&&															// It's an image
									((maxDims[0] > imgDims[0]) || (maxDims[1] > imgDims[1])) && 					// Has higher resolution version
									((targetDims[0] > imgDims[0]) || (targetDims[1] > imgDims[1])) && 				// The target size is larger than the base size
									(!main.data('lastDims') || main.data('lastDims')[0] < targetDims[0])			// The higher resolution version hasn't yet been loaded
								) {
								// Saving optimized image source 
								main.data('optSource', album.getOptimalImagePath(o, targetDims, settings.displayOriginals));
								main.data('lastDims', targetDims);
							}
								
							// Adding padding (border)
							targetDims = [  targetDims[0] + 2 * imgPadding, targetDims[1] + 2 * imgPadding ];
																					
							// Reset scale
							matrix[0] = matrix[3] = 1;
							// Setting position
							if (!main.data('inited') || (!isPano && fitted)) {
								// First paint or fit
								main.data('inited', true);
								matrix[4] = 0 - targetDims[0] / 2;
								matrix[5] = 0 - targetDims[1] / 2  + 
										(fitted?
											(Math.max(thumbsHeight + controlsHeight, lbPadding) - Math.max(infoHeight, lbPadding)) / 2
											:
											0
										)
							} else {
								// Already painted
								var z = (targetDims[0] - 2 * imgPadding) / main.width(),
									h = main.height();
									
								if (typeof center !== UNDEF && center) {
									// Center around event coords
									var	cx = center.x - lbDims[0] / 2,
										cy = center.y - lbDims[1] / 2; 
									matrix[4] = cx - (cx - matrix[4]) * z;
									matrix[5] = cy - (cy - matrix[5]) * z;
								} else {
									// Use previous center
									matrix[4] *= z;
									matrix[5] *= z;
								}
							}
							
							// Prepare panoramas
							if (isImage) {
								if (isPano) {
									// Pamorama
									if (!main.data('hasAutoPano')) {
										if (fitted && (targetDims[0] > (lbDims[0] + 10) || targetDims[1] > (lbDims[1] + 10))) {
											// Applying panorama player
											if (targetDims[0] / targetDims[1] > lbDims[0] / lbDims[1]) {
												// Horizontal
												matrix[4] -= settings.autoPanoStart * (targetDims[0] - lbDims[0]) / 2;
											} else {
												// Vertical
												matrix[5] -= settings.autoPanoStart * (targetDims[1] - lbDims[1]) / 2;
											}
										}
									}
								} /*else if (targetDims[0] <= lbDims[0] && targetDims[1] <= lbDims[1]) {
									// Fits screen => center it
									matrix[4] = 0 - targetDims[0] / 2;
									matrix[5] = 0 - targetDims[1] / 2;
								}*/
							}
							
							// Functions to execute on transition end or immediately if no animation
							var fto = null,
								finish = function() {
										// Replacing image source if not optimal
										if (main.data('optSource')) {
											var img = main.children('img').eq(0);
											if (img.length) {
												img.attr('src', main.data('optSource'));
												console.log('src replaced: ' + img.attr('src'));
												main.removeData('optSource');
											}
										}
										// Adjust or attach pano player
										if (isImage && isPano && (typeof center === UNDEF || !center)) {
											
											if (main.data('hasAutoPano')) {
												main.trigger('autopanoAdjust');
											} else {
												//console.log('Applying autopano');
												main.autopano({ 
													direction: 	-settings.autoPanoStart || direction,
													speed:		settings.autoPanoSpeed
												});
											}
										}
									
										if (isVideo && settings.videoAuto && media[0].paused) { 
											// Play video only after the transition
											playVideo(media[0]);
										}
									},
								
								endFitImage = function() {
										clearTimeout(fto);
										// Done Function
										if (typeof doneFn === FUNCTION) {
											doneFn(finish);
										} else {
											finish();
										}
									};
						
							main.css({
									display:		'block',
									transition:		animate? ('transform ' + settings.transitionProps + ', width ' + settings.transitionProps + ', height ' + settings.transitionProps) : 'none'
								});

							// Apply transforms
							
							if (animate) {
								//console.log('Scheduling finish()');
								main.one('transitionend', endFitImage);
								fto = setTimeout(endFitImage, 320);
							}
							
							main.data({
									fitted: 		fitted,
									minRatio:		minRatio,
									maxRatio:		maxRatio
								})
								.css({
									transform:		'matrix(' + matrix.join(',') + ')',		
									width: 			targetDims[0],
									height: 		targetDims[1]
								});
								
							// Set zoom button
							if (settings.useZoom) {
								if (maxRatio > targetRatio) {
									setZoomBtn(true, false);
								} else if (minRatio < targetRatio) {
									setZoomBtn(false, true);
								} else {
									setZoomBtn(false, false);
								}
							}
							
							if (!animate) {
								//console.log('Calling finish()');
								fto = setTimeout(endFitImage, 20);
							}
						}
						
					},
				
				// Reading image type
				
				getImageType = function(item) {
						
						isVideo = isAudio = isOther = isImage = isVr = isPdf = isPanorama = false;
						
						isExternal = item.hasOwnProperty(J.EXTERNAL);
						
						isVr = !isExternal && settings.use360Player && (
								(item.hasOwnProperty(J.PROJECTIONTYPE) && item[J.PROJECTIONTYPE] === 'equirectangular') 
								||
								(item[J.CATEGORY] === 'video' && item.hasOwnProperty(J.PANORAMA) && item[J.PANORAMA])
							);
						
						if (!isExternal && !isVr) {
							
							switch (item[J.CATEGORY]) {
								
								case 'video':
									isVideo = true;
									break;
								
								case 'audio':
									isAudio = true;
									break;
								
								case 'other':
									isOther = true;
									isPdf = album.getExtension(item).toLowerCase() === 'pdf';
									break;
								
								default:
									isImage = true;
									isPanorama =
										(item.hasOwnProperty(J.PANORAMA) && item[J.PANORAMA]) 
										|| 
										(	settings.autoPano 
											&& 
											(	item[J.IMAGE][J.WIDTH] > lightbox.width()
												||
												item[J.IMAGE][J.HEIGHT] > lightbox.height()
											)
											&&
											(	(item[J.IMAGE][J.WIDTH] / item[J.IMAGE][J.HEIGHT] > settings.horzPanoThreshold) 
												|| 
												(item[J.IMAGE][J.WIDTH] / item[J.IMAGE][J.HEIGHT] < settings.vertPanoThreshold)
											)
										);
							}
						}
					},
				
				// Gets the custom slideshow interval (if exist)
				
				getSlideshowTiming = function(item) {
					
						if (item.hasOwnProperty(J.SLIDESHOWINTERVAL)) {
							slideshowDelay = item[J.SLIDESHOWINTERVAL];
						} else {
							slideshowDelay = settings.slideshowDelay;
						}
						if (item.hasOwnProperty(J.TRANSITIONSPEED)) {
							transitionSpeed = item[J.TRANSITIONSPEED];
						} else {
							transitionSpeed = settings.transitionSpeed;
						}
					},
					
				// Updates rating (if changed externally)
					
				updateRating = function(r) {
						
						if (curr >= 0) {
							if (typeof r === UNDEF) {
								r = thumbs.eq(curr).data(J.OBJ)[J.VISITORRATING] || 0;
							}
						
							lightbox.find('.' + settings.lightboxCaptionClass + ' .ratingbox span')
								.removeClass('r0 r1 r2 r3 r4 r5')
								.addClass('r' + r);
						}
					},
					
				// Paint regions
				
				paintRegions = function(regions, visible) {
						var el = $('<div>', {
									'class':	settings.regionsClass
								}).appendTo(main);
						
						for (var i = 0, r; i < regions.length; i++) {
							r = regions[i].split(';');
							el.append($('<div>').css({
									left:		(100 * parseFloat(r[1])) + '%',
									top:		(100 * parseFloat(r[2])) + '%',
									width:		(100 * parseFloat(r[3])) + '%',
									height:		(100 * parseFloat(r[4])) + '%'
								}).append('<span>' + r[0] + '</span>'));
						}
						
						el.toggle(typeof visible !== UNDEF && visible);
					},
					
				// Show/hide regions
				
				toggleRegions = function() {
						var el = lightbox.find('.' + settings.regionsClass);
					
						if (el.length) {
							settings.regionsVisible = !settings.regionsVisible;
							if (el.is(':visible')) {
								el.fadeOut();
							} else {
								el.fadeIn();
							}
						}
						
						return false;
					},
											
				// Creating caption and buttons
				
				prepareCaption = function(item) {
						
						caption = $('<div>', {
										'class': 	[
														settings.lightboxCaptionClass,
														'scrollable',
														slideshow? 'slideshow' : '',
														settings.infoPanelAdapt? 'adapt-width' : 'fixed-width'
													].filter(Boolean).join(' ')
									});
						
						var txt = $('<div>', {
										'class': 	'caption'
									}),
							buttons = $('<div>', {
										'class': 	'buttons'
									}),
							hasShop,
							useLabels = settings.buttonLabels;
								
						if (item[J.IMAGECAPTION]) {
							txt.append(item[J.IMAGECAPTION]);
						}
						
						if (!isExternal && item[J.PHOTODATA] && !settings.metaAsPopup) {
							txt.append($('<div>', {
										'class':	'photodata',
										html:		item[J.PHOTODATA]
									}));
						}
						
						if (!txt.is(':empty')) {
							txt.find('[data-tooltip]').addTooltip();
							caption.append(txt);
						} else {
							caption.addClass('no-caption');
						}
						
						if (settings.useRating) {
							
							var r = item[J.RATING] || 0;
							
							if (settings.visitorRating || r) {
								var s;
							
								el = $('<div>', {
										'class':	'ratingbox'
									}).appendTo(buttons);
									
								el.append($('<label>', {
										html:		text.rating
									}));
									
								s = $('<span>', {
										'class':	'rating',
										html:		STARS
									})
									.appendTo(el);
									
								if (settings.visitorRating) {
									
									if (item.hasOwnProperty(J.VISITORRATING)) {
										// Already exists
										r = item[J.VISITORRATING];
									} else {
										if (!settings.useJalbumRating) {
											// Ignore jAlbum rating
											r = 0;
										}
										// Save the default
										item[J.VISITORRATING] = r;
									}
											
									s.addClass('r' + r + (settings.useJalbumRating? '' : ' icon-close'))
										.on('click.' + ns, function(e) {
												var el = $(this),
													r = Math.minMax(0, Math.floor((getCoords(e).x - el.offset().left - parseFloat(el.css('paddingLeft'))) / 16), 5); 
													//Math.minMax(0, Math.floor((getCoords(e).x - el.offset().left + 4) / el.width()) * 5, 5);
													
												el.removeClass('r0 r1 r2 r3 r4 r5').addClass('r' + r);
												item[J.VISITORRATING] = r;
												
												// Propagate to thumbnails
												self.trigger('refreshRating', thumbs[curr]);
													
												return false;
											});
								} else {
									// Unalterable rating from jAlbum
									s.addClass('r' + r);
								}
							}
						}
						
						// Extra sizes
						
						if (!isExternal && extraSizes && item[J.CATEGORY] === 'image') {
							var p = album.getImagePath(item);
							
							el = ($('<div>', {
										'class': 	'download icon-download'
									})).appendTo(buttons);
							
							for (var i = 0; i < extraSizes.length; i++) {
								el.append($('<a>', {
										text: 		extraSizes[i],
										href:  		p.replace('slides/', 'dl/' + extraSizes[i] + '/'),
										download: 	''
									}));
							}
						}
						
						// Print button
						
						if (settings.printImage && item[J.CATEGORY] === 'image' && !settings.rightClickProtect) {
							el = $('<a>', {
										'class': 	settings.buttonClass + ' icon-printer'
									}).appendTo(buttons);
							
							if (useLabels) {
								el.html('<span>' + text.print + '</span>');
							}
							
							if (!ISSEPARATEHOVER) {
								el.data('tooltip', useLabels? text.printLabel : text.print);
							}
							
							el.on('click', function(e) {
									printImage((item[J.ORIGINAL] && settings.showDownload)? album.getOriginalPath(item) : album.getImagePath(item),
										item[J.TITLE] || '',
										item[J.THUMBCAPTION] || ''
									);
								});
						}
						
						// Download button
						
						if (!isExternal && settings.showDownload) {
							var link;
							
							if (!!item[J.ORIGINAL] && (isImage || isPdf || settings.allowDownloadOthers)) {
								// Original of images and PDF's are allowed to download, others with extra permission
								link = 	album.getOriginalPath(item);
							} else if (isImage && settings.allowDownloadScaled) { 
								link = album.getImagePath(item);
							}
								
							if (link) {
								
								el = $('<a>', {
										'class': 		settings.buttonClass + ' icon-download download-btn',
										href: 			link,
										html:			useLabels? ('<span>' + text.download + '</span>') : '',
										download: 		''
									}).appendTo(buttons);
								
								if (!ISSEPARATEHOVER) {
									// Adding size as tooltip
									getFileSize(link, function(size, el) { 
											if (size && el) {
												el.addTooltip(useLabels? niceByte(size) : (text.download + ' [' + niceByte(size) + ']'));
											}
										}, el);
								}
							}
						}
						
						// PayPal button
						
						hasShop = settings.hasOwnProperty('shop') && album.hasShop(item) && settings.showShop;
						
						if (hasShop) {
							var txt = album.getPriceRange(item);
							
							txt = text.addCart + (txt? (' <b>' + txt + '</b>') : '');
	
							el = $('<a>', {
										'class': 		settings.buttonClass + ' icon-shopping-cart-add add-cart-btn'
									}).on('click', function(e) {
										
										if (slideshow) {
											suspendAuto();
											settings.shop.root.trigger('onClose', function() {
													if (slideshowSuspended) {
														resumeAuto();
													}
													settings.shop.root.trigger('onClose', null);
												});
										}
										
										settings.shop.root.trigger('addItems', item);
										return false;
										
									}).appendTo(buttons);
							
							el.html('<span>' + txt + '</span>')
								.data('tooltip', text.shopLabel);
							/*
							if (useLabels) {
								el.html('<span>' + txt + '</span>')
									.data('tooltip', text.shopLabel);
							} else {
								el.data('tooltip', txt);
							}
							*/
							el = $('<a>', {
										'class': 		settings.buttonClass + ' secondary icon-shopping-cart view-cart-btn'
									}).on('click', function(e) {
										settings.shop.root.trigger('showCart');
										return false;
									}).appendTo(buttons);
						
							el.html('<span>' + text.viewCart + '</span>')
								.data('tooltip', text.viewCartLabel);
								
							/*
							if (useLabels) {
								el.html('<span>' + text.viewCart + '</span>')
									.data('tooltip', text.viewCartLabel);
							} else {
								el.data('tooltip', text.viewCart);
							}
							*/
							
						}
						
						// Feedback button
						
						if (settings.hasOwnProperty('feedback') && settings.showFeedback) {
							el = $('<a>', {
										'class': 		settings.buttonClass + ' icon-email-send feedback-btn'
									}).on('click', function(e) {
									
										if (slideshow) {
											suspendAuto();
											settings.feedback.root.trigger('onClose', function() {
													if (slideshowSuspended) {
														resumeAuto();
													}
													settings.feedback.root.trigger('onClose', null);
												});
										}
										
										settings.feedback.root.trigger('addItems', item);
										return false;
										
									}).appendTo(buttons);
						
							if (useLabels) {
								el.html('<span>' + settings.feedbackBtnLabel + '</span>')
									.data('tooltip', settings.feedbackBtnTooltip);
							} else {
								el.data('tooltip', settings.feedbackBtnLabel);
							}
							
						}
						
						// Fotomoto button
						
						if ((!LOCAL || DEBUG) && settings.hasOwnProperty('fotomoto') && !album.hideFotomoto(item)) {
							el = $('<a>', {
										'class': 	settings.buttonClass + ' ' + (hasShop? 'icon-fotomoto':'icon-shopping-cart') + ' fotomoto-btn'
									}).on('click', function(e) {
										e.preventDefault();
										
										if (slideshow) {
											stopAuto();
										}
										
										//console.log('Fotomoto button clicked!');
										if (typeof FOTOMOTO !== UNDEF) {
											FOTOMOTO.API.showWindow(10, 
													album.getOriginalPath(item) || album.getItemPath(item)
												);
										}
										return false;
									}).appendTo(buttons);
						
							el.html('<span>' + text.fotomotoBtn + '</span>')
								.data('tooltip', text.fotomotoTooltip);
							/*
							if (useLabels) {
								el.html('<span>' + text.fotomotoBtn + '</span>')
									.data('tooltip', text.fotomotoTooltip);
							} else {
								el.data('tooltip', text.fotomotoBtn);
							}
							*/
						}
						
						// Photo data
						
						if (!isExternal && item[J.PHOTODATA] && settings.metaAsPopup) {
							el = $('<a>', {
										'class': 	settings.buttonClass + ' icon-camera photodata-btn'
									}).appendTo(buttons);
						
							if (useLabels) {
								el.html('<span>' + text.metaBtn + '</span>')
									.data('tooltip', text.metaLabel);
							} else {
								el.data('tooltip', text.metaBtn);
							}
							
							el.on('click', function() {
									
									if (slideshow) {
										suspendAuto();
									}
									
									lightbox.modal($('<div>', {
											'class':	'photodata',
											html: 		item[J.PHOTODATA]
										}), {
											title: 		text.metaBtn,
											icon:		'camera',
											onClose:	function() {
																if (slideshowSuspended) {
																	resumeAuto();
																}
															}
										});
									
									return false;
								});
						}
						
						// Regions
						
						if (!isExternal && settings.showRegions && item[J.REGIONS]) {
							el = $('<a>', {
										'class': 	settings.buttonClass + ' icon-facetag regions-btn'
									}).appendTo(buttons);
						
							if (useLabels) {
								el.html('<span>' + (settings.regionsBtn || text.regionsBtn) + '</span>')
									.data('tooltip', text.regionsLabel);
							} else {
								el.data('tooltip', (settings.regionsBtn || text.regionsBtn));
							}
							
							paintRegions(JSON.parse(item[J.REGIONS]), settings.regionsVisible); 
							
							el.on('click', toggleRegions);
						}
						
						// Map
						
						if (settings.showMap && !!item[J.LOCATION]) {
							
							el = $('<a>', {
										'class': 	settings.buttonClass + ' icon-location map-btn'
									}).appendTo(buttons);
						
							if (useLabels) {
								el.html('<span>' + text.mapBtn + '</span>')
									.data('tooltip', text.mapLabel);
							} else {
								el.data('tooltip', text.mapBtn);
							}
							
							el.on('click', function() {
									var target = $('<div>', {
												'class': 	'map-cont'
											});
									
									if (slideshow) {
										suspendAuto();
									}
									
									target.height($window.height() * settings.mapHeight);
									
									lightbox.modal(target, {
											'class': 	'no-padding large',
											onClose:	function() {
																if (slideshowSuspended) {
																	resumeAuto();
																}
															}
										});
									
									setTimeout(function() {
											if (settings.hasOwnProperty('mapApiKey') && settings.mapApiKey) {
												// Google
												target.addMap({
														apiKey:				settings['mapApiKey'],
														type:				settings['mapType'] || 'hybrid',
														zoom:				settings['mapZoom'] || 16,
														location: 			item[J.LOCATION],
														fitBounds:			false,
														fullscreenControl: 	false,
														onTypeChanged:		function(type) {
																					settings.mapType = type;
																				},
														onZoomChanged:		function(zoom) {
																					settings.mapZoom = zoom;
																				}
													});
											} else {
												// OSM
												target.addMap({
														resPath:			settings.resPath,
														zoom:				settings['mapZoom'] || 16,
														location: 			item[J.LOCATION],
														fitBounds:			false
													});
											}
										}, 100);
									
									return false;
								});
						}
						
						// Mostphotos
						
						if (!LOCAL && !isExternal && item[J.MOSTPHOTOS]) {
							el = $('<a>', {
									'class': 	settings.buttonClass + ' icon-shopping-cart mostphotos-btn',
									target: 	'_blank',
									href: 		'https://mostphotos.com/' + item[J.MOSTPHOTOS]
								}).appendTo(buttons);
							
							if (useLabels) {
								el.html('<span>' + text.mostphotosBtn + '</span>')
									.data('tooltip', text.mostphotosLabel);
							} else {
								el.data('tooltip', text.mostphotosBtn);
							}
						}
						
						// Share buttons
						
						if ((DEBUG || !LOCAL) && settings.share && settings.showShare) {
							
							el = $('<a>', {
									'class':	settings.buttonClass + ' icon-connect share-btn',
								}).appendTo(buttons);
							
							if (useLabels) {
								el.html('<span>' + text.share + '</span>')
									.data('tooltip', text.shareLabel);
							} else {
								el.data('tooltip', text.share);
							}
							
							el.on('click', function() {
									var target = $('<div>', {
												'class': 	'social'
											});
									
									if (slideshow) {
										suspendAuto();
									}
									
									lightbox.modal(target, {
											title: 		text.shareOn,
											icon:		'connect',
											onClose:	function() {
																if (slideshowSuspended) {
																	resumeAuto();
																}
															}
										});
									
									setTimeout(function() {
											target.renderShares({
													sites: 			settings.share,
													title: 			item[J.TITLE] || item[J.NAME].stripExt().replace(/[-_]/g, ' ').capitalize(),
													description: 	item[J.COMMENT],
													image: 			album.getOptimalThumbPath(item, [ 960, 640 ], false),
													href: 			album.getAbsolutePath(item)
												});
										}, 100);
									
									return false;
								});
						}
						
						if (settings.showNumbers) {
							buttons.prepend($('<div>', {
									'class':	'numbers',
									'html':		'<span>' + (curr + 1) + '&nbsp;</span>/&nbsp;' + thumbs.length
								}));
						}
						
						// Audio clip
						
						if (!isAudio && item[J.AUDIOCLIP]) {
							// Wrapper
							el = $('<div>', {
									'class':	'audio-clip paused'
								}).appendTo(buttons);
								
							// Button
							var btn = $('<a>', {
									'class':	settings.buttonClass + ' icon-volume-up audioclip-btn',
								}).appendTo(el);
							
							btn.on('click', function() {
									
									if (btn.hasClass('icon-pause')) {
										pauseAudioClip();
									} else {
										startAudioClip()
									}
									
									return false;
								});
							
							// Audio element
							audioClip = $('<audio>', {
										'class':		'audioclip',
										src:			album.getAudioClipPath(item),
										controlsList:	'nofullscreen nodownload noremote noplaybackrate'
									}).appendTo(el);
							
							// Type attribute saving and duration
							if (item[J.AUDIOCLIP].hasOwnProperty(J.TYPE)) {
								audioClip[0]['type'] = item[J.AUDIOCLIP][J.TYPE];
								if (item[J.AUDIOCLIP].hasOwnProperty(J.DURATION)) {
									audioClip.data('duration', item[J.AUDIOCLIP][J.DURATION]);
								}
							}
							
							var volume = $('<input class="volume" type="range" name="volume" min="0" max="100" value="' + (settings.audioClipVolume * 100) + '">');
							
							if (useLabels) {
								
								btn.append('<span>' + text.play + '</span>')
									.data('tooltip', text.audioClipLabel);
								
								el.append(volume);
								
							} else {
								
								btn.data('tooltip', volume);
							}
							
							volume.on('change', function(e) {
									var v = $(this).val();
									
									if (typeof v !== UNDEF) {
										settings.audioClipVolume = v / 100;
									}
									
									audioClip[0]['volume'] = settings.audioClipVolume;
									savePrefs(settings, settings.prefsKept, 'lb_pref');
									
									if (typeof settings['onVolumeChange'] === FUNCTION) {
										settings.onVolumeChange(settings.audioClipVolume);
									}
								});
							
							// Setting loudness
							audioClip[0]['volume'] = settings.audioClipVolume;
							
							if (settings.autoplayAudioClips) {
								// Trying to autoplay
								startAudioClip();
							}
							
						} else {
							audioClip = $();
						}
						
						if (!buttons.is(':empty')) {
							caption.addClass(settings.hasbuttonsClass);
							caption.append(buttons);
							buttons.find('.button').not('[download]').addTooltip();
						}
						
						if (caption.is(':empty')) {
							lightbox.removeClass(settings.captionVisibleClass);
							lightbox.addClass('no-caption');
						} else {
							lightbox.toggleClass(settings.captionVisibleClass, settings.captionVisible);
							lightbox.removeClass('no-caption');	
							lightbox.append(caption);
						}
						
					},	
				
				// Preloading the next image (direction sensitive)
				
				preloadNext = function() {
						var nextItem;
						
						if (direction < 0 && curr > 0) {
							nextItem = thumbs.eq(curr - 1).data(J.OBJ);
						} else if (curr < thumbs.length - 2) {
							nextItem = thumbs.eq(curr + 1).data(J.OBJ);
						}
						
						if (nextItem) {
							if (nextItem[J.CATEGORY] === 'image') {
								var next = new Image();
								next.src = album.getOptimalImagePath(nextItem, getLightboxDims(), settings.displayOriginals);
							}
						}
					},
				
				// Image clicked :: toggle controls or audio/video controls
				
				imageClicked = function(e) {
						var touched = $('html').data('whatinput') === 'touch' || e.type === 'touchend';
						
						//log(e.type);
									
						if (isVideo || isAudio) {
							
							var m = media[0];
								
							if (m.paused) {
								m.play();
								if (VEND !== 'ms') {
									m.controls = false;
								}
								if (touched) {
									toggleControls();
									if (lightbox.hasClass(settings.thumbsVisibleClass)) {
										hideThumbs();
									}
									if (lightbox.hasClass(settings.captionVisibleClass)) {
										hideCaption();
									}
								}
							} else {
								m.pause();
								if (VEND !== 'ms') {
									m.controls = true;
								}
								if (touched) {
									if (settings.clickAction === 'togglecontrols') {
										toggleControls();
									} else if (settings.clickAction === 'toggleall') {
										if (touched && lightbox.hasClass(settings.controlsHideClass)) {
											lightbox.removeClass(settings.controlsHideClass);
										} else {
											toggleAll();
										}
									}
								}
							}
							return false;
							
						} else if (isImage) {
							
							if (settings.clickAction === 'nextimage') {
								// image navigation
								if ((getCoords(e).x - main.position().left) > (main.width() / 2)) {
									nextImage();
								} else {
									previousImage();
								}
								if (touched) {
									showControls();
								}
							} else if (settings.clickAction === 'togglecontrols') {
								toggleControls();
							} else if (settings.clickAction === 'toggleall') {
								if (touched && lightbox.hasClass(settings.controlsHideClass)) {
									lightbox.removeClass(settings.controlsHideClass);
								} else {
									toggleAll();
								}
							}
						}
					},
				
				removeOld = function() {
						if (oldMain.length) {
							oldMain.remove();
							oldMain = $();
						}
					},
					
				// Doing all the animations in one timeframe
				
				doTransitions = function(doneFn) {
						
						switch (settings.transitionType) {
							
							case 'crossFadeAndSlide':
								var mx = main.getMatrix(),
									ox = mx[4];
								
								if (direction) {
									// Offset by 100 pixels
									mx[4] += 100 * direction;
								
									main.css({
											transition:		'none',
											transform:		'matrix(' +  mx.join(',') + ')'
										});
								}
								
								window.requestAnimationFrame(function() {
										
										if (oldMain.length && oldMain !== main) {
											
											if (oldMain.data('swipe') === 'swipe') {
												setTimeout(removeOld, transitionSpeed / 2);
											} else {
												var omx = oldMain.getMatrix();
												
												omx[4] -= 100 * direction;
												
												oldMain.one('transitionend', removeOld).css({
														transition:		'transform ' + (transitionSpeed / 2) + 'ms ease-out, opacity ' + (transitionSpeed / 2) + 'ms ease-out'
													}).css({
														transform:		'matrix(' + omx.join(',') + ')',
														opacity:		0
													});
											}
										}
										
										main.one('transitionend', function() {
												afterTransition(doneFn);
											});
										
										setTimeout(function() {
												if (direction) {
													// Restore final pos
													mx[4] = ox;
													// Animate to the final position and opacity
													main.css({
															transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + transitionSpeed + 'ms ease-out'
														}).css({
															transform:		'matrix(' + mx.join(',') + ')',
															opacity:		1
														});
												} else {
													main.css({
															transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + transitionSpeed + 'ms ease-out'
														}).css({
															opacity:		1
														});
												}
											}, TOUCHENABLED? 350 : 50);
									});
									
								break;
								
							case 'crossFadeAndZoom':
								
								var mx = main.getMatrix(),
									osx = mx[0],
									osy = mx[3];
								
								if (direction) {
									mx[0] *= (1 - direction / 40);
									mx[3] *= (1 - direction / 40);
									
									main.css({
											transition:		'none',
											transform:		'matrix(' + mx.join(',')  + ')'
										});
								}
								
								window.requestAnimationFrame(function() {
										
										if (oldMain.length && oldMain !== main) {
											
											if (oldMain.data('swipe') === 'swipe') {
												setTimeout(removeOld, transitionSpeed / 2);
											} else {
												var omx = oldMain.getMatrix();
												
												omx[0] *= (1 + direction / 20);
												omx[3] *= (1 + direction / 20);
												
												oldMain.one('transitionend', function() {
														oldMain.remove();
														oldMain = $();
													}).css({
														transition:		'transform ' + (transitionSpeed / 2) + 'ms ease-out, opacity ' + (transitionSpeed / 2) + 'ms ease-out',
														transform:		'matrix(' + omx.join(',') + ')',
														opacity:		0
													});
											}
										}
										
										main.one('transitionend', function() {
												afterTransition(doneFn);
											});
										
										setTimeout(function() {
												if (direction) {
													// Restore final scale
													mx[0] = osx;
													mx[3] = osy;
													// Animate to the final scale and opacity
													main.css({
															transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + transitionSpeed + 'ms ease-out',
															transform:		'matrix(' + mx.join(',') + ')',
															opacity:		1
														});
												} else {
													// No direction -> no scale
													main.css({
															transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + transitionSpeed + 'ms ease-out',
															opacity:		1
														});
												}
											}, TOUCHENABLED? 350 : 50);
									});
								
								break;
								
							default:
								
								main.css({
										transition:		'none',
										opacity: 		0
									});
								
								window.requestAnimationFrame(function() {
										
										if (oldMain.length && oldMain !== main) {
											
											if (oldMain.data('swipe') === 'swipe') {
												setTimeout(removeOld, transitionSpeed / 2);
											} else {
												oldMain.on('transitionend', function() {
														oldMain.remove();
														oldMain = $();
													}).css({
														transition:		'opacity ' + (transitionSpeed / 2) + 'ms ease-out', 
														opacity: 		0
													});
											}
										}
										
										main.one('transitionend', function() {
												afterTransition(doneFn);
											}).css({
												transition: 	'opacity ' + transitionSpeed + 'ms ease-out',
												opacity:		1
											});
										
									});
						}
						
					},
					
				// Transition has completed
					
				afterTransition = function(doneFn) {
						
						if (typeof doneFn === FUNCTION) {
							doneFn.call();
						}
						
						if (typeof settings.onLoadEnd === FUNCTION) {
							settings.onLoadEnd(thumb);
						}
						
						if (settings.preloadNext) {
							preloadNext();
						}
					},
				
				// The image is loaded
				
				imageReady = function() {
					
						loadCounter--;
						
						if (loadCounter > 0) {
							// Still has to load another image: (poster image) 
							return;
						}
						
						lb_activity.hide();
						
						/*
						// Performace metrics
						if (typeof performance !== UNDEF) {
							
							console.log('performance exists');
									
							var pl = performance.getEntriesByType("resource");
							
							if (pl && Array.isArray(pl)) {
								var p = pl[pl.length - 1];
								
								console.log('performance last entry: ' + p);
								
								if (typeof image[0] !== UNDEF && p.name === image[0].src) {
									connectionSpeed = connectionSpeed? ((connectionSpeed + p.decodedBodySize / p.duration) / 2) : (p.decodedBodySize / p.duration);
								}
								
								if (DEBUG) {
									console.log(p.initiatorType + ':' + p.name.substring(p.name.lastIndexOf('/') + 1) + ' [' + Math.round(p.decodedBodySize / 1000) + 'kB] loaded in ' + Math.round(p.duration) + 'ms => ' + (p.decodedBodySize / p.duration / 1000).toFixed(2) + 'MB/s' + ' (avg:' + (connectionSpeed / 1000).toFixed(2) + 'MB/s)');
								}
							}
							
						}
						*/
						
						// Reporting image load in Debug mode
						if (DEBUG) {
							var d = new Date();
							if (isExternal || isVr) {
								console.log((isExternal? 'External content' : '360 player') + ' loaded: ' + (d - loadTimer) + 'ms');
							} else if (image.length) {
								console.log(((isVideo || isAudio)? 'Media' : 'Image') + ' [' + curr + '] loaded: ' + (d - loadTimer) + 'ms src="' + image[0].src + '"' + (connectionSpeed? (' avg. speed: ' + (connectionSpeed / 1000).toFixed(2) + 'MB/s') : ''));
								if (typeof image[0] === UNDEF || typeof media[0] === UNDEF) {
									console.log('Premature ' + (typeof image[0] === UNDEF)? ('loadImage.done(' + image[0].src + ')') : ('loadMedia.done('+ media[0].src + ')'));
								}
							}
						}
											
						// Right click protect
						if ((isImage || isVideo || isAudio) && settings.rightClickProtect) {
							media.on('contextmenu', function(e) {
									e.preventDefault()
									return false;
								});
						}
						
						// Audio / video initilazion
						if (isVideo || isAudio) {
							
							media.attr({
									autoplay: 	settings.videoAuto,
									loop:		settings.videoLoop
								});
							media[0].volume = settings.volume;
							
							media.on('volumechange.' + ns, function() {
									settings.volume = this.volume;
								});
						}
						
						if (oldCaption.length) {
							
							// Removing the old caption
							oldCaption.find('.buttons a').trigger('removeTooltip');
							
							if (oldCaption.length > 1) {
								oldCaption.eq(-1).prevAll('.' + settings.lightboxCaptionClass).remove();
								oldCaption = lightbox.find('.' + settings.lightboxCaptionClass);
							}
							
							if (lightbox.hasClass(settings.captionVisibleClass)) {
								oldCaption.one('transitionend', function() {
										oldCaption.remove();
										oldCaption = $();
									}).css({
										transition:		'opacity ' + (transitionSpeed / 2) + 'ms ease-out',
										opacity:		0
									});
							} else {
								oldCaption.remove();
							}
						}
						
						if (!isVr && !isPdf && !isVideo && (!isExternal || !main.children('iframe').length)) {
							// Swipe handler
							main.swipe({
									onSwipeStart:	function() {
															$(this).trigger('autopanoStop');
															$(this).hideAllTooltips();
														},
									
									onSwipedLeft: 	function() {
															main.data('swipe', 'swipe');
															nextImage();
														},
													
									onSwipedRight: 	function() {
															main.data('swipe', 'swipe');
															previousImage();
														},
													
									onSwipedDown:	function() {
															main.data('swipe', 'down');
															quitLightbox();
														},
													
									onPinchZoom:	function(e) {
															main.data('swipe', 'pinch');
															if (lightbox.data('panomove')) {
																e.preventDefault();
																$(this).trigger('autopanoStop');
															}
															fixZoom(main.getScale()[0], getCoords(e));
														},
													
									onFinished: 	function() {
															if (!dontRemove) {
																$(this).trigger('removeSwipe');
																$(this).remove();
															}
														},
													
									onClick:		function(e) {
															if (lightbox.data('panomove')) {
																main.data('swipe', 'panostop');
																e.preventDefault();
																$(this).trigger('autopanoStop');
															} else {
																main.data('swipe', 'click');
																imageClicked(e);
															}
														},
														
									onRightClick:	function(e) {
															stopAuto(true);
														},
														
									onDoubleClick:	(settings.useZoom && settings.doubleClickZoom)? 
														function(e) {
																var c = getCoords(e);
																main.data('swipe', 'doubleclick');
																if (settings.zoomSlider) {
																	if (zoomLevel < 100) {
																		increaseZoom(50, c);
																	} else {
																		setZoom(0);
																	}
																} else {
																	toggleZoom(c);
																}
															} 
														: 
														null
								});
							
						} else {

							main.on('click.nonimage', function(e) {
									main.data('swipe', 'click');
									imageClicked(e);
								});
							
						}
						
						// Placing and centering the new image
						fitImage(false, null, function(doneFn) {
								// Running transitions
								doTransitions(doneFn);
							});
						
						// Check if video has started 
						if (isVideo && settings.videoAuto && media[0].paused) {
							playVideo(media[0]);
						}
						
						// Continuing slideshow
						if (slideshow) {
							if ((isAudio || isVideo) && settings.videoAuto) {
								suspendAuto();
								media[0].onended = function() {
									resumeAuto();
								};
							} else {
								clearTimeout(slideshow);
								slideshow = setTimeout(nextImage, slideshowDelay);
								showProgress();
							}
						} else {
							//stopAuto(true);
							if (settings.autohideControls) {
								hideControlsLater();
							}
						}
						
					},
				
				// Recentering after swipe for example
				
				recenter = function(el) {
						var el = el || main;
						if (el.data('swipe') === 'swipe') {
							var matrix = main.getMatrix();
							matrix[4] = -main.width() / 2;
							el.one('transitionend', function() {
									el.data('swipe', null);
								}).css({
									opacity: 		1,
									transition:		'opacity ' + (settings.transitionSpeed * 2) + 'ms ease-out, transform ' + (settings.transitionSpeed * 2) + 'ms ease-out',
									transform: 		'matrix(' + matrix.join(',') + ')'
								});
						}
					},
					
				// Handling out-of-bounds move
				
				showLightbox = function() {
						
						lightbox.css({
								display:		'block',
								visibility:		'visible',
								transition: 	'opacity ' + settings.transitionSpeed + 'ms ease-out'
							})
							.one('transitionend', function() {
									if (settings.autoStart) {
										startAuto();
									}
								})
							.css('opacity', 1);
					},
						
				// Main entry point to load a new image
				
				loadImage = function(n) {
					
						if (typeof n !== 'number') {
							n = thumbs.index(n);
						}
						
						if (n < 0 || n >= thumbs.length) {
							// Out of bounds move
							
							dontRemove = true;
							
							if (n < 0) {
								
								switch (settings.afterLast) {
									case 'donothing':
										n = 0;
										if (main.data('swipe') === 'swipe') {
											recenter();
										}
										break;
										
									case 'startover':
										n = thumbs.length - 1;
										break;
										
									case 'onelevelup': 
										if (settings.level) {
											window.location.href = '../' + settings.indexName;
										}
										n = 0;
										break;
										
									case 'nextfolder':
										if (settings.baseSet && settings.previousFoldersLast) {
											window.location.href = settings.previousFoldersLast;
										} else {
											n = 0;
											if (main.data('swipe') === 'swipe') {
												recenter();
											}
										}
										break;
										
									case 'nextindex':
										if (settings.baseSet && settings.previousFolderPath) {
											window.location.href = settings.previousFolderPath;
										} else {
											n = 0;
											if (main.data('swipe') === 'swipe') {
												recenter();
											}
										}
										break;
										
									default:
										n = 0;
										quitLightbox();
										return;
								}
								
							} else {
								
								switch (settings.afterLast) {
									
									case 'donothing':
										dontRemove = true;
										n = thumbs.length - 1;
										stopAuto();
										if (main.data('swipe') === 'swipe') {
											recenter();
										}
										break;
										
									case 'startover':
										n = 0;
										break;
										
									case 'onelevelup': 
										if (settings.level) {
											window.location.href = '../' + settings.indexName;
										}
										n = thumbs.length - 1;
										stopAuto();
										break;
										
									case 'nextfolder':
										if (settings.baseSet && settings.nextFoldersFirst) {
											window.location.href = settings.nextFoldersFirst + (slideshow? '&slideshow' : '');
										} else {
											n = thumbs.length - 1;
											stopAuto();
											if (main.data('swipe') === 'swipe') {
												recenter();
											}
										}
										break;
										
									case 'nextindex':
										if (settings.baseSet && settings.nextFolderPath) {
											window.location.href = settings.nextFolderPath;
										} else {
											n = thumbs.length - 1;
											stopAuto();
											if (main.data('swipe') === 'swipe') {
												recenter();
											}
										}
										break;
										
									case 'ask':
										
										dontRemove = true;
										
										var sr = stopAuto(),
											buttons = new Array();
										
										if (main.data('swipe') === 'swipe') {
											recenter();
										}
										
										n = thumbs.length - 1;
							
										if (thumbs.length > 1) {
											// Start over
											buttons.push({
													t: 	text.startOver,
													c:	'icon-loop',
													h: 	function(lb) { 
															loadImage(0);
														}
												});
										}
										
										if (settings.level) {
											// Up one level
											buttons.push({
													t: 	settings.level? text.upOneLevel : (settings.homepageLinkText || text.backToHome), 
													c:	'icon-one-level-up',	
													h: 	function() { 
															window.location.href = '../' + settings.indexName;
														}
												});
										}
										
										// Back to thumbnails
										buttons.push({
												t: 	text.backToIndex,
												c:	'icon-arrow-up',
												h: 	function() { 
														quitLightbox();
													}
											});
										
										if (settings.baseSet) {
											
											if (settings.nextFoldersFirst) {
												// Go to next folder
												buttons.push({
														t: 	text.nextFolder,
														c:	'icon-arrow-right',
														h: 	function() {
																window.location.href = settings.nextFoldersFirst + (sr? '&slideshow' : '');
															}
													});
											}
								
											if (settings.nextFolderPath) {
												// Go to next index
												buttons.push({
														t: 	text.nextIndex,
														c:	'icon-thumbnails',
														h: 	function() {
																window.location.href = settings.nextFolderPath;
															}
													});
											}
										}
								
										lightbox.modal($('<p>', {
												'class':	'text-center',
												text: 		text.atLastPageQuestion
											}), buttons, {
												onClose:	function() {
																loadImage(thumbs.length - 1);
															},
												'class': 	'secondary',
												icon:		'info',
												title: 		text.atLastPage
											});
										
										return;
											
									default:
										// Back to index
										n = slideshow? 0 : (thumbs.length - 1);
										stopAuto();
										// Resetting play position to 0
										quitLightbox(thumbs[0]);
										return;
								}
							}
						} else {
							dontRemove = false;
						}
						
						// Direction is calculated if the current thumb exists
						if (lightbox.is(':visible')) {
							// Lightbox is on
							if ((Math.abs(n - curr) >= thumbs.length - 1) && settings.afterLast === 'startover') {
								// Flip over
								direction = 1;
							} else {
								direction = (curr > n)? -1 : ((curr < n)? 1 : 0);
							}
							
							if (curr === n) {
								// the requested image is already on screen :: nothing to do
								return;
							}
							
							main.hideAllTooltips();
							
							if (settings.autoHideControls) {
								hideControlsLater();
							}
							
						} else {
							// We're on the index page :: show lightbox
							listening = true;
							$body.add($('html')).css('overflow', 'hidden');
							$body.addClass(settings.lightboxOnClass);
							direction = 0;
							
							if (settings.lightboxFullscreen) {
								requestFullscreen();
							}
							
							if (settings.useRating) {
								updateRating();
							}
							
							showLightbox();
							backgroundAudioOn = backgroundAudioRoot.length && !backgroundAudioRoot.data('paused');

							lazyloadThumbs(fitThumbstrip);
						}
						
						closeModal();
						
						var item;
						
						curr = n;
						thumb = thumbs.eq(curr);
						item = thumb.data(J.OBJ);
						
						if (settings.useThumbstrip && thumbs.length > 1) {
							setActiveThumb();
						}
						
						if (!item) {
							console.log('Fatal error: image (' + curr + ') is missing from the database! (Upload data1.json again!)');
							return;
						}
						
						lb_activity.show();
						hideProgress();
						getImageType(item);
						getSlideshowTiming(item);
						
						setTimeout(function() {
							
							oldMain = lightbox.find('.' + settings.lightboxMainClass);
							oldCaption = lightbox.find('.' + settings.lightboxCaptionClass);
								
							if (oldMain.length) {
								
								oldMain.trigger('autopanoRemove').off('.' + ns);
								
								if (settings.muteBackgroundAudio && backgroundAudioOn) {
									if (isAudio || isVideo) {
										backgroundAudioRoot.trigger('fadeOutPlayer');
									} else {
										backgroundAudioRoot.trigger('fadeInPlayer');
									}
								}
								
								fadeMedia(oldMain);
								
								oldMain.off('click.nonimage');
							}
							
							// Delayed image loading
												
							loadCounter = 1;
							loadTimer = new Date();
							
							main = $('<div>', {
									'class': 	'lightbox-main ' + (isExternal? 'external' : (isVr? 'vr' : (isPdf? 'pdf' : item[J.CATEGORY])))
								})
								.css({
									opacity: 	0,
									transform:	'matrix(1,0,0,1,-50%,-50%)'
								})
								.appendTo(lightbox);
								
							if (settings.hasOwnProperty('shop') && album.hasShop(item) ||
								settings.hasOwnProperty('feedback') && settings.showFeedback) {
								main.append($('<a>', {
										'class':		settings.checkboxClass + (thumb.hasClass(settings.selectedClass)? (' ' + settings.checkmarkClass) : '')
									}).on('click', function() {
										$(this).toggleClass(settings.checkmarkClass);
										thumb.trigger('toggleCard');
										return false;
									}));
								if (settings.hasOwnProperty('shop') && album.hasShop(item)) {
									main.append($('<a>', {
											'class': 		'icon-shopping-cart-add add-cart-btn'
										})
										.addTooltip(text.addCart, { pos: [0,1,2,1] })
										.on('click', function(e) {
											if (slideshow) {
												suspendAuto();
												settings.shop.root.trigger('onClose', function() {
														if (slideshowSuspended) {
															resumeAuto();
														}
														settings.shop.root.trigger('onClose', null);
													});
											}
											settings.shop.root.trigger('addItems', item);
											return false;
										}));
								} else {
									main.append($('<a>', {
											'class': 		'icon-email-send add-cart-btn',
											text:			' ' + settings.feedbackAddBtnLabel
										}).on('click', function(e) {
											if (slideshow) {
												suspendAuto();
												settings.feedback.root.trigger('onClose', function() {
														if (slideshowSuspended) {
															resumeAuto();
														}
														settings.feedback.root.trigger('onClose', null);
													});
											}
											settings.feedback.root.trigger('addItems', item);
											return false;
										}));
								}
							}
								
							if (isVr) {
								
								var w = Math.round(lightbox.width() * settings.fitRatio),
									h = Math.round(lightbox.height() * settings.fitRatio);
									
								main.css({
											width:		w,
											height:		h
										})
									.attr('id', 'vr' + curr)
									.addClass('vr')
									.show()
									.one('DOMReady', imageReady);
								
								// Photosphere viewer by Jeremy Heleine
								if (typeof PhotoSphereViewer !== UNDEF) {
									setTimeout(function() {
											var opt = { container: 	main[0] },
												psv,
												gp;
												
											if (item[J.CATEGORY] === 'video') {
												opt.panorama = album.getVideoPath(item);
												opt.adapter = PhotoSphereViewer.EquirectangularVideoAdapter;
												opt.plugins = [ PhotoSphereViewer.VideoPlugin, {} ];
												opt.navbar = [ 'zoom', 'fullscreen' ];
											} else {
												opt.panorama = album.getAbsoluteImagePath(item);
												opt.navbar = [ 'autorotate', 'zoom', 'fullscreen' ];
												if (settings.autoRotate360 && settings.rotateSpeed360) {
													opt.autorotateDelay = 1000;
												}
												opt.autorotateSpeed = settings.rotateSpeed360 + 'rpm';
											}
											
											if (gp = item['gpano']) {
												if (gp['fov']) {
													opt.defaultZoomLvl = gp.fov;
												}
												if (gp['pan'] || gp['tilt'] || gp['roll']) {
													opt.sphereCorrection = { 
															pan:		Math.PI * gp['pan'] / 180, 
															tilt:		Math.PI * gp['tilt'] / 180, 
															roll:		Math.PI * gp['roll'] / 180
														};
												}
											}
												
											psv = new PhotoSphereViewer.Viewer(opt);
											
										}, transitionSpeed);
								} else {
									console.log('Fatal Error: Missing "photo-sphere-viewer.min.js"!');
								}
								
								// Considered ready after 200ms or the "ready" event, whatever comes first 
								setTimeout(imageReady, 200);
								
							} else if (isImage) {
								
								// Image
								// Creating
								media = image = $('<img>').appendTo(main);
								
								if (DEBUG) {
									console.log('Loading image [' + curr + '] src="' + album.getOptimalImagePath(item, getLightboxDims(), settings.displayOriginals) + '"');
								}
								
								if (image[0].complete && image[0].naturalWidth > 0) {
									// From cache
									imageReady();
									
								} else {
									// Loading
									image.one('load.' + ns, function(e) {
											// Triggered on load event
											imageReady();
										});
								}
								
								// Applying the source
								image[0].src = album.getOptimalImagePath(item, getLightboxDims(), settings.displayOriginals);
								
							} else if (isAudio || isVideo) {
								
								if (isVideo) {
									
									var	dur = album.getVideoDuration(item);
									
									// Video
									media = image = $('<video>', {
												preload: 		'auto',
												controlsList:	'nodownload',
												poster: 		album.getPosterPath(item)
											});
									
									if (dur === null || dur >= 2000) {
										// Normal video
										media[0]['controls'] = 'true';
									} else {
										// Short video < 2s
										//media[0].controls = false;
										media[0]['loop'] = 'true';
									}
									
								} else {
									
									var src = album.getPosterPath(item);
										
									// Audio
									loadCounter = 2;
									
									image = $('<img>', {
											'class': 	'poster' + (src.endsWith('poster.png')? ' default' : '')
										}).one('load', function(e) {
											imageReady();
										})
										.attr('src', src)
										.appendTo(main);
									
									media = $('<audio>', {
											preload: 		'auto',
											controls: 		'true',
											controlsList:	'nofullscreen nodownload'
										});
								}
								
								media.one('loadedmetadata', function(e) {
											imageReady();
										})
									.attr('src', album.getSourcePath(item))
									.appendTo(main);
								
								media.on({
										playing: 	mediaPlaying,
										pause: 		mediaPaused,
										ended:		mediaEnded
									});
										
								if (settings.muteBackgroundAudio && backgroundAudioRoot.length) {
									backgroundAudioOn = !backgroundAudioRoot.data('paused');
								}
								
							} else if (isExternal) {
								
								var cont = item[J.EXTERNAL]['cont'],
									size = item[J.EXTERNAL]['size'];
									
								if (size) {
									size = size.split('x');
									main.data({
										oWidth:		parseInt(size[0]),
										oHeight:	parseInt(size[1])
									})
								}
									
								main.one('DOMReady', function(e) {
										imageReady();
									});
								
								if (cont.match(/^https?\:\/\//i) || cont.match(/\.html?$/i) || cont.match(/^\.\.\//)) {
									main.addClass('iframe')
										.append($('<iframe>', { 
												width: 				'100%',
												height: 			'100%',
												src: 				cont,
												frameborder: 		0,
												allowfullscreen: 	'allowfullscreen'
											}));
								} else {
									if (cont.match(/^<iframe/i)) {
										main.addClass('iframe');
									}
									main.append(cont);
								}
								
								// Considered ready after 200ms or the "ready" event, whatever comes first 
								setTimeout(imageReady, 200);
								
							} else {
								// Other
								var appendIcon = function(target, item) {
														target.append($('<div>', {
																'class':	'icon',
																html:		'<a href="' + album.getSourcePath(item) + '" target="_blank"><img class="other" src="' + album.getImagePath(item) + '"></a><p class="icon-external"> ' + text.clickToOpen + '</p></div>'
															}));
													};
								// Other
								if (isPdf && HASPDFVIEWER && !ISIOSDEVICE) {
									// using the PDF viewer plugin
									var o = $('<object>', {
												type:		'application/pdf'
											})
											.attr('data', album.getSourcePath(item));
										
									appendIcon(o, item);
									main.append(o);
									setTimeout(imageReady, 400);
									
								} else if (settings.useGoogleDocs && !LOCAL && 
									'.docx.xlsx.txt.pdf'.indexOf('.' + (item.hasOwnProperty(J.ORIGINAL)? item[J.ORIGINAL][J.PATH] : item[J.NAME]).getExt()) >= 0) {
									// Fallback to Google Doc Viewer
									main.addClass('iframe');
									var target = $('<iframe>', {
												width: 				'100%',
												height: 			'100%',
												frameborder: 		0,
												allowfullscreen: 	'allowfullscreen'
										}).appendTo(main);
									
									setTimeout(function(target, item) {
											target.attr('src', 'https://docs.google.com/viewer?url=' + window.location.href.getDir() + album.getSourcePath(item) + '&embedded=true');
											setTimeout(imageReady, 400);
										}, 100, target, item);
									
								} else {
									// Generic case with a download button
									appendIcon(main, item);
									imageReady();
								}
							}	
							
							prepareCaption(item);
																	
							if (typeof settings.onLoadStart === FUNCTION) {
								settings.onLoadStart(thumb);
							}
						
						}, 30);
					},
				
				// Hiding the lightbox overlay
				
				quitLightbox = function(thumb) {
						
						stopAuto(true);
						
						self.hideAllTooltips();
						
						listening = false;
						$body.add($('html')).css('overflow', '');
						$body.removeClass(settings.lightboxOnClass);
						audioClip.remove();
						
						if (settings.muteBackgroundAudio && backgroundAudioOn) {
							backgroundAudioRoot.trigger('fadeInPlayer');
						}
						
						if (!main.length) {
							
							if(!SMALLSCREEN) {
								exitFullscreen();
							}
							
							if (typeof settings.onClose === FUNCTION) {
								if (typeof thumb !== UNDEF) {
									settings.onClose(thumb);
								} else {
									settings.onClose();
								}
							}
							
						} else {
							
							if (lightbox.data('panomove')) {
								// Panorama playing
								main.trigger('autopanoStop');
							}
							
							if ((isAudio || isVideo) && media) {
								var sv = media[0].volume,
									tm = transitionSpeed / (sv * 50),
									fade = function() {
											if (media) {
												var v = Math.max(media[0].volume - 0.02, 0);
												if (v > 0.005) {
													media[0].volume = v;
													setTimeout(fade, tm);
												} else {
													media[0].pause();
												}
											}
										};
								
								media.off('.' + ns);
								fade();
							}
							
							window.requestAnimationFrame(function() {
									
									lightbox.css({
											transition: 	'opacity ' + settings.transitionSpeed + 'ms ease-out'
										})
										.one('transitionend', function() {
											// Avoid flicker
											lightbox.css('visibility', 'hidden');
											setTimeout(function() {
													lightbox.css('display', 'none');
												}, 20);
											
											if (!SMALLSCREEN) {
												exitFullscreen();
											}
											
											if (main.length) {
												main.remove();
												main = $();
											}
											
											if (caption.length) {
												caption.remove();
												caption = $();
											}
										})
										.css({
											opacity:		0
										});
								});
							
							if (typeof settings.onClose === FUNCTION) {
								if (thumb !== UNDEF) {
									settings.onClose(thumb);
								} else {
									setting.onClose();
								}
							}
								
							$body.hideAllTooltips();
						}
					},
				
				// Removing the lightbox completely
				
				removeLightbox = function() {
						var remove = function() {
									if (settings.lightboxFullscreen) {
										exitFullscreen();
									}
									lightbox.remove();
								};
						// Stop slideshow		
						stopAuto(true);
						listening = false;
						// removing event handlers
						thumbs.off('.' + ns);
						$document.add($window).add(lightbox).off('.' + ns);
						$body.add($('html')).css('overflow', '');
						$body.removeClass(settings.lightboxOnClass);
						
						if (!main.length) {
							// No image; remove immediately
							remove();
						} else {
							// Fade out
							lightbox.css('transition', 'opacity ' + settings.transitionSpeed + 'ms ease-out')
								.one('transitionend', remove)
								.css('opacity', 0);
						}
					},
				
				// Set play/pause button
				
				setPlayPause = function(on) {
					
						if (lb_play_pause) {
							if (on) {
								lb_play_pause.removeClass('icon-play').addClass('icon-pause');
								lb_play_pause.children('.lbl').text(text.pauseShort);
							} else {
								lb_play_pause.removeClass('icon-pause').addClass('icon-play').removeClass('show-progress');
								lb_play_pause.children('.lbl').text(text.startSlideshowShort);
							}
						}
					},
				
				// Toggling auto slideshow
				
				toggleAuto = function() {
					
						if (slideshow) {
							stopAuto();
						} else {
							startAuto();
						}
						
					},
					
				// Starting auto slideshow
				
				startAuto = function(keepMusic) {
						
						clearTimeout(slideshow);
						
						setPlayPause(true);
						
						$body.add(lightbox).addClass(settings.immerseClass);
						
						if (settings.autohideControls) {
							hideControlsLater();
						}
						
						caption.addClass('slideshow');
						
						// Resetting zoom
						fitImages = settings.fitImages;
						
						// Starting background music
						if (!(keepMusic === true) && settings.backgroundAudioSlideshowControl) {
							backgroundAudioRoot.trigger('fadeInPlayer');
						}
						
						// Full screen mode
						if (settings.slideshowFullscreen) {
							requestFullscreen();
						}
						
						// Wake lock
						requestWakeLock();
						
						if (audioClipTimeout) {
							// Wait until audioclip ends
							slideshow = null;
							slideshowSuspended = true;
							onAudioClipEnded(nextImage);
						} else {
							// Immediately start
							slideshowSuspended = false;
							slideshow = setTimeout(nextImage, settings.slideshowDelay / 4);
						}
						
						if (settings.onSlideshowStart !== false) {
							settings.onSlideshowStart(thumb);
						}
					},
									
				resumeAuto = function() {
						
						setPlayPause(true);
						
						if (settings.autohideControls) {
							hideControlsLater();
						}
						
						$body.add(lightbox).addClass(settings.immerseClass);
						slideshow = setTimeout(nextImage, settings.slideshowDelay / 4);
						slideshowSuspended = false;
						
						if (settings.backgroundAudioSlideshowControl) {
							backgroundAudioRoot.trigger('fadeInPlayer');
						}
					},
		
				stopAuto = function(keepMusic) {
						var sr = slideshow !== null;
						
						if (settings.onSlideshowPause !== false) {
							settings.onSlideshowPause(thumb);
						}
						
						if (!(keepMusic === true) && settings.backgroundAudioSlideshowControl) {
							backgroundAudioRoot.trigger('fadeOutPlayer');
						}
						
						setPlayPause(false);
						
						clearTimeout(slideshow);
						slideshow = null;
						slideshowSuspended = false;
						caption.show().removeClass('slideshow');
						$body.add(lightbox).removeClass(settings.immerseClass);
						
						showControls();
						
						if (settings.slideshowFullscreen && !settings.lightboxFullscreen) {
							exitFullscreen();
						}
						
						releaseWakeLock();
						
						if (settings.onSlideshowPause !== false) {
							settings.onSlideshowPause(thumb);
						}
						
						return sr;
					},
				
				suspendAuto = function() {
					
						if (settings.backgroundAudioSlideshowControl) {
							backgroundAudioRoot.trigger('fadeOutPlayer');
						}
						
						clearTimeout(slideshow);
						slideshow = null;
						slideshowSuspended = true;
					},
					
				updateAudioClipProgress = function(pb) {
					
						if (audioClip.length && pb.length) {
							pb.css('width', (100 * audioClip[0].currentTime / audioClip[0].duration) + '%');
						}
					},
					
				startAudioClip = function() {
					
						if (audioClip.length) {
							
							audioClip[0].play().then(function() {
								
									var btn = audioClip.siblings('.audioclip-btn'),
										pb = btn.children('.progress');
										
									btn.removeClass('icon-volume-up').addClass('icon-pause');
									audioClip.parent().removeClass('paused').addClass('playing');
									
									if (slideshow) {
										suspendAuto();
									}
									
									if (!pb.length) {
										pb = $('<div>', {
												'class':	'progress'
											}).appendTo(btn);
									}
									
									updateAudioClipProgress(pb);
									
									audioClipTimeout = setInterval(updateAudioClipProgress, 100, pb);
									
									audioClip.on('ended', function() {
										
											btn.removeClass('icon-pause').addClass('icon-volume-up');
											audioClip.parent().removeClass('playing').addClass('paused');
											
											if (slideshowSuspended) {
												resumeAuto();
											}
											
											pb.remove();
											
											clearInterval(audioClipTimeout);
										});
											
								}, function(err) {
									
									btn.removeClass('icon-pause').addClass('icon-volume-up');
									console.log(err);
								});
						}
					},
					
				pauseAudioClip = function() {
							
						if (audioClip.length) {
							var btn = audioClip.siblings('.audioclip-btn');
							
							audioClip[0].pause();
							clearInterval(audioClipTimeout);
							
							btn.removeClass('icon-pause').addClass('icon-volume-up');
							audioClip.parent().removeClass('playing').addClass('paused');
							
							if (slideshowSuspended) {
								resumeAuto();
							}
						}
					},	
					
				onAudioClipEnded = function(fn, params) {
					
						if (audioClip.length && typeof fn === FUNCTION) {
							if (audioClip[0].paused) {
								if (typeof params !== UNDEF) {
									fn.apply(null, params);
								} else {
									fn.call(null);
								}
							} else {
								audioClip.on('ended', fn, params);
							}
						}
					},
					
				mediaPlaying = function() {
					
						if (settings.muteBackgroundAudio) {
							if (backgroundAudioOn = !backgroundAudioRoot.data('paused')) {
								backgroundAudioRoot.trigger('fadeOutPlayer');
							}
						}
						startAudioClip();
						main.addClass(settings.playingClass);
					},
					
				mediaPaused = function() {
						
						if (settings.muteBackgroundAudio && backgroundAudioOn) {
							backgroundAudioRoot.trigger('fadeInPlayer');
						}
						pauseAudioClip();
						main.removeClass(settings.playingClass);
					},
					
				mediaEnded = function() {
					
						if (settings.muteBackgroundAudio) {
							backgroundAudioOn = false;
						}
						pauseAudioClip();
						main.removeClass(settings.playingClass);
					},
				
				fadeMedia = function(el) {
						var media = (el || lightbox).find('audio,video').eq(0);
						
						if (media.length) {
							var sv = media[0].volume,
								tm = settings.transitionSpeed / (sv * 50),
								fade = function() {
										if (media) {
											var v = Math.max(media[0].volume - 0.02, 0);
											if (v > 0.005) {
												media[0].volume = v;
												setTimeout(fade, tm);
											} else {
												media[0].pause();
											}
										}
									};
							
							media.off('volumechange.' + ns);
							fade();
						}
					},
					
				stopMedia = function(el) {
						var m = (el || lightbox).find('audio,video').eq(0);
						
						if (m.length) {
							m[0].pause();
						}
					},
					
				showControls = function() {
						clearTimeout(controlsTimeout);
						lightbox.removeClass(settings.controlsHideClass);
					},
				
				hideControls = function() {
						clearTimeout(controlsTimeout);
						controls.hideAllTooltips();
						lightbox.addClass(settings.controlsHideClass);
					},
					
				hideControlsLater = function() {
						clearTimeout(controlsTimeout);
						controlsTimeout = setTimeout(function() {
								//$body.hideAllTooltips();
								hideControls();
							}, /*slideshow? Math.min(settings.slideshowDelay / 2, settings.hideControlsDelay) :*/ settings.hideControlsDelay);
					},
	
				toggleControls = function() {
						clearTimeout(controlsTimeout);
						lightbox.toggleClass(settings.controlsHideClass, !controlsHidden());
					},
				
				controlsHidden = function() {
						return lightbox.hasClass(settings.controlsHideClass);
					},
				
				toggleFullscreen = function() {
						if (isFullscreen()) {
							exitFullscreen();
						} else {
							requestFullscreen();
						}
					},
					
				showThumbs = function() {
						controls.hideAllTooltips();
						lightbox.addClass(settings.thumbsVisibleClass);
						settings.thumbsVisible = thumbsVisibleDefault = true;
						savePrefs(settings, settings.prefsKept, 'lb_pref');
						if (main.data('fitted')) {
							// re-adjusting position
							fitImage(true);
						}
					},
				
				hideThumbs = function() {
						controls.hideAllTooltips();
						lightbox.removeClass(settings.thumbsVisibleClass);
						settings.thumbsVisible = thumbsVisibleDefault = false;
						savePrefs(settings, settings.prefsKept, 'lb_pref');
						if (main.data('fitted')) {
							// re-adjusting position
							fitImage(true);
						}
					},
				
				showCaption = function() {
						lightbox.addClass(settings.captionVisibleClass);
						settings.captionVisible = captionVisibleDefault = true;
						savePrefs(settings, settings.prefsKept, 'lb_pref');
						if (main.data('fitted')) {
							// re-adjusting position
							fitImage(true);
						}
					},
					
				hideCaption = function() {
						controls.hideAllTooltips();
						lightbox.removeClass(settings.captionVisibleClass);
						settings.captionVisible = captionVisibleDefault = false;
						savePrefs(settings, settings.prefsKept, 'lb_pref');
						if (main.data('fitted')) {
							// re-adjusting position
							fitImage(true);
						}
					},
				
				toggleCaption = function() {
						if (settings.captionVisible) {
							hideCaption();
						} else {
							showCaption();
						}
					},
						
				toggleAll = function() {
						if (!settings.captionVisible && !settings.thumbsVisible) {
							showControls();
							// Show items only to be visible by default
							if ((thumbsVisibleDefault || !captionVisibleDefault) && !settings.thumbsVisible) {
								lightbox.addClass(settings.thumbsVisibleClass);
								settings.thumbsVisible = true;
							}
							if ((captionVisibleDefault || !thumbsVisibleDefault) && !settings.captionVisible) {
								lightbox.addClass(settings.captionVisibleClass);
								settings.captionVisible = true;
							}
						} else {
							thumbsVisibleDefault = settings.thumbsVisible;
							captionVisibleDefault = settings.captionVisible;
							// Hide everything
							controls.hideAllTooltips();
							clearTimeout(controlsTimeout);
							lightbox.addClass(settings.controlsHideClass);
							lightbox.removeClass(settings.thumbsVisibleClass + ' ' + settings.captionVisibleClass);
							settings.thumbsVisible = settings.captionVisible = false;
						}
						
						savePrefs(settings, settings.prefsKept, 'lb_pref');
						if (settings.fitBetween !== 'screen') {
							if (main.data('fitted')) {
								// re-adjusting position
								fitImage(true);
							}
						}
					},
					
				previousImage = function() {
						loadImage(curr - 1);
					},
				
				nextImage = function() {
						loadImage(curr + 1);
					},
				
				moveThumbs = function(x) {
						
						lb_thumbs
							.css({
								transition:		'transform ' + settings.thumbSpeed + 'ms ease-out',
								transform:		'translateX(' + x + 'px)'
							});
							
						lazyloadThumbs();
					},
				
				setActiveThumb = function() {
					
						if (!settings.useThumbstrip || thumbs.length < 2) {
							return;
						}
						
						var cthumb = lb_thumbs.children().eq((curr < 0)? 0 : curr),
							tl = cthumb.position().left,
							tw = cthumb.width(),
							cl = lb_thumbs.getTranslate()[0],
							cw = lb_thumb_cont.width(),
							tsw = lb_thumbs.width();
							
						lb_thumbs.children().removeClass(settings.activeClass);
						cthumb.addClass(settings.activeClass);
						
						if (tl < -cl) {
							moveThumbs(Math.min(0, settings.thumbOverhead - tl));
						} else  if ((tl + tw) > (cw - cl)) {
							moveThumbs(Math.max(cw - tl - tw - settings.thumbOverhead, cw - tsw));
						} else if ((cw - cl) > tsw) {
							moveThumbs(cw - tsw);
						}
							
					},
				
				// Adding one thumb
				
				loadThumb = function(thumb) {
						
						if (thumb.length) {
							var i = $('<img>', {
									'class': 	'hide-image'
								})
								// Onload action
								.one('load', function() {
									$(this).removeClass('hide-image').addClass('show-image');
									$(this).parent().removeClass(settings.lazyloadClass);
								})
								.attr('src', thumb.attr('href'));
							
							if (settings.rightClickProtect) {
								i.on('contextmenu', function(e) {
										e.preventDefault()
										return false;
									});
							}
							
							thumb.append(i).removeAttr('href');
						}
											
					},
					
				// Loading visible thumbs
				
				lazyloadThumbs = function(callback) {
					
						if (!lightbox.is(':visible') || !settings.useThumbstrip || thumbs.length < 2) {
							return;
						}
						
						var cw = lb_thumb_cont.width(),
							cl = lb_thumbs.getTranslate()[0];
						
						lb_thumbs.children('.' + settings.lazyloadClass).each(function() {
							var t = $(this),
								tl = t.position().left,
								tw = t.width();
								
							if (((tl + cl) < (cw * 7 / 4)) && ((tl + tw + cl) > (0 - cw * 3 / 4))) {
								// In view
								t.removeClass(settings.lazyloadClass);
								loadThumb(t);
							} else if ((tl + cl) >= cw) {
								// Right to clip window
								return false;
							}
						});
						
						if (typeof callback === FUNCTION) {
							callback.call(this);
						}
					},
					
				// Fit thumbnail strip if shorter than the original space
				
				fitThumbstrip = function() {
						if (!lightbox.is(':visible')) {
							return;
						}
						
						var lt = lb_thumbs.children(':last-child');
	
						if ((lt.position().left + lt.outerWidth()) > lb_thumb_cont.width()) {
							lb_thumbstrip.addClass(settings.scrollClass);
							setActiveThumb();
						} else {
							lb_thumbstrip.removeClass(settings.scrollClass);
							moveThumbs(0);
						}
					},
					
				// Scrolling the thumb strip
				
				scrollThumbs = function(direction) {
						var cw = lb_thumb_cont.width(),
							cl = lb_thumbs.getTranslate()[0];
					
						if (cw > lb_thumbs.width()) {
							if (cl) {
								moveThumbs(0);
							}
						} else {
							cl = (direction < 0)? 
								Math.min(0, cl + cw)
								:
								Math.max(cw - lb_thumbs.width(), cl - cw);
							moveThumbs(cl);
						}
					},
									
				// Settings up the thumb strip
				
				initThumbstrip = function() {
					
						if (settings.thumbsVisible) {
							lightbox.addClass(settings.thumbsVisibleClass);
						}
						
						// Thumbsstrip
						lb_thumbstrip = $('<div>', {
								'class':	'thumb-strip'
							})
							.appendTo(lightbox);
							
						lb_thumbstrip.append($('<button>', {
								'class':	'left icon-caret-left'
							}).on('click.' + ns, function(e) {
								scrollThumbs(-1);
								return false;
							}));
							
						lb_thumbstrip.append($('<button>', {
								'class':	'right icon-caret-right'
							}).on('click.' + ns, function(e) {
								scrollThumbs(1);
								return false;
							}));
							
						lb_thumb_cont = $('<div>', {
								'class':	'thumb-cont'
							}).appendTo(lb_thumbstrip);
							
						lb_thumb_cont.on('selectstart.' + ns, function(e) {
								return false;
							});
							
						lb_thumbs = $('<div>', {
								'class':	'thumbs'
							}).appendTo(lb_thumb_cont);
							
						var item,
							w,
							h = lb_thumbs.height() || 60,
							a,
							tw = 0;
							
						thumbs.each(function(i) {
								
							item = $(this).data(J.OBJ);
							
							a = $('<a>', {
									'class':	settings.lazyloadClass,
									title:		item[J.THUMBCAPTION] || '',
									href:		album.getThumbPath(item)
								}).appendTo(lb_thumbs);
							
							a.on('click', function(e) {
									var a = $(e.target).closest('a');
									
									loadImage(lb_thumbs.children().index(a));
									return false;
								});
							
							w = Math.floor(Math.max((h - 4) * 3 / 4, Math.min(item[J.THUMB][J.WIDTH], (h - 4) * item[J.THUMB][J.WIDTH] / item[J.THUMB][J.HEIGHT])));
							
							a.width(w);
							
							tw += w;
						});
					},
					
				// Setting up the controls
				
				initControls = function() {
						// Control strip
						controls = $('<div>', {
									'class':	settings.controlsClass + (settings.controlsUseText? ' use-text' : '')
								}).appendTo(lightbox);
						
						// Left button
						if (thumbs.length > 1) { 
							lb_btn_left = $('<button>', {
									type: 		'button',
									'class': 	'previous',
									title:		text.previousPicture,
									text:		settings.controlsUseText? text.previousPictureShort : ''
								})
								.on('click.' + ns, previousImage)
								.appendTo(controls);
						}
							
						// Up button
						lb_up = $('<button>', {
								type: 		'button',
								'class': 	'up icon-arrow-up',
								title:		text.upOneLevel,
								text:		settings.controlsUseText? text.upOneLevelShort : ''
							})
							.on('click.' + ns, quitLightbox)
							.appendTo(controls);
						
						// Zoom button
						if (settings.useZoom) {
							
							if (settings.zoomSlider) {
								// Slider
								var zoom_panel= $('<div>', {
											'class':	'zoom-control'
										}),
									zoom_out_btn = $('<a>', {
											'class':	'zoom-out button'
										}).appendTo(zoom_panel);
										
								lb_zoom_slider = $('<input>', {
											name:		'zoom-level',
											type:		'range'
										}).appendTo(zoom_panel);
										
								var zoom_in_btn = $('<a>', {
											'class':	'zoom-in button'
										}).appendTo(zoom_panel);
									
								// Zoom toggle button
								lb_zoom = $('<button>', {
											type: 		'button',
											'class': 	'zoom-level icon-zoom-level',
											text:		settings.controlsUseText? text.zoom : ''
										})
									.on('click.' + ns, function(){
											if (listening) {
												setTimeout(toggleZoom, 50);
												if ($('html').data('whatinput') === 'touch') {
													// Touch toggle
													return true;
												}
											}
											return false; 
										})
									.addTooltip($('<div>', {
											'class':	'zoom-panel'
										}).append(zoom_panel), {
											touchToggle:	true,
											pos:			[1,0,1,2]
										}).appendTo(controls);
									
								lb_zoom_slider.on('change', function() {
										setZoom(parseInt(lb_zoom_slider.val()));
										return true;
									});
								
								zoom_in_btn.on('click', function() {
										increaseZoom();
										return false;
									});
								
								zoom_out_btn.on('click', function() {
										decreaseZoom();
										return false;
									});
								
							} else {
								
								// Zoom toggle button
								lb_zoomin = $('<button>', {
											type: 		'button',
											'class': 	'zoom-in icon-expand',
											title: 		text.oneToOneSize,
											text:		settings.controlsUseText? text.oneToOneSizeShort : ''
										})
									.on('click.' + ns, function() { 
											toggleZoom(); 
											return false; 
										})
									.appendTo(controls);
								
								lb_zoomout = $('<button>', {
											type: 		'button',
											'class': 	'zoom-out icon-contract',
											title: 		text.fitToScreen,
											text:		settings.controlsUseText? text.fitToScreenShort : ''
										})
									.on('click.' + ns, function() { 
											toggleZoom(); 
											return false; 
										})
									.appendTo(controls);
							}
						}
						
						// Hide/show top thumbs
						if (settings.useThumbstrip && thumbs.length > 1) {
							lb_showthumbs = $('<button>', {
									type: 		'button',
									'class': 	'show-thumbs icon-show-top-panel',
									title: 		text.showThumbs,
									text:		settings.controlsUseText? text.showThumbsShort : ''
								})
								.on('click.' + ns, showThumbs)
								.appendTo(controls);
						
							lb_hidethumbs = $('<button>', {
									type: 		'button',
									'class': 	'hide-thumbs icon-hide-top-panel',
									title: 		text.hideThumbs,
									text:		settings.controlsUseText? text.hideThumbsShort : ''
								})
								.on('click.' + ns, hideThumbs)
								.appendTo(controls);
						}
							
						// Hide/show captions
						lb_showcaption = $('<button>', {
								type: 		'button',
								'class': 	'show-caption icon-show-bottom-panel',
								title: 		text.showInfo,
								text:		settings.controlsUseText? text.showInfoShort : ''
							})
							.on('click.' + ns, showCaption)
							.appendTo(controls);
						
						lb_hidecaption = $('<button>', {
								type: 		'button',
								'class': 	'hide-caption icon-hide-bottom-panel',
								title: 		text.hideInfo,
								text:		settings.controlsUseText? text.hideInfoShort : ''
							})
							.on('click.' + ns, hideCaption)
							.appendTo(controls);
							
						if (settings.useSlideshow && thumbs.length > 1) {
							
							// Play/Pause button
							lb_play_pause = $('<button>', {
									type: 		'button',
									'class': 	'play-pause icon-play',
									'title': 	text.slideshow
								})
								.appendTo(controls);
							
							if (settings.controlsUseText) {
								lb_play_pause.append($('<span>', {
										'class':	'lbl',
										html:		text.startSlideshowShort
									}));
							}
							
							lb_progress = $('<span>', {
									'class': 	'progress'
								})
								.appendTo(lb_play_pause);
								
							lb_play_pause.on('click.' + ns, function(){ 
									if (listening) {
										toggleAuto();
										if ($('html').data('whatinput') === 'touch') {
											// Touch toggle
											return true;
										}
									}
									return false; 
								});
									
							if (settings.timingControl) {
								// Slideshow timing control
								var timing_panel= $('<div>', {
											id:			'timing-control',
											'class':	'timing-control'
										}),
									decr_time_btn = $('<a>', {
											'class':	'decr-time'
										}).appendTo(timing_panel);
										
								lb_timing_value = $('<span>').appendTo(timing_panel);
										
								var incr_time_btn = $('<a>', {
											'class':	'incr-time'
										}).appendTo(timing_panel);
									
								lb_play_pause.addTooltip($('<div>', {
											'class':	'timing-panel'
										}).append($('<div>', {
											'class':	'label',
											html:		text.timing
										})).append(timing_panel), {
											touchToggle:	true,
											delay:			600,
											pos:			[1,0,1,2]
										});
									
								incr_time_btn.on('click', function() {
										increaseTiming();
										return false;
									});
								
								decr_time_btn.on('click', function() {
										decreaseTiming();
										return false;
									});
								
								setTimeout(function() { 
										setTiming(settings.slideshowDelay);
									}, 500);
								
							} else {
								// No timing control
								lb_play_pause.attr('title', text.startStopSlideshow);
							}
						}
								
						// Full screen toggle button
						if (settings.showFullscreen && hasFullscreen()) {
							lb_fullscr = $('<button>', {
									type: 		'button',
									'class': 	'gofullscreen icon-fullscreen',
									title: 		text.fullscreen,
									text:		settings.controlsUseText? text.fullscreenShort : ''
								})
								.on('click.' + ns, requestFullscreen)
								.appendTo(controls);
							
							lb_exitfullscr = $('<button>', {
									type: 		'button',
									'class': 	'exitfullscreen icon-fullscreen-off',
									title: 		text.exitFullscreen,
									text:		settings.controlsUseText? text.exitFullscreenShort : ''
								})
								.on('click.' + ns, exitFullscreen)
								.appendTo(controls);
								
							if (isFullscreen()) {
								lightbox.addClass('fullscreen');
							}
						}
							
						// Right button
						if (thumbs.length > 1) { 
							lb_btn_right = $('<button>', {
									type: 		'button',
									'class': 	'next',
									title:		text.nextPicture,
									text:		settings.controlsUseText? text.nextPictureShort : ''
								})
								.on('click.' + ns, nextImage)
								.appendTo(controls);
						}
						
						// Adding tooltips
						controls.children('button').not('.zoom-level').not('.pause').addTooltip({
								delay:		1000,
								pos:		[1,0,1,2]
							});
			
					},
					
				// Setting up the structure
				
				initLightbox = function(ns) {
					
						lightbox = $('<div>', {
								id: 		ns,
								'class': 	'lightbox'
							})
							.hide()
							.appendTo(self);
					
						// Darken background
						lb_overlay = $('<div>', {
								'class': 	'lightbox-overlay'
							})
							.appendTo(lightbox);
					
						// Activity indicator
						lb_activity = $('<div>', {
								'class': 	'lightbox-loading'
							})
							.append('<div>')
							.append('<div>')
							.append('<div>')
							.appendTo(lightbox);
						
						// Apply visibility classes
						lightbox.toggleClass(settings.thumbsVisibleClass, settings.thumbsVisible && thumbs.length > 1);
						lightbox.toggleClass(settings.captionVisibleClass, settings.captionVisible);
						//lightbox.toggleClass('zoomed', zoomed);
						
						// Controls
						initControls();
						
						// Thumb strip
						if (settings.useThumbstrip && thumbs.length > 1) {
							initThumbstrip();
						}
						
						// Slideshow delay and transition speed
						if (!settings.hasOwnProperty('slideshowDelay')) {
							slideshowDelay = settings.slideshowDelay = 4000;
						}
						if (!settings.hasOwnProperty('transitionSpeed')) {
							transitionSpeed = settings.transitionSpeed = 400;
						}
						
						// Quit beside handler
						if (!settings.quitOnDocClick) {
							lb_overlay.on('click.' + ns, function(e) {
									
									if (listening) {
										if (this === e.target) {
											var p = getCoords(e);
											
											if (p.x >= lightbox.width() / 2) {
												nextImage();
											} else {
												previousImage();
											}
										}
										return false;
									}
								
								});
						}
					};
					
					
			// Initializing Lightbox
						
			if (ns) {
				// should never happen, but still living lightbox attached to thumb elements
				cleanup(ns);
			}
			
			// Creating new namespace
			self.data('llb_ns', ns = 'llb_' + Math.floor(Math.random() * 10000));		
	
			// Finding thumbs
			thumbs = self.find(settings.delegate);
			
			if (!settings.useThumbstrip) {
				settings.prefsKept.splice(0, 1);
			}
			
			loadPrefs(settings, settings.prefsKept, 'lb_pref');
			
			// Initializing controls
			initLightbox();	
			
			// Setting up events
			
			// Resize
			$window.on('resize.' + ns /* + ' orientationchange.' + ns*/, function() {
					clearTimeout(resizeTimeout);
					// Executed only if 50ms has passed since the last resize event
					resizeTimeout = setTimeout(function() { 
						clearTimeout(resizeTimeout);
						if (main && main.length && !(isVr && isFullscreen())) {
							fitImage();
						}
						lazyloadThumbs(fitThumbstrip);
					}, 50);
				});
			
			// Quit on document touch
			if (settings.quitOnDocClick) {
				
				lb_overlay.on('click.' + ns, function(e) {
						
						if (listening) {
							if (settings.autohideControls && controlsHidden()) {
								// Toggle controls back
								showControls();
								return false;
							}
							
							if (main.length && !$(e.target).is(main)) {
								// Quit
								quitLightbox();
								return false;
							}
						}
						
						return true;
					});
			}
			
			// On mouse-driven devices
			if (settings.autohideControls) {
				
				// Auto hide controls
				$document.on('mousemove.' + ns, function() {
						showControls();
						hideControlsLater();
					});
			}
							
			// Keyboard
			if (settings.enableKeyboard) {
				
				$document.on('keyup.' + ns, function(e) {
					if (!listening || !main.length || lightbox.children('.modal:visible').length || document.activeElement && (document.activeElement.nodeName === 'INPUT' || document.activeElement.nodeName === 'TEXTAREA')) {
						return true;
					}
					
					e.preventDefault();
					
					switch (e.keyCode) {
						
						case 27:
							quitLightbox();
							break;
						
						case 33:
						case 37:
							previousImage();
							break;
							
						case 34:
						case 39:
							nextImage();
							break;
							
						case 97:
						case 35:
							loadImage(thumbs.length - 1);
							break;
							
						case 103:
						case 36:
							loadImage(0);
							break;
						
						case 106:
						case 179:
							toggleAuto();
							break;
							
						case 107:
							if (settings.useZoom) {
								if (settings.zoomSlider) {
									increaseZoom();
								} else {
									toggleZoom();
								}
							} else {
								toggleCaption();
							}
							break;
							
						case 109:
							if (settings.useZoom) {
								if (settings.zoomSlider) {
									decreaseZoom();
								} else {
									toggleZoom();
								}
							} else {
								toggleAll();
							}
							break;
							
						case 32:
							if (isVideo) {
								if (media[0].paused) {
									playVideo(media[0]);
								} else {
									media[0].pause();
								}
							} else if (isAudio) {
								if (media[0].paused) {
									media[0].play();
								} else {
									media[0].pause();
								}
							} else {
								toggleAuto();
							}
							break;
							
						default:
							return true;
											
					}
					
					return false;
				});
			}
			
			// Mouse wheel
			if (settings.mouseWheelAction) {
				var wheelTimeout = null;
				
				lightbox.on('mousewheel.' + ns + ' DOMMouseScroll.' + ns, function(e) {
						if (listening) {
							clearTimeout(wheelTimeout);
							
							if (	!main.length || 
									$(e.target).closest('.' + settings.lightboxCaptionClass).length ||
									main.hasClass('pdf') || 
									main.hasClass('external') ||
									lightbox.children('.modal:visible').length
								) {
								return true;
							}
							
							if (e.ctrlKey == true || settings.mouseWheelAction === 'zoom') {
								if (settings.useZoom) {
									if (settings.zoomSlider) {
										wheelTimeout = setTimeout((e.originalEvent.wheelDelta > 0 || e.originalEvent.detail < 0)?
											function(e) {
												increaseZoom();
											}
											: 
											function(e) {
												decreaseZoom();
											}, 100);
									} else {
										wheelTimeout = setTimeout((e.originalEvent.wheelDelta > 0 || e.originalEvent.detail < 0)?
											function(e) {
												if (!fitImages) {
													fitImages = true;
													fitImage(true);
												}
											}
											: 
											function(e) {
												if (fitImage) {
													fitImages = false;
													fitImage(true);
												}
											}, 100);
									}
								}
							} else if (settings.mouseWheelAction === 'navigation') {
								var d = new Date();
								if (typeof lightbox.data('lastWheel') === UNDEF || (d - lightbox.data('lastWheel')) > 250) {
									// Only if 250ms apart from the last wheel event
									wheelTimeout = setTimeout(function(dir) {
											lightbox.data('lastWheel', new Date());
											if (dir) {
												previousImage();
											} else {
												nextImage();
											}
									 	}, 100, (e.originalEvent.wheelDelta > 0 || e.originalEvent.detail < 0));
								}
							}
						}
						return false;
					});
			}
			
			// Events that can be triggered from outside
		
			// External trigger to switch image
			self.on('lightboxLoad.' + ns, function(e, n, auto) {
						stopAuto(true);

						if (typeof n === NUMBER) {
							n = Math.minMax(0, n, thumbs.length);
						} else if (typeof n === UNDEF) {
							n = 0;
						} else {
							n = thumbs.index(n);
						}
						
						if (settings.onStart !== false) {
							settings.onStart((typeof n === NUMBER)? thumbs.eq(n) : th);
						}
						
						loadImage(n);
						
						if (slideshow) {
							stopAuto(true);
						}
						
						if (auto) {
							if (typeof auto === NUMBER) {
								setTimeout(startAuto, auto);
							} else {
								startAuto();
							}
						}
					})
				// External trigger to quit = does not remove, just hides the lightbox
				.on('lightboxQuit.' + ns, function() {
						quitLightbox();
						return false;
					})
				// Removing the lightbox completely
				.on('lightboxRemove.' + ns, function() {
						removeLightbox();
						return false;
					})
				// Stopping auto hide controls
				.on('stopAutoHide.' + ns, function() {
						clearTimeout(controlsTimeout);
					})
				// Returning the current lightbox container
				.on('lightboxContainer.' + ns, function() {
						return lightbox;
					})
				// External trigger to go to the previous image
				.on('lightboxNext.' + ns, function() {
						stopAuto();
						nextImage();
						return false;
					})
				// External trigger to go to next image
				.on('lightboxPrevious.' + ns, function() {
						stopAuto();
						previousImage();
						return false;
					});
			
			// Ready event
			
			if (settings.hasOwnProperty('onReady') && typeof settings.onReady === FUNCTION) {
				settings.onReady(thumb);
			}
			
			// Auto start
			
			if (settings.autoStart && settings.baseSet) {
				startAuto();
			}
	
			return this;
		};
	
	$.fn.lightbox.defaults = {
			delegate:						'.card.lbable',
			lightboxMainClass:				'lightbox-main',
			lightboxCaptionClass:			'lightbox-caption',
			lightboxOnClass:				'lightbox-on',
			controlsClass:					'controls',
			buttonClass:					'button',
			lazyloadClass:					'lazyload',
			activeClass:					'active',
			scrollClass:					'scroll',
			regionsClass:					'regions',
			captionVisibleClass:			'caption-visible',
			thumbsVisibleClass:				'thumbs-visible',
			hasbuttonsClass:				'hasbuttons',
			immerseClass:					'immerse',
			controlsVisibleClass:			'controls-visible',
			controlsHideClass:				'controls-hide',
			checkboxClass:					'checkbox',
			checkmarkClass:					'icon-checkmark',
			selectedClass:					'checked',
			playingClass:					'playing',
			transitionProps:				'300ms ease-out',
			slideshowDelay:					4000,
			timingControl:					false,
			hideControlsDelay:				2500,
			prefsKept: 						[
												'thumbsVisible',
												'captionVisible',
												'audioClipVolume'
											],
			controlsUseText:				false,
			thumbsVisible:					true,
			useThumbstrip:					true,
			captionVisible:					true,
			fitImages:						true,
			fitBetween:						'screen',
			fitRatio:						0.94,
			maxZoom:						1.4,
			horzPanoThreshold:				1.8,
			vertPanoThreshold:				0.5,
			displayOriginals:				true,
			useZoom:						true,
			zoomSlider:						false,
			useOriginals:					false,
			hiDpiThumbs:					false,
			hiDpiImages:					false,
			showFullscreen:					false,
			indexName:						'index.html',
			baseSet:						true,
			autohideControls:				false,
			autoStart:						false,
			clickAction:					'donothing',
			mouseWheelAction:				'navigation',
			useSlideshow:					true,
			autoplayAudioClips:				true,
			backgroundAudioSlideshowControl:false,
			muteBackgroundAudio:			true,
			use360Player:					true,
			autoRotate360:					true,
			rotateSpeed360:					-2,
			useGoogleDocs:					true,
			lightboxFullscreen:				false,
			slideshowFullscreen:			false,
			afterLast:						'donothing',
			doubleClickZoom:				true,
			mapHeight:						0.8,
			mapType:						'hybrid',
			mapZoom:						15,
			showShop:						false,
			showFeedback:					false,
			showLowestPrice:				false,
			videoAuto:						false,
			videoLoop:						false,
			autoPano:						false,
			autoPanoStart:					0,
			autoPanoSpeed:					80,
			volume:							0.5,
			audioClipVolume:				0.75,
			rightClickProtect: 				false,
			useRating:						false,
			jalbumRating:					false,
			visitorRating:					false,
			buttonLabels:					true,
			showNumbers:					false,
			infoPanelAdapt:					false,
			showShare:						false,
			showDownload:					false,
			allowDownloadScaled:			false,
			allowDownloadOthers:			false,
			showMap:						false,
			showRegions:					true,
			regionsVisible:					false,
			printImage:						false,
			metaAsPopup:					true,
			transitionType:					'crossFadeAndSlide',
			transitionSpeed:				400,
			panoramaAutoDetect:				1.3333,
			panoramaTreshold:				[ 2.5, 2.5 ],
			defaultPosterSize:				[ 628, 360 ],
			thumbSpeed:						400,
			thumbOverhead:					40,
			preloadNext:					true,
			enableKeyboard: 				true,
			quitOnEnd:						true,
			quitOnDocClick: 				true,
			onStart:						false,
			onClose:						false,
			onLoadStart:					false,
			onLoadEnd:						false,
			onReady:						false,
			onSlideshowStart:				false,
			onSlideshowPause:				false,
			onVolumeChange:					false,
			feedbackBtnLabel:				'Write feedback',
			feedbackBtnTooltip:				'View feedback window',
			feedback:						{}
		};
	
	$.fn.lightbox.text = {
			rating:							"Rating",
			print:							"Print",
			printLabel:						"Print out this photo on your printer",
			download:						"Download",
			addCart:						"Add to Cart",
			shopLabel:						"Add this item to the shopping cart",
			viewCart:						"View Cart",
			viewCartLabel:					"View shopping cart",
			fotomotoBtn:					"Buy / Share",
			fotomotoTooltip:				"Buy prints or digital files, share, send free eCards",
			metaBtn:						"Photo data",
			metaLabel:						"Display photographic (Exif/Iptc) data",
			regionsBtn:						"People",
			regionsLabel:					"Show tagged people",
			mapBtn:							"Map",
			mapLabel:						"Show the photo location on the map",
			mostphotosBtn:					"Purchase",
			mostphotosLabel:				"Download this image from <b>mostphotos.com</b>!",
			share:							"Share",
			shareLabel:						"Share this photo over social sites",
			shareOn:						"Share on",
			play:							"Play",
			audioClipLabel:					"Play / pause the attached audio clip",
			startOver:						"Start over",
			upOneLevel:						"Up one level",
			backToHome:						"Back to home",
			backToIndex:					"Back to index page",
			nextFolder:						"Next folder",
			nextIndex:						"Next index page",
			atLastPageQuestion:				"Where to go next?",
			atLastPage:						"At last page",
			clickToOpen:					"Click to open this document with the associated viewer",
			pauseShort:						"Pause",
			startSlideshowShort:			"Play",
			previousPicture:				"Previous picture",
			previousPictureShort:			"Prev",
			upOneLevelShort:				"Exit",
			zoom:							"Zoom",
			oneToOneSize:					"1:1 size",
			oneToOneSizeShort:				"1:1",
			fitToScreen:					"Fit to screen",
			fitToScreenShort:				"Fit",
			showThumbs:						"Show thumbnails",
			showThumbsShort:				"Thumbnails",
			hideThumbs:						"Hide thumbnails",
			hideThumbsShort:				"Hide thumbs",
			showInfo:						"Show caption / info",
			showInfoShort:					"Info",
			hideInfo:						"Hide caption / info",
			hideInfoShort:					"Hide info",
			slideshow:						"Slideshow",
			timing:							"Timing",
			startStopSlideshow:				"Start / stop slideshow",
			fullscreen:						"Fullscreen",
			fullscreenShort:				"Fullscr",
			exitFullscreen:					"Exit fullscreen",
			exitFullscreenShort:			"Normal",
			nextPicture:					"Next picture",
			nextPictureShort:				"Next"
		};

	
})(jQuery, jQuery(window), jQuery(document), jQuery('body'));
