<%
	var safeTitle = stripHTML(title).replace(/"/g, '&quot;').replace(/ & /g, ' &amp; '),				//" fixing syntax highlighting :)
		safeDescription = stripHTML((pageType === 'page')? comment : description).replace(/"/g, '&quot;').replace(/ & /g, ' &amp; '), 	//"
		safeThumbPath = (typeof hasFolderImage !== UNDEF && hasFolderImage)? ((typeof pageThumbPath === UNDEF)? shareImageFilename : pageThumbPath) : '';
	
	out.println('<!doctype html>' +
		'\n<html ' + (shareFacebook? 'prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb#" ' : '') + 'lang="' + language + '"' + ' class="no-js" data-level="' + level + '">' +
		'\n\t<!-- Generated by jAlbum app (https://jalbum.net) -->');
	
	/*********************************************************************************
	 *									HEAD
	 */
	
	out.println('\t<head>');
	
		out.println('\t\t<meta charset="' + textEncoding + '">');
		out.println('\t\t<meta http-equiv="x-ua-compatible" content="ie=edge">');
		out.println('\t\t<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">');
		
		// Preloading icon font
		out.println('\t\t<link rel="preload" href="' + resPath + '/icon/skinicon-' + iconStyle + '.woff?v' + skinVersion + '" as="font" type="font/woff" crossorigin>');
		out.println('\t\t<link rel="preload" href="' + resPath + '/icon/skinicon-' + iconStyle + '.ttf?v' + skinVersion + '" as="font" type="font/ttf" crossorigin>');
		
		// Google font
		if (typeof googleFont !== UNDEF && !!googleFont && copyGoogleFonts !== UNDEF && !copyGoogleFonts) {
			out.println('\t\t<link rel="preload" href="https://fonts.googleapis.com/css?family=' + googleFont + '" as="style">');
			out.println('\t\t<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=' + googleFont + '">');
		}
		
		// Title
		out.println('\t\t<title>' + [ safeTitle, titleSEOText ].filter(Boolean).join(' ') + '</title>');
		
		// Description
		out.println('\t\t<meta name="description" content="' + [ safeDescription || safeTitle, descriptionSEOText ].filter(Boolean).join(' ') + '">');
		
		// Author
		if (typeof writer !== UNDEF && writer) {
			out.println('\t\t<meta name="author" content="' + writer + '">');
		}
		
		// Generator
		out.println('\t\t<meta name="generator" content="' + [ 'jAlbum', internalVersion, '&', skinName, skinVersion, ('[' + styleName + ']') ].filter(Boolean).join(' ') + '">');
		
		// Keywords, tags
		var k = [];
		
		if (typeof keywords !== UNDEF && keywords) {
			k.push(keywords);
		}
		
		if (typeof albumTags !== UNDEF && albumTags) {
			k.push(albumTags);
		}
		
		if (k.length) {
			out.println('\t\t<meta name="keywords" content="' + k.join(' ') + '">');
		}
		
		// Folder thumbnail
		if (typeof pageUrl !== UNDEF && pageUrl) {
			out.println('\t\t<meta property="og:url" content="' + pageUrl + '">');
		}
		
		if (typeof hasFolderImage !== UNDEF && hasFolderImage) {
			out.println('\t\t<meta property="og:image" content="' + safeThumbPath + '">');
			
			if (pageProtocol === 'https:') {
				out.println('\t\t<meta property="og:image:secure_url" content="' + safeThumbPath + '">');
			}
				
			out.println('\t\t<meta property="og:image:width" content="' + folderThumbSize.split('x')[0] + '">');
			out.println('\t\t<meta property="og:image:height" content="' + folderThumbSize.split('x')[1] + '">');
			out.println('\t\t<link rel="image_src" href="' + safeThumbPath + '">');
			out.println('\t\t<meta name="twitter:image" content="' + safeThumbPath + '">');
		}
		
		// Title, description for OG
		out.println('\t\t<meta property="og:title" content="' + safeTitle + '">');
		out.println('\t\t<meta property="og:description" content="' + (safeDescription || safeTitle) + '">');
		
		// OG type
		out.println('\t\t<meta property="og:type" content="website">');
		
		// FB app ID
		if (facebookAppId) {
			out.println('\t\t<meta property="fb:app_id" content="' + facebookAppId + '">');
		}
		
		// Twitter-related meta tags
		out.println('\t\t<meta name="twitter:title" content="' + safeTitle + '">');
		out.println('\t\t<meta name="twitter:card" content="summary_large_image">');
		
		if (safeDescription) {
			out.println('\t\t<meta name="twitter:description" content="' + (safeDescription || safeTitle) + '">');
		}
		
		// Mobile-related meta
		out.println('\t\t<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">');
		out.println('\t\t<meta name="mobile-web-app-capable" content="yes">');
		out.println('\t\t<meta name="format-detection" content="telephone=no">');
		
		out.println('\t\t<link rel="manifest" href="' + resPath + '/site.webmanifest" crossorigin="use-credentials">');
		
		// Favicon
		if (useFavicon) {
			out.println('\t\t<link rel="apple-touch-icon" sizes="180x180" href="' + resPath + '/apple-touch-icon.png">');
			out.println('\t\t<link rel="icon" type="image/png" sizes="32x32" href="' + resPath + '/favicon-32x32.png">');
			out.println('\t\t<link rel="icon" type="image/png" sizes="16x16" href="' + resPath + '/favicon-16x16.png">');
			out.println('\t\t<link rel="mask-icon" href="' + resPath + '/safari-pinned-tab.svg" color="' + mainBgColor + '">');
			out.println('\t\t<link rel="icon" href="' + resPath + '/favicon.ico">');
			out.println('\t\t<meta name="msapplication-config" content="' + resPath + '/browserconfig.xml">');
		}
		
		out.println('\t\t<meta name="theme-color" content="' + mainBgColor + '">');
		out.println('\t\t<meta name="msapplication-TileColor" content="' + mainBgColor + '">');
		
		// Leaflet :: Open Street Map 
		if (_useMap && !googleApiKey && !avoidCDNs) {
			out.println('\t\t<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />');
		}
	
		// The main CSS file
		out.println('\t\t<link rel="stylesheet" href="' + resPath + '/common.css?v=' + skinVersion + '">');
				
		// Preloading theme image
		if (heroImageType && (typeof hasFolderImage !== UNDEF && hasFolderImage) || heroImageType === 'albumImage') {
			var smallBg = folderImageSmallFileName,
				small2xBg,
				normalBg = folderImageFileName,
				normal2xBg,
				hook = '.hero';
				
			if (hiDpiThemeImage) {
				small2xBg = smallBg.replace('.jpg', '@2x.jpg');
				normal2xBg = normalBg.replace('.jpg', '@2x.jpg');
			}
			
			if (heroImageType === 'albumImage' && rootPath !== '.') {
				smallBg = rootPath + '/' + smallBg;
				normalBg = rootPath + '/' + normalBg;
				if (hiDpiThemeImage) {
					small2xBg = rootPath + '/' + small2xBg;
					normal2xBg = rootPath + '/' + normal2xBg;
				}
			}
			
			// Preloading theme image
			out.println('\t\t<link rel="preload" href="' + smallBg + '?v=' + pageCounter + '" as="image" media="(max-width:800px)">');
			out.println('\t\t<link rel="preload" href="' + normalBg + '?v=' + pageCounter + '" as="image" media="(min-width:801px)">');
			if (hiDpiThemeImage) {
				out.println('\t\t<link rel="preload" href="' + small2xBg + '?v=' + pageCounter + '" as="image" media="(min-resolution:2dppx) and (max-width:800px)">');
				out.println('\t\t<link rel="preload" href="' + normal2xBg + '?v=' + pageCounter + '" as="image" media="(min-resolution:2dppx) and (min-width:801px)">');
			}
			out.println('\t\t<style>');
				out.println('\t\t\t@media (max-width:800px) { ' + hook + ' { background-image: url(' + smallBg + '?v=' + pageCounter + '); } }');
				out.println('\t\t\t@media (min-width:801px) { ' + hook + ' { background-image: url(' + normalBg + '?v=' + pageCounter + '); } }');
				if (hiDpiThemeImage) {
					out.println('\t\t\t@media (min-resolution: 2dppx) and (max-width:800px) { ' + hook + ' { background-image: url(' + small2xBg + '?v=' + pageCounter + '); } }');
					out.println('\t\t\t@media (min-resolution: 2dppx) and (min-width:801px) { ' + hook + ' { background-image: url(' + normal2xBg + '?v=' + pageCounter + '); } }');
				}
			out.println('\t\t</style>');
		}
		
		pageCounter += 1;
		
		// Custom page-related CSS
		getCustomPageCSS(currentObject);
		
		if (headHook) {
			out.println('\t\t' + getProcessed(headHook));
		}
		
		if (googleAnalytics === 'gtag') {
			out.println('\t\t<script async src="https://www.googletagmanager.com/gtag/js?id=' + googleSiteID + '"></script>');
			out.println('\t\t<script>');
				out.println('\t\t\twindow.dataLayer=window.dataLayer||[];');
				out.println('\t\t\tfunction gtag(){dataLayer.push(arguments);}');
				out.println('\t\t\tgtag(\'js\',new Date());');
				out.println('\t\t\tgtag(\'config\',\'' + googleSiteID + '\',{\'send_page_view\':false});');
			out.println('\t\t</script>');
		}
		
	out.println('\t</head>');

	/*********************************************************************************
	 *									BODY
	 */
	 
	 out.println('\t<body id="' + pageType + '" class="' + [
					pageType, 
					'scrollable', 
					'stop-transitions',
					lightStyle? 'light-mode' : 'dark-mode',
					level? 'sub-album' : 'top-level',
					'icon-' + iconStyle,
					(pageType === 'page')? pageHook : '',
					(maxPageWidth === 'none')? 'no-limit' : ''
				].filter(Boolean).join(' ') + '">');
		
		out.println('\t\t<div id="main" class="' + [
					'main',
					hoverEffect || '',
					(typeof locationCount !== UNDEF && !!locationCount)? 'has-map' : 'no-map'
				].filter(Boolean).join(' ') + '" data-baseHasMap="' + (typeof locationCount !== UNDEF && !!locationCount) + '">');
		
		if (typeof header !== UNDEF && header.length) {
			out.println('\t\t\t<div class="custom-header' + (headerFitWidth? ' fit-width' : '') + '">' + getProcessed(header) + '</div>');
		}
		
		/*********************************************************************************
		 *								  Top bar
		 */
		
		if (buttonbarPlacement === 'above') {
			out.println(getInclude('panels.inc'));
		}
		
		/*********************************************************************************
		 *								Main content
		 */

		if (pageType === 'page') {
			out.println(getInclude('hero-page.inc'));	
			if (buttonbarPlacement === 'below') {
				out.println(getInclude('panels.inc'));
			}
			out.println('\t\t\t<article id="main-cont" class="content base-overlay">');
				out.println('\t\t\t\t<section class="custom">');
					out.println('\t\t\t\t\t<div class="page-wrap cont">');
		} else {
			out.println(getInclude('hero.inc'));
			if (buttonbarPlacement === 'below') {
				out.println(getInclude('panels.inc'));
			}
		}
		
%>