;(function($, $target) {
	'use strict';
				
	/* 
		smoothScroll.js - provides smooth scroll functionality for internal links
	*/

	$.fn.smoothScroll = function(settings) {
		
		return $(this).on('click', function(e) {
				var te = $(this).data('smoothscroll'),
					be = (settings && settings.hasOwnProperty('below'))? $(settings.below) : false,
					target = navigator.userAgent.match(/(iPod|iPhone|iPad)/)? $('body') : $('html');
				
				if (te.length) {
					te = $(te).filter(':visible').eq(0);
					
					if (te.length) {
						if (navigator.userAgent.match(/(iPod|iPhone|iPad)/)) {
							var scrollTo = function(to, dur) {
									var start = window.scrollY,
										d = to - start - (be? be.outerHeight() : 0),
										time = 0,
										
										easeFn = function(t) {
												return (t < .5)?
														(2 * t * t)
														:
														(1 - (-2 * t + 2) * (-2 * t + 2) / 2);
											},
											
										scrollFn = function() {
												time += 20;
												window.scrollTo(0, Math.round(start + d * easeFn(time / dur)));
												if (time < dur) {
													setTimeout(scrollFn, 20);
												}
											};
											
									scrollFn();
								};
								
							scrollTo(te.offset().top, 500);
							
						} else {
							target.animate({ 
									scrollTop: 		te.offset().top - (be? be.outerHeight() : 0) 
								}, 500, function() {
									target.clearQueue();
								});
						}
						
						return false;
					}
					
					return true;
				}
			});
	};
	
}(jQuery, navigator.userAgent.match(/(iPod|iPhone|iPad)/)? jQuery('body') : jQuery('html')));