/*	
 *	laza.easySlider() :: simple slider
 *
 *	Copyright by Lazaworx
 *	http://www.lazaworx.com
 *	Author: Laszlo Molnar
 *
 *	Dual licensed under the MIT and GPL licenses.
 *	- http://www.opensource.org/licenses/mit-license.php
 *	- http://www.gnu.org/copyleft/gpl.html
 *
 *	Usage: $(element).easyslider( options );
 */
 
;(function($, $window, $body) {
	'use strict';
		
	$.fn.easySlider = function(settings) {
		
			settings = $.extend({}, $.fn.easySlider.defaults, settings);
			
			return this.each(function() {
				
					var self = $(this);
					
					if (self.attr('data-easyslider-id')) {
						return true;
					}
						
					var	ns 			= 'les_' + Math.floor(Math.random() * 10000),	// Namespace
						sto			= null,											// Slideshow timeout
						shown		= [],											// Already shown
						
						imgReady = function(src) {
								var os = self.children('.' + settings.slideClass),
									ns = ($('<div>', {
											'class':			settings.slideClass
										}).css({
											transition:			'none',
											opacity:			0,
											backgroundImage:	'url(' + src + ')'
										})).appendTo(self);
								
								setTimeout(function() {
										window.requestAnimationFrame(function() {
												os.one('transitionend', function() {
														$(this).remove();
													});
												ns.one('transitionend', function() {
														clearTimeout(sto);
														sto = setTimeout(nextSlide, settings.delay);	
													});
												os.css({
														transition:			'opacity ' + settings.speed + 'ms ease',
														opacity: 			0
													});
												ns.css({
														transition:			'opacity ' + settings.speed + 'ms ease',
														opacity:			1
													});
											});
										
										sto = setTimeout(nextSlide, settings.delay + 50);
										
									}, 50);
								
							},
							
						getNextSource = function() {
								var r;
								
								do {
									r = Math.floor(Math.random() * settings.src.length);
								} while (shown.indexOf(r) >= 0);
								
								shown = [r].concat(shown).slice(0, settings.src.length - 1);
								
								return settings.src[r];
							},
							
						nextSlide = function() {
							
								clearTimeout(sto);
									
								var img = new Image(),
									src = getNextSource(),
									ready = false;
								
								$(img).one('load', function() {
										if (!ready) {
											ready = true;
											imgReady(src);
										}
									}).attr('src', src);
									
								if (img.complete && img.naturalWidth) {
									if (!ready) {
										ready = true;
										imgReady(src);
									}
								}
							},
							
						init = function() {
								
								self.attr('data-easyslider-id', ns);
								
								if (settings.hasOwnProperty('src') && settings.src.length > 1) {
									sto = setTimeout(nextSlide, settings.delay);
								}
							};
						
					// Starts here
					
					init();
					
				});
		};
				
	$.fn.easySlider.defaults = {
			delay:			2000,
			speed: 			1500,
			randomize:		true,
			slideClass:		'slide',
			transition: 	'crossFade'
		};
	
})(jQuery, jQuery(window), jQuery('body'));
							
