<%
		// Sidebar navigation
	var	navigation = function() {
				return (navigationType !== 'subfolders')? 
					getTree(rootFolder, true, true, true, 4)
					:
					(pageType !== 'page')? 
					getTopMenu(currentFolder, true, true, true)
					:
					'';
			}(),
			
		upButton = function() {
				return (level || pageType === 'page')?
					('<a href="' + (pageType === 'page'? '' : '../') + indexName + '" class="btn icon-one-level-up" title="' + getText('upOneLevel') + '"></a>')
					:
					(!level && homepageAddress)?
					('<a href="' + homepageAddress + '" class="btn icon-home" title="' + getText('home') + '">' + (homepageLinkText || getText('home')) + '</a>')
					:
					'';
			}(),
					
		// Items
		items = children.thumbnails();
		
		// Sharing
		sharingLinks = hasShare?
			function() {
				// Creating sharing icons
				var	sb = [],
					t = encodeURIComponent(title),
					d = encodeURIComponent(stripHTML(description)),
					txt = [t, d].filter(Boolean).join('%20');
					
				if (shareFacebook) {
					sb.push('<a href="https://www.facebook.com/sharer/sharer.php?u=$PAGE_URL" class="facebook btn icon-facebook" target="_blank" rel="nofollow noopener">Facebook</a>');
				}
				if (shareThreads) {
					sb.push('<a href="https://threads.net/intent/post?text=' + txt + ':%20$PAGE_URL" class="threads btn icon-threads" target="_blank" rel="nofollow noopener">Threads</a>');
				}
				if (shareBlueSky) {
					sb.push('<a href="https://bsky.app/intent/compose?text=' + txt + ':%20$PAGE_URL" class="bluesky btn icon-bluesky" target="_blank" rel="nofollow noopener">BlueSky</a>');
				}
				if (shareTwitter) {
					sb.push('<a href="https://twitter.com/intent/tweet?url=$PAGE_URL&text=' + txt + '" class="twitter btn icon-x" target="_blank" rel="nofollow noopener">X / Twitter</a>');
				}
				if (shareLinkedIn) {
					sb.push('<a href="https://www.linkedin.com/shareArticle?mini=true&url=$PAGE_URL&title=' + t + '&summary=' + d + '" class="linkedin btn icon-linkedin" target="_blank" rel="nofollow noopener">LinkedIn</a>');
				}
				if (sharePinterest) {
					sb.push('<a href="https://www.pinterest.com/pin/create/button?url=$PAGE_URL&media=IMAGE&description=' + txt + '" class="pinterest btn icon-pinterest" target="_blank" rel="nofollow noopener">Pinterest</a>');
				}
				if (shareReddit) {
					sb.push('<a href="https://www.reddit.com/submit?url=$PAGE_URL&title=' + d + '" class="reddit btn icon-reddit" target="_blank" rel="nofollow noopener">Reddit</a>');
				}
				if (shareEmail) {
					sb.push('<a href="mailto:?subject=' + t + '&body=$PAGE_URL%20%0D%0A' + d + '" class="email btn icon-email" target="_blank" rel="nofollow noopener">' + getText('email') + '</a>');
				}
				if (shareLink) {
					sb.push('<a href="javascript:void(0)" class="link btn icon-link" target="_blank" rel="nofollow noopener">' + getText('link') + '</a>');
				}
				return sb.join('');
			}()
			:
			'',
		// Original page name
		originalPageName = (pageType === 'page')? getOriginalPageName(currentObject, 'user') : 'index',
		// Page URL if uploaded at least once or empty
		pageUrl = basePath? (basePath.replace(/^http:/,'https:') + encodeAsJava(getRelPath(currentFolder)) + ((pageType === 'page')? encodeAsJava(currentObject.getWebName()) : '')) : '',
		// Page title
		pageTitle = stripHTML(title).replace(/"/g, '&quot;').replace(/ & /g, ' &amp; '),				//" fixing syntax highlighting :)
		// Page description
		pageDescription = stripHTML((pageType === 'page')? comment : description).replace(/"/g, '&quot;').replace(/ & /g, ' &amp; '), 	//"
		// Relative path to folder from root
		relPathEncoded = encodeAsJava(getRelPath(currentFolder));
		// Counts
		count = getCountObj(currentFolder);
		itemCount = count.image + count.audio + count.video + count.other; 
		// Page thumb path
		rao = currentFolder.getRepresentingAlbumObject(),
		shareImage = rao? rao.getVars().get('imagePath') : '',
		// Gets folder modified dates
		getDates = function(ao, deep, nodeName, className) {
			var dr = (typeof deep !== 'undefined' && deep)? JAlbumUtilities.getDeepCameraDates(ao) : JAlbumUtilities.getDeepCameraDates(ao),
				nodenm = typeof nodeName !== 'undefined'? nodeName : 'div',
				classnm = typeof className !== 'undefined'? className : 'dates';
			if (dr && dr.first < dr.last) { 
				return '<' + nodenm + ' class="' + classnm + '">' + getFormattedDateRange(dr.first + 0, dr.last + 0) + '</' + nodenm + '>';
			}
			return '';
		},
		// Use map?
		useMap = (pageType === 'page' || showMapBtn) && hasLocationData(currentObject),
		// Returns the lightbox caption according to 'lightboxItems' variable
		getLightboxCaption = function(ao) {
			var vars = ao.getVars(),
				keys = lightboxItems.split('\t'),
				k,
				val,
				tf = false,
				sb = [];
				
			for each (k in keys) {
				
				if (k === 'fileTitle' || k === 'label' || k === 'fileName') {
					if (lightboxTitleFirstFound && tf) {
						continue;
					}
					val = (k === 'label')? vars.get('label').replaceAll('_', ' ') : vars.get(k);
					if (val) {
						sb.push('<span class="title">' + val + '</span>');
						tf = true;
					}
				} else {
					
					if (k === 'photodata') {
						val = getPhotodataFields(ao, photodataTemplate);
					} else {
						val = vars.get(k);
					}
					
					if (val) {
						sb.push('<span class="' + k + (k === 'photodata'? ' icon-camera"> ' : k === 'keywords'? ' icon-tag"> ' : '">') + val + '</span>');
					}
				}
			}
			
			return sb.join('').replaceAll('"', '&#34;');
		};
	
	/* HTML */
	out.println('<!DOCTYPE html>');
	out.println('<html lang="' + language + '">');
	
	/* HEAD */
	out.println('<head>');
		out.println('\t<meta charset="' + textEncoding + '">');
		out.println('\t<title>' + albumTitle + '</title>');
		out.println('\t<meta name="generator" content="jAlbum ' + internalVersion + ' with ' + skinName + ' ' + skinVersion + ', ' + style + ' style, album creation date ' + currentDate + '">');
		out.println('\t<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">');
		if (typeof albumTags !== UNDEF || typeof keywords !== UNDEF) {
			var tags = [];
			if (typeof albumTags !== UNDEF) {
				tags.push(albumTags);
			}
			if (typeof keywords !== UNDEF) {
				tags.push(keywords);
			}
			out.println('\t<meta name="keywords" content="' + tags.join(' ') + '">');
		}
		out.println('\t<meta name="description" content="' + pageDescription + '">');
		// Mobile-related meta
		out.println('\t<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">');
		out.println('\t<meta name="mobile-web-app-capable" content="yes">');
		out.println('\t<meta name="format-detection" content="telephone=no">');
		// Google font
		if (googleFont) {
			out.println('\t<link rel="preload" href="https://fonts.googleapis.com/css?family=' + googleFont + '" as="style">');
			out.println('\t<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=' + googleFont + '">');
		}
		if (hasShare) {
			if (pageUrl) {
				out.println('\t<meta property="og:url" content="' + pageUrl + '">');
			}
			out.println('\t<meta property="og:title" content="' + pageTitle + '">');
			out.println('\t<meta property="og:description" content="' + pageDescription + '">');
			out.println('\t<meta property="og:type" content="website">');
			if (shareImage) {
				out.println('\t<meta property="og:image" content="' + basePath + relPathEncoded + shareImage + '">');
				out.println('\t<meta property="og:image:width" content="' + rao.getVars().get('imageWidth') + '">');
				out.println('\t<meta property="og:image:height" content="' + rao.getVars().get('imageHeight') + '">');
				out.println('\t<link rel="image_src" href="' + basePath + relPathEncoded + shareImage + '">');
			}
		}
		out.println('\t<link rel="icon" type="image/png" href="' + resPath + '/favicon-96x96.png" sizes="96x96">');
		out.println('\t<link rel="icon" type="image/svg+xml" href="' + resPath + '/favicon.svg">');
		out.println('\t<link rel="shortcut icon" href="' + resPath + '/favicon.ico">');
		out.println('\t<link rel="apple-touch-icon" sizes="180x180" href="' + resPath + '/apple-touch-icon.png">');
		// Leaflet :: Open Street Map 
		if (useMap) {
			out.println('\t<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />');
		}
		/* Main CSS */ 
		out.println('\t<link rel="stylesheet" href="' + resPath + '/common.css">');
		out.println(getUserInclude(rootImageDirectory, 'user-head.inc'));
		if (typeof headHook !== UNDEF && headHook) {
			out.println('\t' + getProcessed(headHook));
		}
		
	out.println('</head>');
	
	/* BODY */
	out.println('<body class="' + [
			pageType, 
			pageType === 'page'? (originalPageName + '-page') : '',
			(getLuminosity(lightboxBackgroundColor) > 0.6? 'light' : 'dark') + '-mode',
			itemCount? 'has-thumbs' : 'menu-on'
		].filter(Boolean).join(' ') + '">');
	out.println('\t<script>document.body.classList.add(\'stop-transitions\');</script>');

	/* MAIN */
	out.println('\t<article class="main">');

	out.println(getInclude('sidebar.inc'));
	
	if (pageType === 'page') {
		out.println('\t\t<section id="lightbox" class="page-wrap lightbox">');
			out.println('\t\t\t<div class="cont page">');
	}
%>