/*
 *	init.js - initializing the skin, skin-specific utilities
 *	Author: Laza
 */

var JAFilter = Java.type("se.datadosen.jalbum.JAFilter"),
	JAlbumUtilities = Java.type("se.datadosen.jalbum.JAlbumUtilities"),
	FixedShapeFilter = Java.type("FixedShapeFilter"),
	ThemeImageProcessor = Java.type("se.datadosen.jalbum.ThemeImageProcessor"),
	
	// Undefined
	UNDEF = 'undefined';

 	// URL-encoding should be always on
	engine.setUrlEncode(true);
	
	// Making folder thumbs fixed shape
	engine.addFilter(new FixedShapeFilter(), JAFilter.THUMBNAILS_PRESCALE_STAGE);
	
	// Setting up Theme image processor
	engine.setThemeImageProcessor(new ThemeImageProcessor());
	
	// Reading custom keys
	if (typeof customKeys !== UNDEF) {
		getCustomTexts(customKeys);
	}
	
	credits = getCredits();
	
	// Has subfolders or a simple album
	albumHasFolders = JAlbumUtilities.countCategories(rootFolder, false).getCount(Category.folder) > 0;
	
	// Has sharing options
	hasShare = shareFacebook || shareTwitter || shareLinkedIn || sharePinterest || shareReddit || shareEmail || shareLink;
	shares = [ shareFacebook? 'facebook':'', shareTwitter? 'twitter':'', shareLinkedIn? 'linkedIn':'', sharePinterest? 'pinterest':'', shareReddit? 'reddit':'', shareEmail? 'email':'', shareLink? 'link':'' ].filter(Boolean).join(',');
	
	// Create a stripped album description for use in a meta tag
	strippedAlbumDescription = stripHTML(albumDescription);

	photodataTemplate = "# Creator & rights\n" +
		"Creator: xmp.dc:creator|photographer|artist|Artist|Owner|xmp.aux:OwnerName|Creator|Xmp.Author|Iptc.IIM/Creator\n" +
		"Credit: xmp.dc:credit|Credit|Iptc.IIM/CreditLine\n" +
		"Rights: xmp.dc:rights|rights|xmp.xmpRights:UsageTerms|Iptc.IIM/Usage Terms\n" +
		"Copyright: Copyright|Iptc.Copyright Notice|Iptc.IIM/CopyrightNotice\n" +
		"# Title\n" +
		"Title: xmp.dc:title|Xmp.Title|objectName|Iptc.IIM/ObjectName|Xmp.UserComment\n" +
		"Headline: xmp.photoshop:Headline|Headline|Iptc.IIM/Headline\n" +
		"# Description\n" +
		"Description: xmp.dc:description|ImageDescription|Xmp.Description|Xmp.Subject|Iptc.IIM/Caption/Abstract\n" +
		"Category: xmp.photoshop:Category|Category|Iptc.IIM/Category\n" +
		"# Keywords\n" +
		"Keywords: xmp.dc:subject|keywords|Iptc.IIM/Keywords\n" +
		"Identifier: xmp.dc:identifier|Xmp.Identifier\n" +
		"Label: Xmp.Label\n" +
		"# Location\n" +
		"Country: xmp.photoshop:Country|Country|Country/Primary Location|Country/Primary Location Name|Iptc.IIM/Country\n" +
		"State: xmp.photoshop:State|Province/State|Iptc.IIM/Province/State\n" +
		"City: xmp.photoshop:City|City|Iptc.IIM/City\n" +
		"Sub-location: Sub-location|Iptc.IIM/Sub-Location\n" +
		"# Camera\n" +
		"Date/Time: originalDate|Date/Time Original|Date/Time|CreateDate|ModifyDate\n" +
		"Make: Make\n" +
		"Model: Model|Camera\n" +
		"Lens: lens|Lens|Lens Model|Canon makernote.Lens Model|Xmp.Lens-Information|xmp.aux:Lens|Lens Specification\n" +
		"Focal length: focalLength35mm|focusDistance|Focal Length|Focallength\n" +
		"Distance: SubjectDistance\n" +
		"Metering mode: meteringMode|Metering Mode\n" +
		"ISO equivalent: isoEquivalent|ISO Speed Ratings\n" +
		"Exposure time: exposureTime|Exposure Time|Shutter Speed Value|ShutterSpeedValue\n" +
		"Aperture: Aperture Value|aperture|F-Number|FNumber|Aperturevalue\n" +
		"Exposure bias: Exposure Bias Value\n" +
		"Exposure program: Exposure Program|Exposureprogram|Exposure Mode\n" +
		"Scene type: Xmp.SceneType\n" +
		"White balance: White Balance|WhiteBalance\n" +
		"Color space: Xmp.ColorSpace\n" +
		"Light source: Xmp.LightSource\n" +
		"Flash: flash|Flash\n" +
		"Resolution: resolution\n";
	
	// Passed skin settings
	jsVars = {
		slideshowDelay:		slideshowDelay,
		transTime: 			transitionLength,
		autoplayVideos: 	autoplayVideos,
		showMapBtn: 		showMapBtn,
		showDownloadBtn: 	showDownloadBtn,
		rightClickProtect: 	rightClickProtect,
		enableKeyboard: 	enableKeyboard,
		wheelAction: 		mouseWheelAction,
		adaptivePlacement:	captionCanBePlacedBeside,
		texts:				{
								download:		getSafeText('download'),
								map:			getSafeText('map')
							},
		thumbsPadding: 		48
	};
	
	if (lightboxBackground) {
		jsVars.backgroundType = lightboxBackground;
	}
	
	processFile('main.js', 'res/main.js');
