import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import se.datadosen.component.*;
import static se.datadosen.component.StateMonitor.enable;
import se.datadosen.jalbum.*;
import se.datadosen.util.Item;
public class Responsive extends CompiledBase {
    public Responsive(AlbumBean engine) {
        super(engine);
// Skin properties
        SkinProperties skinProps = new SkinProperties(skinDirectory);
        String skinVersion = skinProps.getProperty(SkinProperties.VERSION);
        ControlPanel ui = new ControlPanel() {
// Layout tab fields
            JCheckBox showFolderName = new JCheckBox(texts.getString("ui.layout.showFolderName"));
            JCheckBox folderImgCount = new JCheckBox(texts.getString("ui.layout.folderImgCount"));
            JComboBox folderTitleUp = new JComboBox<>(new Object[]{
                new Item("true", texts.getString("ui.layout.above")),
                new Item("false", texts.getString("ui.layout.under"))
            });
            JSpinner textSize = new JSpinner(new SpinnerNumberModel(16, 10, 32, 1));
            JComboBox imgBoxSize = new JComboBox<>(new Object[]{
                new Item("150", texts.getString("ui.layout.small")),
                new Item("175", texts.getString("ui.layout.medium")),
                new Item("200", texts.getString("ui.layout.large")),
                new Item("225", texts.getString("ui.layout.extraLarge"))
            });
            JComboBox imgHoverScaleFactor = new JComboBox<>(new Object[]{
                new Item("scale(1.0)", texts.getString("ui.layout.none")),
                new Item("scale(1.1)", texts.getString("ui.layout.small")),
                new Item("scale(1.2)", texts.getString("ui.layout.medium")),
                new Item("scale(1.3)", texts.getString("ui.layout.large"))
            });
            JSpinner maxImgInRow = new JSpinner(new SpinnerNumberModel(15, 1, 15, 1));
            JSpinner imgBorderSize = new JSpinner(new SpinnerNumberModel(1, 0, 5, 1));
            JSpinner imgBorderRadius = new JSpinner(new SpinnerNumberModel(0, 0, 9, 1));
            JComboBox imgShadowSize = new JComboBox<>(new Object[]{
                new Item("0px 0px", texts.getString("ui.layout.none")),
                new Item("1px 0px", texts.getString("ui.layout.small")),
                new Item("2px 2px", texts.getString("ui.layout.medium")),
                new Item("5px 5px", texts.getString("ui.layout.large"))
            });
            JComboBox imgShadowBlur = new JComboBox<>(new Object[]{
                new Item("0px", texts.getString("ui.layout.none")),
                new Item("4px", texts.getString("ui.layout.small")),
                new Item("10px", texts.getString("ui.layout.medium")),
                new Item("15px", texts.getString("ui.layout.large"))
            });
            JCheckBox showComments = new JCheckBox(texts.getString("ui.layout.showComments"));
            JSpinner slideBorderSize = new JSpinner(new SpinnerNumberModel(0, 0, 5, 1));
            JSpinner slideMarginSize = new JSpinner(new SpinnerNumberModel(0, 0, 40, 5));
            JAlphaColorSelector backgroundColor = new JAlphaColorSelector(texts.getString("ui.layout.backgroundColor"), new JSmartTextField("#00000000", 8));
            JAlphaColorSelector textColor = new JAlphaColorSelector(texts.getString("ui.layout.fontColor"), new JSmartTextField("#ff333333", 8));
            JAlphaColorSelector imgBorderColor = new JAlphaColorSelector(texts.getString("ui.layout.imgBorderColor"), new JSmartTextField("#ffffffff", 8));
            JAlphaColorSelector imgShadowColor = new JAlphaColorSelector(texts.getString("ui.layout.imgShadowColor"), new JSmartTextField("#00000000", 8));
            JAlphaColorSelector slideBorderColor = new JAlphaColorSelector(texts.getString("ui.layout.imgBorderColor"), new JSmartTextField("#ffffffff", 8));
            JSpinner embedBorderRadius = new JSpinner(new SpinnerNumberModel(10, 0, 20, 1));
// About tab fields
            JLabel description = new JLabel(texts.getString("ui.about.description"));
            JLabel version = new JLabel(texts.getString("ui.about.version") + " " + skinVersion);
            {
// Layout tab listeners
                new StateMonitor() {
                    public void onChange() {
                        enable(showFolderName.isSelected(), folderImgCount, folderTitleUp, textSize);
                        enable(!imgShadowSize.getSelectedItem().equals("0px 0px"), imgShadowBlur);
                    }
                }.add(showFolderName).add(imgShadowSize).done();
// Layout tab setup
                ControlPanel layoutPanel = new ControlPanel() {
                    ControlPanel aa = new ControlPanel() {
                        ControlPanel aaa = new ControlPanel() {
                            ControlPanel aaaa = new ControlPanel(texts.getString("ui.layout.Folders")) {
                                {
                                    add(showFolderName);
                                    add("br", folderImgCount);
                                    add("br", new JLabelFor(texts.getString("ui.layout.folderTitleUp"), folderTitleUp));
                                    add("tab", folderTitleUp);
                                    add("br", new JLabelFor(texts.getString("ui.layout.fontSize"), textSize));
                                    add("tab", textSize);
                                    add(new JLabelFor("px", textSize));
                                }
                            };
                            ControlPanel bbbb = new ControlPanel(texts.getString("ui.layout.Thumbnails")) {
                                {
                                    add(new JLabel(texts.getString("ui.layout.imgBoxSize")));
                                    add("tab", imgBoxSize);
                                    add("br", new JLabel(texts.getString("ui.layout.imgHoverScaleFactor")));
                                    add("tab", imgHoverScaleFactor);
                                    add("br", new JLabel(texts.getString("ui.layout.maxImgInRow")));
                                    add("tab", maxImgInRow);
                                    add("br", new JLabel(texts.getString("ui.layout.imgBorderSize")));
                                    add("tab", imgBorderSize);
                                    add(new JLabel("px"));
                                    add("br", new JLabel(texts.getString("ui.layout.imgBorderRadius")));
                                    add("tab", imgBorderRadius);
                                    add(new JLabel("px"));
                                    add("br", new JLabel(texts.getString("ui.layout.imgShadowSize")));
                                    add("tab", imgShadowSize);
                                    add("br", new JLabelFor(texts.getString("ui.layout.imgShadowBlur"), imgShadowBlur));
                                    add("tab", imgShadowBlur);
                                }
                            };
                            {
                                add("hfill", aaaa);
                                add("br hfill vfill", bbbb);
                            }
                        };
                        {
                            add("vfill", aaa);
                        }
                        ControlPanel bbb = new ControlPanel() {
                            ControlPanel cccc = new ControlPanel(texts.getString("ui.layout.Slides")) {
                                {
                                    add(showComments);
                                    add("br", new JLabel(texts.getString("ui.layout.slideBorderSize")));
                                    add("tab", slideBorderSize);
                                    add(new JLabel("px"));
                                    add("br", new JLabel(texts.getString("ui.layout.slideMarginSize")));
                                    add("tab", slideMarginSize);
                                    add(new JLabel(texts.getString("ui.layout.slideMarginSizeRelative")));
                                }
                            };
                            ControlPanel dddd = new ControlPanel(texts.getString("ui.layout.Colors")) {
                                {
                                    add(new JLabel(texts.getString("ui.layout.backgroundColor")));
                                    add("tab", backgroundColor.getTextComponent());
                                    add("tab", backgroundColor);
                                    add("br", new JLabel(texts.getString("ui.layout.backgroundColorAdvice")));
                                    add("br", new JLabel(texts.getString("ui.layout.fontColor")));
                                    add("tab", textColor.getTextComponent());
                                    add("tab", textColor);
                                    add("br", new JLabel(texts.getString("ui.layout.imgBorderColor")));
                                    add("tab", imgBorderColor.getTextComponent());
                                    add("tab", imgBorderColor);
                                    add("br", new JLabel(texts.getString("ui.layout.imgShadowColor")));
                                    add("tab", imgShadowColor.getTextComponent());
                                    add("tab", imgShadowColor);
                                    add("br", new JLabel(texts.getString("ui.layout.slideBorderColor")));
                                    add("tab", slideBorderColor.getTextComponent());
                                    add("tab", slideBorderColor);
                                }
                            };
                            ControlPanel eeee = new ControlPanel(texts.getString("ui.layout.Embedding")) {
                                {
                                    add(new JLabel(texts.getString("ui.layout.embedBorderRadius")));
                                    add("tab", embedBorderRadius);
                                    add(new JLabel("px"));
                                    add("br", new JLabel(texts.getString("ui.layout.embedBorderRadiusAdvice")));
                                }
                            };
                            {
                                add("hfill", cccc);
                                add("br hfill", dddd);
                                add("br hfill vfill", eeee);
                            }
                        };
                        {
                            add("vtop vfill", aaa);
                            add("hfill vfill", bbb);
                        }
                    };
                    {
                        add(aa);
                    }
                };
// About tab setup
                ControlPanel aboutPanel = new ControlPanel() {
                    {
                        add("br", description);
                        add("br", version);
                    }
                };
// Add tabs
                JTabbedPane tabs = new JTabbedPane() {
                    {
                        add(layoutPanel, texts.getString("ui.layoutPanel"));
                        add(aboutPanel, texts.getString("ui.aboutPanel"));
                    }
                };
                {
                    add("hfill vfill", tabs);
                }
            }
        };
// Install components into jAlbum
            window.setSkinUI (ui);
            window.pack ();
        }
    }
