package projector;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import se.datadosen.component.JPlaylist;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.util.SmartResourceBundle;

/**
 *
 * @author Laza
 */

public class ImageDataUI extends JCustomPanel {

	JPlaylist backgroundAudioLocal = new JPlaylist();
	JLabel backgroundAudioLabel = new JLabel();
	JCheckBox panorama = new JCheckBox();
	JCheckBox hideLocation = new JCheckBox();
	JLabel customSlideshowDelayLabel = new JLabel();
	JTextField customSlideshowDelay = new JTextField(4);
	JLabel customTransitionSpeedLabel = new JLabel();
	JTextField customTransitionSpeed = new JTextField(4);

	@Override
	public void setAlbumObject(AlbumObject ao) {
			
		super.setAlbumObject(ao);
			
		if (ao != null) {
			Category cc = ao.getCategory();
			boolean lightboxable = cc != Category.folder && cc != Category.webPage && cc != Category.webLocation;
			
			backgroundAudioLocal.setVisible(cc == Category.folder);
			backgroundAudioLabel.setVisible(cc == Category.folder);
			panorama.setVisible(lightboxable);
			hideLocation.setVisible(lightboxable);
			customSlideshowDelayLabel.setVisible(lightboxable);
			customSlideshowDelay.setVisible(lightboxable);
			customTransitionSpeedLabel.setVisible(lightboxable);
			customTransitionSpeed.setVisible(lightboxable);
		}
	}
	
	public ImageDataUI(JAlbumContext context, SmartResourceBundle texts) {
		
		super(context);
		//setOpaque(true);
		backgroundAudioLabel.setText(texts.getString("ui.backgroundMusic"));
		panorama.setText(texts.getString("ui.panorama"));
		hideLocation.setText(texts.getString("ui.hideLocation"));
		customSlideshowDelayLabel.setText(texts.getString("ui.slideshowDelay"));
		customSlideshowDelay.setToolTipText(texts.getString("ui.customSlideshowDelayInfo") + " " + texts.getString("ui.leaveEmptyForDefault"));
		customTransitionSpeedLabel.setText(texts.getString("ui.transitionSpeed"));
		customTransitionSpeed.setToolTipText(texts.getString("ui.customTransitionSpeedInfo") + " " + texts.getString("ui.leaveEmptyForDefault"));

		add("", backgroundAudioLabel);
		add("br hfill", backgroundAudioLocal);
		add("", panorama);
		add("br", hideLocation);
		add("br", customSlideshowDelayLabel);
		add("tab", customSlideshowDelay);
		add("br", customTransitionSpeedLabel);
		add("tab", customTransitionSpeed);

		init();
	}
}
