/* 
 *	main.js - the skin's javascript functions
 */
	
;(function($, $window, $document, $body, undefined) {
	'use strict';
				
	/********************************************************
	 *
	 *		Implementing select functions on images
	 *
	 ********************************************************/
	
	$.fn.selectable = function(options) {
		
			options = $.extend({
							cardClass:				'card',
							thumbClass:				'thumb',
							checkboxClass: 			'checkbox',
							selectedClass:			'checked',
							checkmarkClass:			'icon-checkmark',
							hasSelectedClass:		'has-selected',
							allSelectedClass:		'all-selected',
							selectionChange:		null
						}, options);
			
			var overlay = $(this).eq(0),
				cards,
				
				update = function(n) {
					
						if (typeof options.selectionChange === FUNCTION) {
							options.selectionChange.call(n);
						}
						
						$body
							.toggleClass(options.hasSelectedClass, n > 0)
							.toggleClass(options.allSelectedClass, n === cards.length);
					},
					
				selectedCnt = function() {
						return cards.filter('.' + options.selectedClass).length;
					},
				
				getCards = function() {
						return options.selector? overlay.find(options.selector) : overlay.find('.' + options.cardClass);
					},
					
				selectCard = function(e) {
						var card = (e instanceof $)? e : $(this);
						
						card.addClass(options.selectedClass)
							.find('.' + options.checkboxClass)
							.addClass(options.checkmarkClass);
					},
					
				unselectCard = function(e) {
						var card = (e instanceof $)? e : $(this);
						
						card.removeClass(options.selectedClass)
							.find('.' + options.checkboxClass)
							.removeClass(options.checkmarkClass);
					},
					
				toggleCard = function(e) {
						var card = (e instanceof $)? e : $(this);
						
						if (card.hasClass(options.selectedClass)) {
							unselectCard(card);
						} else {
							selectCard(card);
						}
					},
			
				clicked = function(e) {
						var card = $(e.target).closest('.' + options.cardClass),
							n = selectedCnt();
						
						if (card.hasClass(options.selectedClass)) {
							unselectCard(card);
							n -= 1;
							
							if (typeof options.selectionChange === FUNCTION) {
								options.selectionChange.call(n);
							}
							
						} else {
							
							selectCard(card);
							n += 1;
							
							if (typeof options.selectionChange === FUNCTION) {
								options.selectionChange.call(n);
							}
						}	
						
						update(n);
						
						return false;
					},
			
				selectAll = function() {
					
						if (overlay.is(':visible')) {
							var n = selectedCnt();
							
							if (n < cards.length) {
								n = cards.length;
								cards.not('.' + options.selectedClass).each(function() {
										selectCard($(this));
									});
										
								if (typeof options.selectionChange === FUNCTION) {
									options.selectionChange.call(n);
								}
							}
							
							update(n);
						}
					},
			
				selectNone = function() {
					
						if (overlay.is(':visible')) {
							var n = selectedCnt();
							
							if (n > 0) {
								n = 0;
								cards.filter('.' + options.selectedClass).each(function() {
										unselectCard($(this));
									});
										
								if (typeof options.selectionChange === FUNCTION) {
									options.selectionChange.call(n);
								}
							}
							
							update(n);
						}
					},
					
				selectInverse = function() {
					
						if (overlay.is(':visible')) {
							var n = cards.length - selectedCnt();
							
							if (n === 0) {
								// All selected
								cards.each(function() {
										unselectCard($(this));
									});
								
								if (typeof options.selectionChange === FUNCTION) {
									options.selectionChange.call(0);
								}
								
							} else {
								// Some selected
								cards.each(function() {
										toggleCard($(this));
									});
								
								if (typeof options.selectionChange === FUNCTION) {
									options.selectionChange.call(n);
								}
							}
							
							update(n);
						}
					},
				
				selectRefresh = function() {
						var th, 
							cb;
						
						cards = getCards();
						
						cards.each(function() {
								
							if (!($(this).find('span.' + options.checkboxClass).length)) {
								
								th = $(this).children('.' + options.thumbClass).eq(0);
								
								if (th.length) {
									cb = $('<span>', {
										'class': 	options.checkboxClass
										}).appendTo(th);
								} else {
									cb = $('<span>', {
											'class': 	options.checkboxClass
										}).prependTo($(this));
								}
								
								cb.on({
										click: 		clicked
									});
							}
							
						});
						
						if (typeof options.selectionChange === FUNCTION) {
							options.selectionChange.call(selectedCnt());
						}
						
					};
			
			selectRefresh();
			
			overlay.on({
					selectAll: 			selectAll,
					selectNone: 		selectNone,
					selectInverse: 		selectInverse,
					selectRefresh: 		selectRefresh
				});
					
			return this;
		};
			
		
	/********************************************************
	 *
	 *					The main skin code
	 *
	 ********************************************************/
	
	$.fn.skin = function(settings) {
		
			settings = $.extend({}, $.fn.skin.defaults, settings);
			
			var main 					=	$(this),									// Container (#main) sidebar + content
				content					=	main.children('.' + settings.contClass),	// Main container: article next to sidebar, contains the overlays
				text					= 	getTranslations({							// Translated texts
													foundNTimes:					'found {0} time(s)',
													notFound: 						'not found',
													search: 						'Search',
													searchPlaceholder:					'Search...',
													newImages:						'New images',
													results:						'Results',
													reset:							'Reset',
													label: 							'Label',
													selectedItems:					'Selection',
													addCart:						'Add to cart',
													'return': 						'return',
													select:							'Select',
													sortBy:							'Sort by',
													sortedBy:						'Sorted by',
													ascending:						'ascending',
													descending:						'descending',
													multipleSelectHint:				'Use SHIFT to select range, CTRL for multiple entries',
													noRating:						'No rating',
													inTheLastDay:					'in the last day',
													inThePastNDays:					'in the past {0} days',
													sinceMyLastVisit:				'since my last visit',
													betweenDays:					'between {0} and {1}',
													onDay:							'on {0}',
													beforeDay:						'before {0}',
													afterDay:						'after {0}',
													imagesAdded:					'Images added',
													imagesModified:					'Images modified',
													imagesTaken:					'Images taken',
													'new':							'New',
													more:							'more',
													less:							'less',
													image:							'image',
													images:							'images',
													audio:							'audio',
													audio:							'audios',
													video:							'video',
													videos:							'videos',
													other:							'other',
													others:							'others',
													fatalError:						'Fatal Error!'
												}),
				/*
				shopSection 			= 	$(),										// Whole Shopping section
				shopRoot 				= 	$(),										// Root element for cart
				feedbackSection 		= 	$(),										// Whole Feedback section
				feedbackRoot 			= 	$(),										// Root element for the feedback tool
				*/
				mapRoot					=	$(),										// Root element for Map on index
				album,																	// The database
				ns 						= 	'projector_skin',							// Namespace
				lastHash 				= 	'',											// Storing last state
				hashChangedByJs 		= 	false,										// Tracking for internally or externally triggered hash changes
				pageExt					= 	settings.indexName.split('.')[1] || 'html',	// Index page extension
				initByHash 				=	window.location.hash !== '',				// Initial URL contains hash
				nows 					= 	new Date() / 1000,							// Now in seconds
			
				// Determine card type
				
				cardType = function(card) {
						if (card.hasClass(settings.folderClass)) {
							return 'folder';
						} else if (s.hasClass(settings.thumbClass)) {
							return 'thumb';
						}
						
						return '';
					},
												
				/********************************************************
				 *
				 *					Managing overlays
				 *				e.g. after search or filter
				 *
				 ********************************************************/
				/*
					<div id="main" class="paused">
						<article class="cont cover-up thumbs-bottom thumbs-auto">
							<section class="overlay base-overlay" data-overlay="base"> 		// overlay base-overlay or sub-overlay
								<header>
									<h4>“asd”<small>not found</small></h4>
									<button class="close" aria-label="return" data-tooltip-id="_ltt_4042"></button>
								</header>
								<div class="thumbnails">									// thumbnails
									<div class="clip">
										<div class="thumb-cont">							// thumbContainer -> cards -> images
											<a class="thumb lbable" href="slides/1447875372440-4037e6fae95d.jpg" title="This photo has a single shop option" data-tooltip-id="_ltt_1122"><img src="thumbs/1447875372440-4037e6fae95d.jpg" width="90" height="90" alt="1447875372440-4037e6fae95d" class="show-image"></a><a class="thumb lbable" href="slides/matthew-kane-365718.jpg" title="This photo has 3 options" data-tooltip-id="_ltt_9849"><img src="thumbs/matthew-kane-365718.jpg" width="90" height="90" alt="matthew-kane-365718" class="show-image"></a><a class="thumb lbable" href="slides/camera-man.jpg" title="Camera Man This photo is using the default shop options" data-tooltip-id="_ltt_559"><img src="thumbs/camera-man.jpg" width="90" height="90" alt="Camera Man" class="show-image"></a><a class="thumb lbable" href="slides/averie-woodard-319832.jpg" add="" to="" cart"="" button="" is="" disabled="" on="" this="" photo"="" data-tooltip-id="_ltt_9950"><img src="thumbs/averie-woodard-319832.jpg" width="90" height="90" alt="averie-woodard-319832" class="show-image"></a><a class="thumb lbable" href="slides/cristian-lozan-371397.jpg" data-tooltip-id="_ltt_3215"><img src="thumbs/cristian-lozan-371397.jpg" width="90" height="90" alt="cristian-lozan-371397" class="show-image"></a><a class="thumb lbable" href="slides/fhhgpo3amsu-matteo-paganelli.jpg" data-tooltip-id="_ltt_1281"><img src="thumbs/fhhgpo3amsu-matteo-paganelli.jpg" width="90" height="90" alt="fhhgpo3amsu-matteo-paganelli" class="show-image"></a><a class="thumb lbable" href="res/pdf.png"><img src="res/pdf.png" width="90" height="90" alt="vivoactive_3_OM_EN" class="show-image"></a><a class="thumb lbable" href="slides/hiadjnxzxl8-benjamin-combs.jpg" data-tooltip-id="_ltt_6701"><img src="thumbs/hiadjnxzxl8-benjamin-combs.jpg" width="90" height="90" alt="hiadjnxzxl8-benjamin-combs" class="show-image"></a><a class="thumb lbable" href="slides/jared-sluyter-260692.jpg" data-tooltip-id="_ltt_6840"><img src="thumbs/jared-sluyter-260692.jpg" width="90" height="90" alt="jared-sluyter-260692" class="show-image"></a><a class="thumb lbable" href="slides/lyedubb2auk-roksolana-zasiadko.jpg" data-tooltip-id="_ltt_5550"><img src="thumbs/lyedubb2auk-roksolana-zasiadko.jpg" width="90" height="90" alt="lyedubb2auk-roksolana-zasiadko" class="show-image"></a><a class="thumb lbable" href="slides/kalen-emsley-100223.jpg" data-tooltip-id="_ltt_7868"><img src="thumbs/kalen-emsley-100223.jpg" width="90" height="90" alt="kalen-emsley-100223" class="show-image"></a><a class="thumb lbable active" href="slides/oldm7mnhdic-stefan-kunze.jpg" data-tooltip-id="_ltt_3509"><img src="thumbs/oldm7mnhdic-stefan-kunze.jpg" width="90" height="90" alt="oldm7mnhdic-stefan-kunze" class="show-image"></a><a class="thumb lbable" href="slides/u2ukri4lci8-nasa.jpg" title="Nasa" data-tooltip-id="_ltt_308"><img src="thumbs/u2ukri4lci8-nasa.jpg" width="90" height="90" alt="u2ukri4lci8-nasa" class="show-image"></a>
										</div>
									</div>
									<button class="scroll-back icon-arrow-left disabled"></button>
									<button class="scroll-forward icon-arrow-right disabled"></button>
								</div>
								<div class="lightbox cube threedee landscape">			// lightbox
									<div class="jcards cube fwd" style="transform: translateZ(-429px) rotateX(0deg); transition: none 0s ease 0s;">
										<div id="c11" class="jcard image cube has-caption jimageready" style="opacity: 1; backface-visibility: visible; transform: rotateX(0deg) translateZ(429px); transition: opacity 600ms ease 0s; z-index: 0;" draggable="false">
											<img src="slides/oldm7mnhdic-stefan-kunze.jpg" style="left: 238px; top: 94.5px; width: 1000px; height: 668px;">
											<div class="jcaption center bottom dark">
												<span class="nr">12 <em>13</em></span>
												<div class="text">
													<h5>oldm7mnhdic-stefan-kunze</h5><div class="comment">Stefan Kunze</div>
												</div>
												<div class="buttons"><a class="btn icon-camera meta" data-tooltip-id="_ltt_5394"></a></div>
											</div>
										</div>
									</div>
									<button class="jprev btn"></button>
									<button class="jnext btn"></button>
								</div>
							</section>
							<section class="hero scrollable">
								<div class="window hasimages">
									<div class="album-title fullwidth hasbutton">
										<div class="folder-image">
											<div class="image">&nbsp;</div>
											<button class="btn autoplay icon-play" title="Start slideshow" data-tooltip="" data-tooltip-id="_ltt_4832"></button>
										</div>
										<div class="title">
											<h1>Skin Comparison - Projector <span class="date">4/26/13—11/12/15</span></h1>
											<div class="description">Sample album for blog post: Which Skin?</div>
										</div>
									</div>
									<div class="folders thumbtype">							// folders
									</div>
									<footer>
										<div class="modifieddate"><span>Modified</span> 11/4/21, 2:33 PM</div>
										<div class="counts"><span>12&nbsp;images</span><span>1&nbsp;other</span></div>
										<span class="credits"><a href="https://jalbum.net" rel="generator" data-tooltip="" title="jAlbum, web photo album creator, 25.0.7" data-tooltip-id="_ltt_4836">jAlbum - customizable image galleries</a> · <a href="https://lazaworx.com" rel="generator" data-tooltip="" title="Skin: Projector 2.3.0 Black, 2.3" data-tooltip-id="_ltt_9235">Projector 2.3.0</a></span>
									</footer>
								</div>
							</section>
							<button class="hero-handle"></button>
						</article>
					</div>
				*/
				
				OLYTAG = 'section',
				
				// Content has overlay?
				
				hasOverlay = function() {
					
						return content.find(OLYTAG + '.' + settings.overlayClass).length > 0;
					},
				
				// Content has sub-overlay?
				
				hasSubOverlay = function() {
					
						return content.find(OLYTAG + '.' + settings.subOverlayClass).length > 0;
					},
				
				// Getting NameSpace, creating new if not exists
				
				getOverlayNS = function() {
						var oly = getOverlay();
						
						if (oly.length) {
							var ns = oly.data('overlay');
						
							if (ns) {
								// Has namespace
								return ns;
							}
						
							// Adding namespace
							ns = oly.hasClass(settings.baseOverlayClass)?
									'base' : getUniqueId();
							
							oly.attr('data-overlay', ns);
					
							return ns;
						}
						
						// No overlay
						return  '';
					},
					
				// Getting unique ID for overlays
				
				getUniqueId = function() {
						return 'oly_' + Math.floor(Math.random() * 10000);
					},
					
				// Getting active overlay; creating one if missing
				
				getOverlay = function(create) {
						var oly = content.find('.' + settings.overlayClass + ':visible').last();			// The latest added visible overlay
						
						if (!oly.length && typeof create !== UNDEF && create) {
							// Creating one
							oly = createOverlay();
						}
						
						return oly;
					},
					
				// Getting base overlay
				
				getBaseOverlay = function() {
				
						return content.find('.' + settings.baseOverlayClass);
					},
					
				// Scroll to overlay
					
				focusOverlay = function() {
						var oly = getOverlay();
						
						if (oly.length && coverOn()) {
							hideCover();
						}
					},
			
				// Creating a new overlay
				
				createOverlay = function() {
						var ns = getUniqueId(),
							oly = $('<' + OLYTAG + '>', {
										'class':		[
															settings.overlayClass,
															settings.subOverlayClass
														].join(' ')
									}).attr({
										id:				ns,
										'data-overlay':	ns
									}),
							boly = getBaseOverlay();		// Base overlay
							
						if (boly.length) {
							// Has base: create after it
							boly.after(oly);
						} else {
							// No base: create at first position
							content.prepend(oly);
						}
						
						// Image container
						createImageContainer(oly);
						
						main.addClass(settings.hasOverlayClass);
						
						return oly;
					},
					
				// Creating header
				
				createOverlayHeader = function(options, oly) {
						var head = $('<header>').prependTo(oly || getOverlay()),
							h = $('<div>', {
									 'class':	[
									 	 			settings.overlayTitleClass,
									 	 			(options && options.hasOwnProperty('icon'))? options.icon : ''
									 	 		].filter(Boolean).join(' ')
									}).appendTo(head);
						
						if (options && options.hasOwnProperty('title')) {
							h.append($('<h' + settings.overlayHeadLevel + '>', {
									html: 	options.title
								}));
						}			
								
						h.append($('<a>', {
									'class': 		'close',
									href: 			'',
									'aria-label':	text.return
								})
							.addTooltip(text.return, { 
									pos:			[ 0, 1, 2, 1 ]
								})
							.on('click', function() {
									$(this).trigger('removeTooltip');
									removeOverlay();
									return false;
								}));
						
						return head;
					},
					
				// Getting overlay header (jQ element)
				
				getOverlayHeader = function() {
						
						return getOverlay().children('header').eq(0);
					},
					
				// Getting overlay title (jQ element)
				
				getOverlayTitle = function() {
						
						return getOverlayHeader().find('h' + settings.overlayHeadLevel).eq(0);
					},
					
				// Append text to overlay title
				
				appendToOverlayTitle = function(cont) {
						var t = getOverlayTitle();
						
						return t.length? cont.appendTo(t) : $();
					},
					
				// Adding progressbar
				
				appendProgressbar = function() {
					
						return $('<div>', {
									'class': 	settings.progressbarClass
								}).insertAfter(getOverlayHeader());
					},
					
				// Remove progressbar
				
				removeProgressbar = function(target) {
					
						getOverlay().find('.' + settings.progressbarClass).remove();
					},

				// Associate elements with the current overlay
				
				attachToOverlay = function(el) {
					
						if (el.length) {
							var ns = getOverlayNS();
							
							el.each(function() {
									$(this).attr('data-rel', ns);
								});
						}
					},

				// Remove overlay-attached elements	
					
				removeAttachedElementsFromOverlay = function(ns) {
						var ns = ns || getOverlayNS();
						
						if (ns) {
							main.find('[data-rel=' + ns + ']').remove();
						}
					},
				
				// Creating image container within target overlay
				
				createImageContainer = function(oly) {
						// Finding or creating the element to hold the thumbs
						var	thumbnails = oly.children('.' + settings.thumbnailsClass);
						
						if (!thumbnails.length) {
							thumbnails = $('<div>', {
									'class': 	settings.thumbnailsClass
								}).appendTo(oly);
						}
							
						// Finding or creating the clip element
						var	clip = thumbnails.children('.' + settings.clipClass);
									
						if (!clip.length) {
							clip = $('<div>', {
									'class': 	settings.clipClass
								}).appendTo(thumbnails);
						}
							
						// Finding or creating the thumbs container
						var	tc = clip.children('.' + settings.thumbContClass);
									
						if (!tc.length) {
							tc = $('<div>', {
									'class': 	settings.thumbContClass
								}).appendTo(clip);
						}
						
						return thumbnails;
					},
					
				// Getting base thumbnail section
				
				getBaseImageContainer = function() {
				
						return getBaseOverlay().find('.' + settings.thumbnailsClass);
					},
					
				// Returns the current thumbnail section if exists
				
				getImageContainer = function(create) {
						var ic = getOverlay().find('.' + settings.thumbnailsClass);
						
						if (!ic.length && create) {
							ic = createImageContainer(getOverlay(true));
						}
						
						return ic; 
					},
					
				// Returns the current thumbnail container if exists
				
				getImageCont = function() {
					
						return getOverlay().find('.' + settings.thumbContClass);
					},
					
				// Has images?
				
				hasImages = function() {
						var ic = getImageCont();
						return ic.length && !ic.is(':empty');
					},
										
				// Has lightbox?
				
				hasLightbox = function() {

						return getOverlay().find('.' + settings.lightboxClass).length > 0;
					},
										
				// Restoring base overlay's attached elements
				
				restoreBaseOverlay = function() {
						var bo = getBaseOverlay();
						
						if (bo.length) {
							// Attached elements
							$('[data-rel=' + bo.data('overlay') + ']').show();
							// Refreshing thumbnails
							getBaseImageContainer().trigger('refresh');
						} else {
							content.removeClass(settings.coverUpClass).addClass(settings.coverDownClass);
						}
					},
					
				// Getting all base cards
				
				getBaseCards = function(selector) {
						
						return getBaseOverlay().find('.' + settings.thumbClass + (selector? selector : ''));
					},
					
				// Returns the current cards (base or overlay)
				
				getCards = function(selector) {
					
						return getOverlay().find('.' + settings.thumbClass + (selector? selector : ''));
					},
					
				// Returns the current images (base or overlay)
				
				getImages = function(selector) {
					
						return (typeof selector !== UNDEF)?
								getCards('>img').filter(selector)
								:
								getCards('>img');
					},
					
				// Returns the current cards (base or overlay)
				
				getSelectedCards = function() {
					
						return getCards('.' + settings.selectedClass);
					},
					
				// Getting current card
				
				getActiveCard = function(o) {
						
						return getCards('.' + settings.activeClass).eq(0);
					},
					
				// Setting active card and loading into lightbox
				
				setActiveCard = function(card, delay) {
						var ac = getActiveCard(),
							nr = card.data('lbnr') || 0;
							
						if (ac !== card) {
							
							if (ac.length) {
								ac.removeClass(settings.activeClass);
							}
							
							card.addClass(settings.activeClass);
							
							if (getOverlay().trigger('lightboxCurrent') !== nr) {
								if (typeof delay !== UNDEF) {
									var oly = getOverlay();
					
									oly.add(main)
										.removeClass(settings.pausedClass)
										.addClass(settings.playingClass);
										
									getOverlay().trigger('lightboxLoad', [ nr, delay ]);
								} else {
									getOverlay().trigger('lightboxLoad', nr);
								}
							}
						}
						
						return ac;
					},
					
				// Setting active class
				
				setActiveClass = function(n) {
						var ac = getActiveCard(),
							nc = getNthCard(n);
						
						if (ac !== nc) {
							
							if (ac.length) {
								ac.removeClass(settings.activeClass);
							}
						
							if (nc.length) {
								nc.addClass(settings.activeClass);
							}
							
							getImageContainer().trigger('scrollToActive');
						}
					},
					
				// Get Nth card
				
				getNthCard = function(n) {
						return getOverlay().find('.' + settings.thumbClass + '.' + settings.lbableClass).eq(n);
					},
					
				// Returns the current cards (base or overlay)
				
				getSelectableCards = function() {
						
						return getCards('.' + settings.selectableClass).eq(0);
					},
					
				// Removing overlay
				
				removeOverlay = function() {
						var oly = getOverlay();
						
						if (oly.length && oly.hasClass(settings.overlayClass)) {
							var ns = oly.data('oly-ns');
							
							$window.off('.' + ns);
							
							oly.trigger('lightboxRemove');
							
							removeAttachedElementsFromOverlay(ns);
							
							oly.trigger('overlayRemoved');
							
							oly.remove();
							
							main.removeClass(settings.hasOverlayClass);
							
							restoreBaseOverlay();
							
							removeParam(settings.indexName);
							
							updateShares();
							/*	
							if (getSelectableCards().length) {
								shopBox.add(feedbackBox).show();
							} else {
								shopBox.add(feedbackBox).hide();
							}
							*/
							content.hideAllTooltips();
						}
					},
					
				// Adding new overlay
			
				addOverlay = function(options) {
						
						// Removing existing overlay first
						if (hasSubOverlay()) {
							removeOverlay();
						}
						
						content.hideAllTooltips();
						
						// Creating overlay (section.thumbnails)
						var oly = createOverlay();
						
						// Creating header
						createOverlayHeader(options, oly);
							
						// Triggering ready event
						content.trigger('overlayReady', oly);
						
						return oly;
					},
					
				// Getting file name from thumbnail
				
				getImageFileName = function(t) {
						var l = t.data('href') || t.attr('href');
								
						return l? l.substring(l.lastIndexOf('/') + 1).replace('#img=', '') : '';
					},
				
				// Checking if file is a custom page and matches base name: "name"
				
				checkPageName = function(fn, name) {
						
						if (fn.slice(-pageExt.length) === pageExt) {
							return fn.substring(0, fn.lastIndexOf('.')) === name.substring(0, name.lastIndexOf('.'));
						}
						
						return false;
					},
					
				// Getting image by file name, name is mandatory
				
				getCardByName = function(name, base) {
						var cards,
							t = $();
						
						cards = (typeof base === UNDEF || !base)?
							getCards()
							:
							getBaseCards();
						
						name = decodeURIComponent(name);
						
						cards.each(function() {
								var  fn = $(this).data('name') || getImageFileName($(this));
								
								if (fn === name || checkPageName(fn, name)) {
									t = $(this);
									return false;
								}
							});
						
						return t;
					},
					
				// Getting all folder cards
				
				getFolders = function(selector) {
						
						return content.find('.' + settings.foldersClass + (selector || ''));
					},
													
				// Getting map
				
				getMapRoot = function(create) {
						
						return $('[data-map-root]');
					},
													
				// Getting attached lightbox
				
				getLightboxContainer = function() {
					
						return getOverlay().trigger('lightboxContainer');
					},
					
				// Leaving lightbox
				
				lightboxQuit = function() {
					
						getOverlay().trigger('lightboxQuit');
					},
					
				// Getting selected items from current overlay
				
				getSelectedItems = function() {
						var r = [];
								
						getSelectedCards().each(function() {
								r.push($(this).data(J.OBJ));
							});
						
						return r;
					},
				
				// Getting all items from current overlay
				
				getAllItems = function() {
						var r = [];
								
						getCards().each(function() {
								r.push($(this).data(J.OBJ));
							});
						
						return r;
					},
								
				// Getting all items from base overlay
				
				getBaseItems = function() {
						var r = [];
						
						getBaseCards().each(function() {
								r.push($(this).data(J.OBJ));
							});
						
						return r;
					},
					
				// Getting active element's data
				
				getActiveItem = function() {
						var card = getActiveCard();
						
						if (card.length) {
							return card.data(J.OBJ);
						}
						
						return null;
					},
					
				// Get Nth item
				
				getNthItem = function(n) {
						var card = getNthCard(n);
						
						return card.length? card.data(J.OBJ) : null;
					},
					
				// Is at last card?
				
				atLastCard = function() {
						
						return getActiveCard()[0] === getCards().last()[0];
					},	

										
				/********************************************************
				 *
				 *						Folder tree
				 *
				 ********************************************************/
				
				getFolderTree = function() {
					
						var getFolderObjects = function(folder) {
								if (folder.hasOwnProperty(J.FOLDERS) && folder[J.FOLDERS].length) {
									var ul, li, i, p, f = folder[J.FOLDERS];
									ul = $('<ul>');
									for (i = 0; i < f.length; i++) {
										p = album.getPath(f[i]);
										li = $('<li>').appendTo(ul);
										li.append($('<a>', {
												href: 	(p? (p + '/') : '') + settings.indexName,
												html: 	f[i][J.TITLE] || f[i][J.NAME] || ''
											})).append(getFolderObjects(f[i]));
										if (!p) {
											li.addClass('actual');
										}
									}
									return ul;
								}
								return $();
							},
							
							getHomeLink = function() {
								var p = settings.rootPath;
								return $('<a>', {
										'class': 	'home-link icon-home',
										href:		(p? (p + '/') : '') + settings.indexName,
										text:		' ' + album.getAlbumTitle()
									});
							};
							
						if (settings.folderTree.type === 'tree') {
							if (settings.level > 0) {
								return getHomeLink().add(getFolderObjects(album.getTree()));
							} else {
								return getFolderObjects(album.getTree());
							}
						} else {
							getFolderObjects(album.getCurrentFolder());
						}
					};
								
				/********************************************************
				 *
				 *					Image overlay rendering 
				 *			or initializing images in the base overlay
				 *
				 ********************************************************/
				
				$.fn.renderImages = function(items, complete, autoStart, baseSet) {
					
						if (typeof items === UNDEF || !items.length) {
							return this;
						}
						
						if (!Array.isArray(items)) {
							items = [ items ];
						}
						
						var	overlay				= $(this),												// Overlay
							ns 					= getOverlayNS(),										// Namespace
							lightbox			= getLightboxContainer(),								// the lightbox
							imageContainer		= getImageContainer(true),								// image container (for overlays)
							cont 				= imageContainer.find('.' + settings.thumbContClass),	// Image wrapper
							lazyloadTimeout 	= null,													// Lazy load timeout
							ttpos 				= [ 1, 2, 1, 0 ],										// Tooltip position
							vertical			= false,												// Vertical thumbnail layout
														
							// Rendering images
							
							initThumbs = function() {
									var thumbs = getCards(),
										thumb,
										img,
										isFolder,
										isLbable,
										isMedia,
										isIcon,
										caption,
										s,
										d,
										cd = settings.hasOwnProperty('markNew')? (nows - settings.markNew.days * ONEDAY_S) : null,
										lnr = 0,
										item;
										
									// Initializing images
									for (var i = 0; i < items.length; i++) {
										
										item = items[i];
										isFolder = item[J.CATEGORY] === 'folder';
										isLbable = !isFolder && album.isLightboxable(item);
										isMedia = item[J.CATEGORY] === 'video' || item[J.CATEGORY] === 'audio';
										isIcon = item.hasOwnProperty(J.THUMB)? /res\/\w+\.png$/.test(item[J.THUMB][J.PATH]) : false;
										s = item[J.THUMBCAPTION];
										
										if (i < thumbs.length) {
											// Already exists in the HTML source
											thumb = thumbs.eq(i);
										} else {
											// Not yet exists in the HTML source: happens only on overlays
											thumb = $('<a>', {
													'class': 	[
																	settings.thumbClass, 
																	settings.lazyloadClass, 
																	item[J.CATEGORY],
																	(item[J.THUMB][J.WIDTH] < settings.maxThumbWidth && item[J.THUMB][J.HEIGHT] < settings.maxThumbHeight)? 'tiny' : '',
																	isIcon? 'icon' : ''
																].filter(Boolean).join(' ')
												}).css('width', item[J.THUMB][J.WIDTH]).appendTo(cont);
										}

										// Data pointer
										thumb.data(J.OBJ, item);
										
										if (isLbable) {
											thumb.addClass(settings.lbableClass);
											// Saving lightbox order number
											thumb.data('lbnr', lnr++);
										}
										
										// Creating structure
										
										// Finding/creating image
										img = thumb.find('img').eq(0);
										if (!img.length) {
											img = $('<img>', {
													alt:		album.getAlt(item)
												}).appendTo(thumb);
										}
									
										if (item[J.THUMB].hasOwnProperty(J.RENDITIONS)) {
											// Has renditions, wait if larger image is needed
											img.data('hasrenditions', true);
										} else {
											// Removing preload class upon img is loaded
											img.one('load.' + ns, function() {
													$(this).addClass(settings.showImageClass)
														.removeClass(settings.hideImageClass)
														.parent().removeClass(settings.preloadClass);
												});
										}
												
										// Cached image?
										if (img[0].complete) {
											img.trigger('load');
										}
												
										// Adding width, height
										if (isIcon) {
											thumb.addClass('iconthumb');
										} else {
											img.attr({
													width:		item[J.THUMB][J.WIDTH],
													height:		item[J.THUMB][J.HEIGHT]
												});
											
											// Adding pano class
											if ((item[J.THUMB][J.HEIGHT] / item[J.THUMB][J.WIDTH]) < 0.5) {
												thumb.addClass(settings.panoClass);
											}
											
											if (isFolder) {
												thumb.append($('<span>', {
														'class':	'icon-folder'
													}));
											}
												
										}	
										
										// Save image name: for later
										if (!thumb.data('name')) {
											thumb.attr('data-name', album.getItemName(item));
										}
									
										// Caption
										if (s) {
											thumb.attr('data-tooltip', s);
										}
										
										// Preparing for Lightbox
										if (isLbable) {
											
											// Click event
											if (isLbable) {
												thumb.on('click.' + ns, thumbClicked);
											}
											
											// Set href
											if (!thumb.data('href')) {
												thumb.attr('data-href', img.attr('src') || album.getOptimalImagePath(item, [ img.outerWidth(), img.outerHeight() ]));
											}
											
											// Removing link (to avoid unwanted navigation)
											// Links are included to help robots finding the slide images
											if (thumb[0].hasAttribute('href')) {
												thumb.attr('href', '');
											}
											
										} else {
											// Not lightboxable, e.g. webLocation or folder: using the link
											thumb.addClass(item[J.CATEGORY]);
											thumb.attr('href', album.getItemPath(item));
										}
										
										// Mark new images
										if (cd != null) {
											
											d = item[J.DATES];
											
											if (d && (d = d[settings.markNew.reference]) && d >= cd) {
												s = settings.markNew.text?
													$('<span>', {
															'class':	'new-image',
															text:		settings.markNew.text
														})
													:
													$('<span>', {
															'class':	'icon-new-fill new-image'
														});
													
												thumb.append(s);
													
												if (!TOUCHENABLED) {
													s.data('tooltip', (new Date(d * 1000)).toLocaleDateString(LOCALE)).addTooltip();
												}
											}
										}
										
										if (settings.rightClickProtect) {
											thumb.on('contextmenu', function(e) {
													e.preventDefault()
													return false;
												});
										}
									}
									
									lazyloadTimeout = setTimeout(lazyloadThumbs, settings.scrollCheckInterval / 2);
								},
									
							// Lazyloading
							
							lazyloadThumbs = function(e, p0, doneFn) {
									var p0 = (typeof p0 === UNDEF)? cont.position()[vertical? 'top' : 'left'] : p0,	// Top position
										cw = cont.width(),															// Clip width
										ch = cont.height(),															// Clip height
										targetDims,																	// Max. dimensions
										t,
										item,
										img,
										imgs = $();
									
									// Set target dimensions
									if (vertical) {
										targetDims = [ cw, settings.fixedShapeThumbs? cw : cw * 1.5 ];
									} else {
										targetDims = [ settings.fixedShapeThumbs? ch : ch * 1.5, ch ];
									}
								
									cont.children('.' + settings.lazyloadClass)
										.filter(function() {
												var p;
												// Half screen width backwards, full screen width forwards
												if (vertical) {
													p = $(this).position()['top'] + p0;
													return (p + ch / 2) >= 0 && (p - ch * 2) <= 0;
												}
												
												p = $(this).position()['left'] + p0;
												return (p + cw / 2) >= 0 && (p - cw * 2) <= 0;
											})
										.each(function() {
												t = $(this);
												img = t.children('img'); 
												
												if (!img.length) {
													img = $('<img>', {
																'class': 	settings.hideImageClass
															})
														.appendTo(t);
												}
												
												item = t.data(J.OBJ);
												
												if (item && !img[0].hasAttribute('src')) {
													// Onload action
													img.one('load', function() {
																$(this)
																	.addClass(settings.showImageClass)
																	.removeClass(settings.hideImageClass)
																	.parent().removeClass(settings.lazyloadClass);
															})
														.attr({
																src:		album.getOptimalThumbPath(item, targetDims),
																//width:		item[J.THUMB][J.WIDTH],
																//height:		item[J.THUMB][J.HEIGHT],
																alt:		item[J.TITLE] || item[J.NAME].stripExt()
															});
												}
												
											});
									
									if (typeof doneFn === FUNCTION) {
										doneFn.call();
									}
									
									if (cont.children('.' + settings.lazyloadClass).length) {
										lazyloadTimeout = setTimeout(lazyloadThumbs, settings.scrollCheckInterval / 2);
									}
								},
								
							// Clicked image
							
							thumbClicked = function(e) {
									
									setActiveCard($(this));
									return false;
								};
															
					
						// Creating new Unique ID if not yet exists
						if (!ns) {
							ns = 'base';
						}
						
						// Vertical layout arrangement
						vertical = content.hasClass('thumbs-left') || content.hasClass('thumbs-right');
						
						// Set tooltip position
						if (content.hasClass('thumbs-right')) {
							ttpos = [ 2, 1, 0, 1 ];
						} else if (content.hasClass('thumbs-left')) {
							ttpos = [ 0, 1, 2, 1 ];
						} else if (content.hasClass('thumbs-top')) {
							ttpos = [ 1, 0, 1, 2 ];
						}
						
						initThumbs();
						
						imageContainer.thumbScroll();
						
						// Lazyloading
						// Moving the active element into view
						overlay.on({
								refresh:			lazyloadThumbs
							});
						
						if (typeof complete === FUNCTION) {
							if (typeof autoStart !== UNDEF) {
								if (typeof baseSet !== UNDEF) {
									complete.call(undefined, overlay, autoStart, baseSet);
								} else {
									complete.call(undefined, overlay, autoStart);
								}
							} else {
								complete.call(undefined, overlay);
							}
						}
						
						return overlay;
					};
			
			var
				/********************************************************
				 *
				 *					Preparing images
				 *
				 ********************************************************/
				 
				prepareImages = function(overlay, baseSet) {
					
						if (!album) {
							return;
						}
						
						var cards = getCards();

						overlay.lightbox(album, {
								
									onLoadStart:	
									
										function(n) {
										
												if (!coverOn()) {
													var item = getNthItem(n);
													
													if (item) {
														addParam(settings.indexName, {
																img: 		album.getItemName(item)
															}, item[J.TITLE]);
													}
												} else {
													removeParam(settings.indexName, 'img');
												}
											},
													
									onLoadEnd: 		
									
										function(n) {
												// Picture change initiated by lightbox
												setActiveClass(n);
												
												if (settings.hasOwnProperty('share')) {
													var item = getNthItem(n);
													
													if (item) {
														$(settings.share.hook).trigger('updateLinks', {
																title:			item[J.TITLE] || item[J.NAME].stripExt().replace(/[-_]/g, ' ').capitalize(),
																description:	(item[J.COMMENT] || '').stripHTML(),
																image:			album.getOptimalImagePath(item, [ 1200, 800 ]),
																href:			album.getAbsolutePath(item)
															});
													}
												}
											},
													
									onVolumeChange:	
									
										function(v) {
												settings.audioClipVolume = v;
											},
													
									onReady:		
										
										function() {
										
												if (initByHash && window.location.hash) {
													initByHash = false;
													var param = readParam();
													
													content
														.removeClass(settings.coverDownClass)
														.addClass(settings.coverUpClass);
													
													if (param.hasOwnProperty('label') && param.label !== null) {
														// Label filter
														getItemsByLabel(param.label, function() {
															addParam(settings.indexName, {
																	label:			param.label + '',
																	search:			null,
																	newimages:		null,
																	date:			null
																}, text.label + ': ' + param.label);
														});
													} else if (param.hasOwnProperty('search') && param.search !== null) {
														// Search
														getItemsBySearch(param.search, function() {
															addParam(settings.indexName, {
																	search:			param.search + '',
																	label:			null,
																	newimages: 		null,
																	date:			null
																}, text.search + ': ' + param.search);
														});
													} else if (param.hasOwnProperty('newimages')) {
														// Search new images
														getItemsByDate(getSearchNewOptions(param.newimages), function() {
															addParam(settings.indexName, {
																	newimages:		param.newimages,
																	search:			null,
																	label:			null,
																	date:			null
																}, text.searchNew + ': ' + param.newimages);
														});
													} else if (param.hasOwnProperty('date')) {
														var options = getDateRangeOptions(param.date);
														// Search images in date range
														getItemsByDate(options, function() {
															addParam(settings.indexName, {
																	date:			param.date,
																	newimages:		null,
																	search:			null,
																	label:			null
																}, getDateReference(options.reference) + ': ' + param.date);
														});
													} else if (param.hasOwnProperty('img') && param.img !== null) {
														var card = getCardByName(param.img);
														
														if (card.length) {
															if (param.hasOwnProperty('slideshow')) {
																setActiveCard(card, 2000);
															} else {
																setActiveCard(card);
															}
														} else {
															removeParam(settings.pageName || settings.indexName, 'img');
														}
													} else if (param.hasOwnProperty('slideshow')) {
														setActiveCard(getNthCard(0), 2000);
													}
													
												} else if (hasOverlay()) {
													if (settings.autoStart) {
														hideCover();
														startAutoplay();
														setActiveCard(getNthCard(0), 2000);
													} else {
														stopAutoplay();
														setActiveCard(getNthCard(0));
													}
											
													
													$('.' + settings.startshowClass).fadeIn().children('.button').on('click', startAuto);
												}
												
											},
														
									onSlideshowStart:
									
											function() {
													var oly = getOverlay();
					
													oly.add(main)
														.removeClass(settings.pausedClass)
														.addClass(settings.playingClass);
												},
									
									onSlideshowPause:
									
											function() {
													var oly = getOverlay();
					
													oly.add(main)
														.removeClass(settings.playingClass)
														.addClass(settings.pausedClass);
												},
												
									onShowPanel:
									
											function(p) {
													showPanel(p);
												},
													
									onHidePanel:
									
											function(p) {
													hidePanel(p);
												},
													
									onQuit:			
											
											function() {
													showCover();
													stopAutoplay();
												}
								});
					},
					
				// Sets the URL by JS
				
				setHash = function(params, title) {
						var hash = (typeof params === UNDEF)? '' : '#' + paramize(params);
					
						if (hash !== window.location.hash) {
							hashChangedByJs = true;
							if (params) {
								setParam(settings.pageName || settings.indexName, params, title || '');
							} else {
								removeParam(settings.pageName || settings.indexName);
							}
							setTimeout(function() {
									// reseting hashByJs
									hashChangedByJs = false;
								}, 1000);
						}
					},
				
				// Hash change listener :: when the browser's back / forward buttons were pressed
				
				stateChange = function() {
						if (window.location.hash === lastHash || hashChangedByJs) {
							// Same hash or changed by JS (not on external trigger)
							return;
						}
						
						lastHash = window.location.hash;
						hashChangedByJs = false;
						var param = readParam();
						
						if (param.hasOwnProperty('label') && param.label !== null) {
							// Label filter
							getItemsByLabel(param.label, function() {
									updateShares();
								});
						} else if (param.hasOwnProperty('search') && param.search !== null) {
							// Search
							getItemsBySearch(param.search, function() {
									updateShares();
								});
						} else if (param.hasOwnProperty('newimages') && param.newimages !== null) {
							// New images
							getItemsByDate(getSearchNewOptions(param.newimages), function() {
									updateShares();	
								});
						} else if (param.hasOwnProperty('date') && param.date !== null) {
							// Date range
							var options = getDateRangeOptions(param.date);
							getItemsByDate(options, function() {
									updateShares();	
								});
						} else if (param.hasOwnProperty('img') && param.img !== null) {
							// Image (no search or label)
							var card = getCardByName(param.img);
							if (card.length) {
								if (param.hasOwnProperty('slideshow')) {
									setActiveCard(card, 2000);
								} else {
									setActiveCard(card);
								}
							} else {
								removeParam(settings.indexName, 'img');
							}
						} else if (param.hasOwnProperty('slideshow')) {
							setActiveCard(0, 2000);
						} else {
							// Plain index page
							showCover();
							removeOverlay();
							updateShares();	
						}
						
					},
					
				// Starts slideshow
				
				startAuto = function(e) {
						var ct = getCards('.' + settings.activeClass + ':first-child');
						
						if (!ct.length) {
							ct = getCards('.' + settings.thumbClass + ':first-child');
						}
						
						if (ct.length) {
							getOverlay().trigger('loadImage', [ ct, true ]);
						}
						
						return false;
					},
				
				/********************************************************
				 *
				 *		Functionalities that results in new overlay
				 *
				 ********************************************************/
				
				/********************************************************
				 *
				 *				Keeping only selected items
				 *
				 ********************************************************/
				
				keepSelectedItems = function(tx, ready) {
						var items = getSelectedItems();
						
						if (!items.length || items.length === getCards('.' + settings.lbableClass).length) {
							return;
						}
						
						var oly = addOverlay({
									className:	'selected-items',
									icon:		'icon-checkbox-checked',
									title:		'&ldquo;' + tx + '&rdquo;'
								});
							
						appendToOverlayTitle($('<small>', {
								text: 		text.foundNTimes.replace('{0}', items.length)
							}));
						
						focusOverlay();
						
						setTimeout(function() {
							
								oly.renderImages(items, prepareImages);
								
								if (typeof ready === FUNCTION) {
									ready.call();
								}
								
							}, 50);
					},
				
				/********************************************************
				 *
				 *					Search and tag search
				 *
				 ********************************************************/
				 
				// Executing Search
				
				getItemsBySearch = function(tx, ready) {
						var oly = addOverlay({
									className:	'search-results',
									icon:		'icon-search',
									title:		'&ldquo;' + tx + '&rdquo;'
								});
							
						appendProgressbar();
						
						focusOverlay();
						
						album.collectItems($.extend(settings.search, {
								terms:		tx,
								depth:		'tree',
								ready:		function() {
													
													appendToOverlayTitle($('<small>', {
															text: 	this.length? text.foundNTimes.replace('{0}', this.length) : text.notFound
														}));
													
													oly.renderImages(this, prepareImages);
													
													removeProgressbar();
													
													if (typeof ready === FUNCTION) {
														ready.call();
													}
												}
							}));
					},
					
				// Preparing Search functionality
				
				prepareSearch = function(f) {
					
						if (!f.length || !album) {
							return;
						}
						
						// Adding defaults if missing
						
						settings.search = $.extend({
								depth:		'tree',
								fields:		'creator,keywords,title,comment'
							}, settings.search);
						
						var startSearch = function(f) {
								
								var tx = f.find('input').eq(0).val(),
									p = f.closest('.panel');
								
								if (tx && tx.length > 1) {
									$('aside .btn').removeClass('on');
									hidePanel(p);
									getItemsBySearch(tx, function() {
											setHash({
													search:		tx
												}, text.search + ': ' + tx);
											updateShares();
										});
								}
								return false;
							};
							
						f.find('.search-btn, button').on('click', function() {
								if (f.hasClass(settings.activeClass)) {
									startSearch(f);
									f.removeClass(settings.activeClass);
								} else {
									f.find('input').eq(0).focus();
									f.addClass(settings.activeClass);
								}
								return false;
							});
						
						f.on('submit', function(e) {
								e.preventDefault();
								startSearch(f);
								f.removeClass(settings.activeClass);
								hidePanel(f.closest('.panel'));
								return false;
							});
						
						f.find('input').on('focus',	function() { 
								f.addClass(settings.activeClass); 
							});
					},
				
				/********************************************************
				 *
				 *						Tag cloud
				 *
				 ********************************************************/
				 
				// Preparing Tag Search functionality
				
				prepareTagSearch = function(target) {
						var f = $(settings.tagCloud.searchHook);
							// Start tag search		
							startSearch = function(f) {
								var tx = f.find('input').eq(0).val(),
									p = f.closest('.panel');
								
								if (tx && tx.length > 1) {
									$('aside .btn').removeClass('on');
									hidePanel(p);
									getItemsByLabel(tx, function() {
										setHash({
												label: 	tx
											}, text.label + ': ' + tx);
										updateShares();
									});
								}
								return false;
							};
							
						if (!f.length) {
							f = $('<form>', {
									'class': 		settings.tagCloud.searchHook
								}).appendTo(target);
							
							f.append($('<div>', {
									'class':		'search-input'
								})
								.append($('<input>', {
									'type':			'text',
									placeholder:	text.searchPlaceholder,
									ariaLabel:		text.search
								})));
								
							f.append($('<a>', {
									'class':		'search-btn icon-search'
								}));
						}
						
						f.find('.search-btn').on('click', function() {
								var f = $(this).closest('form');
								f.find('input').eq(0).focus();
								startSearch(f);
								return false;
							});
						
						f.on('submit', function(e) {
								e.preventDefault();
								startSearch($(this));
								hidePanel($(this).closest('.panel'));
								return false;
							});
						
					},
				
				// Search labels
				
				getItemsByLabel = function(tx, caseSensitive, ready) {
						var oly = addOverlay({
									className:		'tags-found',
									icon:			'icon-tag',
									title:			'&ldquo;' + tx + '&rdquo;'
								});
							
						appendProgressbar();
						
						if (typeof caseSensitive === UNDEF) {
							caseSensitive = false;
						} else if (typeof caseSensitive === FUNCTION) {
							ready = caseSensitive;
							caseSensitive = false;
						}
						
						if (oly.offset().top < $window.scrollTop() || oly.offset().top > ($window.scrollTop() + $window.height() - 100)) {
							$window.scrollTop(oly.offset().top);
						}
						
						album.collectItems($.extend(settings.tagCloud, {
								exact:			settings.exactFields,
								caseSensitive:	caseSensitive,
								terms:			tx,
								ready: 			function() {
									
														appendToOverlayTitle($('<small>', {
																text: 	this.length? text.foundNTimes.replace('{0}', this.length) : text.notFound
															}));
														
														oly.renderImages(this, prepareImages);
														
														removeProgressbar();
														
														if (typeof ready === FUNCTION) {
															ready.call();
														}
												}
							}));
					},
	
				// Collect items from a path array
				
				getItemsByPaths = function(tx, paths, ready) {
						var oly = addOverlay({
									className:	'tags-found',
									icon:		'icon-tag',
									title:		'&ldquo;' + tx + '&rdquo;'
								});
							
						appendProgressbar();
						
						focusOverlay();
						
						album.collectByPath({
								paths:		paths,
								ready:		function() {
									
														appendToOverlayTitle($('<small>', {
																text: 		this.length? text.foundNTimes.replace('{0}', this.length) : text.notFound
															}));
														
														oly.renderImages(this, prepareImages);
														
														removeProgressbar();
														
														if (typeof ready === FUNCTION) {
															ready.call();
														}
													}
							});
					},
					
				// Collecting and displaying tags
			
				prepareTagCloud = function(tags) {
						var tc = $(settings.tagCloud['hook'] || '.tag-cloud-cont');
						
						if (!tc.length) {
							return;
						}
						
						if (!tags.length) {
							// Nothing found
							tc.remove();
						} else {
						
							var t = tc.children('.' + settings.tagCloudClass),
								// Click function
								tagClicked = function() {
									var tx = $(this).children('span').eq(0).text(),
										p = $(this).closest('.panel');
									
									$('aside .btn').removeClass('on');
									hidePanel(p);
									
									if (tx && tx.length > 1) {
											getItemsByPaths(tx, $(this).data('paths'), function() {
												setHash({
															label: 		tx
														}, text.label + ': ' + tx);
													updateShares();
												});
									}
									
									return false;
								};
							
							// Creating wrap el if not exists
							if (!t.length) {
								t = $('<div>', {
										'class':		settings.tagCloudClass
									}).appendTo(tc);
							}
							
							// Adding tags
							for (var a, r, cnt, i = 0, l = tags.length; i < l; i++) {
								
								// Creating link element
								a = $('<a>', {
										'class': 	'tag'
										})
									.on('click', tagClicked)
									.data('paths', tags[i][1])
									.append($('<span>', {
										html: 		tags[i][0]
									}));
								
								// Adding count
								if (tags[i][1].length > 1) {
								
									if (settings.tagCloud.fontVaries) {
										r = 0;
										cnt = Math.min(64, tags[i][1].length);
										// calculate weight
										while (cnt > 1) {
											r++;
											cnt = cnt >> 1;
										}
										a.addClass('size-' + r);
									}
									
									a.append('&nbsp;').append($('<sup>', {
										text: 		tags[i][1].length
									}));
								}
								
								t.append(a).append(' ');
							}
						}
						
						// Adding search box
						if (settings.tagCloud['useSearch']) {
							prepareTagSearch(tc.parent());
						}
						
						if (!tags.length && !settings.tagCloud['useSearch']) {
							$('aside .btn[data-rel=tag-cloud]').hide();
						}
						
					},
	
				/********************************************************
				 *
				 *						Search new images
				 *
				 ********************************************************/
				 
				getSearchNewOptions = function(days) {
					
						return settings.hasOwnProperty('searchNew')?
							{
								reference:		settings.searchNew['reference'] || 'dateTaken',
								depth:			settings.searchNew['depth'] || 'subfolders',
								start:			nows / ONEDAY_S - days
							}
							:
							{
								reference:		'dateTaken',
								depth:			'subfolders',
								start:			nows / ONEDAY_S - days
							};
						
					},
				
				// Search for new images
				
				getDateRangeOptions = function(range) {
						var m = range.match(/^([amt])?([cts])?\:?(\d+)\-?(\d+)?/i),
							o = {
									range:		0,
									reference:	'dateTaken',
									depth:		'current'
								};
								
						if (m) {
							if (m[1]) {
								// Reference
								if (m[1] === 'a') {
									o.added = 'added';
								} else if (m[1] === 'm') {
									o.added = 'fileModified';
								} else if (m[1] === 't') {
									o.added = 'dateTaken';
								}
							}
							
							if (m[2]) {
								// Depth
								if (m[2] === 'c') {
									o.depth = 'current';
								} else if (m[2] === 't') {
									o.depth = 'tree';
								} else if (m[2] === 's') {
									o.depth = 'subfolders';
								}
							}
							
							if (m[4]) {
								// Range
								o.start = parseInt(m[3]) || 0;
								o.end = parseInt(m[4]);
							} else if (m[3]) {
								// Single day
								o.start = parseInt(m[3]);
								o.range = 1;
							}
						}
						
						return o;
					},
				
				getDateReference = function(r) {
					
						if (r === 'dateTaken') { 
							return text.imagesTaken;
						} else if (r === 'fileModified') {
							return text.imagesModified;
						}
						
						return text.imagesAdded;
					},
					
				getDateRangeTitle = function(o) {
						var t1 = getDateReference(o['reference']),
							t2,
							start,
							end,  
							today = Math.floor(new Date() / ONEDAY_MS),
							date = function(d) {
									return new Date(d * ONEDAY_MS).toLocaleDateString(LOCALE);
								};
						
						if (!o.hasOwnProperty('end') && !o.hasOwnProperty('start')) {
							t2 = getTimespan(o.range);
						} else if (!o.hasOwnProperty('end')) {
							if (o.hasOwnProperty('start')) {
								if (o.hasOwnProperty('range')) {
									if (o['range'] > 1) {
										t2 = text.betweenDays.template(date(o.start), date(o.start + o.range));
									} else {
										t2 = text.onDay.template(date(o.start));
									}
								} else {
									t2 = getTimespan(nows / ONEDAY_S - o.start);
									//t2 = text.afterDay.template(date(o.start));
								}
							}
						} else {
							t2 = text.beforeDay.template(date(o.end));
						}	
						
						return t1 + ' ' + t2;
					},
				
				getItemsByDate = function(options, ready) {
						var oly = addOverlay({
									className:		'search-results',
									icon:			'icon-calendar',
									title:			getDateRangeTitle(options)
								});
							
						appendProgressbar();
						
						album.collectByDate($.extend(options, {
									ready:		function() {
													
														appendToOverlayTitle($('<small>', {
																text: this.length? text.foundNTimes.replace('{0}', this.length) : text.notFound
															}));
												
														oly.renderImages(this, prepareImages);
												
														removeProgressbar();
														
														if (typeof ready === FUNCTION) {
															ready.call();
														}
													}
						}));
					},
					
				// Search date range
				
				searchDateRange = function(range) {
					
						if (range) {
							var options = getDateRangeOptions(range);
							
							getItemsByDate(options, function() {
									setHash({
											date:		range
										}, getDateRangeTitle(options));
									updateShares();
								});
						}
						
						return false;
					},
				
				// Search new images
				
				searchNew = function(days) {
						
						if (days) {
							
							getItemsByDate($.extend(settings.searchNew, { 
									start: 		nows / ONEDAY_S - days 
								}), function() {
									setHash({
											newimages:		days
										}, getDateReference(settings.searchNew['reference']));
									updateShares();
								});
						}
						
						return false;
					},
				
				// Prepare Search new functionality
				
				prepareSearchNew = function(f) {
					
						if (!f.length || !album) {
							return;
						}
						
						// Setting up defaults if something is missing
						
						settings.searchNew = $.extend({
								days: 				'3,30,90',
								depth: 				'folder',
								reference: 			'dateTaken',
								sinceLastVisit:		true
							}, settings.searchNew);
						
						var	days = settings.searchNew.days.split(',');
						
						f.append($('<label>', {
								text: 	getDateReference(settings.searchNew.reference)
							}));
								
						for (var i = 0; i < days.length; i++) {
							f.append($('<a>', {
									'class': 	'smallbtn',
									text: 		getTimespan(days[i])
								})
								.data('days', parseInt(days[i], 10))
								.on('click', function() {
									searchNew($(this).data('days'));
								}));
						}
								
						if (settings.searchNew.sinceLastVisit) {
							
							var start = $.cookie('lastVisit'),
								now = Math.round(new Date() / 1000);
							
							if (start && start < (now - ONEDAY_S)) {
								f.append($('<a>', {
										'class': 	'smallbtn',
										text: 		text.sinceMyLastVisit
									})
									.on('click', function() {
											searchNew((now - start) / ONEDAY_S);
										}));
							}
							
							// Storing last visit date for 10 years
							$.cookie('lastVisit', now, 315360000);
						}
						
					},
					
				/********************************************************
				 *
				 *						Controls
				 *
				 ********************************************************/
				
				// Go fullscreen
				
				goFullscreen = function() {
						
						$(this).trigger('removeTooltip');
						$body.addClass(settings.fullscreenClass);
						$('html').fullScreen(true);
						
					},

				// Exit fullscreen
				
				exitFullscreen = function() {
						
						$(this).trigger('removeTooltip');
						$body.removeClass(settings.fullscreenClass);
						$('html').fullScreen(false);
						
					},
					
				// Controlling the skin states
				
				startAutoplay = function() {
					
						if (!autoplayOn()) {
							var oly = getOverlay();
							
							oly.add(main)
								.removeClass(settings.pausedClass)
								.addClass(settings.playingClass);
							
							if (atLastCard()) {
								oly.trigger('lightboxLoad', [ 0, true ]);
							} else {
								oly.trigger('startAuto', [ 1000 ]);
							}
						}
					},
					
				stopAutoplay = function() {
					
						if (autoplayOn()) {
							
							var oly = getOverlay();
							
							oly.add(main)
								.removeClass(settings.playingClass)
								.addClass(settings.pausedClass);
							
							oly.trigger('stopAuto');
						}
					},
					
				autoplayOn = function() {
						return getOverlay().hasClass('playing');
					},
					
				hideCover = function() {
						
						$('.autoplay').trigger('removeTooltip');
						
						var item = getActiveItem();
						
						if (item) {
							addParam(settings.indexName, {
								img: 	album.getItemName(item)
							}, item[J.TITLE]);
						}
						
						getLightboxContainer().trigger('resumeAudioClip').trigger('resumeMedia');
						
						content
							.removeClass(settings.coverDownClass)
							.addClass(settings.coverUpClass);				
					},
					
				showCover = function() {
					
						removeParam(settings.indexName, 'img');
						//getLightboxContainer().trigger('lightboxQuit');
						//trigger('pauseMedia').trigger('pauseAudioClip');
						
						content
							.removeClass(settings.coverUpClass)
							.addClass(settings.coverDownClass);
					},
					
				coverOn = function() {
					
						return !content.hasClass(settings.coverUpClass);
					},
					
				showPanel = function(p) {
					
						if (!p || !p.length) {
							return;
						}
						
						var btn = $('aside .sidebtn[data-rel=' + p[0].id + ']'),
						
							autoHide = btn.data('autohide'),
						
							init = function()  {
									var at = btn.length? btn.parent().position().top : 0,
										bt = btn.length? btn.offset().top : 0;
									
									btn.addClass('on');
									
									p.addClass('on')
										.css({
												transition:		'none',
												display: 		'flex',
												opacity:		0,
												transform:		'translateX(-16px)'
											});
										 
									window.requestAnimationFrame(function() {
											//console.log('at: ' + at + ' top: ' + bt + ' main.height: ' + main.outerHeight() + ' panel.height: ' + p.outerHeight());
											p.css({
													left:			$('aside').outerWidth(),
													top:			Math.min(bt, main.outerHeight() - p.outerHeight())
													//Math.max(-at, Math.min(bt, main.outerHeight() - p.outerHeight() - at))
												});
											
											p.one('transitionend', function() {
													p.css({
															display:		'flex',
															opacity:		1
														});
													
													if (p[0].id === 'map') {
														p.find('[data-map-root]').trigger('refresh');
													}
													
													if (autoHide) {
														setTimeout(function() {
																hidePanel(p);
															}, autoHide || 3000);
													}
												})
												.css({
														transition:		'opacity 500ms, transform 500ms ease-out',
														opacity:		1,
														transform:		'translateX(0)'
													});
										});
								};
								
						window.requestAnimationFrame(init);
					},
					
				hidePanel = function(p) {
						
						if (!p || !p.length || p.css('position') === 'static') {
							// don't remove the folder navigation in the sidebar 
							return;
						}
						
						var btn = $('aside .sidebtn[data-rel=' + p[0].id + ']');
						
						$('aside').hideAllTooltips();
						
						window.requestAnimationFrame(function() {
								p.one('transitionend', function() {
											p.removeClass('on')
												.css({
														transition:		'none',
														display: 		'none'
													});
											btn.removeClass('on');
										})
									.css({
											transition:		'opacity 500ms, transform 500ms ease-in',
											opacity:		0,
											transform:		'translateX(-16px)'
										});
							});
					},
					
				hideAllPanels = function() {
					
						$('.panel:visible').each(function() {
								hidePanel($(this));
							});
					},
									
				/********************************************************
				 *
				 *				Initializing controls
				 *
				 ********************************************************/
				
				initControls = function() {
					
						// Full screen
						
						$('#fullscreen-btn').on('click', function() {
								if (!document.fullscreenElement) {
									main.addClass('fullscreen');
									document.documentElement.requestFullscreen().catch(function(err) {
										console.log('Error going full-screen: ${err.message} (${err.name})');
									});
								}
							});
						
						$('#fullscreen-exit-btn').on('click', function() {
								if (document.fullscreenElement) {
									main.removeClass('fullscreen');
									document.exitFullscreen().catch(function(err) {
										console.log('Error exiting full-screen: ${err.message} (${err.name})');
									});
								}
							});
						
						// Auto start slideshow button events
						
						if (hasImages()) {
							// Autoplay with various buttons
							$('.btn.play,.btn.autoplay').on('click', function() {
									if (SMALLSCREEN && settings.useFullScreen && !document.fullscreenElement) {
										document.documentElement.requestFullscreen().catch(function(err) {
												console.log('Error going full-screen: ${err.message} (${err.name})');
											});
									}
									hideCover();
									startAutoplay();
								});
							
							$('.btn.pause').on('click', function() {
									stopAutoplay();
								});
								
							$('.album-title .folder-image>.image').on('click', hideCover);
							
							// Pause button
							// Toggling the cover & autoplay when clicking the actual folder
							$('.topnav .' + settings.actualClass).on('click', function(e) {
									if ($(e.target).closest('li').hasClass(settings.actualClass)) {
										if (coverOn()) {
											if (SMALLSCREEN && settings.useFullScreen && !document.fullscreenElement) {
												document.documentElement.requestFullscreen().catch(function(err) {
														console.log('Error going full-screen: ${err.message} (${err.name})');
													});
											}
											hideCover();
											startAutoplay();
										} else {
											stopAutoplay();
											showCover();
										}
										return false;
									}
								});
							
							// Handle
							$('.hero-handle').on('click', function() {
									if (coverOn()) {
										if (SMALLSCREEN && settings.useFullScreen && !document.fullscreenElement) {
											document.documentElement.requestFullscreen().catch(function(err) {
													console.log('Error going full-screen: ${err.message} (${err.name})');
												});
										}
										hideCover();
									} else {
										stopAutoplay();
										showCover();
									}
								});
							
						}
						
						// Closing panels
						
						$('.panel>.close').on('click', function() {
								hidePanel($(this).closest('.panel'));
							});
						
						// Sidebar buttons
						
						$('aside .top .sidebtn').on('click', function() {
								
								if (this.id.startsWith('fullscreen')) {
									return true;
								}
								
								if ($(this).hasClass('on')) {
									$(this).removeClass('on');
									hidePanel($('#' + $(this).data('rel')));
								} else {
									hideAllPanels();
									$('aside .sidebtn').removeClass('on');
									$(this).addClass('on');
									showPanel($('#' + $(this).data('rel')));
								}
							});
						
						// Tool tips
						$('[data-tooltip]').addTooltip();

					},
										
				/********************************************************
				 *
				 *			Initialization of misc functions
				 *
				 ********************************************************/
										
				// Right click blocking
				
				avoidRightClick = function() {
						getCards().add(getFolders()).on('contextmenu', 'img', function(e) {
								e.preventDefault()
								return false;
							});
					},
					
				// Initializing background music
				
				prepareBackgroundMusic = function(player) {
					
						if (player.length) {
							player.audioPlayer({
									rootPath: 		settings.rootPath,
									pos:			[2,1,0,1],
									onPaused:		function() {
															main.removeClass(settings.bgaudioPlayingClass).addClass(settings.bgaudioPausedClass);
														},
									onPlaying:		function() {
															main.removeClass(settings.bgaudioPausedClass).addClass(settings.bgaudioPlayingClass);
														},
								});
						}
					},
					
				// Updating the share buttons after a state change
				
				updateShares = function() {
					
						if (settings.hasOwnProperty('share')) {
							
							if (getLightboxContainer().is(':visible')) {
								// Lightbox: sharing actual image
								var item = getActiveItem();
								
								if (item) {
									$(settings.share.hook).trigger('updateLinks', {
											sites: 			settings.share,
											title: 			item[J.TITLE] || item[J.NAME].stripExt().replace(/[-_]/g, ' ').capitalize(),
											description: 	item[J.COMMENT] || '',
											image: 			album.getOptimalImagePath(item, [ 1200, 800 ]),
											href: 			album.getAbsolutePath(item)
										});
								}
							} else {
								// Index page: reset to page sharing
								$(settings.share.hook).trigger('updateLinks');
							}	
						}
					},
					
				// Initializing Social sharing
				
				prepareShares = function(opt) {
						
						$.fn.renderShares.defaults.buttonTheme = opt['buttonTheme'] || 'dark';
						$.fn.renderShares.defaults.indexName = settings.indexName;
						$.fn.renderShares.defaults.facebookAppId = opt['facebookAppId'] || '';
						$.fn.renderShares.defaults.albumTitle = album.getAlbumTitle(); 
						
						if (opt.hasOwnProperty('emailSubject')) {
							$.fn.renderShares.defaults.emailSubject = opt.emailSubject;
						}
						
						if (opt.hasOwnProperty('emailBody')) {
							$.fn.renderShares.defaults.emailBody = opt.emailBody;
						}
						
						$(opt['hook']).renderShares(opt);
							
						$.fn.lightbox.defaults.share = settings.share.sites;
						
					},
					
				// Preparing map
				
				prepareMap = function(images, settings) {
						
						var	markers,
							mapRoot = getMapRoot(true),
							
							getMarkers = function(images) {
									// Reading out map locations
									var markers = [];
									
									for (var i = 0, l; i < images.length; i++) {
										if (images[i] && (l = album.getLocation(images[i]))) {
											markers.push({
												title:		[((i + 1) + '.'), images[i]['title'], images[i]['comment']].filter(Boolean).join(' '),
												pos: 		l,
												link:		images[i].path
											});
										}
									}
									
									return markers;
								};
						
						if (!mapRoot.data('inited')) {
							// Add map only once
							markers = getMarkers(images);
							
							if (markers.length || settings.hasOwnProperty('overlay')) {
								// Markers or overlay exists
								
								if (markers.length) {
									settings.markers = markers;
								}
								
								mapRoot.addMap($.extend({
										apiKey:				settings['apiKey'],
										type:				settings['type'] || 'hybrid',
										zoom:				settings['zoom'] || 15,
										markers: 			markers,
										typeControl:		(window.innerWidth >= 640) && (window.innerHeight >= 640),
										onMarkerClick:		function() {
																	if (this.hasOwnProperty('link')) {
																		var el = getCardByName(this.link);
																		
																		if (el.length) {
																			if (isFullscreen()) {
																				exitFullscreen();
																			}
																			if (coverOn()) {
																				hideCover();
																			}
																			getOverlay().trigger('setactivecard', el);
																			setActiveCard(el);
																		}
																	}
																}
									}, settings));
							}
						}
						
						mapRoot.data('inited', true);
					},
					
				/********************************************************
				 *
				 *					Index page initialization
				 *
				 ********************************************************/
				 
				prepareIndex = function() {
					
						if (!album) {
							return;
						}
						
						var images = album.getImages();
						
						// Removing thumbnail links right away
						getCards().each(function() {
								$(this).data('href', $(this).attr('href')).attr('href', '');
							});
						
						// Preapring folders
						prepareFolders();
			
						// Rendering thumbnails
						if (images.length) {
							
							getBaseOverlay().renderImages(images, prepareImages, true);
		
						} else if (window.location.hash) {
							// no thumbnails, only folders
							if (window.location.hash) {
								// we should check the search / tags / newimages filter
								stateChange();
							}
						}
						
						// Initializing map
						if (settings.hasOwnProperty('map')) {
							// Pass defaults to lightbox
							if (settings.map.hasOwnProperty('apiKey')) {
								$.fn.lightbox.defaults.mapApiKey = settings.map.apiKey;
							}
						
							if (settings.map.hasOwnProperty('type')) {
								$.fn.lightbox.defaults.mapType = settings.map.type;
							}
						
							if (settings.map.hasOwnProperty('zoom')) {
								$.fn.lightbox.defaults.mapZoom = settings.map.zoom;
							}

							prepareMap(images, settings.map);
						}
						
						// Collecting tags if gathered only from this folder
						if (settings.hasOwnProperty('tagCloud') && settings.tagCloud['depth'] === 'current') {
							album.collectTags($.extend(settings.tagCloud, {
									exact:		settings.exactFields,
									ready:		function() {
														prepareTagCloud(this);
													}
								}));
						}
												
						// Search 
						if (settings.hasOwnProperty('search')) {
							prepareSearch($(settings.search.hook));
						}
						
						// Search new
						if (settings.hasOwnProperty('searchNew')) {
							prepareSearchNew($(settings.searchNew.hook));
						}
								
						// Preparing share buttons
						if (settings.hasOwnProperty('share')) {
							prepareShares(settings.share);
						}
						
						// Custom query (eg. new images sample box)
						var queryTarget = $('[data-jalbum-query]');
						
						if (queryTarget.length) {
							// Reding settings from data attribute
							var qsettings = queryTarget.data('jalbum-query');
							
							if (qsettings.hasOwnProperty('fn')) {
								// Calling the jalbum.album function
								album[qsettings.fn]($.extend(qsettings, {
											ready:		function(opt) {
												
																for (var i = 0, a, item, mx = Math.min(this.length, 10); i < mx; i++) {
																	
																	item = this[i];
																	
																	a = $('<a>', {
																			href:	album.getLink(item)
																		}).appendTo(queryTarget);
																	
																	a.append($('<img>', {
																			src:		album.getThumbPath(item),
																			width:		item[J.THUMB][J.WIDTH],
																			height:		item[J.THUMB][J.HEIGHT],
																			alt:		item[J.TITLE] || item[J.NAME]
																		}));
																}
																
																if (this.length > 10) {
																	queryTarget.append($('<a>', {
																			'class':	'more',
																			href:		qsettings.linkMore,
																			text:		'+' + (this.length - 10)
																		}));
																}
																
																if (settings.rightClickProtect) {
																	queryTarget.on('contextmenu', 'img', function(e) {
																			e.preventDefault()
																			return false;
																		});
																}
															}
								
									}));
							}
						}
					},
				
				/********************************************************
				 *
				 *					Custom page initialization
				 *
				 ********************************************************/
				
				preparePage = function() {
						// Page :: initializing functions
						// Search 
						if (settings.hasOwnProperty('search')) {
							prepareSearch($(settings.search.hook));
						}
						
						// Preparing share buttons
						if (settings.hasOwnProperty('share')) {
							prepareShares(settings.share);
						}
						
						settings.pageName = window.location.pathname.getFile();
						
						var paths = [];
						
						getCards().each(function() {
								$(this).data('href', a.attr('href')).attr('href', '');
								// Collecting paths from thumbnails
								paths.push($(this).data(J.PATH));
							});
						
						if (paths.length) {
						
							album.collectByPath({
									paths:		paths,
									ready:		function() {
														// Rendering thumbnails
														if (this.length) {
															
															this.children('a.' + settings.lazyloadClass)
																.each(function() {
																	t = $(this);
																	item = t.data(J.OBJ);
																	
																	if (!t.children('img').length) {
																		img = $('<img>', {
																				'class': 	settings.hideImageClass
																			})
																			// Onload action
																			.one('load', function() {
																				$(this).addClass(settings.showImageClass).removeClass(settings.hideImageClass);
																				$(this).parent().removeClass(settings.lazyloadClass);
																			})
																			.attr({
																				src:		album.getThumbPath(item),
																				width:		item[J.THUMB][J.WIDTH],
																				height:		item[J.THUMB][J.HEIGHT],
																				alt:		item[J.TITLE] || item[J.NAME].stripExt()
																			})
																			.appendTo(t);
																			
																		t.append(img);
																	}
																});
														}
													}
								});	
						}
					},
				
				/********************************************************
				 *
				 *	 Preparing functions that need the full album tree
				 *
				 ********************************************************/
				
				prepareDeepFunctions = function() {
					
						// Collecting tags if gathered from deep tree
						if (settings.hasOwnProperty('tagCloud') && settings.tagCloud['depth'] !== 'current') {
							album.collectTags($.extend(settings.tagCloud, {
									ready:		function() {
														prepareTagCloud(this);
													}
								}));
						}
					},
					
				/********************************************************
				 *
				 *					Preparing folders
				 *
				 ********************************************************/
				
				// Marking new folders
				
				markFoldersNew = function() {
						
						if (!album) {
							return;
						}
						
						var folders = album.getFolders(),
							secs 	= settings.markNew['days'] * ONEDAY_S,
							s,
							d;
						
						getFolders(':not(.webloc)').each(function(i) {
									
								if (i < folders.length) {
									d = folders[i][J.DATES];
									
									if (d) {
										d = d[settings.markNew['reference']] || d[J.DATERANGE][1] || d[J.DATERANGE][0];
										
										if (d && (nows - d) < secs) {
											s = settings.markNew.text?
												$('<span>', {
														'class':	'new-image',
														text:		settings.markNew.text
													})
												:
												$('<span>', {
														'class':	'icon-new-fill new-image'
													});
												
											if (!TOUCHENABLED) {
												s.data('tooltip', (new Date(d * 1000)).toLocaleDateString(LOCALE)).addTooltip({ delay: 100 });
											}
											
											$(this).find('.' + settings.thumbClass).eq(0).append(s);
										}
									}
								}
							});
					},
					
				// Reading counts from a <span class="image">N images</span><span class="audio">N audios</span><span class="video">N videos</span>
				
				readCounts = function(el) {
						var cnt = {
									images:		0,
									audios:		0,
									videos:		0,
									others:		0
								};
								
						el.children().each(function(i) {
								var c = this.innerText.split(/\W/),
									t = this.classList[0];
								
								if (!t && c.length > 1) {
									switch (c[1]) {
										case text.image:
										case text.images:
											t = 'images';
											break;
										case text.audio:
										case text.audios:
											t = 'audios';
											break;
										case text.video:
										case text.videos:
											t = 'videos';
											break;
										case text.other:
										case text.others:
											t = 'others';
											break;
										default:
											t = 'images';
									}
								}
										
								cnt[t] += parseInt(c[0]) || 0;
							});
						
						return cnt;
					},
					
				// Calculates the difference between two count objects
				
				getCountDiff = function(c1, c2) {
						var diff = {
									images:		0,
									audios:		0,
									videos:		0,
									others:		0
								};
								
						for (var c in c1) {
							if (c2.hasOwnProperty(c) && c1[c] !== c2[c]) {
								diff[c] = c1[c] - c2[c];
							}
						}
						
						return diff;
					},
					
				// CHeck if any difference was found
				
				allZero = function(diff) {
					
						for (var c in diff) {
							if (diff[c] !== 0) {
								return false;
							}
						}
						
						return true;
					},
					
				// Creates HTML formatted counts: <span class="image">N images</span><span class="audio">N audios</span><span class="video">N videos</span>
				
				getFormattedCounts = function(cnt) {
						var c = '';
						
						if (cnt['images']) {
							c += '<span class="image">' + cnt['images'] + '&nbsp;' + translate(cnt['images'] > 1? 'images':'image') + '</span>';
						}
						if (cnt['audios']) {
							c += '<span class="audio">' + cnt['audios'] + '&nbsp;' + translate(cnt['audios'] > 1? 'audios':'audio') + '</span>';
						}
						if (cnt['videos']) {
							c += '<span class="video">' + cnt['videos'] + '&nbsp;' + translate(cnt['videos'] > 1? 'videos':'video') + '</span>';
						}
						if (cnt['others']) {
							c += '<span class="other">' + cnt['others'] + '&nbsp;' + translate(cnt['others'] > 1? 'others':'other') + '</span>';
						}
						
						return c;
					},
					
				// Modifying the total 
					
				fixTotalImages = function(diff) {
						var el = $('.footer .counts'),
							cnt = readCounts(el);
							
						for (var c in cnt) {
							if (diff[c] !== 0) {
								cnt[c] += diff[c];
							}
						}
						
						//console.log('Diff: ' + JSON.stringify(diff) + ' cnt: ' + JSON.stringify(cnt));
						
						el.empty().append(getFormattedCounts(cnt));
					},
					
				// Preparing folders
			
				prepareFolders = function() { 
					
						var folders = getFolders();
						
						if (!folders.length) {
							return;
						}
							
						if (settings.hasOwnProperty('markNew')) {
							// Marking new folders
							setTimeout(markFoldersNew, 300);
						}
										
						setTimeout(function() {
								
							// Start lazy load 
							lazyloadFolders();
							
								// Removing prelaod class on folders already loaded
								folders.filter('.' + settings.preloadClass + ':first-child img')
									.one('load', function() {
											$(this).parents('.' + settings.preloadClass).removeClass(settings.preloadClass);
										});
								
								if ((!LOCAL || DEBUG) && settings.hasOwnProperty('weblocationCounts') && settings.weblocationCounts) {
								// Adding counts to weblocations
								folders.filter('.webloc.has-count').each(function() {
											var caption = $(this).children('.caption'),					// Tha caption
												counts = readCounts(caption.find('.counts')),			// Saving original counts
												diff;
										
										loadExternal($(this).children('.thumb').attr('href'), function() {
												
												if (typeof this === OBJECT && this.hasOwnProperty(J.DEEPCOUNTERS)) {
													diff = getCountDiff(this[J.DEEPCOUNTERS], counts);
												
													if (!allZero(diff)) {
												
														caption.find('.counts')
															.empty()
															.append(getFormattedCounts(this[J.DEEPCOUNTERS]));
																
														fixTotalImages(diff);
													}
												}
											});
									});
							}
							
						}, 500);
					},
									
				/********************************************************
				 *
				 *					Initializing album
				 *
				 ********************************************************/
				
				initAlbum = function(readyFn) {
					
						if (typeof Album === UNDEF) {
							console.log('Critical Error: Missing jalbum.album.js library!');
						}
						
						var needsDeep = settings.hasOwnProperty('tagCloud') && settings.tagCloud['depth'] !== 'current' || 
										settings.pageType === 'page' && settings.pageName === 'newimages',
							params = {
									makeDate:			settings['makeDate'],
									rootPath:			settings['rootPath'],
									relPath:			settings['relPath'],
									hiDpiImages:		settings['hiDpiImages'] || false,
									hiDpiThumbs:		settings['hiDpiThumbs'] || false,
									ready: 				(settings.pageType === 'index')? prepareIndex : preparePage,
									loadDeep:			needsDeep,
									locale:				settings['locale'] || 'en-US'
								};
							
						if (settings.indexName !== $.fn.skin.defaults.indexName) {
							params.indexName = settings['indexName'];
						}
						
						if (settings.audioPoster !== $.fn.skin.defaults.audioPoster) {
							params.audioPoster = settings['audioPoster'];
						}
							
						if (settings.videoPoster !== $.fn.skin.defaults.videoPoster) {
							params.videoPoster = settings['videoPoster'];
						}
						
						if (settings.useOriginals) {
							params.useOriginals = true;
						}
						
						if (needsDeep) {
							params.deepReady = prepareDeepFunctions;
						}
						
						album = new Album($, params);
					},
					
				// Main initializing function
				
				init = function() {
					
						// Removing search string, e.g. FB data
						if (window.location.search) {
							removeSearch();
						}
										
						loadPrefs(settings, [ 'audioClipVolume' ], 'lb_pref');
						
						// lightbox.js
						passDefaults(settings, $.fn.lightbox.defaults, 'indexName,level,uplink,uplinkText,autoStart,useOriginals,previousFoldersLast,nextFoldersFirst,rightClickProtect,useFullScreen,audioClipVolume,enableKeyboard,enableMouseWheel,extraSizes');
						passDefaults(settings.lightbox, $.fn.lightbox.defaults);
						// thumbscroll.js
						passDefaults(settings, $.fn.thumbScroll.defaults, 'activeClass,disabledClass,thumbContClass,thumbsPosition,enableMouseWheel');
									
						// Creating new Album instance
						initAlbum();
						
						// Right click protection on folders, slider
						if (settings.rightClickProtect) {
							avoidRightClick();
						}
						
						// Initializing controls
						initControls();
						
						// Background music
						prepareBackgroundMusic($('[data-audioPlayer]'));
						
						// Hash change listener
						$window.on('hashchange.' + ns, stateChange);
																					
					};
					
			
			/********************************************************
			 *
			 *					Execution starts here
			 *
			 ********************************************************/
				
			init();
			
			// Utility function for debugging
			this.getAlbum = function() {
					return album;
				};
			
			return this;
		};
	
	/********************************************************
	 *
	 *						Defaults
	 *
	 ********************************************************/
				
	$.fn.skin.defaults = {
			locale:								'en-US',
			contentHook:						'article.cont',
			startSlideshowHook:					'#start-slideshow',
			hasOverlayClass:					'has-overlay',
			baseOverlayClass:					'base-overlay',
			hideOnOverlayClass:					'hide-on-overlay',
			overlayClass:						'overlay',
			subOverlayClass:					'sub-overlay',
			overlayTitleClass:					'title',
			overlayHeadLevel:					3,
			progressbarClass:					'progressbar',
			lightboxClass:						'lightbox',
			contClass:							'cont',
			coverUpClass:						'cover-up',
			coverDownClass:						'cover-down',
			playingClass:						'playing',
			pausedClass:						'paused',
			bgaudioPlayingClass:				'bgaudio-playing',
			bgaudioPausedClass:					'bgaudio-paused',
			folderClass:						'folder',
			thumbnailsClass:					'thumbnails',
			clipClass:							'clip',
			thumbContClass:						'thumb-cont',
			thumbClass:							'thumb',
			actualClass:						'actual',
			cardClass:							'card',
			lbableClass:						'lbable',
			captionClass:						'caption',
			commentClass:						'comment',
			selectableClass:					'selectable',
			hascaptionClass:					'hascaption',
			checkedClass:						'checked',
			activeClass:						'active',
			preloadClass:						'preload',
			lazyloadClass:						'lazyload',
			hideImageClass:						'hide-image',
			showImageClass:						'show-image',
			startshowClass:						'startshow',
			selectAllClass:						'select-all',
			selectNoneClass:					'select-none',
			addSelectedClass:					'add-selected',
			scrollCheckInterval:				100,
			indexName:							'index.html',
			audioPoster:						'audio.poster.png',
			videoPoster:						'video.poster.png',
			exactFields:						'creator,keywords,regions',
			dateFormat:							'M/d/yyyy',
			audioClipVolume:					0.75,
			thumbsPosition:						'top',
			fixedShapeThumbs:					true,
			autoStart:							false,
			rightClickProtect: 					false,
			useFullScreen:						true,
			enableKeyboard:						true,
			useOriginals:						false
		};
		
})(jQuery, jQuery(window), jQuery(document), jQuery('body'));
