/*
 * 	Lightbox.js - lightbox for Projector skin
 */


/**********************************************************************
 *
 *		Projector
 *
 *********************************************************************/
	
(function($, $window, $document, $body, undefined) {	
	'use strict';
	
	/*
	 *	Auxillary routines
	 */
	 
	var log = function(txt) {
				if (console && txt && DEBUG) {
					console.log(txt);
				}
			},
		
		// Random number between -base and +base 
		random = function(base) {
				return base * (1 - 2 * Math.random());
			},
			
		getTranslateZ = function(el) {
				var st = window.getComputedStyle(el[0], null),
					tr = st.getPropertyValue('transform') || st.getPropertyValue('-ms-transform') || st.getPropertyValue('-webkit-transform'),
					m;
					
				if (tr && (m = tr.match(/matrix(3d)?\(([^\)]+)\)/))) {
					m = m[2].split(/\s*,/);
					if (m.length === 16) {
						return parseFloat(m[14]);
					} 
				}
				return 0;
			};
			
	/*********************************************************
	 *
	 *		The main function
	 *
	 *********************************************************/

	$.fn.lightbox = function(album, options) {
		
			if (typeof album === UNDEF) {
				return this;
			}
			
			options = $.extend({}, $.fn.lightbox.defaults, options);
			
			var text 	= getTranslations($.fn.lightbox.text),
				id 		= {
								lightbox:		'lightbox',
								prev:			'jprev',
								next:			'jnext',
								pause:			'pause',
								jalbum:			'jalbum',
								cards:			'jcards',
								card:			'jcard',
								caption:		'jcaption',
								scrollable:		'scrollable',
								title:			'jtitle',
								hasCaption:		'jhascaption',
								imageReady:		'jimageready',
								prevPage:		'jprevpg',
								nextPage:		'jnextpg',
								currPage:		'jcurrpg',
								paging:			'jpaging',
								shade:			'jshade',
								threedee:		'threedee'
							};
				
				
			
			return $(this).each(function() {
					
					var overlay			= 	$(this),									// Overlay
						subOverlay		=	overlay.hasClass('sub-overlay'),			// is overlay (not base)
						cont			=	overlay.parent(),							// Container
						ns				=	overlay.data('lightbox-ns');				// Namespace
						
					if (typeof ns !== UNDEF) {
						// Already instantitated
						return;
					}
					
						
					var	lightbox,														// main element
						settings,														// local settings
						
						pw,																// Projector width
						ph,																// ... and height
												
						cards,															// All cards container
						prevBtn,
						nextBtn,
						fullScreenBtn,
						progressBar1,
						progressBar2,
						items			= 	[],											// Objects
						curr			=	-1,											// Current item's index
						nxt				=	-1,											// Next number (e.g. random ordering)
						dir				= 	1,											// Direction
						max 			= 	0,											// Maximum number of items
						zoom			=	0,											// Zoom: 0-100, where 0 is Min(fit to box, 1:1), 100 is the max image variant size
						caption			=	$(),										// Current item's caption
						audioClip 		= 	$(),										// Audio clip's AUDIO element
						audioClipTimeout = null,
						threedee,														// using 3D transforms?
						slideshow		= 	null,										// slideshow timeout
						slideshowDelay	= 	4000,										// slideshow timing
						transitionSpeed	=	1500,										// transition speed
						suspended		= 	false,										// suspended slideshow
						resumeDelay		= 	0,											// delay before suspending slideshow
						progressTo		=	null,										// progress timeout
						layoutTo		= 	null,										// layout refresh timeout
						fitTo			= 	null,										// Fit image timeout
						loaded			= 	false,										// has been loaded?
						swiped			= 	$(),										// last item swiped
						
						lastLoad		= new Date(),									// Saving last date to avoid too many changes
						
						backgroundAudioRoot = $('[data-audioplayer]'),
	
						// Returns a random direction for animations that use direction
						
						randomDirection = function() {
							
								if (settings.direction.length > 0) {
									var a = [];
									for (var i = 0; i < settings.direction.length; i++) {
										switch(settings.direction[i].toLowerCase()) {
											case 'e': a.push([1,0]); break;
											case 's': a.push([0,1]); break;
											case 'w': a.push([-1,0]); break;
											case 'n': a.push([0,-1]); break;
										}
									}
									if (a.length === 1) {
										return a[0];
									} else if (a.length > 1) {
										return a[Math.floor(Math.random() * a.length)] || [1, 0];
									}
									// No valid direction: fall back to East
									return [1, 0];
								}
								
								// Random
								return (Math.random() >= 0.5)? [ (Math.random() >= 0.5)? 1 : -1, 0 ] : [ 0, (Math.random() >= 0.5)? 1 : -1];
							},
							
						getDirection = function() {
								switch(settings.direction[0].toLowerCase()) {
									case 's': 	return [0,1];
									case 'w': 	return [-1,0];
									case 'n': 	return [0,-1];
									default:	return [1,0];
								}
							},
							
						getReverseDirection = function(d) {
								switch(settings.direction[0].toLowerCase()) {
									case 's': 	return [0,-1];
									case 'w': 	return [1,0];
									case 'n': 	return [0,1];
									default:	return [-1,0];
								}
							},
							
						// Is the cover still on?
						
						isCoverDown = function() {
								return !cont.hasClass('cover-up');
							},
							
						// Quit lightbox
						
						quitLightbox = function() {
							
								pauseMedia();
								pauseAudioClip();
								
								if (backgroundAudioRoot.length && backgroundAudioRoot.data('slideshowControl') && !backgroundAudioRoot.data('paused')) {
									backgroundAudioRoot.trigger('fadeOutPlayer');
								}
								
								if (settings.hasOwnProperty('onQuit') && typeof settings.onQuit === FUNCTION) {
									settings.onQuit.call(null, curr);
								}
							},
							
						// Reset position after swipe
						
						resetCardPosition = function() {
								if (swiped.length) {
									swiped.data('swiped', false);
									swiped.trigger('resetSwipe');
									swiped = $();
								}
							},
											
						// Slideshow next stage
						
						changeCard = function() {
								var n, sh = !!slideshow;
								
								//log('Change card');
								
								if (max < 2) {
									return;
								}
								
								if (settings.ordering === 'random') {
									
									do {
										n = Math.floor(Math.random() * items.length);
									} while (n === curr);
									
									loadCard(n);
									
								} else {
									
									nextCard(sh);
								}
								
							},
							
						// Previous card
						
						previousCard = function(sh) {
								
								//log('Previous card');
								_clearAuto();
								
								dir = -1;
								
								if (curr) {
									
									loadCard(curr - 1);
									return;
									
								} else if (overlay.data('overlay') === 'base') {
									
									switch (settings.afterLast) {
										
										case 'donothing':
											
											break;
											
										case 'nextfolder':
											
											if (settings.previousFoldersLast) {
												window.location.href = settings.previousFoldersLast + ((typeof sh !== UNDEF && sh)? '&slideshow' : '');
											}
											break;
											
										case 'backtocover':
										case 'startover':
										case 'onelevelup':
										case 'ask':
											
											loadCard(items.length - 1);
											return;
											
									}
									
								} else {
									
									loadCard(items.length - 1);
									return;
								}
								
								resetCardPosition();
							},
							
						// Next card
						
						nextCard = function(sh) {
								
								//log('Next card');
								
								_clearAuto();
								
								dir = 1;
								
								if (curr < (items.length - 1)) {
									
									// Not at end
									loadCard(curr + 1);
									return;
									
								} else if (overlay.data('overlay') === 'base') {
									
									// At end of Base set
									switch (settings.afterLast) {
										
										case 'donothing':
											
											resetCardPosition();
											stopAuto();
											break;
											
										case 'startover':
											
											loadCard(0);
											return;
											
										case 'onelevelup':
											
											if (settings.level) {
												window.location.href = '../' + settings.indexName;
											} else if (settings.uplink) {
												window.location.href = settings.uplink;
											} else {
												resetCardPosition();
												stopAuto();
											}
											break;
											
										case 'nextfolder':
											
											if (settings.nextFoldersFirst) {
												window.location.href = settings.nextFoldersFirst + ((typeof sh !== UNDEF && sh)? '&slideshow' : '');
											} else {
												resetCardPosition();
												stopAuto();
											}
											break;
											
										case 'backtocover':
											
											resetCardPosition();
											stopAuto();
											
											if (settings.hasOwnProperty('onQuit') && typeof settings.onQuit === FUNCTION) {
												settings.onQuit.call(null, curr);
											}
											break;
											
										case 'ask':
									
											var buttons = new Array();
											
											resetCardPosition();
											stopAuto();
											
											if (items.length > 1) {
												// Start over
												buttons.push({
														t: 	text.startOver,
														c:	'icon-loop',
														h: 	function(lb) { 
																loadCard(0);
															}
													});
											}
											
											if (settings.level) {
												// Up one level
												buttons.push({
														t: 	text.upOneLevel, 
														c:	'icon-one-level-up',	
														h: 	function() { 
																window.location.href = ('../' + settings.indexName);
															}
													});
											}
											
											if (settings.uplink) {
												// To Home
												buttons.push({
														t: 	settings.uplinkText, 
														c:	'icon-home',	
														h: 	function() { 
																window.location.href = settings.uplink;
															}
													});
											}
											
											// Back to cover
											buttons.push({
													t: 	text.backToCover,
													c:	'icon-arrow-down',
													h: 	quitLightbox
												});
											
											if (settings.nextFoldersFirst) {
												// Go to next folder
												buttons.push({
														t: 	text.nextFolder,
														c:	'icon-arrow-right',
														h: 	function() {
																window.location.href = settings.nextFoldersFirst;
															}
													});
											}
									
											overlay.modal($('<p>', {
													'class':	'text-center',
													text: 		text.atLastPageQuestion
												}), buttons, {
													onClose:	function() {
																	stopAuto();
																	loadCard(items.length - 1);
																},
													'class': 	'secondary',
													title: 		text.atLastPage
												});
											
											return;
											
									}
									
								} else {
									
									// On overlay e.g. search results: loop
									loadCard(0);
									return;
								}
								
								resetCardPosition();
							},
						
						// Animating progress bar
						
						animateProgress = function(duration) {
								var d = 20 / duration,
								
									setProgress = function(to) {
										
											//progress.css('transform', 'rotate(' + to * 360 + 'deg)');
											progressBar1[0].style.transform = 'rotate(' + Math.min(to, .5) * 360 + 'deg)';
											progressBar2[0].style.transform = 'rotate(' + Math.max(to - .5, 0) * 360 + 'deg)';

											if (to < 1) {
												to = Math.min(1, to + d);
												progressTo = setTimeout(setProgress, 20, to); 
											}
										};
									
								clearTimeout(progressTo);
								if (progressBar1.length) {
									progressTo = setTimeout(setProgress, 20, 0);
								}
							},
							
						// Stopping the slideshow timeout
							
						_clearAuto = function() {
							
								//settings.auto = false;
								
								if (slideshow) {
									clearTimeout(slideshow);
									slideshow = null;
									suspended = true;
								} else {
									suspended = false;
								}
							},
							
						// Start auto play
						
						_startAuto = function(delay) {
								var delay = delay || 0;
								//log('Start auto');
								
								clearTimeout(slideshow);
								if (isMediaPlaying()) {
									onMediaEnded(changeCard);
									suspended = true;
								} else {
									slideshow = setTimeout(changeCard, delay);
									animateProgress(delay);
									suspended = false;
								}
								settings.auto = true;
								
							},
							
						// With Full screen toggle
						
						startAuto = function(delay) {
							
								if (SMALLSCREEN && settings.useFullScreen && !document.fullscreenElement) {
									// Going full screen
									document.documentElement.requestFullscreen().catch(function(err) {
											console.log('Error going full-screen: ${err.message} (${err.name})');
										});
									layoutTo = setTimeout(layoutRefresh, 100);
								}
								
								requestWakeLock();
								
								_startAuto(typeof delay === UNDEF? 0 : delay);
								
								if (backgroundAudioRoot.length && backgroundAudioRoot.data('slideshowControl') && backgroundAudioRoot.data('paused')) {
									backgroundAudioRoot.trigger('fadeInPlayer');
								}
								
								if (settings.hasOwnProperty('onSlideshowStart') && typeof settings.onSlideshowStart === FUNCTION) {
									settings.onSlideshowStart.call(null, curr);
								}
								
								if (settings.hideSidebar) {
									layoutRefresh();
								}
							},
							
						// Stop auto play
						
						_stopAuto = function() {
							
								//log('Stop auto');
								
								clearTimeout(slideshow);
								slideshow = null;
								settings.auto = false;
								suspended = false;
								
							},
							
						// With Full screen toggle
						
						stopAuto = function() {
								
								if (settings.auto) {
									_stopAuto();
									
									showCaption();
									
									if (settings.thumbstripVisibility === 'auto') {
										showThumbs();
									}
									
									if (backgroundAudioRoot.length && backgroundAudioRoot.data('slideshowControl') && !backgroundAudioRoot.data('paused')) {
										backgroundAudioRoot.trigger('fadeOutPlayer');
									}
									
									if (settings.hasOwnProperty('onSlideshowPause') && typeof settings.onSlideshowPause === FUNCTION) {
										settings.onSlideshowPause.call(null, curr);
									}
									
									releaseWakeLock();
									
									if (settings.hideSidebar) {
										layoutRefresh();
									}
								}
							},
							
						// Toggling autoplay
						
						toggleAuto = function() {
							
								if (settings.auto) {
									stopAuto();
								} else {
									startAuto(resumeDelay);
								}
							},
							
						// Suspending auto during video play
						
						suspendAuto = function() {
							
								if (settings.auto) {
									if (backgroundAudioRoot.length && backgroundAudioRoot.data('slideshowControl') && !backgroundAudioRoot.data('paused')) {
										backgroundAudioRoot.trigger('fadeOutPlayer');
									}
									suspended = true;
									clearTimeout(slideshow);
									slideshow = null;
								} else {
									suspended = false;
								}
							},
							
						// Resuming auto after video ended
							
						resumeAuto = function() {
							
								if (suspended) {	
									suspended = false;
									if (settings.auto) {
										slideshow = setTimeout(changeCard, resumeDelay);
										if (backgroundAudioRoot.length && backgroundAudioRoot.data('slideshowControl') && backgroundAudioRoot.data('paused')) {
											backgroundAudioRoot.trigger('fadeInPlayer');
										}
									}
								}
							},
						
						// Gets the custom slideshow interval (if exist)
						
						getSlideshowTiming = function(item) {
							
								if (item.hasOwnProperty(J.SLIDESHOWINTERVAL)) {
									slideshowDelay = item[J.SLIDESHOWINTERVAL];
								} else {
									slideshowDelay = settings.slideshowDelay;
								}
								if (item.hasOwnProperty(J.TRANSITIONSPEED)) {
									transitionSpeed = item[J.TRANSITIONSPEED];
								} else {
									transitionSpeed = settings.transitionSpeed;
								}
							},
					
						// Audio clip handling
						// Updating progress bar
						
						updateAudioClipProgress = function(pb) {
							
								if (audioClip.length && pb.length) {
									pb.css('width', (100 * audioClip[0].currentTime / audioClip[0].duration) + '%');
								}
							},
							
						// Starting audio clip
						
						startAudioClip = function() {
							
								if (audioClip.length) {
									var p,
										btn = audioClip.siblings('.audioclip-btn'),
										pb = btn.children('.progress');
									
									if (p = audioClip[0].play()) {
										
										p.then(function() {
												
												btn.removeClass('icon-volume-up').addClass('icon-pause');
												audioClip.parent().removeClass('paused').addClass('playing');
												
												suspendAuto();
												
												if (!pb.length) {
													pb = $('<div>', {
															'class':	'progress'
														}).appendTo(btn);
												}
												
												updateAudioClipProgress(pb);
												
												audioClipTimeout = setInterval(updateAudioClipProgress, 100, pb);
												
												audioClip.on('ended', function() {
													
														btn.removeClass('icon-pause').addClass('icon-volume-up');
														audioClip.parent().removeClass('playing').addClass('paused');
														
														resumeAuto();
														
														pb.remove();
														
														clearInterval(audioClipTimeout);
													});
													
											}, function(err) {
												
												btn.removeClass('icon-pause').addClass('icon-volume-up');
												console.log(err);
											});
									}
								}
							},
							
						// Resuming audio clip
						
						resumeAudioClip = function() {
							
								if (audioClip.length && audioClip.data('wasPlaying')) {
									startAudioClip();
								}
							},
							
						// Pausing audio clip
						
						pauseAudioClip = function() {
									
								if (audioClip.length) {
									var btn = audioClip.siblings('.audioclip-btn');
									
									audioClip.data('wasPlaying', !audioClip[0].paused);
									audioClip[0].pause();
									clearInterval(audioClipTimeout);
									
									btn.removeClass('icon-pause').addClass('icon-volume-up');
									audioClip.parent().removeClass('playing').addClass('paused');
									
									resumeAuto();
								}
							},	
							
						// Handling clip ended event
						
						onAudioClipEnded = function(fn, params) {
							
								if (audioClip.length && typeof fn === FUNCTION) {
									if (audioClip[0].paused) {
										if (typeof params !== UNDEF) {
											fn.apply(null, params);
										} else {
											fn.call(null);
										}
									} else {
										audioClip.on('ended', fn, params);
									}
								}
							},
					
						// Pause media
						
						pauseMedia = function() {
								
								cards.children('#c' + curr).children('audio,video').each(function() {
										this.pause();
									});
							},
							
						// Resume media
						
						resumeMedia = function() {
								var m = cards.children('#c' + curr).children('audio,video');
								
								if (m.length) {
									m[0].play();
								}
							},
						
						// Is media playing?
						
						isMediaPlaying = function() {
								var m = cards.children('#c' + curr).children('audio,video');
								
								return m.length? !m[0].paused : false;
							},
							
						// On Media ended
						
						onMediaEnded = function(fn) {
								
								if (typeof fn === FUNCTION) {
									cards.children('#c' + curr).children('audio,video').eq(0).on('ended', fn);
								}
							},
							
						// Video (or audio) has ended
						
						mediaEnded = function() {
							
								if (settings.auto) {
									resumeAuto();
								}
								
								pauseAudioClip();
							},
							
						// Get item from card
						
						getCurrItem = function(el) {
								var n = parseInt(cards.find('#c' + curr)[0].id.slice(1));
								
								return (typeof n === NUMBER)? items[n] : null;
							},
						 
						// Fits all images into cards (that were not fitted previously)
						
						fitImages = function(force) {
								
								var loadcnt = 0;
								
								clearTimeout(fitTo);
								fitTo = null;
								
								cards.find('.' + id.card).each(function(i) {
										var card = $(this);
										
										if (typeof force !== UNDEF && !force && t.data('fitted')) {
											loadcnt++;
											return true;
										}
										
										var img = card.children('img');
										
										if (!img.length) {
											return true;
										}
										
										var	o = items[$(this).data('idx')],
											cw = Math.min(card.outerWidth(), cards.outerWidth()),
											ch = Math.min(card.outerHeight(), cards.outerHeight()),
											w = img[0].naturalWidth || img.width(),
											h = img[0].naturalHeight || img.height(),
											imgDims = album.getDimensions(o),
											maxDims = album.getMaxDimensions(o),
											sc;
											
										if (!w || !h || !cw || !ch) {
											return true;
										}
										
										if (zoom) {
											// Zoomed
											sc = Math.min(maxDims[0] / imgDims[0], maxDims[1] / imgDims[1]);
											//card.removeClass(settings.containClass);
										} else {
											// Fit image: cover | fit
											if (settings.fit === 'both') {
												sc = Math.min(cw / w, ch / h);
											} else if (settings.fit === 'cover') {
												sc = Math.max(cw / w, ch / h);
											} else if (settings.fit === 'vertically' || (cw / w > ch / h)) {
												// Scale for height
												sc = ch / h;
											} else if (settings.fit === 'horizontally') {
												// Scale for width
												sc = cw / w;
											} else {
												sc = 1;
											}
											
											// Apply constraints
											sc = Math.min(sc, settings.scaleUp? settings.maxzoom : 1);
											//card.addClass(settings.containClass);
										}
																				
										w *= sc;
										h *= sc;
										
										card.css({
												width:		'auto'
											});
										
										img.css({
												transition: 'all 300ms ease-out',
												left:		(cw - w) / 2,
												top:		(ch - h) / 2,
												width:		w,
												height:		h
											});										
										
										card.data('fitted', true);
											
										loadcnt++;
									});
								
								if (cards.find('.' + id.card).length > loadcnt) {
									// Still some cards left to be fitted
									fitTo = setTimeout(fitImages, 100, force);
								}
							},
							
						// Creating video/audio player
						
						createMedia = function(card) {
								var img = card.find('img').eq(0),
									item = items[card.data('idx')],
									cat = item[J.CATEGORY],
									media = $('<' + cat + '>', {
												preload: 		'auto',
												controls: 		'true',
												controlsList:	'nodownload'
											}).insertAfter(img);
											
								if (cat === 'video') {
									img.remove();
									media.attr({
											width:			item[cat][J.WIDTH],
											height:			item[cat][J.HEIGHT]
										});
								}
									
								media[0].volume = settings.volume;
								
								if (cat === 'video') {
									var r = Math.min(card.width() / item[cat][J.WIDTH], card.height() / item[cat][J.HEIGHT]);
									// fitting to the card
									media.css({
											width:			r * item[cat][J.WIDTH],
											height:			r * item[cat][J.HEIGHT]
										});
									
								}
								
								media.on({
									volumechange:
										function() {
											settings.volume = this.volume;
										},
									play:	
										function() {
											card.addClass('media-playing');
											card.children('audio,video').addClass('playing');
											if (settings.auto) {
												suspendAuto();
											}
										},
									pause:	
										function() {
											card.removeClass('media-playing');
											card.children('audio,video').removeClass('playing');
										},
									ended:	
										function() {
											card.removeClass('media-playing');
											mediaEnded();
										}
								}).attr('src', album.getSourcePath(item));
								/*
								if (settings.videoAuto) {
									playMedia();
								}
								*/
								return media;
							},
							
						// Play media button clicked or autoplay
						
						playMedia = function(e) {
								
								suspendAuto();
								
								var card,
									media;
								
								if (e instanceof $) {
									card = e;
								} else if (e) {
									e.preventDefault();
									card = $(e.target).closest('.' + id.card);
								} else {
									return false;
								}
								
								media = card.children('video,audio');
								
								if (!media.length) {
									media = createMedia(card);
								}
								
								if (media.data('loaded')) {
									playVideo(media[0]);
								} else {
									media.one('loadedmetadata', function() {
											$(this).data('loaded', true);
											if (this.paused) {
												if (this.nodeName === 'VIDEO') {
													playVideo(this);
													startAudioClip();
												} else {
													this.play().then(function() {
															addClass(this, 'playing');
														}).catch(function(err) {
															// Rejected
															console.log('Autoplay rejected. Try starting the audio manually!');
														});
												}
											}
										});
								}
								
								suspendAuto();
								
								if (suspended) {
									onMediaEnded(resumeAuto);
								}
								
								return false;
									
							},
							
						// Image clicked :: toggle controls or audio/video controls
						
						imageClicked = function(e) {
								var touched = $('html').data('whatinput') === 'touch' || e.type === 'touchend',
									card = $(e.target).closest('.' + id.card);
								
								//log(e.type);
											
								if (card.data('type') === 'video' || card.data('type') == 'audio') {
									var m = card.children('audio,video')[0];
									
									if (m) {
										if (m.paused) {
											m.play();
											if (VEND !== 'ms') {
												m.controls = false;
											}
										} else {
											m.pause();
											if (VEND !== 'ms') {
												m.controls = true;
											}
										}
									}
									
									if (touched) {
										toggleElements();
									}
									
									return false;
									
								} else {
									
									if (settings.clickAction === 'nextimage') {
										// image navigation
										if (((e.pageX || e.originalEvent.pageX) - overlay.position().left) > (overlay.width() / 2)) {
											nextCard();
										} else {
											previousCard();
										}
									} else if (settings.clickAction !== 'donothing') {
										toggleElements();
									}
								}
							},
							
						// Toggling zoom
						
						toggleZoom = function(e) {
							
								if (zoom < 50) {
									zoom = 100;
								} else {
									zoom = 0;
								}
								
								fitImages();
								
								return false;
							},
							
						// Show caption
						
						showCaption = function(on) {
								if (typeof on === UNDEF || on) {
									lightbox.removeClass(settings.captionHiddenClass).addClass(settings.captionVisibleClass);
								} else {
									lightbox.removeClass(settings.captionVisibleClass).addClass(settings.captionHiddenClass);
								}
							},
						
						// Show thumbs
						
						showThumbs = function(on) {
								if (typeof on === UNDEF || on) {
									cont.removeClass(settings.thumbsHiddenClass).addClass(settings.thumbsVisibleClass);
								} else {
									cont.removeClass(settings.thumbsVisibleClass).addClass(settings.thumbsHiddenClass);
								}
							},
						
						
						
						// Toggling elements
						
						toggleElements = function(e) {
								if (settings.thumbstripVisibility === 'hidden' || settings.thumbstripVisibility === 'auto' && slideshow) {
									showCaption(lightbox.hasClass(settings.captionHiddenClass));
								} else {
									showThumbs(cont.hasClass(settings.thumbsHiddenClass));
								}	
								return false;
							},
							
						// Card ready to be displayed
						
						cardReady = function(e) {
								var card = e? ((e instanceof jQuery)? e : $(e.target)).closest('.' + id.card) : cards.find('#c' + curr),
									// Dimensions
									getDim = function() {
											return [ (card.outerWidth() || cards.width()), (card.outerHeight() || cards.height()) ];
										},
									// Get move direction regarding looping
									getDir = function(p, n) {
											if (items.length === 1) {
												return 0;
											}
											if (!n && p > 1 && p === items.length - 1) {
												return 1;
											}
											if (!p && n > 1 && n === items.length - 1) {
												return -1;
											}
											return (n > p)? 1 : -1;
										},
									// Forcing layout
									flushTransitions = function(c) {
											if (c && c.length) {
												var img = c.children('img');
												window.getComputedStyle(c[0], null);
												if (img.length) {
													window.getComputedStyle(img[0], null);
												}
											}
										};
									
								//$('.map-root').trigger('resetMarkers');
								
								card.addClass(id.imageReady);
								
								var prev = card.prevAll(),
								
									removeTo = null,
										
									removePrev = function(e) {
												
											clearTimeout(removeTo);
											removeTo = null;
												
											var tn = new Date(),
												t = e? $(this).closest('.' + id.card) : card.prevAll(),
												ts = t.data('ts') || t.children('.' + id.card).data('ts');
											
											if (!t.length) {
												//log('Already removed. callee = ' + (e? 'transitionEnd' : 'timeout'));
												return;
											}
											/*
											if (!swiped.length && ((typeof ts !== NUMBER) || (tn - ts) < (transitionSpeed * 0.9))) {
												if (DEBUG) {
													log('Premature remove attempt on "' + t.attr('id') + '"! (' + ((typeof ts !== NUMBER)? 'no start time' : ((tn - ts) + 'ms < ' + transitionSpeed + 'ms')) + ') callee = ' + (e? ('transitionEnd(' + e.originalEvent.propertyName + ')') : 'timeout'));
												}
												return;
											}
											*/
											//log('Normal remove on "' + t.attr('id') + '" (' + (tn - ts) + 'ms) callee = ' + (e? ('transitionEnd(' + e.originalEvent.propertyName + ')') : 'timeout'));
											if (t.parent().hasClass(id.prevPage)) {
												t.parent().remove();
											} else if (settings.transitionType === 'coverflow') {
												// Keep one
												t.not(card.prev()).remove();
											} else {
												t.remove();
											}
										};
										
								if (items.length > 1) {
									if (card.prev().length) {
										dir = getDir(card.prev().data('idx'), card.data('idx'));
									} else {
										dir = 1;
									}
								} else {
									dir = 0;
								}
								
								if (dir > 0) {
									cards.removeClass('bwd').addClass('fwd');
								} else if (dir < 0) {
									cards.removeClass('fwd').addClass('bwd');
								}	
								
								if (settings.transitionType !== 'carousel') {
									if (settings.transitionType === 'coverflow') {
										card.prev().prev().prevAll().remove();
									} else {
										card.prev().prevAll().remove();
									}
									prev = card.prevAll();
								}
								
								// Saving transition start date
								prev.data('ts', new Date());
								
								prev.destroyAllTooltips();
								
								// Flushing CSS transitions
								flushTransitions(card);
								fitImages();
								
								if (settings.hasOwnProperty('onLoadEnd') && typeof settings.onLoadEnd === FUNCTION) {
									settings.onLoadEnd.call(this, curr);
								}
								
								// Add swipe gesture handling
									/*if (prev.length) {
										prev.trigger('removeSwipe');
									}*/
									
								card.swipe({
										noSwipeInside:		'.' + id.caption,
										
										onSwipedLeft: 		function(e) {
																	swiped = $(this);
																	stopAuto();
																	nextCard();
																},
													
										onSwipedRight: 		function() {
																	swiped = $(this);
																	stopAuto();
																	previousCard();
																},
														
										onSwipedDown:		function() {
																	swiped = $(this);
																	stopAuto();
																	quitLightbox();
																	setTimeout(resetCardPosition, 500);
																},
													
										onSwipeStart:		function() {
																	card.data('slideshowStopped', settings.auto);
																	stopAuto();
																},
																
										onClick:			function(e) {
																	if (!card.data('slideshowStopped')) {
																		imageClicked(e);
																	}
																},
																																
										onRightClick:		stopAuto,
														
										onDoubleClick:		settings.doubleClickZoom? 
																toggleZoom
																: 
																null
									});
								
								if (card.hasClass('video') || card.hasClass('audio')) {
									if (settings.videoAuto && !isCoverDown()) {
										playMedia(card);
									}
								}
								
								if (prev.hasClass('video') || prev.hasClass('audio')) {
									prev.find('audio,video').each(function() {
											this.pause();
										});
								}
								
								if (swiped.length) {
									// Image was swiped = let's use a simple transition
									
									var init = function() {
												
												card.css({
														opacity:		0,
														transform:		'scale(.95) translateX(' + (dir * 100) + 'px)'
													});
												
												prev.one('transitionend', removePrev)
												window.requestAnimationFrame(start);
											},
											
										start = function() {
										
												card.css({
														opacity:		1,
														transform:		'scale(1) translateX(0)' + (threedee? (' translateZ(' + (-1 * getTranslateZ(cards)) + 'px)') : ''),
														transition:		'opacity ' + transitionSpeed + 'ms ease-in-out, transform ' + transitionSpeed + 'ms ease-out'
													});
												
												removeTo = setTimeout(removePrev, transitionSpeed);
											};
									
									window.requestAnimationFrame(init);
										
									swiped = $();
									
								} else {
								
									// Transition								
									switch (settings.transitionType) {
										
										/********************************************
										 *				Cross fade
										 */
										 
										case 'crossfade':
											
											if (prev.length) {
												var init = function() {
													
															card.css({
																	opacity:		0,
																	transition:		'none'
																});
															
															window.requestAnimationFrame(start);
														},
														
													start = function() {
														
															card.css({
																	opacity:		1,
																	transition:		'opacity ' + transitionSpeed + 'ms ease-in-out'
																});
															
															prev.one('transitionend', removePrev)
																.css({
																	opacity:		0
																});
																
															removeTo = setTimeout(removePrev, transitionSpeed + 20);
														};
														
												window.requestAnimationFrame(init);
											
											} else {
											
												window.requestAnimationFrame(function() {
														
														card.show().css({
																opacity:		1,
																transition:		'opacity ' + transitionSpeed + 'ms ease-in-out'
															});
													});
											}
											
											break;
											
										/********************************************
										 *					Zoom
										 */
										 
										case 'zoom':
											
											if (prev.length) {
												
												var init = function() {
													
															card.show().css({
																	opacity:		0,
																	transform:		'scale(' + ((dir > 0)? 0.9 : 1.11) + ')',
																	transition:		'none'
																});
															
															window.requestAnimationFrame(start);
														},
														
													start = function() {
														
															card.css({
																	opacity:		1,
																	transform:		'scale(1)',
																	transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + transitionSpeed + 'ms ease-in-out'
																});
																
															prev.one('transitionend', removePrev)
																.css({
																	opacity:		0,
																	transform:		'scale(' + ((dir > 0)? 1.11 : 0.9) + ')',
																	transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + transitionSpeed + 'ms ease-in-out'
																});
																														
															removeTo = setTimeout(removePrev, transitionSpeed + 20);
														};
																												
												window.requestAnimationFrame(init);
												
											} else {
												
												window.requestAnimationFrame(function() {
														
														card.show().css({
																	transform:		'scale(1)',
																	opacity:		1
																});
													});
											}
											
											break;
											
										/********************************************
										 *					Stack
										 */
										 
										case 'stack':
											
											if (prev.length) {
												
												var dim = getDim(),
													a = random(60),
													r = (a + 90) / 180 * Math.PI,
													d = Math.min(dim[0], dim[1]) / 4,
													
													init = function() {
														
															card.css({
																	opacity:		0,
																	transform:		'scale(0.92)',
																	transition:		'none'
																});
																
															//log('a = ' + a.toFixed(2) + 'o (' + r.toFixed(2) + 'rad) ' + ' d = ' + d);  
																
															window.requestAnimationFrame(start);
														},
														
													start = function() {
														
															card.css({
																	opacity:		1,
																	transform:		'scale(1)',
																	transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + (transitionSpeed / 2) + 'ms linear'
																});
															
															prev.one('transitionend', removePrev)
																.css({
																	opacity:		0,
																	transform:		'rotate(' + (0 - a / 10) + 'deg) translate(' + Math.round(d * Math.cos(r)) + 'px,' + dir * Math.round(0 - d * Math.sin(r)) + 'px)',
																	transition:		'transform ' + transitionSpeed + 'ms ease-out, opacity ' + (transitionSpeed / 2) + 'ms linear'
																});
															
															removeTo = setTimeout(removePrev, transitionSpeed + 20);
														};
													
												window.requestAnimationFrame(init);
											
											} else {
												
												window.requestAnimationFrame(function() {
														
														card.show().css({
																opacity:		1,
																transform:		'scale(1)',
																transition:		'opacity ' + Math.min(transitionSpeed / 2, 500) + 'ms linear'
															});
													});
											}
											
											break;
											
										/********************************************
										 *				Ken Burns
										 */
										 
										case 'kenburns':
											
											var dim = getDim(),
												img = card.children('img').eq(0),
												sc = 1.14 + random(0.2),
												a = random(1) * Math.PI,
												d = (Math.random() + 0.2) * Math.min(dim[0], dim[1]) * 0.08,
												dx = Math.round(d * Math.cos(a)),
												dy = Math.round(d * Math.sin(a)),
												
												init = function() {
											
														card.data({
																'sc': 			(sc > 1.14)? (sc - 0.2) : (sc + 0.2),
																'dx':			-dx,
																'dy':			-dy
															});
														
														img.css({
																transform: 		'translate(' + dx + 'px,' + dy + 'px) scale(' + sc + ')',
																transition:		'none'
															}).show();
															
												
											
														window.requestAnimationFrame(start);
															
													},
													
												start = function() {
													
														card.css({
																opacity:		1,
																transition:		'opacity ' + transitionSpeed + 'ms ease-in-out'
															});
														
														img.css({
																transform:		'scale(' + ((sc > 1.14)? (sc - 0.1) : (sc + 0.1)) + ') translate(0,0)',
																transition:		'transform ' + transitionSpeed + 'ms linear'
															});
														
														if (prev.length) {
															
															img = prev.children('img').eq(0);
															
															prev.css({
																	opacity: 		0,
																	transition:		'opacity ' + (transitionSpeed * .98) + 'ms ease-out'
																});
															
															img.one('transitionend', removePrev)
																.css({
																	transition:		'transform ' + (transitionSpeed * .98) + 'ms linear',
																	transform: 		'scale(' + prev.data('sc') + ') translate(' + prev.data('dx') + 'px,' + prev.data('dy') + 'px)'
																});
																
															removeTo = setTimeout(removePrev, transitionSpeed + 20);
														}
													};
													
											window.requestAnimationFrame(init);
											
											break;
											
										/********************************************
										 *					Slide
										 */
										 
										case 'slide':
											
											if (prev.length) {
												
												var dr = (settings.direction.length > 1)? randomDirection() : 
															((dir < 0)? getReverseDirection() : getDirection()),
													dim = getDim(),
												
													init = function() {
													
															card.show().css({
																	opacity:		0.7,
																	transform: 		'translate(' + (dr[0] * dim[0]) + 'px,' + (dr[1] * dim[1]) + 'px)',
																	transition:		'none'
																});
															
															prev.css({
																	transition:		'none'
																});
																
															window.requestAnimationFrame(start);
																
														},
														
													start = function() {
														
															card.css({
																	opacity:		1,
																	transform:		'translate(0,0)',
																	transition:		'transform ' + transitionSpeed + 'ms ease-in-out, opacity ' + transitionSpeed + 'ms ease-out'
																});
														
															prev.one('transitionend', removePrev)
																.css({
																	opacity:		0.7,
																	transform: 		'translate(' + (0 - dr[0] * dim[0]) + 'px,' + (0 - dr[1] * dim[1]) + 'px)',
																	transition:		'transform ' + transitionSpeed + 'ms ease-in-out, opacity ' + transitionSpeed + 'ms ease-out'
																});
																
															removeTo = setTimeout(removePrev, transitionSpeed + 20);
														};
														
												window.requestAnimationFrame(init);
												
											} else {
												
												window.requestAnimationFrame(function() {
														
														card.show()
															.css({
																opacity:		1,
																transition:		'opacity ' + Math.min(transitionSpeed, 1000) + 'ms ease-out'
															});
													});
											}
											
											break;
											
										/********************************************
										 *					Swap
										 */
										 
										case 'swap':
											
											if (prev.length) {
												
												var dim = getDim(),
												
													init = function() {
												
															card.css({
																	zIndex:				0,
																	opacity:			0,
																	transform:			'scale(0.7) translate(0,-40px)',
																	transition:			'none'
																}).show();
																
															prev.css({
																	zIndex:				1,
																	opacity:			1,
																	transition:			'none'
																});
																
															window.requestAnimationFrame(start);
														},
														
													start = function() {
														
															card.css({
																	opacity:			1,
																	transform:			'scale(0.85) translate(' + (dim[0] / 2) + 'px,-40px)',
																	transition:			'transform ' + (transitionSpeed / 2) + 'ms ease-in-out, opacity ' + (transitionSpeed / 2) + 'ms linear'
																})
																.one('transitionend', function() {
																		window.requestAnimationFrame(half);
																	});

															prev.css({
																	transform:			'scale(0.7) translate(' + (0 - dim[0] * .55) + 'px,20px)',
																	transition:			'transform ' + (transitionSpeed / 2) + 'ms ease-in-out, opacity ' + (transitionSpeed / 2) + 'ms linear'
																});
																
															removeTo = setTimeout(removePrev, transitionSpeed + 30);
														},
														
													half = function() {
														
															card.css({
																	zIndex:				1,
																	transform:			'scale(1) translate(0,0)'
																});
															
															prev.css({
																	zIndex:				0,
																	opacity: 			0,
																	transform:			'scale(0.49) translate(0,40px)'
																})
																.one('transitionend', removePrev);
														};
											
												window.requestAnimationFrame(init);
												
											} else  {
												
												window.requestAnimationFrame(function() {
														
														card.css({
																zIndex:				1,
																opacity:			0,
																transform:			'scale(0.85)',
																transition:			'none'
															}).show();
															
														window.requestAnimationFrame(function() {
																
																card.css({
																		opacity:			1,
																		transform:			'scale(1)',
																		transition:			'transform ' + Math.min(transitionSpeed / 2, 500) + 'ms ease-in-out, opacity ' + Math.min(transitionSpeed / 2, 500) + 'ms linear'
																	});
														});
													});
											}
											
											break;
											
										/********************************************
										 *				Carousel
										 */
										 
										case 'carousel':
											
											var dim = getDim(),
												n = cards.children().index(card),
												d = Math.round(dim[0] / (2 * Math.tan(Math.PI / max))),
												r = Math.round(dim[0] / (2 * Math.sin(Math.PI / max))),
												a = 360 / max;
											
											if (cards.data('initialized')) {
												
												var start = function() {
													
															n = Math.floor((cards.data('num') || 0) / max) * max + (n || max);
															
															cards.data('num', n)
																.css({
																	transform:			'translateZ(-' + r + 'px) rotateY(-' + (n * a) + 'deg)',
																	transition:			'transform ' + transitionSpeed + 'ms'
																})
																.children().css({
																	opacity:			BACKFACEBUG? 0.9 : 0.6
																});
															
															card.css({
																	opacity:			1
																});
														};
													
												window.requestAnimationFrame(start);
												
											} else {
												
												var init = function() {
														
															cards.css({
																	transform:			'translateZ(-' + r + 'px) rotateY(0)',
																	transition:			'none'
																});
															
															cards.children().each(function(i) {
																	$(this).css({
																			// Trick to trigger rendering of the backside surfaces 
																			backfaceVisibility: 'visible',
																			opacity:			(i === n)? 1 : (BACKFACEBUG? 0.9 : 0.6),
																			transform:			'rotateY(' + (i * a) + 'deg) translateZ(' + d + 'px)',
																			transition:			'none'
																		})
																		.show();
																});
															
															cards.data({
																'num':				0,
																'initialized': 		true
															});
															
															window.requestAnimationFrame(function() {
																	cards.css({
																			transition:			'transform ' + transitionSpeed + 'ms'
																		});
																	
																	cards.children().css({
																			backfaceVisibility: 'hidden',
																			transition:			'opacity ' + transitionSpeed + 'ms ease-out'
																		});
																});
														};
											
												window.requestAnimationFrame(init);	
											}
											
											break;
											
										/********************************************
										 *					Flip
										 */
										 
										case 'flip':
											
											if (prev.length) {
												
												var init = function() {
													
															card.css({
																	opacity:			0
																})
																.show()
																.css({
																	transition:			'opacity ' + transitionSpeed + 'ms'
																});
																
															window.requestAnimationFrame(start);	
														},
													
													start = function() {
														
															prev.css({
																	opacity:			0
																});
															
															card.css({
																	opacity:			1
																});
															
															cards.css({
																	transform:			'rotateY(' + ((dir < 0)? '180' :  '-180') + 'deg)',
																	transition:			'transform ' + transitionSpeed + 'ms'
																}).one('transitionend', function(e) {
																	window.requestAnimationFrame(stop);	
																});
																
															removeTo = setTimeout(stop, transitionSpeed + 20);
														},
														
													stop = function() {
															
															removePrev();
															
															cards.css({
																	transition:			'none',
																	transform:			'rotateY(0)'
																});
														};
												
												window.requestAnimationFrame(init);	
												
											} else {
												
												window.requestAnimationFrame(function() {
														
														card.show()
															.css({
																opacity:		1,
																transition:		'opacity ' + Math.min(transitionSpeed, 1000) + 'ms'
															});
													});
											}
											
											break;

										/********************************************
										 *					Book
										 */
										 
										case 'book':
											
											cards.children('.' + id.paging).remove();
											
											var p 	= card.position().top,	// padding
												w 	= cards.width() - 2 * p,
												w2 	= w / 2,
												wrp,						// Wrap for prev
												wrn,						// Wrap for next
												paging,						// Paging (rotating)
												pgp,						// :	wrap for prev
												pgn,						// :	wrap for next
												shp,						// :	shade prev
												shn,						// :	shade next
												
												init = function() {
													
														if (cards.children('.' + id.prevPage).length) {
															cards.find('.' + id.prevPage + ' .' + id.card).unwrap();
														}
														
														prev.css({
																width: 			w,
																left:			(dir > 0)? 0 : -w2
															}).wrap(wrp = $('<div>', {
																'class':		id.prevPage	
															}));
													
														card.css({
																opacity:		1,
																width: 			w,
																left:			(dir > 0)? -w2 : 0,
																zIndex:			0
															}).wrap(wrn = $('<div>', {
																'class':		id.nextPage	
															})).show();
															
														// Paging wrap
														
														paging = $('<div>', {
																'class':		id.paging
															}).appendTo(cards);
														
														// Previous page on paging
														pgp = (prev.clone()).css({
																left:			(dir > 0)? '-100%' : 0
															}).appendTo(paging);
															
														// Next page on paging
														pgn = (card.show().clone()).css({
																opacity:		1
															}).appendTo(paging);
														
														pgp.add(pgn).find('audio,video').each(function() {
																this.pause();
															});
														
														shp = $('<div>', {
																	'class':		id.shade
																}).appendTo(pgp);
															
														shn = $('<div>', {
																	'class':		id.shade
																}).hide().appendTo(pgn);
																
														paging.show()
															.css({
																zIndex:				2,	
																transition:			'transform ' + (transitionSpeed / 2) + 'ms linear'
															})
															.data('ts', new Date());
															
														window.requestAnimationFrame(start);
														//start();
													},
													
												start = function() {
													
													shp.css({
																transition:			'opacity ' + (transitionSpeed / 2) + 'ms cubic-bezier(0.32, 0, 0.67, 0)',
																opacity:			.75
															});
														
														paging.one('transitionend', function() {
																window.requestAnimationFrame(half);
																//half();
															}).css({
																transform:			'rotateY(' + ((dir > 0)? '-90' : '90') + 'deg)'
															});
															
														removeTo = setTimeout(stop, transitionSpeed + 30);
													},
													
												half = function() {
													
														pgp.hide();
														
														pgn.css('backface-visibility', 'visible').show();
														
														paging.one('transitionend', function(e) {
																window.requestAnimationFrame(stop);
																//stop();
															}).css({
																transform:			'rotateY(' + ((dir > 0)? '-180' : '180') + 'deg)'
															});
														
														shn.show().css({
																transition:			'opacity ' + (transitionSpeed / 2) + 'ms cubic-bezier(0.33, 1, 0.68, 1)',
																opacity:			0
															});
														
													},
													
												stop = function() {
													
														if (paging) {
															paging.remove();
														}
														
														if (card.parent().hasClass(id.nextPage)) {
															card.unwrap('.' + id.nextPage).css('left', p);
														}
														
														removePrev();
													};
													
											if (prev.length) {
												
												window.requestAnimationFrame(init);
												//init();
												
											} else {
												
												window.requestAnimationFrame(function() {
														
														card.show()
															.css({
																opacity:		1,
																transition:		'opacity ' + Math.min(transitionSpeed, 500) + 'ms'
															});
													});
											}
											
											break;
											
										/********************************************
										 *					Cube
										 */
										 
										case 'cube':
											
											var dim = getDim(),
												d = Math.round(dim[1] / 2),					// Distance from rotation center
												
												init = function() {
													
														prev.css({
																opacity:			1
															});
														
														card.css({
																transform:			'rotateX(0) translateZ(0)',
																opacity:			0.01
																//backfaceVisibility:	'visible'
															})
															.show();
															
														window.requestAnimationFrame(start);
													},
											
												start = function() {
													
														cards.data('transon', true);
															
														cards.css({
																transform:			'translateZ(' + d + 'px) rotateX(0)'
															});
														
														card.css({
																transform:			'rotateX(' + ((dir < 0)? '90' : '270') + 'deg) translateZ(' + d + 'px)'
															});
			
														card.css({
																opacity:			1,
																transition:			'opacity ' + transitionSpeed + 'ms' 	// cubic-bezier(0.33, 1, 0.68, 1)'
															});
														
														prev.css({
																opacity:			0,
																transition:			'opacity ' + transitionSpeed + 'ms' 	// cubic-bezier(0.32, 0, 0.67, 0)'
															});
															
														cards.one('transitionend', function(e) {
																//console.log(e.target.classList.value + ' ' + e.originalEvent.propertyName);
																window.requestAnimationFrame(stop);
															})
															.css({
																transition:			'transform ' + transitionSpeed + 'ms',
																transform:			'translateZ(-' + d + 'px) rotateX(' + (dir * 90) + 'deg)'
															});
															
													},
													
												stop = function() {
													
														cards.data('transon', false);
														
														cards.css({
																transition:			'none',
																transform:			'translateZ(-' + d + 'px) rotateX(0)'
															});
														
														card.css({
																zIndex:				0,
																transform:			'rotateX(0) translateZ(' + d + 'px)'
															});
														
														removePrev();
													};
											
											if (cards.data('transon')) {
												// Ongoing transition
												prev.css({
														transition:			'none',
														zIndex:				0,
														transform:			'rotateX(0) translateZ(' + d + 'px)',
														opacity:			1
													});
												
												cards.css({
														transition:			'none',
														transform:			'translateZ(-' + d + 'px) rotateX(0)'
													});
											}
											
											init();

											break;
										
										/********************************************
										 *				Coverflow
										 */
										 
										case 'coverflow':
											
											var next = card.next(),
												prev0 = card.prev(),
												prev1 = prev0.prev(),
												d = getDim()[0] / 8,
												halfTo = null;
												
												init = function() {
													
														// Preset
														prev1.css({
																zIndex:				0
															});
														
														card.css({
																zIndex:				2
															});
															
														if (!prev0.length) {
															// First card
															card.css({
																	opacity:			1,
																	transform:			'scale(0.5) translate3d(' + (d * settings.coverflowFactor[0]) + 'px,0,-' + (d * 2) + 'px) rotateY(-86deg)'
																})
																.show();
														}
													
														next.css({
																zIndex:				1,
																opacity:			0,
																transform:			'scale(0.4) translate3d(' + (d * settings.coverflowFactor[1]) + 'px,0,-' + (d * 3) + 'px) rotateY(-120deg)'
															})
															.show()
															.css({
																willChange:			'transform, opacity'
															});
														
														card.add(prev0).css({
																opacity:			1,
																transition:			'transform ' + transitionSpeed + 'ms ease-in-out'
															});
															
														next.add(prev1).css({
																transition:			'transform ' + transitionSpeed + 'ms ease-in-out, opacity ' + transitionSpeed + 'ms linear'
															});
														
														window.requestAnimationFrame(start);
													},
													
												start = function() {
														
														// Animations
														prev0.one('transitionend', function() {
																prev1.remove();
															})
															.css({
																transform:			'scale(0.5) translate3d(-' + (d * settings.coverflowFactor[0]) + 'px,0,-' + (d * 2) + 'px) rotateY(86deg)'
															});
																						
														next.css({
																opacity:			1,
																transform:			'scale(0.5) translate3d(' + (d * settings.coverflowFactor[0]) + 'px,0,-' + (d * 2) + 'px) rotateY(-86deg)'
															});
														
														card.css({
																opacity:			1,
																transform:			'scale(0.75) translate3d(0,0,0) rotateY(0)'
															});
													
														prev1.css({
																opacity:			0,
																transform:			'scale(0.4) translate3d(-' + (d * settings.coverflowFactor[1]) + 'px,0,-' + (d * 3) + 'px) rotateY(120deg)'
															});
														
														halfTo = setTimeout(function() {
																clearTimeout(halfTo);
																window.requestAnimationFrame(half);
															}, transitionSpeed * 0.5);
															
													},
													
												half = function() {
														card.css({
																zIndex:				3
															});
															prev0.css({
																zIndex:				1
															});
													};
												
											window.requestAnimationFrame(init);
											
											break;

										default:
									}
									
									// Next image
									if (settings.auto) {
										if ((card.hasClass('video') || card.hasClass('audio')) && settings.videoAuto) {
											suspendAuto();
											onMediaEnded(resumeAuto);
										} else  {
											animateProgress(slideshowDelay + transitionSpeed);
											slideshow = setTimeout(changeCard, slideshowDelay + transitionSpeed);
										}
									}
								}
							},
							
						// Paint regions
						
						paintRegions = function(card) {
								var el = $('<div>', {
											'class':	settings.regionsClass
										}).appendTo(card),
									item = getCurrItem(card),
									dim = album.getDimensions(item),
									regions = album.getRegions(item),
									w = card.width(),
									h = card.height(),
									sc = (settings.transitionType === 'kenburns')? card.find('img').eq(0).getMatrix()[0] : 1;
									
								if (w / dim[0] < h / dim[1]) {
									sc *= (w / h) * (dim[1] / dim[0]);
									el.css({
											top:		50 - sc * 50 + '%',
											height: 	sc * 100 + '%'
										});
								} else {
									sc *= (h / w) * (dim[0] / dim[1]); // w * dim[1] / h / dim[0];
									el.css({
											left: 		50 - sc * 50 + '%',
											width:		sc * 100 + '%'
										});
								}									
								
								for (var i = 0, r; i < regions.length; i++) {
									r = regions[i].split(';');
									el.append($('<div>').css({
											left:		(100 * parseFloat(r[1])) + '%',
											top:		(100 * parseFloat(r[2])) + '%',
											width:		(100 * parseFloat(r[3])) + '%',
											height:		(100 * parseFloat(r[4])) + '%'
										}).append('<span>' + r[0] + '</span>'));
								}
								
								el.fadeIn();
							},
							
						// Show/hide regions
						
						toggleRegions = function() {
								var card = cards.find('#c' + curr),
									r = card.find('.' + settings.regionsClass);
							
								if (r.length) {
									settings.regionsVisible = !settings.regionsVisible;
									if (r.is(':visible')) {
										r.fadeOut();
									} else {
										r.fadeIn();
									}
								} else {
									if (!settings.regionsVisible) {
										paintRegions(card);
									}
								}
								
								return false;
							},
							
						// Show / bounce marker on the map
						
						openMap = function(item) {
								if (settings.hasOwnProperty('onShowPanel') && typeof settings.onShowPanel === FUNCTION) {
									if (!$('#map').hasClass('on')) {
										settings.onShowPanel.call(this, $('#map'));
										$('.map-root').trigger('setActive', item[J.NAME]);
									}
								}
							},

						// No marker; hide map, deactivate all markers
						
						closeMap = function() {
								if (settings.hasOwnProperty('onHidePanel') && typeof settings.onHidePanel === FUNCTION) {
									if ($('#map').hasClass('on')) {
										settings.onHidePanel.call(this, $('#map'));
									}
								}
							},
							
						// Load nth card (with ahead)
						
						loadCard = function(n, ahead) {
								
								//log('Load card(' + n + ')');
								
								_clearAuto();
								
								if (settings.ordering === 'random') {
									curr = n;
								} else {
									curr = n % max;
									ahead = ahead? Math.min(ahead, max - curr) : 0;
								}
								
								var targetDims = [ cards.outerWidth(), cards.outerHeight() ], 
								
									loadOne = function(n) {	
										
											if (n >= items.length) {
												// Out of range :: error
												return $();
											}
											
											var // Create image container
												card = $('<div>', {
																id:				'c' + n,
																'class':		id.card + ' ' + (items[n][J.CATEGORY]||'folder') + ' ' + settings.transitionType
															})
															.data('idx', n)
															.appendTo(cards),
															
												item = items[n],
												img,
												cw,
												ch;
										
											card.css('opacity', 0).addClass(items[n][J.CATEGORY]);
											
											cw = card.outerWidth() || cards.outerWidth();
											ch = card.outerHeight() || cards.outerHeight();
											
											card.data('type', item[J.CATEGORY]);
											
											if (item[J.CATEGORY] === 'folder') {
												var s = album.getThemeImagePath(item);
												
												// Dummy image just for load event triggering
												img = $('<img>').attr('src', s);
												
												card.append($('<div>', {
															'class':	'hero',
															content:	''
														})
														.append(img)
													).append($('<div>', {
															'class':	'album-title',
															html:		item[J.FOLDERTITLE]	 || item[J.THUMBCAPTION]	
														}));
												
											} else {
												
												img = $('<img>').appendTo(card);
												
												// Creating caption
												
												var btn,
													
													src = album.getOptimalImagePath(item, targetDims),
													
													cat = item[J.CATEGORY],
													
													caption = $('<div>', {
															'class':	[ id.caption, settings.captionplacement, settings.captionstyle ].join(' ')
														}),
														
													buttons = $('<div>', {
															'class': 	'buttons'
														});
													
												// Print button
												
												if (settings.printImage && cat === 'image' && !settings.rightClickProtect) {
													btn = $('<a>', {
																'class': 	settings.buttonClass + ' icon-printer'
															})
														.attr('data-tooltip', text.print)
														.on('click', function(e) {
																printImage((item[J.ORIGINAL] && settings.showDownload)? item[J.ORIGINAL][J.PATH] : item[J.IMAGE][J.PATH],
																		item[J.TITLE] || '',
																		item[J.THUMBCAPTION] || ''
																	);
																	
																return false;
															})
														.appendTo(buttons);
												}
												
												// Download button
												
												if (settings.showDownload && (cat === 'image' || settings.allowDownloadOthers)) {
													var href = album.getOriginalPath(item);
													
													if (!href && settings.allowDownloadScaled) {
														href = album.getImagePath(item);
													}
													
													if (href) {
														btn = $('<a>', {
																	'class': 	settings.buttonClass + ' icon-download',
																	download: 	'',
																	href: 		href
																})
															.attr('data-tooltip', text.download)
															.appendTo(buttons);
													}
												}

												// Fotomoto button
												
												if (!LOCAL && typeof FOTOMOTO !== UNDEF && settings.fotomoto) {
													btn = $('<a>', {
																'class': 	settings.buttonClass + ' icon-fotomoto fotomoto-btn'
															})
															.attr('data-tooltip', text.fotomotoBtn)
															.on('click', function(e) {
																	FOTOMOTO.API.showWindow(10, 
																		album.getOriginalPath(item) || album.getItemPath(item)
																	);
																})
															.appendTo(buttons);
												}

												// Photo data
												
												if (item[J.PHOTODATA]) {
													btn = $('<a>', {
																'class':	settings.buttonClass + ' icon-camera meta'
															})
														.attr('data-tooltip', '<div class="photodata">' + item[J.PHOTODATA] + '</div>')
														.appendTo(buttons);
												}
												
												// Regions
												
												if (settings.showRegions && cat === 'image' && item[J.REGIONS]) {
													btn = $('<a>', {
																'class':	settings.buttonClass + ' icon-user regions-btn'
															})
														.attr('data-tooltip', settings['regionsBtn'] || text.regionsLabel)
														.appendTo(buttons);
																												
													btn.on('click', toggleRegions);
												}
												
												// Map
												
												if (settings.showMap) {
													if (item[J.LOCATION]) {
														// SHow GPS location
														btn = $('<a>', {
																	'class': 	settings.buttonClass + ' icon-location map-btn'
																})
															.attr('data-tooltip', text.mapBtn)
															.on('click', function() {
																	if ($('#map').hasClass('on')) {
																		closeMap();	
																	} else {
																		if (!$('.map-root').data('rendered')) {
																			// Not yet rendered
																			$('.map-root').trigger('render', function() {
																					openMap(item);
																				});
																		} else {
																			openMap(item);
																		}
																	}
																	return false;
																})
															.appendTo(buttons);
															
														if ($('#map').hasClass('on')) {
															$('.map-root').trigger('setActive', item[J.NAME]);
														}
														
													} else {
														// No GPS data
														if ($('#map').hasClass('on')) {
															$('.map-root').trigger('setActive');
														}
													}
												}
												
												// Audio clip
												
												if (item[J.AUDIOCLIP]) {
													// Wrapper
													var el = $('<div>', {
																'class':	'audio-clip paused'
															})
														.appendTo(buttons);
														
													// Button
													var btn = $('<a>', {
																'class':	settings.buttonClass + ' icon-volume-up audioclip-btn'
															})
														.attr('data-tooltip', text.audioClipLabel)
														.on('click', function() {
																if (btn.hasClass('icon-pause')) {
																	pauseAudioClip();
																} else {
																	startAudioClip()
																}
															})
														.appendTo(el);
													
													// Audio element
													audioClip = $('<audio>', {
																'class':		'audioclip',
																src:			item[J.AUDIOCLIP][J.PATH],
																controlsList:	'nofullscreen nodownload noremote noplaybackrate'
															})
														.appendTo(el);
													
													// Type attribute saving and duration
													if (item[J.AUDIOCLIP].hasOwnProperty(J.TYPE)) {
														audioClip[0]['type'] = item[J.AUDIOCLIP][J.TYPE];
														if (item[J.AUDIOCLIP].hasOwnProperty(J.DURATION)) {
															audioClip.data('duration', item[J.AUDIOCLIP][J.DURATION]);
														}
													}
													
													var volume = $('<input class="volume" type="range" name="volume" min="0" max="100" value="' + (settings.audioClipVolume * 100) + '">');

													el.append(volume);
													
													volume.on('change', function(e) {
															var v = $(this).val();
															
															if (typeof v !== UNDEF) {
																settings.audioClipVolume = v / 100;
															}
															
															audioClip[0]['volume'] = settings.audioClipVolume;
															savePrefs(settings, ['audioClipVolume'], 'lb_pref');
															
															if (typeof settings['onVolumeChange'] === FUNCTION) {
																settings.onVolumeChange(settings.audioClipVolume);
															}
														});
													
													// Setting loudness
													audioClip[0]['volume'] = settings.audioClipVolume;
													
													if (settings.autoplayAudioClips) {
														if (isCoverDown()) {
															// Not yet exposed
															audioClip.data('wasPlaying', true);
														} else {
															// Trying to autoplay
															startAudioClip();
														}
													}
													
												} else {
													audioClip = $();
												}
					
												if (settings.showNumbers) {
													caption.append($('<span>', {
															'class':	'nr',
															html:		(n + 1) + ' <em>' + items.length + '</em>'
														}));
												}

												if (item[J.IMAGECAPTION]) {
													caption.append($('<div>', {
															'class':	'text',
															html:		item[J.IMAGECAPTION]
														}));
												}
												
												if (!buttons.is(':empty')) {
													caption.append(buttons);
													if (whatInput.ask('intent') === 'mouse') {
														buttons.find('[data-tooltip]').addTooltip({ 
																delay: 			500
															});
													} else {
														// Adding tooltip only for the photo data button
														buttons.children('.meta').addTooltip({ 
																touchToggle: 	true,
																stay:			4000
															});
													}
												}
												
												if (!caption.is(':empty')) {
													card.append(caption).addClass(settings.hasCaptionClass);
													caption.show();
												}
												
												// Load image
												
												if (settings.rightClickProtect) {
													img.on('contextmenu', function(e) {
															e.preventDefault()
															return false;
														});
												}
												
												// Applying src
												
												img.attr('src', src);
												
												if (cat === 'video' || cat === 'audio') {
													if (src.endsWith('res/' + cat + '.png')) {
														// Icon
														img.addClass('icon');
														createMedia(card);
													} else {
														img.addClass('poster');
														card.append($('<a>', {
																	'class':	'icon-play play-btn'
																})
															.on('click', playMedia));
													}
												} else if (cat === 'other') {
													card.append($('<a>', {
															'class':	'icon-external button',
															html:		' ' + text.clickToOpen,
															href:		item[J.ORIGINALPATH],
															download:	'download'
														}));
												}
												
												if (settings.showRegions && cat === 'image' && item[J.REGIONS] && settings.regionsVisible) {
													// Painting regions if visible by default
													setTimeout(function() {
															paintRegions(card);
														}, 100);
												}
											}
											
											return img;
										},
										
									preload = function(n) {
											
											if (items && items.length > n) {
												var img = $('<img>').appendTo($body);
												
												img.hide()
													.attr('src', album.getOptimalImagePath(items[n], targetDims))
													.one('load', function() {
															$(this).remove();
														});
											}
										};
										
								// Stop slideshow
								clearTimeout(slideshow);
								slideshow = null; 
								getSlideshowTiming(items[n]);
								
								pauseAudioClip();
								
								if (settings.hasOwnProperty('onLoadStart') && typeof settings.onLoadStart === FUNCTION) {
									settings.onLoadStart.call(this, n);
								}
								
								if (ahead) {
									// More than 1 to load
									for (var i = 0; i <= ahead; i++) {
										if (!cards.children('#c' + (n + i)).length) {
											loadOne((n + i) % max);
										}
									}
									
									// Triggered only when all images got loaded successfully
									cards.waitAllImg(null, cardReady);
									
									preload((n + i) % max);
									
								} else {
									var card = cards.children('#c' + n),
										img = card.length? card.find('img') : loadOne(n);
										
									if (img.length && img[0].naturalWidth) {
										// Images has loaded already
										cardReady(img);
									} else {
										// Call when ready
										img.one('load', cardReady);
									}
									
									preload((n + 1) % max);
								}
							},
														
						// Initializes lightbox
						
						initCards = function() {
							
								if (items.length < max) {
									max = items.length;
								}
								
							},
							
						// Gets index
						
						getIndex = function(t) {
							
								if (typeof t === 'number') {
							
									if (t < 0) {
										return 0;
									} else if (t >= items.length) {
										return items.length - 1;
									}
									return t;
									
								} else if (typeof t !== 'string') {
									
									if (!(t instanceof $)) {
										t = $(t);
									}
									
									t = t.find('img').eq(0);
									
									if (!t.length) {
										return 0;
									}
									
									t = t.attr('src').getFile();
								}
								
								if (!t) {
									return 0;
								}
								
								for (var i = 0, l = items.length; i < l; i++) {
									if (items[i][J.PATH] === t) {
										return i;
									}
								}
								
								return 0;
							},
							
							
						// Loads one card
						
						loadImage = function(n) {
								
								if (typeof n === UNDEF) {
									n = curr;
								} else {
									n = getIndex(n);
								}
								
								if (settings.transitionType === 'carousel') {
									loadCard(n, 3);	
								} else if (settings.transitionType === 'coverflow') {
									loadCard(n, 1);
								} else {
									loadCard(n);
								}
								
								loaded = true;
							},
							
						// Keyboard handler
						
						keyHandler = function(e) {
								if (!lightbox.length || document.activeElement && (document.activeElement.nodeName === 'INPUT' || document.activeElement.nodeName === 'TEXTAREA')) {
									return true;
								}
								
								e.preventDefault();
								
								switch (e.keyCode) {
									/*
									case 27:
										quitProjector();
										break;
									*/
									case 33:
									case 37:
										previousCard();
										break;
										
									case 34:
									case 39:
										nextCard();
										break;
										
									case 97:
									case 35:
										loadCard(items.length - 1);
										break;
										
									case 103:
									case 36:
										loadCard(0);
										break;
									
									case 106:
									case 179:
									case 32:
										toggleAuto();
										break;
										
									case 107:
										toggleZoom();
										break;
									
									case 109:
										togglePanels();
										break;
									
									default:
										return true;
														
								}
								
								return false;
							},
							
						// Layout refresh
						
						layoutRefresh = function() {
							
								pw = lightbox.outerWidth();
								ph = lightbox.outerHeight();
								
								lightbox
									.removeClass('landscape portrait')
									.addClass((pw >= ph)? 'landscape' : 'portrait');
								
								fitImages(true);
							},
							
						// Is visible
						
						isVisible = function() {
								
								return lightbox.is(':visible');
							},
							
						// Remove lightbox
						
						removeLightbox = function() {
								
								$window.off('.' + ns);
								lightbox.remove();
								
							};
							
																												
					/*****************************************
					 *        Execution starts here
					 *****************************************/
					
					// Projector element
					
					lightbox = overlay.children('.' + id.lightbox);
					
					if (lightbox.length && lightbox.data('lightbox')) {
						// Extend with local settings
						settings = $.extend({}, options, lightbox.data('lightbox'));
					} else {
						if (!lightbox.length) {
							// Not yet exists: creating
							lightbox = $('<section>', {
									'class': 	id.lightbox
								}).appendTo(overlay);
						}
						// Passed settings
						settings = options;
					}
					
					// Collecting items, adding number reference if missing
					
					overlay.find(settings.selector).each(function(n) {
							
							if (typeof $(this).data('lbnr') === UNDEF) {
								$(this).data('lbnr', n);
							}
							
							items.push($(this).data(J.OBJ));
						});
					
					if (!items.length) {
						return;
					}
					
					// Missing defaults
					
					if (!settings.hasOwnProperty('transitionType')) {
						settings.transitionType = $.fn.lightbox.defaults.transitionTypes[Math.floor(Math.random() * $.fn.lightbox.defaults.transitionTypes.length)];
					}
					if (!settings.hasOwnProperty('slideshowDelay')) {
						slideshowDelay = settings.slideshowDelay = $.fn.lightbox.defaults.timings[settings.transitionType || 'slide'][0];
					}
					if (!settings.hasOwnProperty('transitionSpeed')) {
						transitionSpeed = settings.transitionSpeed = $.fn.lightbox.defaults.timings[settings.transitionType || 'slide'][1];
					}
					if (settings.transitionType === 'slide' && !settings.hasOwnProperty('direction')) {
						settings.direction = 'e';
					}
					resumeDelay = Math.max((settings.transitionSpeed + settings.slideshowDelay) / 2, 150),
						
					// Determining type
					
					threedee = 'carousel.flip.book.cube.coverflow'.indexOf(settings.transitionType) >= 0;
					
					// Storing namespace, adding id, classes
					
					overlay.data('lightbox-ns', ns = 'lightbox-' + Math.floor(Math.random() * 10000))
						.attr('id', ns);
					
					// Max number
					
					max = items.length;
					
					// Start with this image if passed or the first
					curr = settings['startWith'] || 0;
					
					// Creating/getting container object
					
					cards = lightbox.find('.' + id.cards);
					
					if (!cards.length) {
						cards = $('<div>', {
								'class':		id.cards
							}).appendTo(lightbox);
					}
					
					cards.addClass(settings.transitionType);
						
					// Prev / Next buttons
					
					prevBtn = lightbox.find('.' + id.prev);
					
					if (!prevBtn.length && (!subOverlay || cards.length > 1)) {
						prevBtn = 	$('<button>', {
											'class':		id.prev + ' btn'
										}).appendTo(lightbox);
					}
										
					prevBtn.on('click', function() {
							previousCard();
						});
					
					nextBtn = lightbox.find('.' + id.next);
					
					if (!nextBtn.length && (!subOverlay || cards.length > 1)) {
						nextBtn = 	$('<button>', {
											'class':		id.next + ' btn'
										}).appendTo(lightbox);
					}
					
					nextBtn.on('click', function() {
							nextCard();
						});
					
					lightbox.addClass([
							settings.transitionType,
							settings.captionVisibleClass,
							(pw > ph)? 'landscape' : 'portrait', 
							threedee? id.threedee : ''
						].filter(Boolean).join(' '));
					
					if (subOverlay) {
						lightbox.css('top', overlay.children('header').outerHeight());
					}
					
					initCards();
					
					// Set dimensions first time
					
					layoutRefresh();
					
					// Projector dimensions has changed 
					
					$window.on('resize.' + ns + ' orientationchange.' + ns, function() {
							clearTimeout(layoutTo);
							layoutTo = setTimeout(layoutRefresh, 100);
						});
					
					// Keyboard
					if (settings.enableKeyboard) {
						$document.on('keyup.' + ns, keyHandler);
					}
	
					// Mouse wheel
					if (settings.enableMouseWheel) {
						var wheelTimeout = null;
						
						lightbox.on('mousewheel.' + ns + ' DOMMouseScroll.' + ns, function(e) {
								wheelTimeout = clearTimeout(wheelTimeout);
								
								if ($(e.target).closest('.' + id.caption).length) {
									return true;
								}
								
								wheelTimeout = setTimeout((e.originalEvent.wheelDelta > 0 || e.originalEvent.detail < 0)? previousCard : nextCard, 200); 
								
								return false;
							});
					}
					
					// Progress bar subelements
					
					progressBar1 = $body.find('.progressbar>.part1>div');
					progressBar2 = $body.find('.progressbar>.part2>div');
					
					if (settings.autoplay) {
						slideshow = setTimeout(changeCard, settings.slideshowDelay + settings.transitionSpeed);
						if (backgroundAudioRoot.length && backgroundAudioRoot.data('slideshowControl') && backgroundAudioRoot.data('paused')) {
							backgroundAudioRoot.trigger('fadeInPlayer');
						}
					}
										
					// Delegated events on the overlay
					
					overlay		// External trigger to switch image
						.on('lightboxLoad.' + ns, function(e, n, auto) {
								
								if (slideshow) {
									stopAuto();
								}
							
								if (typeof n === NUMBER) {
									n = Math.minMax(0, n, items.length);
								} else if (typeof n === UNDEF) {
									n = 0;
								} else if (n.jQuery) {
									n = n.data('lbnr') || 0;
								}
								
								loadImage(n);
								
								if (auto) {
									// Starting slideshow (leave the first image for at least 1 sec
									setTimeout(startAuto, (typeof auto === NUMBER)? auto : Math.max(settings.slideshowDelay, 1000));
								}
							})
						.on('lightboxCurrent.' + ns, function() {
								return curr;
							})
						// External trigger to quit = does not remove, just hides the lightbox
						.on('lightboxQuit.' + ns, function() {
								quitLightbox();
								return false;
							})
						// Removing the lightbox completely
						.on('lightboxRemove.' + ns, function() {
								removeLightbox();
								return false;
							})
						// Returning the current lightbox container
						.on('lightboxContainer.' + ns, function() {
								return lightbox;
							})
						// Startinng slideshow
						.on('startAuto.' + ns, function(e, delay) {
								startAuto((typeof delay === UNDEF)? 0 : Math.max(settings.slideshowDelay, delay));
								return false;
							})
						.on('stopAuto.' + ns, function() {
								stopAuto();
								return false;
							})
						.on('startAudioClip.' + ns, function() {
								startAudioClip();
								return false;
							})
						.on('resumeAudioClip.' + ns, function() {
								resumeAudioClip();
								return false;
							})
						.on('pauseAudioClip.' + ns, function() {
								pauseAudioClip();
								return false;
							})
						.on('pauseMedia.' + ns, function() {
								pauseMedia();
								return false;
							})
						.on('resumeMedia.' + ns, function() {
								resumeMedia();
								return false;
							})
						.on('refresh.' + ns, function() {
								layoutRefresh();
								return false;
							});
					
					// Firing ready event
					
					if (settings.hasOwnProperty('onReady') && typeof settings.onReady === FUNCTION) {
						settings.onReady.call(this);
					}
					
				});
		};

	// Default settings	
	
	$.fn.lightbox.defaults = {
			selector:						'.thumbnails .thumb.lbable',
			lightboxClass:					'lightbox',
			thumbsVisibleClass:				'thumbs-visible',
			thumbsHiddenClass:				'thumbs-hidden',
			captionVisibleClass:			'caption-visible',
			captionHiddenClass:				'caption-hidden',
			containClass:					'contain',
			ordering:						'original',								// 'random', 'original', 'date', 'date-reverse', 'name'
			transitionTypes:				[ 	'crossfade',
												'zoom',
												'kenburns',
												'stack',
												'slide',
												'swap',
												'carousel',
												'flip',
												'book',
												'cube',
												'coverflow'
											],
			timings: 						{										// Slideshow timings
												'crossfade':		[ 1000, 2000 ],
												'zoom':				[ 1000, 2000 ],
												'kenburns':			[    0, 4000 ],
												'stack':			[ 1500, 1500 ],
												'slide':			[ 1500, 1500 ],
												'swap':				[ 2000, 1000 ],
												'carousel':			[ 2000, 1000 ],
												'flip':				[ 2000, 1000 ],
												'book':				[ 2000, 1000 ],
												'cube':				[ 2000, 1000 ],
												'coverflow':		[ 2000, 1000 ]
											},
			coverflowFactor:				[ 6.4, 12.4 ],							//[ 5.9, 11.6 ],
			fit:							'both',									// 'cover', 'fit'
			scaleUp:						false,
			maxzoom:						2,									// maximum allowed zoom
			autoplay:						false,
			useOriginals:					false,
			backgroundAudioSlideshowControl:false,
			muteBackgroundAudio:			true,
			hideSidebar:					false,
			videoAuto:						false,
			useFullScreen:					true,
			loop:							true,
			enableKeyboard:					true,
			enableMouseWheel:				true,
			clickAction:					'donothing',
			afterLast:						'donothing',
			doubleClickZoom:				true,
			thumbstripVisibility:			'auto',
			mapHeight:						0.8,
			volume:							0.5,
			audioClipVolume:				0.75,
			autoplayAudioClips:				true,
			rightClickProtect: 				false,
			captionplacement:				'center bottom',
			captionstyle:					'dark',
			showNumbers:					false,
			showDownload:					false,
			allowDownloadOthers:			false,
			allowDownloadScaled:			false,
			showMap:						false,
			showRegions:					true,
			regionsVisible:					false,
			printImage:						false,
			regionsClass:					'regions',
			buttonClass:					'btn',
			hasCaptionClass:				'has-caption'
		};
		
	$.fn.lightbox.text = {
			startOver:						'Start over',
			upOneLevel:						'Up one level',
			backToHome:						'Back to home',
			backToCover:					'Back to cover page',
			nextFolder:						'Next folder',
			atLastPageQuestion:				'Where to go next?',
			atLastPage:						'At last page',
			atFirstPage:					'At first page',
			//close:							'Close',
			download: 						'Download',
			print:							'Print',
			printLabel:						'Print out this photo on your printer',
			mapBtn: 						'Map',
			mapLabel:						'Show the photo location on map',
			fotomotoBtn:					'Buy / Share',
			fotomotoTooltip:				'Buy prints or digital files, share, send free eCards',
			//mostphotosBtn:					'Purchase',
			//mostphotosLabel:				'Download this image from <b>mostphotos.com</b>!',
			regionsBtn:						'People',
			regionsLabel:					'Show tagged people', 
			//shopBtn: 						'Buy',
			metaBtn: 						'Photo data',
			metaLabel:						'Display photographic (Exif/Iptc) data',
			clickToOpen:					'Click to open this document with the associated viewer!'
		};

		
})(jQuery, jQuery(window), jQuery(document), jQuery('body'));